/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.shortcut;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.proto.trade.PInstructionService;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.LinkedList;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateInstDialog
extends DialogObj {
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private RadioButton buyRadio;
    @FXML
    private RadioButton sellRadio;
    @FXML
    private Spinner<Double> priceSpn;
    @FXML
    private Spinner<Integer> quantitySpn;
    @FXML
    private Label lbUnit;
    @FXML
    private ComboBox<MxNode> cmbPriceType;
    @FXML
    private ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    private ComboBox<MxNode> cmbPriceTypeMkt;
    @FXML
    private ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    private ComboBox<MxNode> cmbPriceTypeAfterHours;
    @FXML
    private Label lbPriceErr;
    private Instruction instruction;
    public RefItem refItem = null;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MObjFactory of;
    private static final Logger logger = LogManager.getLogger(UpdateInstDialog.class);
    private DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    @Inject
    private IInstructionApi<?> instApi;
    @Inject
    private MxAlert alert;

    @FXML
    private void initialize() {
        this.initControlls();
        this.checks();
        this.orderFill();
    }

    private void initControlls() {
        this.ctrlPrice.ctrl(this.priceSpn);
        this.ctrlCount.ctrl(this.quantitySpn);
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
    }

    private void checks() {
        this.registerCheck((Node)this.lbPriceErr, (ObservableBooleanValue)this.priceSpn.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPriceErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.priceSpn.getEditor().getText().isEmpty()) {
                return false;
            }
            double count = StringUtils.parseDouble((String)this.priceSpn.getEditor().getText());
            if (count == 0.0) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.priceSpn.getEditor().textProperty()}));
    }

    private void orderFill() {
        OrderAdvice advice = this.instruction.getOrderAdvice();
        String type = advice.getSecType();
        String market = advice.getMarket();
        String code = advice.getSec();
        this.refItem = this.refMng.getItem(type, market, code);
        ArrayList<RefItem> list = new ArrayList<RefItem>();
        list.add(this.refItem);
        this.lbUnit.setText(QueryUtils.getUnit((String)type, (String)market));
        this.ctrlPrice.setScale(this.refItem.getScale());
        this.ctrlCount.setUnit(this.refItem.getBuyUnit());
        this.txtCode.setText(code);
        this.lbName.setText(advice.getSecName());
        int side = advice.getSide();
        boolean isBuy = side == 49 || advice.getSide() == 71;
        this.buyRadio.setSelected(isBuy);
        this.sellRadio.setSelected(!isBuy);
        this.quantitySpn.getEditor().setText(Long.toString(advice.getOrderQty()));
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type", "50");
        this.cmbPriceType.setItems(node.getNodes());
        this.cmbPriceType.getSelectionModel().select((Object)node.getNode(Integer.toString(advice.getOrdType())));
        this.cmbPriceTypeMkt.setVisible(false);
        this.cmbPriceTypeLimited.setVisible(false);
        this.cmbPriceTypeBidAsk.setVisible(false);
        this.cmbPriceTypeAfterHours.setVisible(false);
        if (((MxNode)this.cmbPriceType.getValue()).is("49")) {
            this.cmbPriceTypeMkt.setVisible(true);
            MxNode nodeMkt = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_mkt", "0");
            this.cmbPriceTypeMkt.getSelectionModel().select((Object)nodeMkt.getNode(advice.getMarketPriceLimit()));
        } else if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            MxNode nodeLimit = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_limited", "1");
            this.cmbPriceTypeLimited.getSelectionModel().select((Object)nodeLimit.getNode(Integer.toString(advice.getPriceLimit())));
        } else if (((MxNode)this.cmbPriceType.getValue()).is("0")) {
            this.cmbPriceTypeBidAsk.setVisible(true);
            MxNode nodeBidAs = ((MxNode)this.of.create(MxNode.class)).load("instr_handicap", "-1");
            this.cmbPriceTypeBidAsk.getSelectionModel().select((Object)nodeBidAs.getNode(Integer.toString(advice.getPriceTypeBidAsk())));
        } else {
            this.cmbPriceTypeAfterHours.setVisible(true);
        }
        double price = advice.getPrice();
        if ("SH1".equals(this.instruction.getOrderAdvice().getMarketPriceLimit())) {
            price = advice.getProtectedLimitPrice();
        }
        this.priceSpn.getEditor().setText(String.valueOf(price));
        this.disable();
    }

    private void disable() {
        this.txtCode.setDisable(true);
        this.lbName.setDisable(true);
        this.buyRadio.setDisable(true);
        this.sellRadio.setDisable(true);
        this.quantitySpn.setDisable(true);
        this.cmbPriceType.setDisable(true);
        this.cmbPriceTypeMkt.setDisable(true);
        this.cmbPriceTypeLimited.setDisable(true);
        this.cmbPriceTypeBidAsk.setDisable(true);
        this.cmbPriceTypeAfterHours.setDisable(true);
        this.cmbPriceTypeAfterHours.setDisable(true);
    }

    private void priceTypeSelected() {
        if (this.cmbPriceType.getValue() == null) {
            return;
        }
        this.cmbPriceTypeMkt.setVisible(false);
        this.cmbPriceTypeLimited.setVisible(false);
        this.cmbPriceTypeBidAsk.setVisible(false);
        this.cmbPriceTypeAfterHours.setVisible(false);
        if (((MxNode)this.cmbPriceType.getValue()).is("49")) {
            this.cmbPriceTypeMkt.setVisible(true);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("0")) {
            this.cmbPriceTypeBidAsk.setVisible(true);
        } else {
            this.cmbPriceTypeAfterHours.setVisible(true);
        }
    }

    public boolean isOK(ButtonType bt) {
        PInstructionService.UpdateInstructionReq.Builder reqTrade = PInstructionService.UpdateInstructionReq.newBuilder();
        reqTrade.setInstructionId(this.instruction.getId());
        PInstructionService.UpdateAdviceParam.Builder param = PInstructionService.UpdateAdviceParam.newBuilder();
        PComponent.Instrument.Builder instItem = PComponent.Instrument.newBuilder();
        OrderAdvice advice = this.instruction.getOrderAdvice();
        instItem.setSecurityId(advice.getSec());
        instItem.setMarket(advice.getMarket());
        instItem.setSecurityType(advice.getSecType());
        param.setInstrument(instItem);
        LinkedList<PInstructionService.UpdateAdviceParam> list = new LinkedList<PInstructionService.UpdateAdviceParam>();
        int ordType = advice.getOrdType();
        double price = StringUtils.parseDouble((String)this.priceSpn.getEditor().getText());
        if (50 == ordType) {
            switch (advice.getPriceLimit()) {
                case 1: {
                    param.addUpdateFieldValue(1);
                    param.setMaxPrice(price);
                    break;
                }
                case 4: {
                    param.addUpdateFieldValue(2);
                    param.setMinPrice(price);
                    break;
                }
                case 2: {
                    param.addUpdateFieldValue(3);
                    param.setFixedPrice(price);
                }
            }
        } else if (49 == ordType) {
            param.addUpdateFieldValue(4);
            param.setProtectedPrice(price);
        }
        list.add(param.build());
        reqTrade.addAllUpdateAdviceParam(list);
        try {
            this.instApi.updateInstructionReq(reqTrade);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("update inst faild", (Throwable)e);
            return false;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u4fee\u6539\u6210\u529f");
        return true;
    }

    public void setInstruction(Instruction inst) {
        this.instruction = inst;
    }
}

