/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.shortcut;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.define.MxDict;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.ActionInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.viewers.shortcut.InstructionShortcutAlgoDialog;
import cms.tmx.instructions.viewers.shortcut.InstructionShortcutDialog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.current.models.InstructionShortcutModel;
import cms.tmx.query.current.views.InstructShortDialog;
import cms.tmx.query.current.views.InstructionQueryPart;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class InstructionShortcutQueryPart
extends InstructionQueryPart {
    @FXML
    private HBox hboxOperate;
    @FXML
    protected TableView<Instruction> tableInstruction;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnAllCancel;
    @FXML
    private Button btnStrategyExe;
    @FXML
    private Button btnSingleExe;
    @FXML
    private Button btnInstRead;
    @FXML
    private Button btnBasketExe;
    @FXML
    private CheckBox checkUnfinished;
    @Inject
    private InstructionShortcutModel shortModel;
    @FXML
    protected TableColumn<Instruction, String> colCreater;
    @FXML
    protected TableColumn<Instruction, String> colLeavesAmt;
    @FXML
    protected TableColumn<Instruction, String> colUnit;
    @FXML
    protected TableColumn<Instruction, String> colAuthorizer;
    @FXML
    protected TableColumn<Instruction, Number> colAvailOrdQty;
    @FXML
    protected TableColumn<Instruction, Number> colCumQty;
    @FXML
    protected TableColumn<Instruction, Number> colOrdQty;
    @FXML
    protected TableColumn<Instruction, Number> colOrdAvg;
    @FXML
    protected TableColumn<Instruction, Number> colOrdAmt;
    @FXML
    protected TableColumn<Instruction, Number> colAvailOrdAmt;
    @FXML
    protected TableColumn<Instruction, Number> colAvailOrdNum;
    @FXML
    protected TableColumn<Instruction, MxNode> colOrdStatus;
    @FXML
    protected TableColumn<Instruction, Number> colNewPrice;
    @FXML
    protected TableColumn<Instruction, String> colLeaveMessages;
    @FXML
    protected Label lbOrderQty;
    @FXML
    protected Label lbOrderAmt;
    @FXML
    protected Label lbInstQty;
    @FXML
    protected Label lbInstAmt;
    @FXML
    protected Label lbCumQty;
    @FXML
    protected Label lbCumAmt;
    @FXML
    protected Label lbAvailOrdQty;
    @FXML
    protected Label lbAvailOrdAmt;
    @FXML
    protected Label lbNum;
    @FXML
    private CheckBox checkboxFinished;
    @Inject
    private EPartService eps;
    @Inject
    private MEventService es;
    protected Predicate<Instruction> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((Instruction)en)) {
            return false;
        }
        if (!(en.getId().contains(text) || en.getBelongTo() == null || en.getBelongTo().contains(text) || en.getSecurityCode().contains(text))) {
            return false;
        }
        if (this.extend((Instruction)en)) {
            return true;
        }
        return true;
    };
    protected MxList<Instruction> mxUnList = new MxList();
    private static final List<String> FINISHED = Arrays.asList("6", "7", "4", "59", "60", "61");
    private static final List<String> BASKETTYPE = Arrays.asList("5", "13", "17", "16");
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        List newList = Collections.synchronizedList(new ArrayList());
        List unList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList().getList());
            unList.addAll(this.model.getList().getList().filtered(each -> !FINISHED.contains(each.getStatus().getRaw()) && this.canOrd((Instruction)each) != false));
        }
        this.mxList.update(newList, this.pd);
        this.mxUnList.update(unList, this.pd);
        if (this.checkUnfinished.isSelected()) {
            this.update(this.mxUnList);
            this.sumNum(this.mxUnList);
        } else {
            this.update((MxList<Instruction>)this.mxList);
            this.sumNum((MxList<Instruction>)this.mxList);
        }
        this.handleCheckBox();
        this.tableInstruction.refresh();
        this.tableInstruction.sort();
    });
    private InvalidationListener lstnSearch = ob -> Platform.runLater(() -> {
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            this.mxList.filter((List)this.model.getList().getList(), this.pd);
            this.mxUnList.filter((List)this.model.getList().getList().filtered(each -> !FINISHED.contains(each.getStatus().getRaw())), this.pd);
        }
        if (this.checkUnfinished.isSelected()) {
            this.update(this.mxUnList);
            this.sumNum(this.mxUnList);
        } else {
            this.update((MxList<Instruction>)this.mxList);
            this.sumNum((MxList<Instruction>)this.mxList);
        }
        this.tableInstruction.refresh();
        this.tableInstruction.sort();
    });
    private Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), e -> this.tableInstruction.requestFocus(), new KeyValue[0])});
    private ChangeListener<? super Boolean> lstnCheckbox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> {
                if (e.isCancelSelected()) {
                    e.setSelected(now.booleanValue());
                    e.setCancelManualSelected(true);
                } else {
                    e.setSelected(false);
                }
            });
        }
    };
    private InvalidationListener lstnPart = ob -> {
        String partId = this.shortModel.getSelectedPart();
        if (!"cms.tmx.instructions.part.shortcut.instruct.query".equals(partId)) {
            return;
        }
        Platform.runLater(() -> this.tableInstruction.requestFocus());
    };
    private InvalidationListener lstnKey = ob -> {
        String key;
        switch (key = this.shortModel.getKeyCode()) {
            case "8": 
            case "W": {
                this.aKeyDetailCancel();
                break;
            }
            case "M": {
                this.aKeyAllCancel();
                break;
            }
            case "E": {
                this.aKeyStrategyExe();
                break;
            }
            case "F": 
            case "K": {
                this.aKeySingleExe();
                break;
            }
            case "R": {
                this.aKeyInstRead();
            }
        }
    };

    @PreDestroy
    protected void close() {
        super.close();
        this.shortModel.removeSearch(this.searchText);
        this.shortModel.selectedPartProperty().removeListener(this.lstnPart);
        this.shortModel.changedProperty().removeListener(this.lstnKey);
    }

    @Focus
    public void onFocus() {
        this.tableInstruction.refresh();
    }

    @FXML
    public void initialize() {
        this.shortModel.addSearch(this.searchText);
        super.initialize();
        this.shortModel.selectedPartProperty().addListener(this.lstnPart);
        this.shortModel.changedProperty().addListener(this.lstnKey);
        this.initKeyPressHandler();
        this.timeline.setCycleCount(1);
        this.timeline.setAutoReverse(false);
        this.timeline.play();
        this.checkUnfinished();
    }

    private void checkUnfinished() {
        this.checkUnfinished.selectedProperty().addListener((ob, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.sumNum(this.mxUnList);
                this.tableInstruction.setItems(this.mxUnList.getList());
            } else {
                this.sumNum((MxList<Instruction>)this.mxList);
                this.tableInstruction.setItems(this.mxList.getList());
            }
        });
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected InvalidationListener getLstnSearch() {
        return this.lstnSearch;
    }

    private Boolean canOrd(Instruction inst) {
        if (!"2".equals(inst.getType().getRaw())) {
            return true;
        }
        if (inst.getLeavesQty() != 0L) {
            return true;
        }
        if (inst.getOrderAdvice() != null && inst.getOrderAdvice().getSide() != 49) {
            return true;
        }
        String market = inst.getMarket();
        String securityType = inst.getSecurityType();
        long availOrderQty = inst.getAvailOrderQty();
        String id = inst.getSecurityCode();
        switch (securityType) {
            case "STOCK": {
                if (id.startsWith("688")) {
                    return availOrderQty >= 200L;
                }
                return availOrderQty >= 100L;
            }
            case "FUND": {
                return availOrderQty >= 100L;
            }
            case "BOND": {
                if ("XSHE".equals(market)) {
                    return availOrderQty >= 10L;
                }
                return availOrderQty >= 1L;
            }
        }
        return true;
    }

    public boolean premise(Instruction order) {
        return "2".equals(order.getType().getRaw()) || "4".equals(order.getType().getRaw()) || "12".equals(order.getType().getRaw()) || "5".equals(order.getType().getRaw()) || "13".equals(order.getType().getRaw()) || "17".equals(order.getType().getRaw()) || "16".equals(order.getType().getRaw());
    }

    private void update(MxList<Instruction> mxList) {
        for (Instruction inst : mxList.getList()) {
            if (!"2".equals(inst.getType().getRaw()) || 50 != inst.getOrderAdvice().getOrdType()) {
                return;
            }
            inst.getCumQty();
            if ("XSHG".equals(inst.getMarket()) && !"BOND".equals(inst.getSecurityType())) continue;
        }
    }

    protected void createTable() {
        super.createTable();
        this.colCreater.setCellValueFactory(data -> ((Instruction)data.getValue()).creatorNameProperty());
        this.colLeavesAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).leavesAmtProperty());
        this.colAvailOrdQty.setCellValueFactory(data -> ((Instruction)data.getValue()).availOrderQtyProperty());
        this.colAvailOrdQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrdAvg.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().orderAvgProperty());
        this.colOrdAvg.setCellFactory(p -> new AvgCell());
        this.colOrdAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().orderAmtProperty());
        this.colOrdAmt.setCellFactory(p -> new PriceCell());
        this.colNewPrice.setCellValueFactory(data -> ((Instruction)data.getValue()).nowPriceProperty());
        this.colNewPrice.setCellFactory(p -> new PriceCell());
        this.colOrdStatus.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().ordStatusProperty());
        this.colAvailOrdAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).availOrderAmtProperty());
        this.colAvailOrdAmt.setCellFactory(p -> new PriceCell());
        this.colAvailOrdNum.setCellValueFactory(data -> ((Instruction)data.getValue()).availOrderNumProperty());
        this.colAvailOrdNum.setCellFactory(cell -> new NumberTableCell());
        this.colCumQty.setCellValueFactory(data -> ((Instruction)data.getValue()).cumQtyProperty());
        this.colCumQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrdQty.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().orderQtyProperty());
        this.colOrdQty.setCellFactory(cell -> new NumberTableCell());
        this.colAvgPx.setCellFactory(p -> new AvgCell());
        this.colUnit.setCellValueFactory(data -> ((Instruction)data.getValue()).unitProperty());
        this.colLeaveMessages.setCellValueFactory(data -> ((Instruction)data.getValue()).leaveMessagesProperty());
        this.colAuthorizer.setCellValueFactory(data -> ((Instruction)data.getValue()).authorizersProperty());
        this.colAuthorizer.setCellFactory(data -> new TooltipTableCell<Instruction, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((Instruction)this.getValue()).getAuthorizers();
            }
        });
        this.tableInstruction.getColumns().remove((Object)this.colSelected);
        this.tableInstruction.getColumns().remove((Object)this.colOrdRatio);
        this.tableInstruction.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            Instruction inst = (Instruction)Instruction.class.cast(newV);
            if (inst != null) {
                inst.getLock().lock();
                try {
                    List actions = inst.getTransferInfo().getActionInfoList();
                    boolean canReview = false;
                    for (ActionInfo actionInfo : actions) {
                        if (actionInfo.getActionId() != MxDict.WORKFLOW_REVIEW) continue;
                        canReview = true;
                    }
                    this.btnInstRead.setDisable(!canReview);
                    if (inst.getIsOrderStep()) {
                        this.btnStrategyExe.setDisable(!inst.isCanModify());
                        this.btnSingleExe.setDisable(false);
                    } else {
                        this.btnSingleExe.setDisable(true);
                        this.btnStrategyExe.setDisable(true);
                    }
                }
                finally {
                    inst.getLock().unlock();
                }
            }
        });
    }

    public void onVisit() {
        this.model.setShortcutVisible(true);
    }

    protected void listener() {
        super.listener();
        this.checkBox.selectedProperty().addListener(this.getLstnCheckbox());
    }

    public ChangeListener<? super Boolean> getLstnCheckbox() {
        return this.lstnCheckbox;
    }

    @FXML
    private Instruction getSelectedItem() {
        Instruction inst = (Instruction)this.tableInstruction.getSelectionModel().getSelectedItem();
        if (inst == null && this.tableInstruction.isFocused()) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u6307\u4ee4\uff01");
        }
        return inst;
    }

    @FXML
    private void aKeyDetailCancel() {
        Instruction inst = this.getSelectedItem();
        if (inst == null) {
            return;
        }
        this.showDetail(inst);
    }

    protected void showDetail(Instruction instruction) {
        this.selectRow(instruction);
        if (this.isBasket(instruction) && instruction.getBasketOrderAdvice() != null) {
            this.queryBasketItems(instruction);
        }
        InstructShortDialog obj = (InstructShortDialog)this.of.create(InstructShortDialog.class);
        obj.setInstruction(instruction);
        obj.setType(1);
        obj.setShowCancel(true);
        obj.setSelectedTabOrder(true);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u8be6\u60c5" + instruction.getId());
        dialog.getButton(ButtonType.CLOSE).setVisible(false);
        dialog.launch();
    }

    @FXML
    private void aKeyAllCancel() {
        Instruction inst = this.getSelectedItem();
        if (inst == null) {
            return;
        }
        String message = "";
        if (!inst.isWorkFlowDone() || "4".equals(inst.getStatus().getRaw())) {
            return;
        }
        String info = "\u662f\u5426\u64a4\u5355\uff1a" + (message = String.valueOf(message) + inst.getId() + "  ") + "?";
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, info)) {
            return;
        }
        try {
            this.model.cancelAllOrder(inst);
        }
        catch (MException e) {
            this.logger.error("\u64a4\u5355\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u64a4\u5355\u5931\u8d25");
        }
    }

    @FXML
    private void aKeySingleExe() {
        Instruction inst = this.getSelectedItem();
        if (inst == null) {
            return;
        }
        if ("4".equals(inst.getType().getRaw()) || "12".equals(inst.getType().getRaw())) {
            this.sendBasketEvent(inst);
            if (!this.p.isFocused() && !this.tableInstruction.isFocused()) {
                Platform.runLater(() -> this.p.requestFocus());
            }
            return;
        }
        if (BASKETTYPE.contains(inst.getType().getRaw())) {
            this.execNewStock(inst);
            return;
        }
        if ("2".equals(inst.getType().getRaw()) && inst.getSecurityType().equals("OIS")) {
            this.execNewStock(inst);
            return;
        }
        if (!inst.getIsOrderStep()) {
            return;
        }
        InstructionShortcutDialog obj = (InstructionShortcutDialog)((Object)this.of.create(InstructionShortcutDialog.class));
        obj.setInst(inst);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u5355\u6b65\u6267\u884c");
        obj.setMxDialog(dialog);
        ButtonType bt = dialog.launch();
        bt.equals(ButtonType.OK);
    }

    private void execNewStock(Instruction instruction) {
        MPart newPart;
        if (instruction == null) {
            return;
        }
        this.model.updateResource(instruction);
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001\u6216\u6307\u4ee4\u5269\u4f59\u53ef\u6267\u884c\u6570\u91cf");
            return;
        }
        MEvent eCall = new MEvent();
        if (instruction.getIsOrderStep() && (instruction.isRegular() || instruction.isAlgo() || instruction.isBlock() || instruction.isFutures())) {
            try {
                this.model.udpateAvailableOrderQty(instruction);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519");
                this.logger.error("\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519", (Throwable)e);
                return;
            }
        }
        if (BASKETTYPE.contains(instruction.getType().getRaw())) {
            newPart = null;
            String isOrder = "";
            String isApprove = "";
            if ("16".equals(instruction.getType().getRaw())) {
                isOrder = "cms.tmx.instructions.part.ccs.adj.approve";
                isApprove = "cms.tmx.instructions.part.ccs.adj.execute";
            } else if ("17".equals(instruction.getType().getRaw())) {
                isOrder = "cms.tmx.instructions.part.port.adj.approve";
                isApprove = "cms.tmx.instructions.part.port.adj.execute";
            } else if ("5".equals(instruction.getType().getRaw()) || "13".equals(instruction.getType().getRaw())) {
                isOrder = "cms.tmx.instructions.part.portfolio.basket.approve";
                isApprove = "cms.tmx.instructions.part.portfolio.basket.execution";
            }
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart(isApprove);
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart(isOrder);
            } else {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        if ("2".equals(instruction.getType().getRaw()) && instruction.getSecurityType().equals("OIS")) {
            newPart = null;
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart("cms.tmx.newstock.part.instruction.execution");
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart("cms.tmx.newstock.part.instruction.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }

    @FXML
    private void aKeyInstRead() {
        Instruction inst = this.getSelectedItem();
        if (inst == null) {
            return;
        }
        this.reviewed(inst, MxDict.WORKFLOW_REVIEW);
        this.btnInstRead.setDisable(true);
    }

    protected void tableDoubleClickHandler() {
        this.tableInstruction.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                this.aKeySingleExe();
            }
        });
    }

    protected ReadOnlyObjectWrapper<Object> setOperate(Instruction instruction) {
        final String[] opStr = new String[]{""};
        HBox box = new HBox(){

            public String toString() {
                return opStr[0];
            }
        };
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        ArrayList arrayList = new ArrayList();
        try {
            arrayList.addAll(instruction.getTransferInfo().getActionInfoList());
        }
        finally {
            instruction.getLock().unlock();
        }
        if (instruction.getTransferInfo() != null) {
            block15: for (ActionInfo action : arrayList) {
                Button btn = new Button(action.getActionName());
                btn.getStyleClass().add((Object)"btnOperation");
                switch (action.getActionId()) {
                    case 2: {
                        btn.setOnAction(event -> this.audit(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    case 3: {
                        btn.setOnAction(event -> this.audit(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    case 4: {
                        continue block15;
                    }
                    case 5: {
                        if ("4".equals(instruction.getType().getRaw())) {
                            btn.setOnAction(event -> this.entrustBasket(instruction, action.getActionId()));
                            opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                            break;
                        }
                        btn.setOnAction(event -> this.entrust(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    case 6: {
                        btn.setOnAction(event -> this.cancel(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    case 9: {
                        btn.setOnAction(event -> this.tradeExecute(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    case 8: {
                        btn.setOnAction(event -> this.tradeCancel(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    case 10: {
                        btn.setOnAction(event -> this.reviewed(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    case 13: {
                        btn.setOnAction(event -> this.applyCancel(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    case 14: {
                        btn.setOnAction(event -> this.approveCancel(instruction, action.getActionId()));
                        opStr[0] = String.valueOf(opStr[0]) + action.getActionName() + "  ";
                        break;
                    }
                    default: {
                        continue block15;
                    }
                }
                box.getChildren().add((Object)btn);
            }
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    @FXML
    protected void aKeyStrategyExe() {
        if (this.btnStrategyExe.isDisabled()) {
            return;
        }
        Instruction instruction = this.getSelectedItem();
        if (instruction == null) {
            return;
        }
        if (BASKETTYPE.contains(instruction.getType().getRaw())) {
            this.execNewStock(instruction);
            return;
        }
        if ("4".equals(instruction.getType().getRaw())) {
            this.sendBasketEvent(instruction);
            if (!this.p.isFocused() && !this.tableInstruction.isFocused()) {
                Platform.runLater(() -> this.p.requestFocus());
            }
            return;
        }
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001\u6216\u6307\u4ee4\u5269\u4f59\u53ef\u6267\u884c\u6570\u91cf");
            return;
        }
        InstructionShortcutAlgoDialog.setInstruction(instruction);
        InstructionShortcutAlgoDialog obj = (InstructionShortcutAlgoDialog)((Object)this.of.create(InstructionShortcutAlgoDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u7b56\u7565\u6267\u884c" + instruction.getId());
        obj.setMxDialog(dialog);
        dialog.getButton(ButtonType.OK).setVisible(false);
        ButtonType btnType = dialog.launch();
        btnType.equals(ButtonType.OK);
    }

    private void initKeyPressHandler() {
        this.searchText.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.DOWN == event.getCode() || KeyCode.TAB == event.getCode()) {
                Platform.runLater(() -> this.tableInstruction.requestFocus());
            }
        });
        this.tableInstruction.setOnKeyPressed(event -> {
            if (KeyCode.TAB == event.getCode()) {
                Platform.runLater(() -> this.searchText.requestFocus());
            }
        });
        this.tableInstruction.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableInstruction.getSelectionModel().getSelectedItem() == null && !this.tableInstruction.getItems().isEmpty()) {
                this.tableInstruction.getSelectionModel().select(0);
            }
        });
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeOneOrTwoHeadExcel(this.tableInstruction, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithTwoHead(this.tableInstruction, (int)0, (int)0);
    }

    private void sumNum(MxList<Instruction> mxList) {
        double orderAmt = 0.0;
        double orderQty = 0.0;
        double instQty = 0.0;
        double instAmt = 0.0;
        double cumQty = 0.0;
        double cumAmt = 0.0;
        double availOrdQty = 0.0;
        double availOrdAmt = 0.0;
        for (Instruction inst : mxList.getList()) {
            availOrdAmt += inst.getAvailOrderAmt();
            availOrdQty += inst.getAvailOrderNum();
            orderAmt += inst.getResource().getOrderAmt();
            orderQty += (double)inst.getResource().getOrderQty();
            instAmt += inst.getOrderAmount();
            instQty += (double)inst.getTotalExpectationQty();
            cumQty += (double)inst.getCumQty();
            cumAmt += inst.getResource().getTradeAmount();
        }
        this.lbAvailOrdAmt.setText(StringUtils.toThousands((Number)availOrdAmt, (int)2));
        this.lbAvailOrdQty.setText(StringUtils.toThousands((Number)availOrdQty, (int)2));
        this.lbOrderAmt.setText(StringUtils.toThousands((Number)orderAmt, (int)2));
        this.lbOrderQty.setText(StringUtils.toThousands((Number)orderQty, (int)2));
        this.lbInstAmt.setText(StringUtils.toThousands((Number)instAmt, (int)2));
        this.lbInstQty.setText(StringUtils.toThousands((Number)instQty, (int)2));
        this.lbCumQty.setText(StringUtils.toThousands((Number)cumQty, (int)2));
        this.lbCumAmt.setText(StringUtils.toThousands((Number)cumAmt, (int)2));
        this.lbNum.setText(StringUtils.toThousands((Number)mxList.getList().size()));
    }

    protected class AvgCell
    extends DoubleTableCell<Instruction> {
        int scale = 3;

        protected AvgCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Instruction posi = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                RefItem refItem = InstructionShortcutQueryPart.this.refMng.getItem(posi.getSecurityType(), posi.getMarket(), posi.getSecurityCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)4));
                }
            }
        }
    }

    private class MxCheckBoxTableCellIns
    extends CheckBoxTableCell<Instruction, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    this.checkbox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                        if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                            return;
                        }
                        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        Instruction inst = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                        inst.setCancelManualSelected(true);
                        System.out.println();
                    });
                    Instruction ins = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                    this.disableProperty().bind((ObservableValue)ins.canCancelProperty().not());
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected class PriceCell
    extends DoubleTableCell<Instruction> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Instruction posi = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                RefItem refItem = InstructionShortcutQueryPart.this.refMng.getItem(posi.getSecurityType(), posi.getMarket(), posi.getSecurityCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            }
        }
    }
}

