/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.shortcut;

import cms.tmx.api.data.IRefItem;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.IntegerFilter;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.core.MProps;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.instructions.models.regular.InstructionShortcutTradeModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructionShortcutDialog
extends DialogObj {
    @FXML
    private Label lbInstId;
    @FXML
    private Label lbCode;
    @FXML
    private Label lbName;
    @FXML
    private Label lbInstPrice;
    @FXML
    private Label lbInstCount;
    @FXML
    private Label lbCanCount;
    @FXML
    private Label lbMnger;
    @FXML
    private Label lbFundAccnt;
    @FXML
    private Label lbSecAccnt;
    @FXML
    private Label lbMoney;
    @FXML
    private TextField txtCountLimit;
    @FXML
    private TextField txtAmtLimit;
    @FXML
    private Label lbAllMoney;
    @FXML
    private TextField txtPrice;
    @FXML
    private TextField txtCount;
    @FXML
    private Label lbPriceErr;
    @FXML
    private Label lbCountErr;
    @FXML
    private Label lbAmtErr;
    private Instruction inst;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private InstructionShortcutTradeModel tradeModel;
    @Inject
    private MxAlert alert;
    protected transient Logger logger = LogManager.getLogger(InstructionShortcutDialog.class);
    @Inject
    private MConfService cs;
    private MxDialog dialog;
    private String countLimit = "";
    private String amtLimit = "";

    @FXML
    public void initialize() {
        MProps userProps = this.cs.getUserProps();
        this.countLimit = userProps.get("instruction.strategy.count.limit", "300000");
        this.txtCountLimit.textProperty().addListener((ob, old, now) -> {
            if ("".equals(now)) {
                return;
            }
            userProps.setValue("instruction.strategy.count.limit", now);
        });
        this.amtLimit = userProps.get("instruction.strategy.amt.limit", "5000000");
        this.txtAmtLimit.textProperty().addListener((ob, old, now) -> {
            if ("".equals(now)) {
                return;
            }
            userProps.setValue("instruction.strategy.amt.limit", now);
        });
        this.initControls();
        this.checks();
        this.initKeyPressHandler();
        Platform.runLater(() -> this.txtPrice.requestFocus());
    }

    private void initControls() {
        this.lbInstId.setText(this.inst.getId());
        this.lbCode.setText(this.inst.getSecurityCode());
        this.lbName.setText(this.inst.getOrderObj());
        this.lbInstPrice.setText(this.inst.getInsPrice());
        this.lbInstPrice.setTooltip(new Tooltip(this.inst.getInsPrice()));
        this.lbInstCount.setText(String.valueOf(this.inst.getTotalExpectationQty()));
        String avaQty = String.valueOf(this.inst.getResource().getAvailOrderQty());
        this.lbCanCount.setText(avaQty);
        this.lbMnger.setText(this.inst.getCreatorName());
        OrderAdvice advice = this.inst.getOrderAdvice();
        List listAcc = advice.getAccSecInfoList();
        if (!listAcc.isEmpty()) {
            this.lbFundAccnt.setText(((AccntSecInfo)listAcc.get(0)).getInvestorId());
            this.lbSecAccnt.setText(((AccntSecInfo)listAcc.get(0)).getSecAccntId().replaceAll("[_A-Z]*$", ""));
        }
        this.lbMoney.setText(String.valueOf(this.inst.getLeavesAmt()));
        int orderType = advice.getOrdType();
        if (50 == orderType || 99 == orderType) {
            this.txtPrice.setText(String.valueOf(this.checkPrice(this.inst)));
            int scale = this.getRefItemByIns(this.inst).getScale();
            this.txtPrice.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 6, scale)));
        } else {
            this.txtPrice.clear();
            this.txtPrice.setDisable(true);
        }
        this.txtCount.setText(avaQty);
        this.txtCount.setTextFormatter(new TextFormatter((UnaryOperator)new IntegerFilter(true, avaQty.length())));
        this.lbAllMoney.setText(this.allMoney(this.getCount(), this.getPrice()));
        this.txtCountLimit.setText(this.countLimit);
        this.txtCountLimit.setTextFormatter(new TextFormatter((UnaryOperator)new IntegerFilter(true, 1000000)));
        this.txtAmtLimit.setText(this.amtLimit);
        this.txtAmtLimit.setTextFormatter(new TextFormatter((UnaryOperator)new IntegerFilter(true, 1000000)));
        this.txtCount.textProperty().addListener((ob, old, now) -> {
            if (now == "") {
                return;
            }
            this.lbAllMoney.setText(this.allMoney((String)now, this.getPrice()));
        });
        this.txtPrice.textProperty().addListener((ob, old, now) -> {
            if (now == "") {
                return;
            }
            this.lbAllMoney.setText(this.allMoney(this.getCount(), (String)now));
        });
        this.lbCountErr.visibleProperty().addListener((ob, oldV, newV) -> System.out.println(this.lbCountErr.isVisible()));
        this.lbAmtErr.visibleProperty().addListener((ob, oldV, newV) -> System.out.println(this.lbAmtErr.isVisible()));
    }

    private void checks() {
        OrderAdvice advice = this.inst.getOrderAdvice();
        int orderType = advice.getOrdType();
        if (50 == orderType) {
            this.registerCheck((Node)this.lbPriceErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                try {
                    if (this.txtPrice.getText().isEmpty()) {
                        return false;
                    }
                    int ordType = advice.getOrdType();
                    double price = advice.getPrice();
                    double priceTxt = Double.valueOf(this.txtPrice.getText());
                    if (50 == ordType) {
                        switch (advice.getPriceLimit()) {
                            case 1: {
                                if (!(priceTxt > price)) break;
                                return false;
                            }
                            case 4: {
                                if (!(priceTxt < price)) break;
                                return false;
                            }
                            case 2: {
                                this.txtPrice.setDisable(true);
                            }
                        }
                    }
                    return true;
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                    return true;
                }
            }, (Observable[])new Observable[]{this.txtPrice.textProperty()}));
        } else if (99 == orderType) {
            this.txtPrice.setDisable(true);
        }
        this.registerCheck((Node)this.lbCountErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            try {
                if (this.txtCountLimit.getText().isEmpty()) {
                    this.lbCountErr.setText("\u6570\u91cf\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a");
                    return false;
                }
                if (this.txtCount.getText().isEmpty()) {
                    return false;
                }
                long count = Long.parseLong(this.txtCount.getText());
                long countLimit = Long.parseLong(this.txtCountLimit.getText());
                if (countLimit == 0L || count == 0L) {
                    this.lbCountErr.setText("\u6570\u91cf\u8f93\u5165\u6709\u8bef");
                    return false;
                }
                if (count > countLimit) {
                    this.lbCountErr.setText("\u6570\u91cf\u5927\u4e8e\u4e0a\u9650");
                    return false;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCount.textProperty(), this.txtCountLimit.textProperty()}));
        this.registerCheck((Node)this.lbAmtErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            try {
                System.out.println(this.txtAmtLimit.getText());
                if (this.txtAmtLimit.getText().isEmpty()) {
                    this.lbAmtErr.setText("\u8f93\u5165\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    return false;
                }
                if (this.txtPrice.getText().isEmpty()) {
                    return true;
                }
                if (this.lbAllMoney.getText().isEmpty()) {
                    return false;
                }
                double amtLimit = Double.valueOf(this.txtAmtLimit.getText());
                double amtAll = (double)Math.round(Double.valueOf(this.getCount()) * Double.valueOf(this.getPrice()) * 100.0) / 100.0;
                if (amtLimit == 0.0 || amtAll == 0.0) {
                    return false;
                }
                if (amtAll > amtLimit) {
                    this.lbAmtErr.setText("\u91d1\u989d\u5927\u4e8e\u4e0a\u9650");
                    return false;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
            }
            return true;
        }, (Observable[])new Observable[]{this.lbAllMoney.textProperty(), this.txtAmtLimit.textProperty()}));
    }

    private double checkPrice(Instruction inst) {
        OrderAdvice advice = inst.getOrderAdvice();
        int orderType = advice.getOrdType();
        double price = 0.0;
        switch (orderType) {
            case 50: 
            case 99: {
                price = advice.getPrice();
                break;
            }
            case 0: {
                MarketItem mktItem = this.getMktItemByIns(inst);
                int ask = advice.getPriceTypeBidAsk();
                if (ask > 0) {
                    price = mktItem.getBuyPrice(ask);
                    break;
                }
                if (ask < 0) {
                    price = mktItem.getSellPrice(ask);
                    break;
                }
                price = mktItem.getNowPrice();
                break;
            }
            default: {
                MarketItem mktItem = this.getMktItemByIns(inst);
                price = mktItem.getNowPrice();
            }
        }
        return price;
    }

    private RefItem getRefItemByIns(Instruction inst) {
        String code = inst.getSecurityCode();
        String market = inst.getMarket();
        String type = inst.getSecurityType();
        RefItem item = this.refMng.getItem(type, market, code);
        return item;
    }

    private MarketItem getMktItemByIns(Instruction inst) {
        RefItem item = this.getRefItemByIns(inst);
        LinkedList<RefItem> listRef = new LinkedList<RefItem>();
        listRef.add(item);
        Gears g = new Gears();
        g.setBuys();
        g.setSells();
        this.mktMng.query(listRef, g);
        MarketItem mktItem = this.mktMng.getInfo((IRefItem)item);
        return mktItem;
    }

    protected boolean isOK(ButtonType bt) {
        try {
            String priceStr = this.txtPrice.getText();
            String countStr = this.txtCount.getText();
            double price = priceStr.isEmpty() ? 0.0 : Double.parseDouble(priceStr);
            long count = countStr.isEmpty() ? 0L : Long.parseLong(this.txtCount.getText());
            this.tradeModel.execute(this.inst);
            this.tradeModel.submit(this.inst, price, count);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u6267\u884c\u6210\u529f");
        }
        catch (MException e) {
            this.logger.error("\u6267\u884c\u5931\u8d25", (Throwable)e);
            this.txtCount.requestFocus();
            this.alert.alert(Alert.AlertType.ERROR, "\u6267\u884c\u5931\u8d25: " + e.getDesc());
            return false;
        }
        return true;
    }

    private void initKeyPressHandler() {
        this.txtPrice.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.ENTER == event.getCode() || KeyCode.DOWN == event.getCode()) {
                Platform.runLater(() -> this.txtCount.requestFocus());
            }
        });
        this.txtCount.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.UP == event.getCode()) {
                Platform.runLater(() -> this.txtPrice.requestFocus());
            } else if (KeyCode.ENTER == event.getCode() || KeyCode.TAB == event.getCode()) {
                event.consume();
                Button ok = this.dialog.getButton(ButtonType.OK);
                Platform.runLater(() -> ok.requestFocus());
            }
        });
    }

    private String allMoney(String count, String price) {
        if ("".equals(count) || "".equals(price)) {
            return "";
        }
        if ("XSHG".equals(this.inst.getMarket()) && "BOND".equals(this.inst.getSecurityType())) {
            return StringUtils.toThousands((Number)(Double.valueOf(count) * Double.valueOf(price) * 10.0), (int)2);
        }
        return StringUtils.toThousands((Number)(Double.valueOf(count) * Double.valueOf(price)), (int)2);
    }

    public void setInst(Instruction inst) {
        this.inst = inst;
    }

    public String getPrice() {
        return this.txtPrice.getText();
    }

    public String getCount() {
        return this.txtCount.getText();
    }

    public void setMxDialog(MxDialog dialog) {
        this.dialog = dialog;
    }
}

