/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.shortcut;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoNode;
import cms.tmx.algorithm.viewers.AlgoUtils;
import cms.tmx.api.data.IRefItem;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.instructions.models.regular.InstructionShortcutTradeModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionShortcutAlgoNode
extends AlgoNode {
    @Inject
    private InstructionShortcutTradeModel model;
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private AlgoModel param;
    @Inject
    private IMarketDataMng mktMng;
    protected SecSuggest spCode = new SecSuggest();
    protected AutoCompletion<RefItem> autoCompletionAlgo;
    protected Map<Integer, List<Node>> mapParent = new HashMap<Integer, List<Node>>();
    public String instructionType = "0";
    public static Instruction instruction;
    private MxDialog dialog;
    @Inject
    private IRefDataMng refMng;

    @FXML
    public void initialize() {
        this.initAlgo();
        this.initControl();
        this.checks();
        this.doOrderFill();
    }

    protected List<Node> getNodeParent(Node ... nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            list.add((Node)node.getParent());
            ++n2;
        }
        return list;
    }

    private void doOrderFill() {
        if (instruction == null) {
            logger.error("shortcut algo dialog: instruction is null");
            return;
        }
        OrderAdvice advice = instruction.getOrderAdvice();
        String type = advice.getSecType();
        String market = advice.getMarket();
        String code = advice.getSec();
        this.refItem = this.refMng.getItem(type, market, code);
        String unit = QueryUtils.getUnit((String)type, (String)market);
        int scale = this.refItem.getScale();
        ArrayList<RefItem> list = new ArrayList<RefItem>();
        list.add(this.refItem);
        this.mktMng.query(list, new Gears());
        MarketItem mktItem = this.mktMng.getInfo((IRefItem)this.refItem);
        this.txtCode.setText(code);
        this.lbName.setText(advice.getSecName());
        int side = advice.getSide();
        boolean isBuy = side == 49 || advice.getSide() == 71;
        this.buyRadio.setSelected(isBuy);
        this.sellRadio.setSelected(!isBuy);
        this.btnOrder.setText(isBuy ? "\u4e70\u5165" : "\u5356\u51fa");
        this.btnOrder.setVisible(true);
        this.spnQty.getValueFactory().setValue((Object)((int)instruction.getResource().getAvailOrderQty()));
        this.cmbEngine.getSelectionModel().select((Object)"Apama\u5f15\u64ce");
        this.cmbEngine.setDisable(true);
        this.cmbAlgo.setItems(this.getAlgoList());
        this.cmbAlgo.getSelectionModel().select(0);
        this.ctrlCount.setUnit(this.refItem.getBuyUnit());
        this.lbUnit.setText(unit);
        this.ctrlPriceLow.setScale(scale);
        this.ctrlPriceUp.setScale(scale);
        this.ctrlPriceMost.setScale(scale);
        if (50 == advice.getOrdType() && "1".equals(String.valueOf(advice.getPriceLimit()))) {
            this.spnPriceUp.getEditor().setText(StringUtils.toPriceStr((double)advice.getPrice(), (double)this.refItem.getPriceUnit()));
            this.spnPriceLow.getEditor().setText(StringUtils.toPriceStr((double)mktItem.getDownLimitPrice(), (double)this.refItem.getPriceUnit()));
        } else if (50 == advice.getOrdType() && "4".equals(String.valueOf(advice.getPriceLimit()))) {
            this.spnPriceUp.getEditor().setText(StringUtils.toPriceStr((double)mktItem.getUpLimitPrice(), (double)this.refItem.getPriceUnit()));
            this.spnPriceLow.getEditor().setText(StringUtils.toPriceStr((double)advice.getPrice(), (double)this.refItem.getPriceUnit()));
        }
        this.txtCode.setEditable(false);
    }

    private ObservableList<Algorithm> getAlgoList() {
        ObservableList list = FxUtils.newList();
        for (Algorithm algo : this.getAlgos("Apama\u5f15\u64ce")) {
            if (algo.getType() != 12 && algo.getType() != 13) continue;
            Algorithm a = new Algorithm();
            a.update(algo);
            list.add((Object)a);
        }
        return list;
    }

    public void initControl() {
        super.initControl();
        this.spnTimeSlice.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.focuseOrder((KeyEvent)event));
        this.btnOrder.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.enterKeyOrder((KeyEvent)event));
    }

    private void focuseOrder(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.btnOrder.requestFocus();
            key.consume();
        }
    }

    protected void checks() {
        super.checks();
        this.registerCheck((Node)this.lbAlgoErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            try {
                if (this.cmbAlgo.getValue() == null) {
                    return false;
                }
                if (((Algorithm)this.cmbAlgo.getValue()).getType() == 18 && !"0".equals(this.instructionType)) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbAlgo.valueProperty()}));
        this.registerCheck((Node)this.lbQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int count = this.getInt(this.spnQty.getEditor());
            if (count == 0) {
                this.lbQtyErr.setText("\u8bf7\u8f93\u5165\u59d4\u6258\u6570\u91cf");
                return false;
            }
            long canCount = 0L;
            if (instruction != null && (long)count > (canCount = instruction.isCanModify() && instruction.getType().getRaw().equals("2") ? instruction.getAvailOrderQty() : (long)(instruction.getIsOrderStep() ? instruction.getAlgoParam().getOrderAvailableQuantity() : instruction.getAlgoParam().getCount()))) {
                this.lbQtyErr.setText("\u4e0d\u80fd\u8d85\u8fc7\u6307\u4ee4\u6570\u91cf" + canCount);
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQty.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbEndErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int minuter;
            boolean isRepo;
            int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
            int end = this.getInt(this.txtEndHour) * 60 + this.getInt(this.txtEndMinute);
            if (!AlgoModel.timeIsValid((int)end, (boolean)(isRepo = AlgoUtils.isRepo((RefItem)this.refItem)))) {
                if (isRepo) {
                    this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:29");
                } else {
                    this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                }
                return false;
            }
            if (end <= start) {
                this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u8d77\u59cb\u65f6\u95f4");
                return false;
            }
            Calendar calender = Calendar.getInstance();
            int hour = calender.get(11);
            if (end < hour * 60 + (minuter = calender.get(12))) {
                this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty(), this.param.minuteProperty()}));
    }

    @FXML
    public void order() {
        this.txtCode.requestFocus();
        if (this.refItem.getCode().startsWith("688")) {
            this.alert.alert(Alert.AlertType.ERROR, "\u79d1\u521b\u677f\u6682\u4e0d\u652f\u6301\u7b97\u6cd5\u4ea4\u6613\uff01");
            return;
        }
        if (!this.valid()) {
            return;
        }
        String status = instruction.getResource().getStatus();
        if ("61".equals(status)) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5df2\u64a4\u9500\uff0c\u6267\u884c\u5931\u8d25");
            return;
        }
        if ("4".equals(status)) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5df2\u5b8c\u6210\uff0c\u6267\u884c\u5931\u8d25");
            return;
        }
        try {
            this.model.execute(instruction);
            AlgoParam param = this.submitParam(this.refItem);
            String id = this.model.submit(instruction, param);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u7b56\u7565\u6267\u884c\u6210\u529f\uff1a" + id);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.dialog.close();
    }

    public void selectedAlgo(Algorithm algo) {
        if (algo == null) {
            return;
        }
        int type = algo.getType();
        this.buyRadio.setDisable(false);
        this.sellRadio.setDisable(false);
        switch (type) {
            case 10: {
                this.buyRadio.setSelected(true);
                this.buyRadio.setDisable(true);
                this.sellRadio.setDisable(true);
                this.lbPriceMost.setText("\u6700\u9ad8\u4e70\u4ef7");
                break;
            }
            case 11: {
                this.sellRadio.setSelected(true);
                this.buyRadio.setDisable(true);
                this.sellRadio.setDisable(true);
                this.lbPriceMost.setText("\u6700\u4f4e\u5356\u4ef7");
            }
        }
        if (type == 19 || type == 20) {
            type = this.buyRadio.isSelected() ? 19 : 20;
            this.priceUpAndDownLimit = false;
        } else {
            this.priceUpAndDownLimit = true;
        }
        this.vboxAlgo.getChildren().setAll((Collection)this.mapAlgo.get(type));
        this.clear(true);
        if (instruction != null && instruction.isCanModify()) {
            this.buyRadio.setDisable(true);
            this.sellRadio.setDisable(true);
        }
    }

    public TextField getTxtCode() {
        return this.txtCode;
    }

    public List<Algorithm> getAlgos(String engine, Boolean isBuy) {
        return this.algoFunc.getRegularAlgo(engine, isBuy);
    }

    public void setMxDialog(MxDialog dialog) {
        this.dialog = dialog;
    }

    public static void setInstruction(Instruction inst) {
        instruction = inst;
    }
}

