/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.shortcut;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.define.IDictMap;
import cms.tmx.define.MxDict;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.ActionInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.viewers.shortcut.UpdateInstDialog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.InstructionShortcutModel;
import cms.tmx.query.current.views.InstructShortDialog;
import cms.tmx.query.current.views.InstructionQueryPart;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionCreaterQueryPart
extends InstructionQueryPart {
    @FXML
    private HBox hboxOperate;
    @FXML
    private CheckBox checkUnfinished;
    @FXML
    protected TableView<Instruction> tableInstruction;
    @Inject
    private InstructionShortcutModel shortModel;
    @FXML
    protected TableColumn<Instruction, String> colCreater;
    @FXML
    protected TableColumn<Instruction, String> colLeavesAmt;
    @FXML
    protected TableColumn<Instruction, String> colUnit;
    @FXML
    protected TableColumn<Instruction, String> colAuthorizer;
    @FXML
    protected TableColumn<Instruction, String> colLastCaller;
    @FXML
    protected TableColumn<Instruction, Number> colAvailOrdQty;
    @FXML
    protected TableColumn<Instruction, Number> colCumQty;
    @FXML
    protected TableColumn<Instruction, Number> colOrdQty;
    @FXML
    protected TableColumn<Instruction, Number> colOrdAvg;
    @FXML
    protected TableColumn<Instruction, Number> colOrdAmt;
    @FXML
    protected TableColumn<Instruction, Number> colAvailOrdAmt;
    @FXML
    protected TableColumn<Instruction, Number> colAvailOrdNum;
    @FXML
    protected TableColumn<Instruction, MxNode> colOrdStatus;
    @FXML
    protected TableColumn<Instruction, String> colLeaveMessages;
    @FXML
    private ComboBox<String> cmbAccnt;
    @FXML
    private ComboBox<String> cmbSide;
    @FXML
    private ComboBox<String> cmbStatus;
    @FXML
    private ComboBox<String> cmbPriceTypes;
    @FXML
    protected TableColumn<Instruction, Number> colNewPrice;
    @FXML
    protected Label lbOrderQty;
    @FXML
    protected Label lbOrderAmt;
    @FXML
    protected Label lbInstQty;
    @FXML
    protected Label lbInstAmt;
    @FXML
    protected Label lbCumQty;
    @FXML
    protected Label lbCumAmt;
    @FXML
    protected Label lbAvailOrdQty;
    @FXML
    protected Label lbAvailOrdAmt;
    @FXML
    protected Label lbNum;
    @Inject
    private IFundAccountService fundService;
    @Inject
    private IDictMap dictMap;
    private static final String ALL = "\u5168\u90e8";
    private boolean auth = false;
    protected MxList<Instruction> mxUnList = new MxList();
    private static final List<String> FINISHED = Arrays.asList("6", "7", "4", "59", "60", "61");
    protected Predicate<Instruction> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((Instruction)en)) {
            return false;
        }
        if (!en.getSecurityCode().contains(text)) {
            return false;
        }
        if (this.extend((Instruction)en)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        List newList = Collections.synchronizedList(new ArrayList());
        List unList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList().getList());
            unList.addAll(this.model.getList().getList().filtered(each -> !FINISHED.contains(each.getStatus().getRaw())));
        }
        this.mxList.update(newList, this.pd);
        this.mxUnList.update(unList, this.pd);
        this.update((MxList<Instruction>)this.mxList);
        this.update(this.mxUnList);
        this.sumNum((MxList<Instruction>)this.mxList);
        this.handleCheckBox();
        this.tableInstruction.refresh();
        this.tableInstruction.sort();
    });
    private InvalidationListener lstnSearch = ob -> Platform.runLater(() -> {
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            this.mxList.filter((List)this.model.getList().getList(), this.pd);
            this.mxUnList.filter((List)this.model.getList().getList().filtered(each -> !FINISHED.contains(each.getStatus().getRaw())), this.pd);
        }
        this.update((MxList<Instruction>)this.mxList);
        this.update(this.mxUnList);
        this.sumNum((MxList<Instruction>)this.mxList);
        this.tableInstruction.refresh();
        this.tableInstruction.sort();
    });
    private Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), e -> this.tableInstruction.requestFocus(), new KeyValue[0])});
    private ChangeListener<? super Boolean> lstnCheckbox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> {
                if (e.isCancelSelected()) {
                    e.setSelected(now.booleanValue());
                    e.setCancelManualSelected(true);
                } else {
                    e.setSelected(false);
                }
            });
        }
    };
    private InvalidationListener lstnPart = ob -> {
        String partId = this.shortModel.getSelectedPart();
        if (!"cms.tmx.instructions.part.shortcut.instruct.query".equals(partId)) {
            return;
        }
        Platform.runLater(() -> this.tableInstruction.requestFocus());
    };

    public void finalize() {
        this.shortModel.removeSearch(this.searchText);
        super.finalize();
    }

    @PreDestroy
    protected void close() {
        super.close();
        this.shortModel.removeSearch(this.searchText);
        this.shortModel.selectedPartProperty().removeListener(this.lstnPart);
    }

    @FXML
    public void initialize() {
        this.shortModel.addSearch(this.searchText);
        super.initialize();
        this.shortModel.selectedPartProperty().addListener(this.lstnPart);
        this.initKeyPressHandler();
        this.timeline.setCycleCount(1);
        this.timeline.setAutoReverse(false);
        this.timeline.play();
        this.checkUnfinished();
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        this.fundService.getAllFundAccountList().forEach(fund -> {
            boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
        });
        this.cmbAccnt.setItems(listAccnt);
        this.cmbAccnt.getSelectionModel().select((Object)ALL);
        this.cmbAccnt.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
        this.cmbSide.getItems().addAll((Object[])new String[]{ALL, "\u4e70\u5165", "\u5356\u51fa", "\u6b63\u56de\u8d2d", "\u9006\u56de\u8d2d"});
        this.cmbSide.getSelectionModel().select((Object)ALL);
        this.cmbSide.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
        this.cmbStatus.getItems().addAll((Object[])new String[]{ALL, "\u6267\u884c\u5b8c\u6210", "\u6267\u884c\u4e2d", "\u5df2\u64a4\u9500"});
        this.cmbStatus.getSelectionModel().select((Object)ALL);
        this.cmbStatus.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
        this.cmbPriceTypes.getItems().addAll((Object[])new String[]{ALL, "\u9650\u4ef7", "\u4e0d\u9650"});
        this.cmbPriceTypes.getSelectionModel().select((Object)ALL);
        this.cmbPriceTypes.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.lstnSearch.invalidated(null));
        String id = this.p.getParent().getParent().getId().toUpperCase();
        String controlId = "";
        if ("CMS-TMX-INSTRUCTIONS-PART-REGULAR-INSTRUCTION-CREATER-QUERY-ZY".equals(id)) {
            controlId = "cms.tmx.instructions.part.regular.instruction.creater.query.zy_update";
        } else if ("CMS-TMX-INSTRUCTIONS-PART-REGULAR-INSTRUCTION-CREATER-QUERY".equals(id)) {
            controlId = "cms.tmx.instructions.part.regular.instruction.creater.query_update";
        }
        this.auth = this.rightsModel.registerCheck(new String[]{controlId});
    }

    private void checkUnfinished() {
        this.checkUnfinished.selectedProperty().addListener((ob, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.tableInstruction.setItems(this.mxUnList.getList());
            } else {
                this.tableInstruction.setItems(this.mxList.getList());
            }
        });
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected InvalidationListener getLstnSearch() {
        return this.lstnSearch;
    }

    private void update(MxList<Instruction> mxList) {
        for (Instruction inst : mxList.getList()) {
            inst.setAvailOrderNum(inst.getAvailOrderNum());
            inst.setAvailOrderAmt(inst.getAvailOrderAmt());
            if (!"2".equals(inst.getType().getRaw()) || 50 != inst.getOrderAdvice().getOrdType()) {
                return;
            }
            inst.getCumQty();
            if ("XSHG".equals(inst.getMarket()) && !"BOND".equals(inst.getSecurityType())) continue;
        }
    }

    public boolean premise(Instruction order) {
        String priceTypes;
        if (order.getDescId() == 8) {
            return false;
        }
        String accntNow = (String)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (accntNow == null) {
            return true;
        }
        String[] split = accntNow.split("__");
        String sideNow = (String)this.cmbSide.getSelectionModel().getSelectedItem();
        if (!ALL.equals(accntNow) && !order.getInvestId().contains(split[0])) {
            return false;
        }
        if (!ALL.equals(sideNow) && !order.getSide().contains(sideNow)) {
            return false;
        }
        String status = (String)this.cmbStatus.getSelectionModel().getSelectedItem();
        if (!ALL.equals(status)) {
            if (!"2".equals(order.getType().getRaw())) {
                return false;
            }
            if (!order.getStatus().getValue().contains(status)) {
                return false;
            }
        }
        if (!ALL.equals(priceTypes = (String)this.cmbPriceTypes.getSelectionModel().getSelectedItem())) {
            if (!"2".equals(order.getType().getRaw())) {
                return false;
            }
            if ("\u9650\u4ef7".equals(priceTypes) && (order.getOrderAdvice().getPriceLimit() == 3 || !"50".equals(String.valueOf(order.getOrderAdvice().getOrdType())))) {
                return false;
            }
            if ("\u4e0d\u9650".equals(priceTypes) && order.getOrderAdvice().getPriceLimit() != 3 && "50".equals(String.valueOf(order.getOrderAdvice().getOrdType()))) {
                return false;
            }
        }
        return true;
    }

    protected void createTable() {
        super.createTable();
        this.colCreater.setCellValueFactory(data -> ((Instruction)data.getValue()).creatorNameProperty());
        this.colLeavesAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).leavesAmtProperty());
        this.colAvailOrdQty.setCellValueFactory(data -> ((Instruction)data.getValue()).availOrderQtyProperty());
        this.colAvailOrdQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrdAvg.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().orderAvgProperty());
        this.colOrdAvg.setCellFactory(p -> new AvgCell());
        this.colOrdAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().orderAmtProperty());
        this.colOrdAmt.setCellFactory(p -> new PriceCell());
        this.colNewPrice.setCellValueFactory(data -> ((Instruction)data.getValue()).nowPriceProperty());
        this.colNewPrice.setCellFactory(p -> new PriceCell());
        this.colOrdStatus.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().ordStatusProperty());
        this.colAvailOrdAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).availOrderAmtProperty());
        this.colAvailOrdAmt.setCellFactory(p -> new PriceCell());
        this.colAvailOrdNum.setCellValueFactory(data -> ((Instruction)data.getValue()).availOrderNumProperty());
        this.colAvailOrdNum.setCellFactory(cell -> new NumberTableCell());
        this.colAvgPx.setCellFactory(p -> new AvgCell());
        this.colAvgPx.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colCumQty.setCellValueFactory(data -> ((Instruction)data.getValue()).cumQtyProperty());
        this.colCumQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrdQty.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().orderQtyProperty());
        this.colOrdQty.setCellFactory(p -> new NumCell());
        this.colUnit.setCellValueFactory(data -> ((Instruction)data.getValue()).unitProperty());
        this.colAuthorizer.setCellValueFactory(data -> ((Instruction)data.getValue()).authorizersProperty());
        this.colAuthorizer.setCellFactory(data -> new TooltipTableCell<Instruction, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((Instruction)this.getValue()).getAuthorizers();
            }
        });
        this.colLastCaller.setCellValueFactory(data -> ((Instruction)data.getValue()).lastCallerProperty());
        this.colLeaveMessages.setCellValueFactory(data -> ((Instruction)data.getValue()).leaveMessagesProperty());
        this.tableInstruction.getColumns().remove((Object)this.colSelected);
        this.tableInstruction.getColumns().remove((Object)this.colOrdRatio);
        this.tableInstruction.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            Instruction inst = (Instruction)Instruction.class.cast(newV);
            if (inst != null) {
                inst.getLock().lock();
                try {
                    List actions = inst.getTransferInfo().getActionInfoList();
                    for (ActionInfo actionInfo : actions) {
                        if (actionInfo.getActionId() != MxDict.WORKFLOW_REVIEW) continue;
                    }
                }
                finally {
                    inst.getLock().unlock();
                }
            }
        });
    }

    public void onVisit() {
        this.model.setShortcutVisible(true);
    }

    protected void listener() {
        super.listener();
        this.checkBox.selectedProperty().addListener(this.getLstnCheckbox());
    }

    public ChangeListener<? super Boolean> getLstnCheckbox() {
        return this.lstnCheckbox;
    }

    @FXML
    private Instruction getSelectedItem() {
        Instruction inst = (Instruction)this.tableInstruction.getSelectionModel().getSelectedItem();
        if (inst == null && this.tableInstruction.isFocused()) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u6307\u4ee4\uff01");
        }
        return inst;
    }

    protected void showDetail(Instruction instruction) {
        this.selectRow(instruction);
        if (this.isBasket(instruction) && instruction.getBasketOrderAdvice() != null) {
            this.queryBasketItems(instruction);
        }
        InstructShortDialog obj = (InstructShortDialog)this.of.create(InstructShortDialog.class);
        obj.setInstruction(instruction);
        obj.setType(1);
        obj.setShowCancel(true);
        obj.setSelectedTabOrder(true);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u8be6\u60c5" + instruction.getId());
        dialog.getButton(ButtonType.CLOSE).setVisible(false);
        dialog.launch();
    }

    protected List<Button> getActions(Instruction instruction) {
        ArrayList<Button> actions = new ArrayList<Button>();
        if (instruction.getTransferInfo() != null) {
            ArrayList arrayList = new ArrayList();
            instruction.getLock().lock();
            try {
                arrayList.addAll(instruction.getTransferInfo().getActionInfoList());
            }
            finally {
                instruction.getLock().unlock();
            }
            block20: for (ActionInfo action : arrayList) {
                Button btn = new Button(action.getActionName());
                btn.setMinWidth(100.0);
                btn.getStyleClass().add((Object)"btnOperation");
                switch (action.getActionId()) {
                    case 2: {
                        btn.setOnAction(event -> this.audit(instruction, action.getActionId()));
                        break;
                    }
                    case 3: {
                        btn.setOnAction(event -> this.audit(instruction, action.getActionId()));
                        break;
                    }
                    case 4: {
                        btn.setOnAction(event -> this.reject(instruction, action.getActionId()));
                        break;
                    }
                    case 5: {
                        btn.setOnAction(event -> this.entrust(instruction, action.getActionId()));
                        break;
                    }
                    case 6: {
                        btn.setOnAction(event -> this.cancel(instruction, action.getActionId()));
                        break;
                    }
                    case 9: {
                        btn.setOnAction(event -> this.tradeExecute(instruction, action.getActionId()));
                        break;
                    }
                    case 8: {
                        btn.setOnAction(event -> this.tradeCancel(instruction, action.getActionId()));
                        break;
                    }
                    case 10: {
                        btn.setOnAction(event -> this.reviewed(instruction, action.getActionId()));
                        break;
                    }
                    case 13: {
                        btn.setOnAction(event -> this.applyCancel(instruction, action.getActionId()));
                        break;
                    }
                    case 22: {
                        btn.setOnAction(event -> this.orderCancel(instruction, action.getActionId()));
                        break;
                    }
                    case 14: {
                        btn.setOnAction(event -> this.approveCancel(instruction, action.getActionId()));
                        break;
                    }
                    case 999: {
                        if (!this.auth || instruction.getDescId() != 3 || !instruction.getType().getRaw().equals("2")) continue block20;
                        if (50 == instruction.getOrderAdvice().getOrdType()) {
                            switch (instruction.getOrderAdvice().getPriceLimit()) {
                                case 1: 
                                case 2: 
                                case 4: {
                                    btn.setOnAction(event -> this.updateInst(instruction));
                                }
                            }
                            break;
                        }
                        if (49 != instruction.getOrderAdvice().getOrdType() || !"SH1".equals(instruction.getOrderAdvice().getMarketPriceLimit())) break;
                        btn.setOnAction(event -> this.updateInst(instruction));
                        break;
                    }
                    default: {
                        continue block20;
                    }
                }
                if (!this.cancelAllOrder && 22 == action.getActionId()) continue;
                actions.add(btn);
            }
        }
        return actions;
    }

    private void updateInst(Instruction inst) {
        UpdateInstDialog obj = (UpdateInstDialog)((Object)this.of.create(UpdateInstDialog.class));
        obj.setInstruction(inst);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u4fee\u6539");
        dialog.launch();
    }

    private void initKeyPressHandler() {
        this.searchText.setOnKeyPressed(event -> {
            if (event.isShiftDown() && KeyCode.TAB == event.getCode() || KeyCode.DOWN == event.getCode() || KeyCode.TAB == event.getCode()) {
                Platform.runLater(() -> this.tableInstruction.requestFocus());
            }
        });
        this.tableInstruction.setOnKeyPressed(event -> {
            if (KeyCode.TAB == event.getCode()) {
                Platform.runLater(() -> this.searchText.requestFocus());
            }
        });
        this.tableInstruction.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableInstruction.getSelectionModel().getSelectedItem() == null && !this.tableInstruction.getItems().isEmpty()) {
                this.tableInstruction.getSelectionModel().select(0);
            }
        });
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeOneOrTwoHeadExcel(this.tableInstruction, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithTwoHead(this.tableInstruction, (int)0, (int)0);
    }

    private void sumNum(MxList<Instruction> mxList) {
        double orderAmt = 0.0;
        double orderQty = 0.0;
        double instQty = 0.0;
        double instAmt = 0.0;
        double cumQty = 0.0;
        double cumAmt = 0.0;
        double availOrdQty = 0.0;
        double availOrdAmt = 0.0;
        for (Instruction inst : mxList.getList()) {
            availOrdAmt += inst.getAvailOrderAmt();
            availOrdQty += inst.getAvailOrderNum();
            orderAmt += inst.getResource().getOrderAmt();
            orderQty += (double)inst.getResource().getOrderQty();
            instAmt += inst.getOrderAmount();
            instQty += (double)inst.getTotalExpectationQty();
            cumQty += (double)inst.getCumQty();
            cumAmt += inst.getResource().getTradeAmount();
        }
        this.lbAvailOrdAmt.setText(StringUtils.toThousands((Number)availOrdAmt, (int)2));
        this.lbAvailOrdQty.setText(StringUtils.toThousands((Number)availOrdQty));
        this.lbOrderAmt.setText(StringUtils.toThousands((Number)orderAmt, (int)2));
        this.lbOrderQty.setText(StringUtils.toThousands((Number)orderQty));
        this.lbInstAmt.setText(StringUtils.toThousands((Number)instAmt, (int)2));
        this.lbInstQty.setText(StringUtils.toThousands((Number)instQty));
        this.lbCumQty.setText(StringUtils.toThousands((Number)cumQty));
        this.lbCumAmt.setText(StringUtils.toThousands((Number)cumAmt, (int)2));
        this.lbNum.setText(StringUtils.toThousands((Number)mxList.getList().size()));
    }

    protected class AvgCell
    extends DoubleTableCell<Instruction> {
        int scale = 3;

        protected AvgCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Instruction posi = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                RefItem refItem = new RefItem();
                refItem = "SHSC".equals(posi.getMarket()) || "SZSC".equals(posi.getMarket()) ? InstructionCreaterQueryPart.this.refMng.getItem(String.valueOf(posi.getSecurityType()) + posi.getMarket(), posi.getMarket(), posi.getSecurityCode()) : InstructionCreaterQueryPart.this.refMng.getItem(posi.getSecurityType(), posi.getMarket(), posi.getSecurityCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)4));
                }
            }
        }
    }

    private class MxCheckBoxTableCellIns
    extends CheckBoxTableCell<Instruction, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    this.checkbox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                        if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                            return;
                        }
                        Instruction inst = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                        inst.setCancelManualSelected(true);
                    });
                    Instruction ins = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                    this.disableProperty().bind((ObservableValue)ins.canCancelProperty().not());
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected class NumCell
    extends DoubleTableCell<Instruction> {
        int scale = 3;

        protected NumCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Instruction posi = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                RefItem refItem = new RefItem();
                refItem = "SHSC".equals(posi.getMarket()) || "SZSC".equals(posi.getMarket()) ? InstructionCreaterQueryPart.this.refMng.getItem(String.valueOf(posi.getSecurityType()) + posi.getMarket(), posi.getMarket(), posi.getSecurityCode()) : InstructionCreaterQueryPart.this.refMng.getItem(posi.getSecurityType(), posi.getMarket(), posi.getSecurityCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if (item.intValue() == 0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.intValue(), (int)0));
                }
            }
        }
    }

    protected class PriceCell
    extends DoubleTableCell<Instruction> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Instruction posi = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                RefItem refItem = new RefItem();
                refItem = "SHSC".equals(posi.getMarket()) || "SZSC".equals(posi.getMarket()) ? InstructionCreaterQueryPart.this.refMng.getItem(String.valueOf(posi.getSecurityType()) + posi.getMarket(), posi.getMarket(), posi.getSecurityCode()) : InstructionCreaterQueryPart.this.refMng.getItem(posi.getSecurityType(), posi.getMarket(), posi.getSecurityCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            }
        }
    }
}

