/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.shortcut;

import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.define.MxDict;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.instruction.ActionInfo;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.InstructExecModel;
import cms.tmx.query.current.views.InstructionQueryPart;
import cms.tmx.query.history.views.InstructionSideCell;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.di.Focus;

public class BasketInstCreaterQueryPart
extends InstructionQueryPart {
    @FXML
    private HBox hboxOperate;
    @FXML
    private CheckBox checkUnfinished;
    @FXML
    protected TableView<Instruction> tableBasketInstruction;
    @FXML
    protected TableColumn<Instruction, String> colInsId;
    @FXML
    protected TableColumn<Instruction, String> colBelongTo;
    @FXML
    protected TableColumn<Instruction, MxNode> colInsStatus;
    @FXML
    protected TableColumn<Instruction, Number> colInsProgress;
    @FXML
    protected TableColumn<Instruction, String> colInsBeginTime;
    @FXML
    protected TableColumn<Instruction, String> colInsEndTime;
    @FXML
    protected TableColumn<Instruction, String> colInsObj;
    @FXML
    protected TableColumn<Instruction, Number> colQty;
    @FXML
    protected TableColumn<Instruction, Number> colCumAmount;
    @FXML
    protected TableColumn<Instruction, String> colSide;
    @FXML
    protected TableColumn<Instruction, String> colInsInfo;
    @FXML
    protected TableColumn<Instruction, String> colExpiredDate;
    @FXML
    protected TableColumn<Instruction, Number> colOrderAmount;
    @FXML
    protected TableColumn<Instruction, String> colUnit;
    @FXML
    protected TableColumn<Instruction, Number> colCumQty;
    @FXML
    protected TableColumn<Instruction, Number> colOrdQty;
    @FXML
    protected TableColumn<Instruction, Number> colOrdAmt;
    @FXML
    private CheckComboBox ccmbAccnt;
    @FXML
    protected TableView<InstructionExec> tableOrder;
    @FXML
    protected TableColumn<InstructionExec, String> colInstId;
    @FXML
    protected TableColumn<InstructionExec, String> colSecId;
    @FXML
    protected TableColumn<InstructionExec, Number> colRate;
    @FXML
    protected TableColumn<InstructionExec, Number> colInstAmt;
    @FXML
    protected TableColumn<InstructionExec, Number> colInstQty;
    @FXML
    protected TableColumn<InstructionExec, Number> colExecQty;
    @FXML
    protected TableColumn<InstructionExec, Number> colFroQty;
    @FXML
    protected TableColumn<InstructionExec, Number> colOrderQty;
    @FXML
    protected TableColumn<InstructionExec, Number> colDealQty;
    @FXML
    protected TableColumn<InstructionExec, Number> colDealAmt;
    @FXML
    protected TableColumn<InstructionExec, Number> colCumRate;
    @FXML
    protected TableColumn<InstructionExec, Number> colRelativeWeight;
    @FXML
    protected Label lbOrderAmt;
    @FXML
    protected Label lbInstAmt;
    @FXML
    protected Label lbCumAmt;
    @FXML
    protected Label lbNum;
    @FXML
    protected Label lbOrdOrderQty;
    @FXML
    protected Label lbOrdInstQty;
    @FXML
    protected Label lbOrdCumQty;
    @FXML
    protected Label lbOrdCumAmt;
    @FXML
    protected Label lbOrdNum;
    @FXML
    protected Label lbRate;
    @FXML
    protected Label lbCumRate;
    @FXML
    private Label lbAccnt;
    private Instruction selectedItem;
    @Inject
    private IFundAccountService fundService;
    @Inject
    private InstructExecModel executionModel;
    List<String> listAccId = FxUtils.newList();
    private MxList<InstructionExec> execuMxList = new MxList();
    private static final String ALL = "\u5168\u90e8";
    private static final List<String> FINISHED = Arrays.asList("6", "7", "4", "59", "60", "61");
    boolean ccmbfalg = false;
    protected Predicate<Instruction> pd = en -> {
        if (!this.premise((Instruction)en)) {
            return false;
        }
        if (this.extend((Instruction)en)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnModel = ob -> {
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList().getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> {
            this.sumNum((MxList<Instruction>)this.mxList);
            this.handleCheckBox();
            this.tableBasketInstruction.refresh();
            this.tableBasketInstruction.sort();
        });
    };
    private InvalidationListener lstnInstModel = ob -> this.refreshOrder();
    private InvalidationListener lstnSearch = ob -> Platform.runLater(() -> {
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            this.mxList.filter((List)this.model.getList().getList(), this.pd);
        }
        this.sumNum((MxList<Instruction>)this.mxList);
        this.tableBasketInstruction.refresh();
        this.tableBasketInstruction.sort();
    });
    private Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), e -> this.tableBasketInstruction.requestFocus(), new KeyValue[0])});
    private ChangeListener<? super Boolean> lstnCheckbox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> {
                if (e.isCancelSelected()) {
                    e.setSelected(now.booleanValue());
                    e.setCancelManualSelected(true);
                } else {
                    e.setSelected(false);
                }
            });
        }
    };

    public void finalize() {
        super.finalize();
    }

    @PreDestroy
    protected void close() {
        super.close();
        this.tableBasketInstruction.getSelectionModel().selectedItemProperty().removeListener(this.lstnInstModel);
    }

    @FXML
    public void initialize() {
        this.tableBasketInstruction.getSelectionModel().clearSelection();
        this.refresh();
        this.refreshOrder();
        this.createTable();
        this.createInstExecTable();
        this.onFocus();
        this.checkUnfinished();
        this.initCheckCmbBox();
        this.listener();
        this.refresh();
        this.refreshOrder();
    }

    private void initCheckCmbBox() {
        ObservableList listAccnt = FxUtils.newArrayList();
        listAccnt.add((Object)ALL);
        this.fundService.getAllFundAccountList().forEach(fund -> {
            boolean bl = listAccnt.add((Object)(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName()));
        });
        this.ccmbAccnt.getItems().addAll((Collection)listAccnt);
        this.ccmbAccnt.getCheckModel().checkAll();
        this.listAccId.addAll((Collection<String>)listAccnt);
        int i = 1;
        while (i < listAccnt.size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.ccmbfalg) {
                    this.ccmbfalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.ccmbfalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.ccmbfalg) {
                this.ccmbfalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.ccmbfalg = true;
            }
        });
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = ALL;
            if (!listItem.contains(ALL)) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.refresh();
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
        this.lstnSearch.invalidated(null);
        this.ccmbfalg = true;
    }

    private void checkUnfinished() {
        this.checkUnfinished.selectedProperty().addListener((ob, oldVal, newVal) -> this.tableBasketInstruction.setItems(this.mxList.getList()));
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void refreshOrder() {
        this.selectedItem = (Instruction)this.tableBasketInstruction.getSelectionModel().getSelectedItem();
        if (this.selectedItem != null) {
            List itemList;
            this.executionModel.setInstruction(this.selectedItem, 1);
            this.queryItems(this.selectedItem);
            List<InstructionExec> execList = Collections.synchronizedList(new ArrayList());
            try {
                this.executionModel.fullQuery();
            }
            catch (MException e) {
                this.logger.error("\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u6210\u5206\u80a1\u5931\u8d25\uff1a " + e.getMessage(), (Throwable)e);
            }
            ObservableList e = this.executionModel.getList();
            synchronized (e) {
                execList.addAll((Collection<InstructionExec>)this.executionModel.getList());
            }
            HashMap<String, InstructionExec> execMap = new HashMap<String, InstructionExec>();
            for (InstructionExec instructionExec : execList) {
                execMap.put(instructionExec.getSecId(), instructionExec);
            }
            if ("16".equals(this.selectedItem.getType().getRaw()) || "17".equals(this.selectedItem.getType().getRaw())) {
                itemList = this.selectedItem.getAdjustPosAdvice().getItems();
                for (BasketAlgoItem basketAlgoItem : itemList) {
                    if (!execMap.containsKey(basketAlgoItem.getCode())) continue;
                    ((InstructionExec)execMap.get(basketAlgoItem.getCode())).setRelativeWeight(basketAlgoItem.getDestWeight());
                }
            } else {
                itemList = this.selectedItem.getBasketOrderAdvice().getItemList();
                block7: for (InstructionExec instructionExec : execList) {
                    for (BasketSecurityInst basketSecurityInst : itemList) {
                        if (!basketSecurityInst.getSecurityId().equals(instructionExec.getSecId())) continue;
                        instructionExec.setRelativeWeight(basketSecurityInst.getRelativeWeight());
                        continue block7;
                    }
                }
            }
            this.execuMxList.update(execList);
            Platform.runLater(() -> {
                this.sumOrdNum(this.execuMxList);
                this.tableOrder.refresh();
                this.tableOrder.sort();
            });
        } else {
            this.execuMxList.clear();
            Platform.runLater(() -> {
                this.sumOrdNum(this.execuMxList);
                this.tableOrder.refresh();
                this.tableOrder.sort();
            });
        }
    }

    protected void queryItems(Instruction instruction) {
        try {
            if ("17".equals(instruction.getType().getRaw()) || "16".equals(instruction.getType().getRaw())) {
                this.model.queryAdjItems(instruction);
            } else {
                this.model.queryBasketItems(instruction);
            }
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                this.logger.error("\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            });
        }
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    public boolean premise(Instruction order) {
        ObservableList listAccnt = this.ccmbAccnt.getCheckModel().getCheckedItems();
        boolean flag = false;
        for (String accId : listAccnt) {
            String[] split = accId.split("__");
            if (!split[0].equals(order.getInvestId())) continue;
            flag = true;
            break;
        }
        if (!("4".equals(order.getType().getRaw()) || "12".equals(order.getType().getRaw()) || "5".equals(order.getType().getRaw()) || "13".equals(order.getType().getRaw()) || "17".equals(order.getType().getRaw()) || "16".equals(order.getType().getRaw()))) {
            return false;
        }
        if (listAccnt.contains(ALL)) {
            flag = true;
        }
        if (!flag) {
            return flag;
        }
        return true;
    }

    protected void createTable() {
        this.colSelected.setGraphic((Node)this.checkBox);
        this.colSelected.setCellValueFactory(data -> ((Instruction)data.getValue()).selectedProperty());
        this.colSelected.setCellFactory(data -> new MxCheckBoxTableCellIns());
        this.colSelected.setSortable(false);
        this.colSelected.getTableView().setEditable(true);
        this.colInsId.setCellValueFactory(data -> ((Instruction)data.getValue()).idProperty());
        this.colBelongTo.setCellValueFactory(data -> ((Instruction)data.getValue()).belongToProperty());
        this.colBelongTo.setCellFactory(data -> new TooltipTableCell<Instruction, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((Instruction)this.getValue()).belongToProperty().get();
            }
        });
        this.colInsProgress.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().ratioProperty());
        this.colInsProgress.setCellFactory(p -> new DoubleTableCell());
        this.colInsStatus.setCellValueFactory(data -> ((Instruction)data.getValue()).statusProperty());
        this.colInsBeginTime.setCellValueFactory(data -> ((Instruction)data.getValue()).beginTimeProperty());
        this.colInsEndTime.setCellValueFactory(data -> ((Instruction)data.getValue()).endTimeProperty());
        this.colInsObj.setCellValueFactory(data -> ((Instruction)data.getValue()).orderObjProperty());
        this.colQty.setCellValueFactory(data -> ((Instruction)data.getValue()).totalExpectationQtyProperty());
        this.colQty.setCellFactory(cell -> new NumberTableCell());
        this.colSide.setCellValueFactory(data -> ((Instruction)data.getValue()).sideProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.colCumAmount.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().tradeAmountProperty());
        this.colCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colOrderAmount.setCellValueFactory(data -> ((Instruction)data.getValue()).orderAmountProperty());
        this.colOrderAmount.setCellFactory(cell -> new DoubleTableCell());
        this.colOrdAmt.setCellValueFactory(data -> ((Instruction)data.getValue()).effectOrderAmtProperty());
        this.colOrdAmt.setCellFactory(p -> new PriceCell());
        this.colCumQty.setCellValueFactory(data -> ((Instruction)data.getValue()).cumQtyProperty());
        this.colCumQty.setCellFactory(cell -> new NumberTableCell());
        this.colOrdQty.setCellValueFactory(data -> ((Instruction)data.getValue()).effectOrderQtyProperty());
        this.colOrdQty.setCellFactory(cell -> new NumberTableCell());
        this.colInsId.setCellValueFactory(data -> ((Instruction)data.getValue()).idProperty());
        this.colBelongTo.setCellValueFactory(data -> ((Instruction)data.getValue()).belongToProperty());
        this.colBelongTo.setCellFactory(data -> new TooltipTableCell<Instruction, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((Instruction)this.getValue()).belongToProperty().get();
            }
        });
        this.colInsProgress.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().ratioProperty());
        this.colInsProgress.setCellFactory(p -> new DoubleTableCell());
        this.colInsStatus.setCellValueFactory(data -> ((Instruction)data.getValue()).statusProperty());
        this.colInsBeginTime.setCellValueFactory(data -> ((Instruction)data.getValue()).beginTimeProperty());
        this.colInsEndTime.setCellValueFactory(data -> ((Instruction)data.getValue()).endTimeProperty());
        this.colInsObj.setCellValueFactory(data -> ((Instruction)data.getValue()).orderObjProperty());
        this.colQty.setCellValueFactory(data -> ((Instruction)data.getValue()).totalExpectationQtyProperty());
        this.colQty.setCellFactory(cell -> new NumberTableCell());
        this.colSide.setCellValueFactory(data -> ((Instruction)data.getValue()).sideProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.colCumAmount.setCellValueFactory(data -> ((Instruction)data.getValue()).getResource().tradeAmountProperty());
        this.colCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colOrderAmount.setCellValueFactory(data -> ((Instruction)data.getValue()).orderAmountProperty());
        this.colOrderAmount.setCellFactory(cell -> new DoubleTableCell());
        this.tableBasketInstruction.setItems(this.mxList.getList());
        this.tableBasketInstruction.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableBasketInstruction);
        this.tableBasketInstruction.getColumns().remove((Object)this.colSelected);
        this.tableBasketInstruction.getColumns().remove((Object)this.colOrdRatio);
        this.tableBasketInstruction.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            Instruction inst = (Instruction)Instruction.class.cast(newV);
            if (inst != null) {
                inst.getLock().lock();
                try {
                    List actions = inst.getTransferInfo().getActionInfoList();
                    for (ActionInfo actionInfo : actions) {
                        if (actionInfo.getActionId() != MxDict.WORKFLOW_REVIEW) continue;
                    }
                }
                finally {
                    inst.getLock().unlock();
                }
            }
        });
    }

    private void createInstExecTable() {
        this.colInstId.setCellValueFactory(data -> ((InstructionExec)data.getValue()).instructIdProperty());
        this.colSecId.setCellValueFactory(data -> ((InstructionExec)data.getValue()).secIdProperty());
        this.colRate.setCellValueFactory(data -> ((InstructionExec)data.getValue()).donePercentProperty());
        this.colRate.setCellFactory(cell -> new DoubleTableCell());
        this.colRelativeWeight.setCellValueFactory(data -> ((InstructionExec)data.getValue()).relativeWeightProperty());
        this.colRelativeWeight.setCellFactory(p -> new FourCell());
        this.colInstQty.setCellValueFactory(data -> ((InstructionExec)data.getValue()).expectQtyProperty());
        this.colInstAmt.setCellValueFactory(data -> ((InstructionExec)data.getValue()).orderAmountProperty());
        this.colExecQty.setCellValueFactory(data -> ((InstructionExec)data.getValue()).orderQtyProperty());
        this.colOrderQty.setCellValueFactory(data -> ((InstructionExec)data.getValue()).orderQtyProperty());
        this.colFroQty.setCellValueFactory(data -> ((InstructionExec)data.getValue()).leavesQtyProperty());
        this.colDealQty.setCellValueFactory(data -> ((InstructionExec)data.getValue()).cumQtyProperty());
        this.colCumRate.setCellValueFactory(data -> ((InstructionExec)data.getValue()).executePercentProperty());
        this.colCumRate.setCellFactory(cell -> new DoubleTableCell());
        this.colDealAmt.setCellValueFactory(data -> ((InstructionExec)data.getValue()).cumAmountProperty());
        this.tableOrder.setItems(this.execuMxList.getList());
    }

    public void onVisit() {
        this.model.setShortcutVisible(true);
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.getLstnModel());
        this.searchText.textProperty().addListener(this.getLstnSearch());
        this.checkBox.selectedProperty().addListener(this.getLstnCheckbox());
        this.tableBasketInstruction.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.tableBasketInstruction.getSelectionModel().getSelectedItem() == null && !this.tableBasketInstruction.getItems().isEmpty()) {
                this.tableBasketInstruction.getSelectionModel().clearSelection();
            }
        });
        this.checkBox.selectedProperty().addListener(this.getLstnCheckbox());
        this.tableBasketInstruction.getSelectionModel().selectedItemProperty().addListener(this.lstnInstModel);
    }

    public ChangeListener<? super Boolean> getLstnCheckbox() {
        return this.lstnCheckbox;
    }

    @FXML
    private Instruction getSelectedItem() {
        Instruction inst = (Instruction)this.tableBasketInstruction.getSelectionModel().getSelectedItem();
        if (inst == null && this.tableBasketInstruction.isFocused()) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u6307\u4ee4\uff01");
        }
        return inst;
    }

    protected void showDetail(Instruction instruction) {
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeOneOrTwoHeadExcel(this.tableBasketInstruction, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void exportOrderExcel() {
        try {
            ExcelUtils.writeOneOrTwoHeadExcel(this.tableOrder, (String)"\u7bee\u5b50\u6307\u4ee4\u660e\u7ec6");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithTwoHead(this.tableBasketInstruction, (int)0, (int)0);
    }

    @FXML
    public void copyOrder() {
        TableUtils.copyContentWithTwoHead(this.tableOrder, (int)0, (int)0);
    }

    @Focus
    public void onFocus() {
    }

    private void sumNum(MxList<Instruction> mxList) {
        double orderAmt = 0.0;
        double instAmt = 0.0;
        double cumAmt = 0.0;
        for (Instruction inst : mxList.getList()) {
            orderAmt += inst.getEffectOrderAmt();
            instAmt += inst.getOrderAmount();
            cumAmt += inst.getResource().getTradeAmount();
        }
        this.lbOrderAmt.setText(StringUtils.toThousands((Number)orderAmt, (int)2));
        this.lbInstAmt.setText(StringUtils.toThousands((Number)instAmt, (int)2));
        this.lbCumAmt.setText(StringUtils.toThousands((Number)cumAmt, (int)2));
        this.lbNum.setText(StringUtils.toThousands((Number)mxList.getList().size(), (int)0));
        this.lbRate.setText(StringUtils.toThousands((Number)((double)Math.round(cumAmt / instAmt * 100.0 * 100.0) / 100.0), (int)2));
    }

    private void sumOrdNum(MxList<InstructionExec> mxList) {
        double orderQty = 0.0;
        double instQty = 0.0;
        double cumQty = 0.0;
        double cumAmt = 0.0;
        double instAmt = 0.0;
        for (InstructionExec inst : mxList.getList()) {
            orderQty += (double)inst.getOrderQty();
            instQty += (double)inst.getExpectQty();
            cumQty += (double)inst.getCumQty();
            cumAmt += inst.getCumAmount();
            instAmt += inst.getOrderAmount();
            inst.setDonePercent((double)Math.round(inst.getOrderAmount() / this.selectedItem.getOrderAmount() * 100.0 * 100.0) / 100.0);
        }
        this.lbOrdOrderQty.setText(StringUtils.toThousands((Number)orderQty, (int)2));
        this.lbOrdInstQty.setText(StringUtils.toThousands((Number)instQty, (int)2));
        this.lbOrdCumQty.setText(StringUtils.toThousands((Number)cumQty, (int)2));
        this.lbOrdCumAmt.setText(StringUtils.toThousands((Number)cumAmt, (int)2));
        this.lbOrdNum.setText(StringUtils.toThousands((Number)mxList.getList().size()));
        this.tableOrder.refresh();
    }

    protected class AvgCell
    extends DoubleTableCell<Instruction> {
        int scale = 3;

        protected AvgCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Instruction posi = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                RefItem refItem = BasketInstCreaterQueryPart.this.refMng.getItem(posi.getSecurityType(), posi.getMarket(), posi.getSecurityCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)4));
            }
        }
    }

    protected class FourCell
    extends DoubleTableCell<InstructionExec> {
        int scale = 3;

        protected FourCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                InstructionExec posi = (InstructionExec)InstructionExec.class.cast(this.getTableRow().getItem());
                RefItem refItem = BasketInstCreaterQueryPart.this.refMng.getItem(posi.getInstrument().getSecType(), posi.getMarket(), posi.getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)4));
            }
        }
    }

    private class MxCheckBoxTableCellIns
    extends CheckBoxTableCell<Instruction, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    this.checkbox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                        if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                            return;
                        }
                        Instruction inst = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                        inst.setCancelManualSelected(true);
                    });
                    Instruction ins = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                    this.disableProperty().bind((ObservableValue)ins.canCancelProperty().not());
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected class PriceCell
    extends DoubleTableCell<Instruction> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                Instruction posi = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                RefItem refItem = BasketInstCreaterQueryPart.this.refMng.getItem(posi.getSecurityType(), posi.getMarket(), posi.getSecurityCode());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

