/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.regular;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.viewers.regular.InstructionCcsPassivePart;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionCcsExecutionPart
extends InstructionCcsPassivePart {
    @Override
    protected void setPrePrice() {
        if (this.ccsModel.isBidAskPrice() && !this.priceSettle) {
            this.ccsModel.setBidAskPrice();
            if (this.ccsModel.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
        if (this.ccsModel.isMktPrice() && !this.priceSettle) {
            this.ccsModel.setMktPrice();
            if (this.ccsModel.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
    }

    @Inject
    public InstructionCcsExecutionPart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.es.subscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    @FXML
    public void initialize() {
        this.ccsModel.create("4");
        this.algoNode.instructionType = "4";
        this.setBuySymbol("\u4e70\u5165");
        this.setSellSymbol("\u5356\u51fa");
        super.initialize();
        this.mktItem.changedProperty().addListener(ob -> this.setPrePrice());
    }

    @PreDestroy
    public void destroy() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    protected boolean validOrderFill() {
        Instruction eventInstr = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        return ("2".equals(eventInstr.getType().getRaw()) || "8".equals(eventInstr.getType().getRaw())) && !eventInstr.getSide().equals("\u65b0\u80a1\u7533\u8d2d") && eventInstr.getIsOrderStep();
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(this.ccsModel.isMktPrice() || this.ccsModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    public void setPrice(double price) {
        if ((this.ccsModel.isLimitPrice() || this.ccsModel.isAfterHoursPrice()) && !this.ccsModel.isSpecify() && price > 0.0) {
            this.ccsModel.setPrice(price);
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    }

    @Override
    protected ObservableList<Boolean> doAction() throws MException {
        this.ccsModel.execute(this.instruction);
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.regular.unfinished.query");
        }
        return super.doAction();
    }

    @Override
    protected void disable(boolean disable) {
        this.algoNode.disable(this.instruction.getAlgoParam().getAlgorithm().getType(), disable, true);
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.isLimitPrice() || this.ccsModel.isSpecify() || this.ccsModel.getAccDisModel().isActive(), (Observable[])new Observable[]{this.ccsModel.priceStgProperty(), this.ccsModel.priceTypeLimitedStgProperty(), this.ccsModel.getAccDisModel().activeProperty()}));
    }

    @Override
    protected void doSetCode() {
        super.doSetCode();
        if (!this.initFinished || this.instruction == null) {
            return;
        }
        if (this.instruction.isCanModify()) {
            return;
        }
        if (this.instruction.getType().getRaw().equals("2")) {
            this.tabNormal.setDisable(false);
            this.tabAlgo.setDisable(true);
        } else if (this.instruction.getType().getRaw().equals("8")) {
            this.tabNormal.setDisable(true);
            this.tabAlgo.setDisable(false);
        }
        this.layout();
    }
}

