/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.regular;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.RiskCheckResult;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.viewers.regular.AlgoNodeInstructionCcsZY;
import cms.tmx.instructions.viewers.regular.InstructionCcsInstructPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.trade.utils.TradeBindings;
import java.net.URL;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionCcsExecutionAutotrophyPart
extends InstructionCcsInstructPart {
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private Label LbLowPrice;
    @FXML
    private Label LbHighPrice;
    @FXML
    private Label LbOpenPrice;
    @FXML
    private Label LbClosePrice;
    @Inject
    public AlgoNodeInstructionCcsZY algoNodeZY;
    protected boolean initFinished = false;
    CcsPosition pos;
    private MEventHandler fullCode = event -> Platform.runLater(() -> {
        CcsPosition pos;
        this.pos = pos = (CcsPosition)event.getObj(CcsPosition.class);
        this.doSetCode();
    });
    private MEventHandler fillCode = event -> Platform.runLater(() -> {
        Instruction ins = (Instruction)event.getObj(Instruction.class);
        if (ins.isRegular()) {
            this.tabNormal.getTabPane().getSelectionModel().select((Object)this.tabNormal);
        } else if (ins.isAlgo()) {
            this.tabNormal.getTabPane().getSelectionModel().select((Object)this.tabAlgo);
        } else {
            return;
        }
        String secCode = ins.getSecurityCode();
        RefItem refItem = this.refMng.getItem(ins.getSecurityType(), ins.getMarket(), ins.getSecurityCode());
        this.txtCode.setUserData((Object)refItem);
        this.txtCode.setText(secCode);
        this.algoNode.txtCode.setUserData((Object)refItem);
        this.algoNode.txtCode.setText(secCode);
        this.autoCompletionNormal.setChange(secCode);
        this.autoCompletionAlgo.setChange(secCode);
        if (ins.getOrderAdvice().getSide() == 50 || ins.getOrderAdvice().getSide() == 70) {
            this.sellRadio.setSelected(true);
        } else {
            this.buyRadio.setSelected(true);
        }
    });

    @Override
    protected boolean isAutotrophy() {
        return true;
    }

    @PostConstruct
    public void init() {
        this.algoNode = this.algoNodeZY;
        super.init();
        this.es.subscribe("instruction.set.on.autotrophy.panel", this.fullCode);
        this.es.subscribe("instruction.set.on.panel.zy", this.fillCode);
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.initFinished = true;
        this.acctTreeTable.getColumns().remove((Object)this.assetCol);
        this.acctTreeTable.getColumns().remove((Object)this.buyCostCol);
        this.acctTreeTable.getColumns().remove((Object)this.posiCapitalCol);
        this.acctTreeTable.getColumns().remove((Object)this.floatPlCol);
        this.acctTreeTable.getColumns().remove((Object)this.realPlCol);
        this.acctTreeTable.getColumns().remove((Object)this.totalPlCol);
        this.acctTreeTable.getColumns().remove((Object)this.weightCol);
        this.acctTreeTable.getColumns().remove((Object)this.amountCol);
        this.acctTreeTable.getColumns().remove((Object)this.canBuyCol);
        this.acctTreeTable.getColumns().remove((Object)this.canSellCol);
        this.acctTreeTable.getColumns().remove((Object)this.productCol);
        Platform.runLater(() -> this.doSetCode());
    }

    protected void doSetCode() {
        if (!this.initFinished || this.pos == null) {
            return;
        }
        String secCode = this.pos.getSecId();
        this.tabNormal.getTabPane().getSelectionModel().select((Object)this.tabNormal);
        RefItem refItem = this.refMng.getItem(this.pos.getSecType(), this.pos.getMarket().getRaw(), this.pos.getSecId());
        this.txtCode.setUserData((Object)refItem);
        this.txtCode.setText(secCode);
        this.autoCompletionNormal.setChange(this.txtCode.getText());
        this.sellRadio.setSelected(this.pos.isSell().booleanValue());
        this.buyRadio.setSelected(this.pos.isSell() == false);
    }

    @Override
    @PreDestroy
    public void close() {
        super.close();
        this.es.unSubscribe("instruction.set.on.autotrophy.panel", this.fullCode);
        this.es.unSubscribe("instruction.set.on.panel.zy", this.fillCode);
    }

    @Override
    protected void createMarketTable() {
        super.createMarketTable();
        this.LbLowPrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getLowPrice()));
        this.LbHighPrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getHighPrice()));
        this.LbOpenPrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getOpenPrice()));
        this.LbClosePrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getClosePrice()));
        this.LbLowPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getLowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.LbHighPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getHighPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.LbOpenPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getOpenPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.LbClosePrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getClosePrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.LbLowPrice, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getLowPrice());
            CssUtils.checkPrice((Control)this.LbHighPrice, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getHighPrice());
            CssUtils.checkPrice((Control)this.LbOpenPrice, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getOpenPrice());
            CssUtils.checkPrice((Control)this.LbClosePrice, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getClosePrice());
        });
    }

    @Override
    protected void onRefChange() {
        TradeBindings.priceBinding((Property)this.LbLowPrice.textProperty(), (ObservableNumberValue)this.mktItem.lowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.LbHighPrice.textProperty(), (ObservableNumberValue)this.mktItem.highPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.LbOpenPrice.textProperty(), (ObservableNumberValue)this.mktItem.openPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.LbClosePrice.textProperty(), (ObservableNumberValue)this.mktItem.closePriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        super.onRefChange();
    }

    @Override
    protected void submitOrder() {
        ArrayList<RiskCheckResult> warns = new ArrayList<RiskCheckResult>();
        ArrayList<RiskCheckResult> forbids = new ArrayList<RiskCheckResult>();
        for (TreeItem acc : this.ccsModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            ((CcsAccountDistribution)acc.getValue()).setRiskForbid(false);
            RiskCheckResult res = this.ccsModel.riskRangeCheck((TreeItem<CcsAccountDistribution>)acc);
            if (res.warn > 0) {
                warns.add(res);
            }
            if (res.forbid <= 0) continue;
            forbids.add(res);
        }
        for (RiskCheckResult riskCheckResult : warns) {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u5f53\u524d\u8bc1\u5238 " + this.txtCode.getText() + this.lbName.getText() + " \u4e0d\u5c5e\u4e8e\u4f18\u9009\u5907\u9009\u6c60\uff0c\u662f\u5426\u8981\u7ee7\u7eed\u4ea4\u6613?")) continue;
            ((CcsAccountDistribution)riskCheckResult.getAcc().getValue()).setRiskForbid(true);
        }
        for (RiskCheckResult riskCheckResult : forbids) {
            this.alert.alert(Alert.AlertType.WARNING, "\u5f53\u524d\u8bc1\u5238 " + this.txtCode.getText() + this.lbName.getText() + " \u5c5e\u4e8e\u7981\u6b62\u6c60\uff0c\u7981\u6b62\u4ea4\u6613");
            ((CcsAccountDistribution)riskCheckResult.getAcc().getValue()).setRiskForbid(true);
        }
        if (this.ccsModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && !((CcsAccountDistribution)ad.getValue()).isRiskForbid()).size() == 0) {
            return;
        }
        try {
            ObservableList<Boolean> listCont = this.doAction();
            if (listCont.filtered(each -> each == false).size() > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            } else {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        this.clearCountCheck();
    }

    @Override
    protected ObservableList<Boolean> doAction() throws MException {
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.regular.instruction.creater.query.zy");
        }
        return this.ccsModel.submitAdvice(true);
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Override
    public void controlFix() {
        this.quantitySpn.getEditor().setOnMouseClicked(event -> {});
    }

    @Override
    protected void clearCountCheck() {
        this.txtCode.requestFocus();
        this.txtCode.clear();
        this.lbName.setText("");
        this.buyRadio.setSelected(true);
        this.algoNode.buyRadio.setSelected(true);
        super.clearCountCheck();
    }
}

