/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.regular;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MException;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.entity.trade.instruction.RespResult;
import cms.tmx.instructions.models.regular.InstructionCcsAlgoModel;
import cms.tmx.instructions.models.regular.InstructionCcsBaseModel;
import cms.tmx.instructions.viewers.portfolio.AlgoNodeInstruction;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.math.BigDecimal;
import java.util.List;
import java.util.ListIterator;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoNodeInstructionCcs
extends AlgoNodeInstruction {
    @Inject
    public InstructionCcsAlgoModel model;
    @Inject
    private UserPreOrderTips setTips;

    @FXML
    public void initialize() {
        this.model.baseModel = (InstructionCcsBaseModel)this.of.create(InstructionCcsBaseModel.class);
        this.initAlgo();
        this.initControl();
        this.checks();
    }

    public void initControl() {
        super.initControl();
        MxBindings.bindSI((Property)this.spnQty.getEditor().textProperty(), (Property)this.model.countAlgoProperty());
    }

    public void onSecurityChange(TextField txtCode) {
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.doChange(refItem);
    }

    public void doChange(RefItem refItem) {
        this.lbName.setText(this.model.baseModel.getName());
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        this.refItem = refItem;
        if (refItem == null) {
            this.lbName.setTooltip(null);
            return;
        }
        if (refItem.isGem()) {
            if (refItem.getStatus().contains("\u4e0a\u5e02\u521d\u671f") || refItem.getStatus().contains("\u4e0a\u5e02\u9996\u65e5")) {
                this.lbName.setText(String.valueOf(this.model.baseModel.getName()) + " " + "\u521d");
            }
            Tooltip tooltip = new Tooltip();
            StringBuilder builder = new StringBuilder();
            builder.append(refItem.getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
            builder.append("\r\n");
            builder.append(refItem.getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
            builder.append("\r\n");
            builder.append(refItem.getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
            builder.append("\r\n");
            builder.append(refItem.getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
            builder.append("\r\n");
            tooltip.setText(builder.toString());
            this.lbName.setTooltip(tooltip);
            this.lbName.setStyle("-fx-font-size: 12;");
        } else if ("FUND".equals(refItem.getType())) {
            BigDecimal down = new BigDecimal(refItem.getLimitDownRate());
            BigDecimal up = new BigDecimal(refItem.getLimitUpRate());
            if (down.doubleValue() == 0.2 || up.doubleValue() == 0.2) {
                this.lbName.setText(String.valueOf(refItem.getName()) + "(\u6da8\u8dcc20%)");
                Tooltip tooltip = new Tooltip();
                tooltip.setText(String.valueOf(refItem.getName()) + "(\u6da8\u8dcc20%)");
                this.lbName.setTooltip(tooltip);
                this.lbName.setStyle("-fx-font-size: 10;");
            }
        } else {
            this.lbName.setStyle("-fx-font-size: 12;");
            this.lbName.setTooltip(null);
        }
        int scale = 0;
        String unit = "";
        if (refItem != null) {
            String type = refItem.getType();
            String market = refItem.getMarket();
            unit = QueryUtils.getUnit((String)type, (String)market);
            scale = refItem.getScale();
            this.ctrlCount.setUnit(refItem.getBuyUnit());
            this.ctrlExposedCount.setUnit(refItem.getBuyUnit());
            this.checkRadioName();
        }
        this.lbUnit.setText(unit);
        this.lbExpUnit.setText(unit);
        this.ctrlPriceLow.setScale(scale);
        this.ctrlPriceUp.setScale(scale);
        this.ctrlPriceMost.setScale(scale);
        this.clear(false);
    }

    public void order() {
        boolean isMise;
        this.txtCode.requestFocus();
        Algorithm algo = (Algorithm)this.cmbAlgo.getValue();
        boolean bl = isMise = algo != null && AlgoMiseMng.isMise((String)String.valueOf(algo.getType()));
        if (!isMise && this.refItem.getCode().startsWith("688")) {
            this.alert.alert(Alert.AlertType.ERROR, "\u79d1\u521b\u677f\u6682\u4e0d\u652f\u6301apama\u7b97\u6cd5\u4ea4\u6613\uff01");
            return;
        }
        if (!this.valid()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef\uff01");
            return;
        }
        if (this.model.baseModel.getMI() != null && this.model.baseModel.getMI().getStop().getValue().booleanValue()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bc1\u5238\u505c\u724c");
            return;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.model.baseModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return;
        }
        this.submitParam();
        this.model.baseModel.getInsExpiredMap().clear();
        this.model.baseModel.getFundTraderMap().clear();
        try {
            List<CcsSingleEntrust> entrusts = this.model.getEntrustList();
            if ("2".equals(this.model.baseModel.getAccDisModel().getInstructType()) || "1".equals(this.model.baseModel.getAccDisModel().getInstructType())) {
                for (CcsSingleEntrust en : entrusts) {
                    WorkFlowDescriptor workFlow = this.model.baseModel.getWorkFlowByFundAccount(en.getFundAccount());
                    if (workFlow == null || WorkflowTemplete.TWO_STEP_INST.getId() != workFlow.getId() && WorkflowTemplete.THREE_STEP_RISK.getId() != workFlow.getId()) continue;
                    Object traderSetting = this.model.baseModel.buildTraderSetting(workFlow);
                    traderSetting.setWt(WorkflowTemplete.getWorkflowTemplete((int)workFlow.getId()));
                    this.model.baseModel.getFundTraderMap().put(en.getFundAccount(), (AppointedTraderSetting)traderSetting);
                }
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
        if (!"0".equals(this.model.baseModel.getAccDisModel().getInstructType()) && !"4".equals(this.model.baseModel.getAccDisModel().getInstructType())) {
            obj.setIsInstruction(true);
        } else {
            obj.setExecution(true);
        }
        if (this.model.baseModel.getInstruction() != null) {
            obj.setShowWarning(!this.model.baseModel.getInstruction().isFrozen());
        }
        obj.setInstructionPanelType(this.model.baseModel.getAccDisModel().getInstructType());
        obj.setBuySymbol(this.btnOrder.getText());
        obj.setSellSymbol(this.btnOrder.getText());
        obj.setRefItem(this.model.baseModel.getMI().getRefItem());
        obj.setPriceStg(this.model.baseModel.getPriceStg());
        obj.setType("ALGO");
        obj.setCustom(((Algorithm)this.cmbAlgo.getValue()).getName());
        obj.setUnit(this.lbUnit.getText());
        obj.setInsExpiredMap(this.model.baseModel.getInsExpiredMap());
        obj.setFundTraderMap(this.model.baseModel.getFundTraderMap());
        try {
            obj.setList(this.model.getEntrustList());
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (this.instruction != null) {
            this.instruction.setPostil(obj.getPostil());
        }
        this.model.getParam().setPostil(obj.getPostil());
        RespResult result = null;
        String operation = "";
        try {
            switch (this.instructionType) {
                case "1": {
                    result = this.model.submitAdvice();
                    operation = "\u6307\u4ee4\u63d0\u4ea4";
                    break;
                }
                case "2": {
                    result = this.model.submitAdvice();
                    operation = "\u5efa\u8bae\u63d0\u4ea4";
                    break;
                }
                case "3": {
                    result = this.model.submitApprove(this.instruction);
                    operation = "\u5ba1\u6279\u63d0\u4ea4";
                    this.disable(this.instruction.getAlgoParam().getAlgorithm().getType(), false, false);
                    this.clearPanel();
                    break;
                }
                case "4": {
                    String status = this.instruction.getResource().getStatus();
                    if ("61".equals(status)) {
                        this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5df2\u64a4\u9500\uff0c\u6267\u884c\u5931\u8d25");
                        return;
                    }
                    if ("4".equals(status)) {
                        this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5df2\u5b8c\u6210\uff0c\u6267\u884c\u5931\u8d25");
                        return;
                    }
                    this.model.execute(this.instruction);
                    this.exe.execute(() -> {
                        RespResult respOrder = this.model.submitOrder(this.instruction.getId(), this.instruction.getResource().getId());
                        Platform.runLater(() -> {
                            this.disable(((Algorithm)this.cmbAlgo.getSelectionModel().getSelectedItem()).getType(), false, true);
                            this.clearPanel();
                            this.respResultAlert(respOrder, "\u4e0b\u5355\u63d0\u4ea4", "cms.tmx.instructions.part.regular.algo.query");
                        });
                    });
                    return;
                }
                case "0": {
                    this.exe.execute(() -> {
                        RespResult respOrder = this.model.submitOrder("", "");
                        Platform.runLater(() -> this.respResultAlert(respOrder, "\u4e0b\u5355\u63d0\u4ea4", "cms.tmx.instructions.part.regular.algo.query"));
                    });
                    return;
                }
            }
            this.respResultAlert(result, operation, "cms.tmx.instructions.part.regular.instruct.query");
        }
        catch (MException e) {
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u7b97\u6cd5\u6307\u4ee4\u4e0b\u8fbe\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, e.toString());
            logger.error("\u7b97\u6cd5\u6307\u4ee4\u4e0b\u8fbe\u5931\u8d25", (Throwable)e);
        }
    }

    private void respResultAlert(RespResult respResult, String operation, String part) {
        this.uiService.showPart(part);
        this.clear(true);
        Alert.AlertType aType = respResult.hasFailed() ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION;
        this.alert.check(!this.setTips.getOrderTips(), aType, respResult.getDesc(operation));
    }

    private void clearPanel() {
        this.model.baseModel.getAccDisModel().removeTree();
        this.model.baseModel.getAccDisModel().setActive(true);
        this.model.baseModel.setInstruction(new Instruction());
    }

    protected void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() == 6 && this.model.baseModel.getMI().getStop().getValue().booleanValue()) {
            this.lbName.setText(this.model.baseModel.getMI().getStatus());
        }
    }

    protected void submitParam() {
        RefItem refItem = this.model.baseModel.getMI().getRefItem();
        this.model.setParam(super.submitParam(refItem));
    }

    public void setBaseModel(InstructionCcsBaseModel baseModel) {
        this.model.baseModel = baseModel;
        this.model.initAlgo();
    }

    public List<Algorithm> getAlgos(String engine, Boolean isBuy) {
        List list = this.algoFunc.getRegularAlgo(engine, isBuy);
        ListIterator<Algorithm> iterator = list.listIterator();
        while (iterator.hasNext()) {
            OrderAdvice advice;
            Algorithm algo = (Algorithm)iterator.next();
            int type = algo.getType();
            if (this.instruction != null && this.instruction.isCanModify() && (1 == (advice = this.instruction.getOrderAdvice()).getPriceLimit() || 4 == advice.getPriceLimit())) {
                if ("Apama\u5f15\u64ce".equals(engine)) {
                    if (type == 12 || type == 13) continue;
                    iterator.remove();
                    continue;
                }
                if (!"Mise\u5f15\u64ce".equals(engine) || type == 19 || type == 20) continue;
                iterator.remove();
                continue;
            }
            this.temporatyCheck(iterator, type);
        }
        return list;
    }

    protected void temporatyCheck(ListIterator<Algorithm> iterator, int type) {
        switch (this.instructionType) {
            case "1": 
            case "2": 
            case "3": 
            case "4": {
                if (type != 21 && type != 22 && type != 23) break;
                iterator.remove();
            }
        }
    }

    @Override
    public IntegerProperty minuteProperty() {
        return this.model.minuteProperty();
    }
}

