/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio.hkwolun;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.viewers.portfolio.hkwolun.InstructionPortfHkPassivePart;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionPortfHkExecutionPart
extends InstructionPortfHkPassivePart {
    @Override
    protected void setPrePrice() {
        if (this.model.isBidAskPrice() && !this.priceSettle) {
            this.model.setBidAskPrice();
            if (this.model.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
        if (this.model.isMktPrice() && !this.priceSettle) {
            this.model.setMktPrice();
            if (this.model.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
    }

    @Inject
    public InstructionPortfHkExecutionPart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.es.subscribe("instruction.set.on.panel", this.hSetCode);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    @FXML
    public void initialize() {
        this.model.create("4");
        this.algoNode.instructionType = "4";
        this.setBuySymbol("\u4e70\u5165");
        this.setSellSymbol("\u5356\u51fa");
        super.initialize();
        this.mktItem.changedProperty().addListener(ob -> this.setPrePrice());
    }

    @PreDestroy
    public void destroy() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    protected boolean validOrderFill() {
        Instruction eventInstr = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        return ("3".equals(eventInstr.getType().getRaw()) || "9".equals(eventInstr.getType().getRaw())) && eventInstr.getIsOrderStep() && this.isHkwolumn(eventInstr.getMarket()) && !this.isMail(eventInstr);
    }

    @Override
    protected String doAction() throws MException {
        this.model.execute(this.instruction);
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.portfolio.hkwolun.instruction.query");
        }
        return super.doAction();
    }

    @Override
    protected void disable(boolean disable) {
        this.algoNode.disable(this.instruction.getAlgoParam().getAlgorithm().getType(), disable, true);
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(this.model.isMktPrice() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    public void setPrice(double price) {
        if ((this.model.isLimitPrice() || this.model.isAfterHoursPrice()) && !this.model.isSpecify() && price > 0.0) {
            this.model.setPrice(price);
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() || this.model.isSpecify() || this.model.getAccDisModel().isActive(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty(), this.model.getAccDisModel().activeProperty()}));
    }

    @Override
    protected void doSetCode() {
        super.doSetCode();
        if (!this.initFinished || this.instruction == null) {
            return;
        }
        if (this.instruction.isCanModify()) {
            return;
        }
        if (this.instruction.getType().getRaw().equals("3")) {
            this.tabNormal.setDisable(false);
            this.tabAlgo.setDisable(true);
        } else if (this.instruction.getType().getRaw().equals("9")) {
            this.tabNormal.setDisable(true);
            this.tabAlgo.setDisable(false);
        }
        this.layout();
    }
}

