/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio.hkwolun;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.instructions.models.portfolio.InstructionPortfHkBaseModel;
import cms.tmx.instructions.models.portfolio.UserPrePortfolioCtrlHkwolun;
import cms.tmx.instructions.viewers.portfolio.hkwolun.AlgoNodeHkwolunInstructionPortf;
import cms.tmx.instructions.viewers.portfolio.hkwolun.LoadPartModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.portfolio.uitls.AccCollapseCell;
import cms.tmx.portfolio.uitls.PortfoCollapseCell;
import cms.tmx.portfolio.viewers.PortfolioCheckBoxCell;
import cms.tmx.query.current.models.portfolio.CcsPortfUnfinOrderModel;
import cms.tmx.rights.IUiRightService;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class InstructionPortfHkBasePart
extends MxPart {
    @FXML
    protected HBox hboxAlgo;
    @Inject
    public AlgoNodeHkwolunInstructionPortf algoNode;
    @FXML
    protected Tab tabNormal;
    @FXML
    protected Tab tabAlgo;
    public static final int SECURITY_TYPE = 1;
    @Inject
    protected InstructionPortfHkBaseModel model;
    @FXML
    protected VBox instructionPortfolioTradePart;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    protected ComboBox<MxNode> cmbMarket;
    @FXML
    protected ComboBox<MxNode> cmbOfferWay;
    @FXML
    protected TextField txtCode;
    @FXML
    private GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    protected Label lbSide;
    @FXML
    protected RadioButton buyRadio;
    @FXML
    protected RadioButton sellRadio;
    @FXML
    protected ComboBox<MxNode> countStg;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeMkt;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeAfterHours;
    @FXML
    protected Spinner<Double> protectedPriceSpn;
    @FXML
    protected HBox hboxProtectedPrice;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    private Label lbPer;
    @FXML
    private Label lbPerSymbol;
    @FXML
    private TextField txtPerCount;
    @FXML
    protected Spinner<Double> moneySpn;
    @FXML
    private Label lbRate;
    @FXML
    protected Label lbOfferPrice;
    @FXML
    private Label lbOfferCount;
    @FXML
    private Label lbInitAmt;
    @FXML
    private Label lbPosAmt;
    @FXML
    private Label lbRateWay;
    @FXML
    private Label lbExchangeRate;
    @FXML
    protected Label lbLatest;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TreeTableView<PortfolioAccountDistribution> portfolioTreeTable;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Boolean> checkBoxCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Portfolio> portfolioCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> availableCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> assetCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> weightCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<PortfolioAccountDistribution, Number> canSellCol;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private Label lbAmountOne;
    @FXML
    private Label lbAmountTwo;
    @FXML
    private Label lbAmountThree;
    @FXML
    private Label lbAmountFour;
    @FXML
    private Label lbTotalOne;
    @FXML
    private Label lbTotalTwo;
    @FXML
    private Label lbTotalThree;
    @FXML
    private Label lbTotalFour;
    @FXML
    private Label lbCanbuyOne;
    @FXML
    private Label lbCanbuyTwo;
    @FXML
    private Label lbCanbuyThree;
    @FXML
    private Label lbCanbuyFour;
    @FXML
    private Label lbCansellOne;
    @FXML
    private Label lbCansellTwo;
    @FXML
    private Label lbCansellThree;
    @FXML
    private Label lbCansellFour;
    @FXML
    private HBox hboxCounts;
    @FXML
    private HBox hboxPer;
    @FXML
    private HBox hboxMoney;
    @FXML
    private HBox hboxCommAmount;
    @FXML
    private HBox hboxTotalAsset;
    @FXML
    private HBox hboxCanbuy;
    @FXML
    private HBox hboxCansell;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    protected Label lbCan;
    @FXML
    protected Label lbCanCount;
    @FXML
    private Label priceMag;
    @FXML
    private Label amtMag;
    @FXML
    private Label qtyMag;
    @FXML
    protected Button btnOrder;
    @FXML
    protected CheckBox checkBoxModify;
    @FXML
    private TextField txtSearch;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    public IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected MarketItem mktItem;
    private SecConverter secCvt;
    @Inject
    protected UserPrePortfolioCtrlHkwolun preModel;
    @Inject
    protected IUIService uiService;
    @Inject
    private IUiRightService right;
    protected boolean priceSettle = false;
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 2);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleSpinnerCtrl ctrlMoney = new DoubleSpinnerCtrl(true, 12, 2);
    private SecSuggest spCode = new SecSuggest();
    private String confirmSymbol = "";
    @Inject
    private CcsPortfUnfinOrderModel unfinishedModel;
    @Inject
    private ExecutorService exe;
    public Map<String, List<CcsOrder>> map;
    protected AutoCompletion<RefItem> autoCompletionNormal;
    protected AutoCompletion<RefItem> autoCompletionAlgo;
    protected boolean tabChange = false;
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {
        ObservableList list = this.unfinishedModel.getList();
        this.map = list.stream().collect(Collectors.groupingBy(t -> t.getInstrument().getSecId()));
        this.MonitOnRefChange();
    });
    private InvalidationListener listener = ob -> {
        MxNode node = (MxNode)this.cmbMarket.getSelectionModel().getSelectedItem();
        String market = node == null ? "SHSC" : node.getRaw();
        Collection list = this.refMng.getItems(new String[]{"STOCK" + market});
        this.spCode.setAllSuggestions(list);
    };
    private InvalidationListener lstnHkRate = ob -> Platform.runLater(() -> {
        if (this.model.isValidRef()) {
            String rate = this.buyRadio.isSelected() ? RefItem.getAskRate() : RefItem.getBidRate();
            this.lbExchangeRate.setText(rate);
        }
    });
    private MEventHandler positionEvent = event -> {
        if ("012".contains(this.model.getAccDisModel().getInstructType()) && this.isVisible()) {
            String market = event.getStr("tMarket");
            if (!"SHSC".equals(market) && !"SZSC".equals(market)) {
                return;
            }
            if (this.autoCompletionAlgo == null || this.autoCompletionNormal == null) {
                return;
            }
            MxNode node = MxNodeFactory.create((String)"hkwolun_market_code", (String)"SHSC");
            node.setRaw(event.getStr("tMarket"));
            this.cmbMarket.setValue((Object)node);
            String secCode = event.getStr("sec_code");
            this.txtCode.setText(secCode);
            RefItem item = this.refMng.getItem("STOCK" + market, market, secCode);
            this.txtCode.setUserData((Object)item);
            this.algoNode.getTxtCode().setUserData((Object)item);
            this.model.setPstAcct(event.getStr("portfolioId"), event.getStr("accntId"), event.getStr("secAccount"), event.getStr("tMarket"));
            this.sellRadio.setSelected(event.getBool("side_sell"));
            if (this.tabAlgo.isSelected()) {
                this.autoCompletionAlgo.setChange(secCode);
                this.onSecurityChange(this.algoNode.getTxtCode(), secCode);
            } else {
                this.autoCompletionNormal.setChange(secCode);
                this.onSecurityChange(this.txtCode, secCode);
            }
            this.model.setCount(event.getLong("count"));
            this.model.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
        }
    };
    private MEventHandler inputEvent = event -> {
        if (!this.isVisible()) {
            return;
        }
        if ("012".contains(this.model.getAccDisModel().getInstructType())) {
            if (this.autoCompletionAlgo == null || this.autoCompletionNormal == null) {
                return;
            }
            Platform.runLater(() -> {
                String market = event.getStr("tMarket");
                if (!"SHSC".equals(market) && !"SZSC".equals(market)) {
                    return;
                }
                MxNode node = MxNodeFactory.create((String)"hkwolun_market_code", (String)"SHSC");
                node.setRaw(market);
                this.cmbMarket.setValue((Object)node);
                String secCode = event.getStr("sec_code");
                this.txtCode.setText(secCode);
                RefItem item = this.refMng.getItem("STOCK" + market, market, secCode);
                this.txtCode.setUserData((Object)item);
                this.algoNode.getTxtCode().setUserData((Object)item);
                this.model.getAccDisModel().clearSelect();
                if (this.tabAlgo.isSelected()) {
                    this.autoCompletionAlgo.setChange(secCode);
                    this.onSecurityChange(this.algoNode.getTxtCode(), secCode);
                } else {
                    this.autoCompletionNormal.setChange(secCode);
                    this.onSecurityChange(this.txtCode, secCode);
                }
            });
        }
    };
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    @Inject
    protected LoadPartModel load;

    @Inject
    public InstructionPortfHkBasePart() {
    }

    public void onShowEvent(MEvent event) {
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.unfinishedModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.exe.execute(() -> this.unfinishedModel.query());
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            List<CcsOrder> orders = this.map.get(this.mktItem.getRefItem().getCode());
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
        }
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listener);
        this.refMng.changedProperty().removeListener(this.lstnHkRate);
        this.es.unSubscribe("trade.panel.set.code.portfoilio", this.positionEvent);
        this.es.unSubscribe("input_portfoilio_trade", this.inputEvent);
    }

    @FXML
    public void initialize() {
        this.algoNode.setBaseModel(this.model);
        this.mktItem = this.model.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> Platform.runLater(() -> this.onRefChange()));
        this.mktItem.changedProperty().addListener(ob -> Platform.runLater(() -> this.onMktItemChange()));
        this.refMng.changedProperty().addListener(this.listener);
        this.refMng.changedHkRateProperty().addListener(this.lstnHkRate);
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTree();
        this.es.subscribe("trade.panel.set.code.portfoilio", this.positionEvent);
        this.es.subscribe("input_portfoilio_trade", this.inputEvent);
        this.hboxAlgo.getChildren().add((Object)this.algoNode.getContent());
    }

    public void afterTableRestore() {
        this.accountCol.setVisible(!this.model.getAccDisModel().isSingle());
        this.secAcctCol.setVisible(!this.model.getAccDisModel().isSingle());
        this.canBuyCol.setVisible(true);
        this.canSellCol.setVisible(true);
    }

    protected void initControls() {
        boolean authority = this.right.registerCheck(new String[]{"cms.tmx.instructions.part.portfolio.hkwolun.algo"});
        if (!authority) {
            this.tabAlgo.setDisable(true);
            this.tabAlgo.setText("");
        }
        this.model.normalProperty().bind((ObservableValue)this.tabNormal.selectedProperty());
        this.tabNormal.selectedProperty().addListener((ob, old, now) -> {
            this.tabChange = true;
            if (!now.booleanValue()) {
                this.algoNode.txtCode.requestFocus();
                this.algoNode.txtCode.selectEnd();
                this.algoNode.txtCode.deselect();
                this.algoNode.onBSChange(this.algoNode.buyRadio.isSelected());
                this.autoCompletionAlgo.setChange(this.txtCode.getText());
            } else {
                this.buyRadio.setSelected(this.algoNode.buyRadio.isSelected());
                this.sellRadio.setSelected(!this.algoNode.buyRadio.isSelected());
                this.autoCompletionNormal.setChange(this.algoNode.getTxtCode().getText());
            }
        });
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (this.tabChange) {
                this.tabChange = false;
                return;
            }
            this.onSecurityChange(this.txtCode, (String)newV);
            this.tableMarketBuy.refresh();
            this.tableMarketSell.refresh();
            this.portfolioTreeTable.refresh();
            this.layout();
        }));
        this.autoCompletionAlgo = Search.bindAutoCompletion((TextField)this.algoNode.getTxtCode(), (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionAlgo.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (this.tabChange) {
                this.tabChange = false;
                return;
            }
            this.onSecurityChange(this.algoNode.getTxtCode(), (String)newV);
            this.tableMarketBuy.refresh();
            this.tableMarketSell.refresh();
            this.portfolioTreeTable.refresh();
            this.layout();
        }));
        MxNode node = MxNodeFactory.create((String)"hkwolun_market_code", (String)"SHSC");
        this.cmbMarket.setItems(node.getNodes());
        this.cmbMarket.setValue((Object)node);
        this.listener.invalidated(null);
        this.cmbMarket.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.spCode.setAllSuggestions(this.refMng.getItems(new String[]{"STOCK" + now.getRaw()}));
                this.txtCode.clear();
                this.txtCode.setUserData(null);
                this.onSecurityChange(this.txtCode, "");
            }
        });
        this.cmbOfferWay.setItems(this.model.getOfferWay().getNodes());
        this.cmbOfferWay.valueProperty().bindBidirectional(this.model.offerWayProperty());
        this.cmbOfferWay.setValue((Object)this.model.getOfferWay());
        this.offerWayDisableBind();
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 5)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.requestFocus();
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        Tooltip tooltip = new Tooltip();
        this.lbName.setTooltip(tooltip);
        tooltip.textProperty().bind((ObservableValue)this.lbName.textProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)now));
        this.buyRadio.setSelected(true);
        this.algoNode.buyRadio.selectedProperty().addListener((ob, old, now) -> {
            this.buyRadio.setSelected(now.booleanValue());
            this.sellRadio.setSelected(now == false);
        });
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.onPriceTypeChange());
        this.cmbPriceType.setDisable(true);
        this.cmbPriceTypeLimited.setItems(this.model.getPriceTypeLimitedStg().getNodes());
        this.cmbPriceTypeLimited.valueProperty().bindBidirectional(this.model.priceTypeLimitedStgProperty());
        this.cmbPriceTypeLimited.valueProperty().addListener((ob, old, newV) -> this.onPriceTypeLimitedChange((MxNode)newV));
        this.cmbPriceTypeMkt.setItems(this.model.getPriceTypeMktStg().getNodes());
        this.cmbPriceTypeMkt.valueProperty().bindBidirectional(this.model.priceTypeMktStgProperty());
        this.cmbPriceTypeBidAsk.setItems(this.model.getPriceTypeBidAskStg().getNodes());
        this.cmbPriceTypeBidAsk.valueProperty().bindBidirectional(this.model.priceTypeBidAskStgProperty());
        this.cmbPriceTypeAfterHours.setItems(this.model.getPriceTypeAfterHours().getNodes());
        this.cmbPriceTypeAfterHours.valueProperty().bindBidirectional(this.model.priceTypeAfterHoursProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.priceDisableBind();
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().clear();
        this.priceVisibleBind();
        this.ctrlPrice.ctrl(this.protectedPriceSpn);
        MxBindings.bindSD((Property)this.protectedPriceSpn.getEditor().textProperty(), (Property)this.model.priceProtectedProperty());
        this.protectedPriceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.protectedPriceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.protectedPriceSpn.getEditor().setText("");
        this.priceDisableBind();
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        SpinnerUtils.arrowsStyle(this.moneySpn);
        TextFieldUtils.showMagnitude((Label)this.amtMag, (TextField)this.moneySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.quantitySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.priceMag, (TextField)this.priceSpn.getEditor());
        this.setPriceUnit();
        this.lbCan.visibleProperty().bind((ObservableValue)this.model.getAccDisModel().showCanBuyProperty());
        this.lbCanCount.visibleProperty().bind((ObservableValue)this.model.getAccDisModel().showCanBuyProperty());
        MxBindings.bindSI((Property)this.lbCanCount.textProperty(), (Property)this.model.getAccDisModel().canBuyProperty());
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantityDisableBind();
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.quantitySpn.getEditor().clear();
        this.countStg.setItems(this.model.getCountStg().getNodes());
        this.countStg.valueProperty().addListener((ob, old, now) -> this.onCountStgChange((MxNode)now));
        this.countStg.valueProperty().bindBidirectional(this.model.countStgProperty());
        this.countStg.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.cmbStgKeyPress((KeyEvent)event));
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxPer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("3") || this.model.getCountStg().is("2") || this.model.getCountStg().is("4"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtPerCount);
        MxBindings.bindSD((Property)this.txtPerCount.textProperty(), (Property)this.model.countPerProperty());
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
        this.ctrlMoney.ctrl(this.moneySpn);
        this.moneySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.txtPerCount.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        MxBindings.bindSDTwoScale((Property)this.moneySpn.getEditor().textProperty(), (Property)this.model.moneyProperty());
        this.moneySpn.getEditor().setText(String.format("%.2f", this.model.getMoney()));
        this.hboxCommAmount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxTotalAsset.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("2"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxCanbuy.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("3"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxCansell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("4"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.btnOrder.setText(this.buySymbol);
        this.checkBoxModify.selectedProperty().bindBidirectional((Property)this.model.canModifyProperty());
    }

    protected void onPriceTypeLimitedChange(MxNode newV) {
        if (newV == null) {
            return;
        }
        if (newV.getNode("3") == null) {
            return;
        }
        if (newV.is("3")) {
            this.priceSpn.getEditor().clear();
            this.protectedPriceSpn.getEditor().clear();
        }
    }

    protected void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return true;
            }
            if (!(((MxNode)this.cmbPriceType.getValue()).is("50") || ((MxNode)this.cmbPriceType.getValue()).is("0") || ((MxNode)this.cmbPriceType.getValue()).is("99"))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
        this.hboxProtectedPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return false;
            }
            if (((MxNode)this.cmbPriceType.getValue()).is("49") && this.model.isStar()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty(), this.mktItem.changedProperty()}));
    }

    protected void offerWayDisableBind() {
    }

    protected void quantityDisableBind() {
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
    }

    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() && !this.model.isAfterHoursPrice() || this.model.isUnlimited(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty()}));
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        TableUtils.beforeClick(this.tableMarketBuy, item -> this.onMktItemClicked((HandicapInfo)item));
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        TableUtils.beforeClick(this.tableMarketSell, item -> this.onMktItemClicked((HandicapInfo)item));
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> {
            this.model.getPriceTypeBidAskStg().setRaw("0");
            this.setPrice(this.mktItem.getNowPrice());
        });
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
        this.model.getAccDisModel().singleProperty().addListener(ob -> this.afterTableRestore());
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.model.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.model.distStgProperty());
        this.txtSearch.textProperty().bindBidirectional((Property)this.model.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.portfolioCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).portfolioProperty());
        this.portfolioCol.setCellFactory(p -> new PortfoCollapseCell(this.model.getAccDisModel().isSingle()));
        this.accountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccCollapseCell(this.model.getAccDisModel().isSingle()));
        this.secAcctCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).isPortDist() ? ((PortfolioAccountDistribution)data.getValue().getValue()).getPortfolio().hkAvailableProperty() : (((PortfolioAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((PortfolioAccountDistribution)data.getValue().getValue()).getAcc().hkAvailableProperty()));
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canBuyCol.setCellFactory(cell -> new NumberTreeTableCell());
        this.canSellCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canSellCol.setCellFactory(cell -> new NumberTreeTableCell());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.model.getAccDisModel().repoProperty().addListener((ob, old, newV) -> {
            this.canBuyCol.setVisible(newV == false);
            this.canSellCol.setVisible(newV == false);
        });
        this.assetCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).isPortDist() ? ((PortfolioAccountDistribution)data.getValue().getValue()).getPortfolio().assetAmtProperty() : (((PortfolioAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((PortfolioAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty()));
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(cell -> new NumberTreeTableCell());
        this.checkBoxCol.setCellFactory(p -> new PortfolioCheckBoxCell(this.model.getAccDisModel().isSingle(), !this.model.getAccDisModel().isActive()));
        this.portfolioTreeTable.setRoot(this.model.getAccDisModel().getRoot());
        this.portfolioTreeTable.setShowRoot(false);
        this.portfolioTreeTable.sort();
        this.portfolioTreeTable.refresh();
        this.portfolioTreeTable.setPlaceholder((Node)new Label());
        this.portfolioTreeTable.editableProperty().bind((ObservableValue)this.model.getAccDisModel().activeProperty());
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.portfolioTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
    }

    protected void refresh() {
        this.model.getAccDisModel().refresh();
    }

    protected void acctTreeSupplement() {
        this.model.countStgProperty().addListener(ob -> {
            String stg = this.model.getCountStg().getRaw();
            if (stg.equals("1") || stg.equals("5")) {
                this.cmbDist.setDisable(false);
            } else {
                this.cmbDist.setDisable(true);
            }
        });
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.portfolioTreeTable);
    }

    protected void onRefChange() {
        this.changeUnit();
    }

    protected void onMktItemChange() {
        RefItem ref;
        if (this.model.isBidAskPrice()) {
            this.model.setBidAskPrice();
        }
        if (this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText(this.mktItem.getStatus());
        }
        if (this.txtCode.getText().length() > 5) {
            this.check();
        }
        if ((ref = (RefItem)this.txtCode.getUserData()) != null) {
            this.lbOfferPrice.setText(String.valueOf(ref.getPriceUnit()));
            this.ctrlPrice.setUnit(ref.getPriceUnit());
            this.ctrlPrice.setScale(ref.getScale());
        } else {
            this.lbOfferPrice.setText("");
        }
        this.lbLatest.setText(StringUtils.toStr((double)this.mktItem.getNowPrice(), (int)this.mktItem.getRefItem().getScale()));
        this.tableMarketBuy.layout();
        this.tableMarketSell.layout();
    }

    protected void onBSChange(Boolean now) {
        boolean isClear = this.model.getMI().isClear();
        if (now.booleanValue()) {
            this.btnOrder.setText(this.getBuySymbol());
            this.lbCan.setText("\u53ef\u4e70");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.lbRateWay.setText("\u5356\u51fa\u6c47\u7387");
            this.lbExchangeRate.setText(isClear ? "" : RefItem.getAskRate());
        } else {
            this.btnOrder.setText(this.getSellSymbol());
            this.lbCan.setText("\u53ef\u5356");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.lbRateWay.setText("\u4e70\u5165\u6c47\u7387");
            this.lbExchangeRate.setText(isClear ? "" : RefItem.getBidRate());
        }
        this.model.setBuy(now);
        if (((Algorithm)this.algoNode.cmbAlgo.getSelectionModel().getSelectedItem()).getType() != 10 && ((Algorithm)this.algoNode.cmbAlgo.getSelectionModel().getSelectedItem()).getType() != 11) {
            this.algoNode.buyRadio.setSelected(now.booleanValue());
            this.algoNode.sellRadio.setSelected(now == false);
        }
        this.layout();
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    private void changeUnit() {
        this.lbUnit.setText("");
        this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit());
        if (this.model.isBond()) {
            if (this.model.isSHbond()) {
                this.lbUnit.setText("\u624b");
            } else {
                this.lbUnit.setText("\u5f20");
            }
        }
        if (this.model.isStock()) {
            this.lbUnit.setText("\u80a1");
        }
        if (this.model.isFund()) {
            this.lbUnit.setText("\u4efd");
        }
    }

    protected void onPriceTypeChange() {
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        this.hideShow();
    }

    private void hideShow() {
        if (this.cmbPriceType.getValue() == null) {
            return;
        }
        if (((MxNode)this.cmbPriceType.getValue()).is("49")) {
            this.cmbPriceTypeMkt.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("0")) {
            this.cmbPriceTypeBidAsk.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else {
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(true);
        }
    }

    private void onCountStgChange(MxNode now) {
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
    }

    private void loseFocus(Boolean val) {
        System.err.println("loseFocus " + val);
        System.err.println("length " + this.txtCode.getText().length());
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCode.setText(txtCode.getText());
        this.algoNode.txtCode.setText(txtCode.getText());
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.doChange(refItem, newText);
    }

    protected void setPrePrice() {
        if (this.model.isMktPrice() && !this.priceSettle) {
            this.model.setMktPrice();
            if (this.model.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
        if (this.model.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
        this.model.setPrice(this.preModel.getDefPrice(this.buyRadio.isSelected()));
        if (this.preModel.getDefPrice(this.buyRadio.isSelected()) != 0.0) {
            this.priceSettle = true;
        }
    }

    protected void doChange(RefItem refItem, String newText) {
        this.model.getMI().setRefItem(refItem);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        if (this.model.isValidRef()) {
            this.ctrlPrice.setScale(refItem.getScale());
        }
        this.model.onSecChange();
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
        if (refItem != null) {
            boolean isRepo = refItem.getType().equals("REPO");
            this.buyRadio.setText(isRepo ? "\u6b63\u56de\u8d2d" : "\u4e70");
            this.sellRadio.setText(isRepo ? "\u9006\u56de\u8d2d" : "\u5356");
            this.txtCode.setText(refItem.getCode());
            this.algoNode.txtCode.setText(refItem.getCode());
            this.lbOfferCount.setText(String.valueOf(refItem.getBuyUnit()));
            String rate = this.buyRadio.isSelected() ? RefItem.getAskRate() : RefItem.getBidRate();
            this.lbExchangeRate.setText(rate);
        } else {
            this.lbOfferCount.setText("");
            this.lbExchangeRate.setText("");
        }
        this.checkQuota(refItem);
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (newText.length() >= 5) {
            this.check();
        }
        this.algoNode.doChange(refItem);
        if (this.model.isValidRef()) {
            this.checkRepo();
            this.priceSettle = false;
            this.setPrePrice();
        }
    }

    protected void checkRepo() {
        if ("REPO".equals(this.model.getValidRef().getType())) {
            this.countStg.getSelectionModel().selectFirst();
            this.countStg.setDisable(true);
        } else {
            this.countStg.setDisable(false);
        }
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || this.model.getValidRef() == null) {
            this.lbName.setText(INVALID_CODE);
        } else if (this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText(this.mktItem.getStatus());
        } else {
            this.lbName.setText(ref.getName());
        }
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.model.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.model.SelectedNumValid(), Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.model.getCount() >= 0L && this.model.isCountValid() != false, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip6 = "\u4fdd\u62a4\u4ef7\u683c\u9700\u8981\u5927\u4e8e0\uff0c\u5c0f\u4e8e1\u4e07\u5143\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
        if (!this.alert.check(!this.model.isStar() || !this.model.isMktPrice() || this.model.isStar() && this.model.getPriceProtected() > 0.0 && this.model.getPriceProtected() < 10000.0, Alert.AlertType.WARNING, tip6)) {
            return false;
        }
        if (this.model.getValidRef().getType().equals("REPO")) {
            String tip7 = "\u6295\u7ec4\u4e0d\u652f\u6301\u6b63\u56de\u8d2d\u4e1a\u52a1";
            if (!this.alert.check(!this.model.isBuy(), Alert.AlertType.WARNING, tip7)) {
                return false;
            }
        }
        return true;
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(!this.model.isLimitPrice() && !this.model.isAfterHoursPrice() || this.model.isUnlimited() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (PortfolioAccountDistribution acc : this.model.validSecAcc()) {
            info.append("\n\u8d26\u53f7 " + acc.getSecAcc().getInverstorSecId() + "\u59d4\u6258\u6570\u91cf " + acc.getCount());
        }
        return info.toString();
    }

    @FXML
    public void order() {
        this.model.validSecAcc();
        if (this.valid()) {
            if (this.model.isStar() && this.model.isMktPrice() && this.mktItem.getUpLimitPrice() > 0.0 && this.model.getPriceProtected() > this.mktItem.getUpLimitPrice() && !this.alert.alert(Alert.AlertType.CONFIRMATION, "\u60a8\u8f93\u5165\u7684\u4fdd\u62a4\u4ef7\u683c\u5927\u4e8e\u6da8\u505c\u4ef7\u683c\uff0c\u662f\u5426\u7ee7\u7eed\u59d4\u6258\uff1f")) {
                return;
            }
            this.model.getInsExpiredMap().clear();
            if (this.preModel.isPopBeforeOrder()) {
                CcsEntrustConfirmDialog obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
                if (!"0".equals(this.model.getAccDisModel().getInstructType()) && !"4".equals(this.model.getAccDisModel().getInstructType())) {
                    obj.setIsInstruction(true);
                } else {
                    obj.setExecution(true);
                }
                if (this.model.getInstruction() != null) {
                    obj.setShowWarning(!this.model.getInstruction().isFrozen());
                }
                if (this.model.getAccDisModel().isMail()) {
                    obj.setShowWarning(false);
                }
                obj.setMail(this.model.getAccDisModel().isMail());
                obj.setBuySymbol(this.getBuySymbol());
                obj.setInstructionPanelType(this.model.getAccDisModel().getInstructType());
                obj.setSellSymbol(this.getSellSymbol());
                obj.setRefItem(this.mktItem.getRefItem());
                obj.setPriceStg(this.model.getPriceStg());
                obj.setPriceTypeMktStg(this.model.getPriceTypeMktStg());
                obj.setPriceTypeLimitedStg(this.model.getPriceTypeLimitedStg());
                obj.setPriceTypeBidAskStg(this.model.getPriceTypeBidAskStg());
                obj.setUnit(this.lbUnit.getText());
                obj.setInsExpiredMap(this.model.getInsExpiredMap());
                obj.setHkwolun(true);
                obj.setBuy(this.buyRadio.isSelected());
                try {
                    obj.setList(this.model.getEntrustList(false));
                    MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u5355\u786e\u8ba4" : this.confirmSymbol);
                    if (dialog.launch() == ButtonType.OK) {
                        if (this.model.getInstruction() != null) {
                            this.model.getInstruction().setPostil(obj.getPostil());
                        }
                        this.model.setPostil(obj.getPostil());
                        this.submitOrder();
                    }
                }
                catch (MException e) {
                    this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u51fa\u9519", (Throwable)e);
                }
                catch (Exception e) {
                    this.alert.alert(Alert.AlertType.ERROR, e.toString());
                    this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u51fa\u9519", (Throwable)e);
                }
            } else {
                this.submitOrder();
            }
        }
        this.layout();
    }

    protected void submitOrder() {
        try {
            String result = this.doAction();
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, result);
        }
        catch (MException e) {
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, e.getMessage());
            this.logger.error("\u6295\u7ec4\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, "\u6295\u7ec4\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
            this.logger.error("\u6295\u7ec4\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        this.clearCountCheck();
    }

    protected String doAction() throws MException {
        return this.model.submitOrder();
    }

    protected void clearCountCheck() {
        if (this.preModel.isClearAfterOrder()) {
            this.clearCountCheckForce();
        }
    }

    protected void clearCountCheckForce() {
        block10: {
            if (!this.preModel.isClearAfterOrder()) break block10;
            switch (this.model.getCountStg().getRaw()) {
                case "5": {
                    this.model.setMoney(0.0);
                    break;
                }
                case "1": {
                    this.model.setCount(0L);
                    break;
                }
                default: {
                    this.model.setCountPer(0.0);
                }
            }
        }
    }

    protected void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            if (this.model.isLimitPrice()) {
                this.priceSpn.requestFocus();
                this.preModel.selectTwoOrAllPriceDecimal();
            } else if (this.model.isMktPrice() && this.model.isStar()) {
                this.protectedPriceSpn.requestFocus();
            } else {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("2")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("3")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("4")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("5")) {
                this.moneySpn.requestFocus();
                this.moneySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.order();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    private void cmbStgKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        }
    }

    protected boolean onMktItemClicked(HandicapInfo now) {
        if (this.tabNormal.isSelected()) {
            this.setPrice(now.getPrice());
        } else {
            this.algoNode.setPrice(now.getPrice());
        }
        return false;
    }

    protected void clearSelection() {
        this.tableMarketBuy.getSelectionModel().clearSelection();
        this.tableMarketSell.getSelectionModel().clearSelection();
    }

    public void setPrice(double price) {
        if ((this.model.isLimitPrice() || this.model.isAfterHoursPrice()) && !this.model.isUnlimited() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.model.setPrice(price);
        } else {
            if (this.model.isMktPrice() || this.model.isBidAskPrice()) {
                return;
            }
            this.priceSpn.getEditor().setText("");
        }
    }

    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.portfolioCol.getText()) + "\t" + this.accountCol.getText() + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.canBuyCol.getText() + "\t" + this.canSellCol.getText() + "\t" + '\n');
        for (TreeItem item : this.model.getAccDisModel().getRoot().getChildren()) {
            PortfolioAccountDistribution portfDis = (PortfolioAccountDistribution)item.getValue();
            clipboardString.append(portfDis.getPortfolio() + "\t" + "\t" + "\t" + portfDis.getPortfolio().getHkAvailable() + "\t" + portfDis.getPortfolio().getAssetAmt() + "\t" + portfDis.getWeight() + "\t" + portfDis.getCount() + "\t" + portfDis.getCanBuy() + "\t" + portfDis.getCanSell() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                PortfolioAccountDistribution accDis = (PortfolioAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getHkAvailable() + "\t" + accDis.getAcc().getAssetAmt() + "\t" + (accDis.getWeight() == 0 ? "" : Integer.valueOf(0)) + "\t" + accDis.getCount() + "\t" + accDis.getCanBuy() + "\t" + accDis.getCanSell() + "\t" + '\n');
                for (TreeItem secItem : subItem.getChildren()) {
                    PortfolioAccountDistribution secAccDis = (PortfolioAccountDistribution)secItem.getValue();
                    clipboardString.append("\t\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + (secAccDis.getWeight() == 0 ? "" : Integer.valueOf(0)) + "\t" + secAccDis.getCount() + "\t" + secAccDis.getCanBuy() + "\t" + secAccDis.getCanSell() + "\t" + '\n');
                }
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public TreeTableView<PortfolioAccountDistribution> getAccTreeTable() {
        return this.portfolioTreeTable;
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public void initUserPre() {
        this.preModel.setType("6", "200052");
        this.preModel.setPart(this);
        this.model.setPreModel(this.preModel);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    public void checkQuota(RefItem item) {
        this.lbPosAmt.textProperty().unbind();
        this.lbInitAmt.setText("");
        this.lbPosAmt.setText("");
        if (item == null) {
            return;
        }
        MxNode node = (MxNode)this.cmbMarket.getSelectionModel().getSelectedItem();
        if ("SHSC".equals(node.getRaw())) {
            this.lbInitAmt.setText(MarketItem.getInitAmtSh());
            this.lbPosAmt.textProperty().bind((ObservableValue)MarketItem.posAmtShProperty());
        } else {
            this.lbInitAmt.setText(MarketItem.getInitAmtSz());
            this.lbPosAmt.textProperty().bind((ObservableValue)MarketItem.posAmtSzProperty());
        }
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public Spinner<Double> getMoneySpn() {
        return this.moneySpn;
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Label getLbAmountOne() {
        return this.lbAmountOne;
    }

    public Label getLbAmountTwo() {
        return this.lbAmountTwo;
    }

    public Label getLbAmountThree() {
        return this.lbAmountThree;
    }

    public Label getLbAmountFour() {
        return this.lbAmountFour;
    }

    public Label getLbTotalOne() {
        return this.lbTotalOne;
    }

    public Label getLbTotalTwo() {
        return this.lbTotalTwo;
    }

    public Label getLbTotalThree() {
        return this.lbTotalThree;
    }

    public Label getLbTotalFour() {
        return this.lbTotalFour;
    }

    public Label getLbCanbuyOne() {
        return this.lbCanbuyOne;
    }

    public Label getLbCanbuyTwo() {
        return this.lbCanbuyTwo;
    }

    public Label getLbCanbuyThree() {
        return this.lbCanbuyThree;
    }

    public Label getLbCanbuyFour() {
        return this.lbCanbuyFour;
    }

    public Label getLbCansellOne() {
        return this.lbCansellOne;
    }

    public Label getLbCansellTwo() {
        return this.lbCansellTwo;
    }

    public Label getLbCansellThree() {
        return this.lbCansellThree;
    }

    public Label getLbCansellFour() {
        return this.lbCansellFour;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStg.getValue();
    }

    public void setCount(Long buyQuantity) {
        this.model.setCount(buyQuantity);
    }

    public void setMoney(Double value) {
        this.model.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.model.setCountPer(value);
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setAutoSlice(boolean slice, long size) {
        this.model.setAutoSlice(slice);
        this.model.setSliceSize(size);
    }

    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    protected void setDialogSymbol(String symbol) {
        this.confirmSymbol = symbol;
    }

    public boolean getActiveFlag() {
        return this.model.getAccDisModel().isActive();
    }

    public InstructionPortfHkBaseModel getInstructionPortfolioBaseModel() {
        return this.model;
    }

    public Spinner<Double> getProtectedPriceSpn() {
        return this.protectedPriceSpn;
    }

    public boolean isHkwolumn(String market) {
        return "SHSC".equals(market) || "SZSC".equals(market);
    }

    private class MoneyCell
    extends EditTreeTableCell<PortfolioAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            PortfolioAccountDistribution accItem = (PortfolioAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<PortfolioAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).portDistProperty());
                if (!((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).isPortDist()) {
                    this.setText("");
                }
            }
        }
    }
}

