/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio.hkwolun;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoNode;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.instruction.Instruction;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public abstract class AlgoNodeHkwolun
extends AlgoNode {
    protected Map<Integer, List<Node>> mapParent = new HashMap<Integer, List<Node>>();
    public Instruction instruction;
    public String instructionType = "0";

    protected void initAlgo() {
        super.initAlgo();
        List<Node> list = this.getNodeParent(new Node[]{this.spnQty, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice});
        this.mapParent.put(5, list);
        this.mapParent.put(6, list);
        this.mapParent.put(15, list);
        this.mapParent.put(16, list);
        this.mapParent.put(7, this.getNodeParent(new Node[]{this.spnPriceLow, this.spnPriceUp, this.spnQty, this.cmbDepth, this.cmbTimeSlice}));
        list = this.getNodeParent(new Node[]{this.spnQty, this.spnPriceMost, this.txtRise, this.cmbPriceBase, this.cmbDepth, this.txtPercent, this.txtDelay});
        this.mapParent.put(10, list);
        this.mapParent.put(11, list);
        list = this.getNodeParent(new Node[]{this.spnQty, this.spnPriceLow, this.spnPriceUp, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice});
        this.mapParent.put(12, list);
        this.mapParent.put(13, list);
        list = this.getNodeParent(new Node[]{this.spnQty, this.spnPriceLow, this.spnPriceUp, this.txtStartHour, this.txtEndHour, this.txtPartication, this.spnWithdrawTime});
        this.mapParent.put(0, list);
        list = this.getNodeParent(new Node[]{this.spnQty, this.spnPriceBid, this.cmbTarget, this.spnOrderIntevel});
        this.mapParent.put(1, list);
        list = this.getNodeParent(new Node[]{this.spnQty, this.txtStartHour, this.txtEndHour});
        this.mapParent.put(2, list);
        this.mapParent.put(18, list);
        list = this.getNodeParent(new Node[]{this.spnQty, this.spnPriceUp, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice});
        this.mapParent.put(19, list);
        list = this.getNodeParent(new Node[]{this.spnQty, this.spnPriceLow, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice});
        this.mapParent.put(20, list);
    }

    protected List<Node> getNodeParent(Node ... nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            list.add((Node)node.getParent());
            ++n2;
        }
        return list;
    }

    protected void checks() {
        super.checks();
        this.registerCheck((Node)this.lbQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int count = this.getInt(this.spnQty.getEditor());
            if (count == 0) {
                this.lbQtyErr.setText("\u8bf7\u8f93\u5165\u59d4\u6258\u6570\u91cf");
                return false;
            }
            long canCount = 0L;
            if (this.instruction != null && (long)count > (canCount = this.instruction.isCanModify() && (this.instruction.getType().getRaw().equals("3") || this.instruction.getType().getRaw().equals("2")) ? this.instruction.getOrderAdvice().getOrderAvailableQuantity() : (long)(this.instruction.getIsOrderStep() ? this.instruction.getAlgoParam().getOrderAvailableQuantity() : this.instruction.getAlgoParam().getCount()))) {
                this.lbQtyErr.setText("\u4e0d\u80fd\u8d85\u8fc7\u6307\u4ee4\u6570\u91cf" + canCount);
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQty.getEditor().textProperty()}));
        if (this.algoConf.limitTime()) {
            this.registerCheck((Node)this.lbEndErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int minuter;
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                int end = this.getInt(this.txtEndHour) * 60 + this.getInt(this.txtEndMinute);
                if (!AlgoModel.timeIsValidHk((int)end)) {
                    this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:59");
                    return false;
                }
                if (end <= start) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u8d77\u59cb\u65f6\u95f4");
                    return false;
                }
                Calendar calender = Calendar.getInstance();
                int hour = calender.get(11);
                if (end < hour * 60 + (minuter = calender.get(12))) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty(), this.minuteProperty()}));
        }
    }

    public void onBSChange(Boolean now) {
        Platform.runLater(() -> {
            this.resetBtnText(now);
            super.onBSChange(now);
        });
    }

    protected void resetBtnText(Boolean now) {
        String textBuy = "";
        String textSell = "";
        switch (this.instructionType) {
            case "1": {
                textBuy = "\u6307\u4ee4\u4e70\u5165";
                textSell = "\u6307\u4ee4\u5356\u51fa";
                break;
            }
            case "2": {
                textBuy = "\u5efa\u8bae\u4e70\u5165";
                textSell = "\u5efa\u8bae\u5356\u51fa";
                break;
            }
            case "3": {
                textBuy = "\u5ba1\u6279\u901a\u8fc7";
                textSell = "\u5ba1\u6279\u901a\u8fc7";
                break;
            }
            case "0": 
            case "4": {
                textBuy = "\u4e70\u5165";
                textSell = "\u5356\u51fa";
            }
        }
        this.btnOrder.setText(now != false ? textBuy : textSell);
    }

    public void disable(int algoType, boolean disable, boolean passQty) {
        for (Node node : this.mapParent.get(algoType)) {
            node.setDisable(disable);
        }
        this.lbStart.setDisable(disable);
        this.lbEnd.setDisable(disable);
        this.spnPriceLow.getParent().setDisable(disable);
        this.spnPriceUp.getParent().setDisable(disable);
        if (passQty) {
            this.spnQty.getParent().setDisable(false);
        }
        this.cmbAlgo.getParent().setDisable(disable);
        this.txtCode.setEditable(!disable);
        this.buyRadio.getParent().setDisable(disable);
        if (!disable) {
            this.txtCode.clear();
            this.lbName.setText("");
            this.txtCode.requestFocus();
            this.spnPriceLow.getEditor().clear();
            this.spnPriceUp.getEditor().clear();
            this.spnPriceMost.getEditor().clear();
            this.txtRise.clear();
            this.txtPercent.clear();
            this.spnQty.getEditor().clear();
            AlgoModel.timeLimitHk((TextField)this.txtStartHour, (TextField)this.txtStartMinute, (TextField)this.txtEndHour, (TextField)this.txtEndMinute);
            this.spnTimeSlice.getEditor().clear();
            this.txtDelay.clear();
        }
    }

    public void selectedAlgo(Algorithm algo) {
        super.selectedAlgo(algo);
        if (this.instruction != null && this.instruction.isCanModify()) {
            this.buyRadio.setDisable(true);
            this.sellRadio.setDisable(true);
        }
    }

    public void setPrice(Double price) {
        Algorithm algo = (Algorithm)this.cmbAlgo.getSelectionModel().getSelectedItem();
        if (algo == null) {
            return;
        }
        switch (algo.getType()) {
            case 7: 
            case 12: 
            case 13: {
                if (this.spnPriceLow.getParent().isDisable() || this.spnPriceUp.getParent().isDisable()) break;
                if (this.spnPriceLow.isFocused()) {
                    this.spnPriceLow.getEditor().setText(price.toString());
                    break;
                }
                if (this.spnPriceUp.isFocused()) {
                    this.spnPriceUp.getEditor().setText(price.toString());
                    break;
                }
                this.spnPriceLow.getEditor().setText(price.toString());
                this.spnPriceUp.getEditor().setText(price.toString());
                break;
            }
            case 19: 
            case 20: {
                if (!this.spnPriceLow.getParent().isDisable() && this.sellRadio.isSelected()) {
                    this.spnPriceLow.getEditor().setText(price.toString());
                    break;
                }
                if (this.spnPriceUp.getParent().isDisable() || !this.buyRadio.isSelected()) break;
                this.spnPriceUp.getEditor().setText(price.toString());
                break;
            }
            case 10: 
            case 11: {
                if (this.spnPriceMost.getParent().isDisable()) break;
                this.spnPriceMost.getEditor().setText(price.toString());
                break;
            }
            case 0: {
                if (this.spnPriceBid.getParent().isDisable()) break;
                this.spnPriceBid.getEditor().setText(price.toString());
            }
        }
    }

    public TextField getTxtCode() {
        return this.txtCode;
    }

    public boolean isHk() {
        return true;
    }

    public abstract IntegerProperty minuteProperty();
}

