/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio.basket.mail;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.entity.trade.instruction.BasketOrderAdvice;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.instructions.viewers.portfolio.basket.mail.InstructionPortfBsktInfoMailInstruction;
import cms.tmx.instructions.viewers.portfolio.basket.mail.InstructionPortfBsktMailBasePart;
import cms.tmx.instructions.viewers.portfolio.basket.mail.InstructionPortfBsktMailInstructionModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.trade.views.basket.BasketEntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cn.hutool.core.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.inject.Inject;

public class InstructionPortfBsktMailInstructionPart
extends InstructionPortfBsktMailBasePart {
    @Inject
    private InstructionPortfBsktMailInstructionModel model;
    @Inject
    private InstructionPortfBsktInfoMailInstruction bi;

    @Override
    @FXML
    public void initialize() {
        this.bi.setMail(true);
        this.initPortfAccntModel();
        this.setBuySimbol("\u90ae\u4ef6\u6307\u4ee4\u4e0b\u8fbe");
        this.setSellSimbol("\u90ae\u4ef6\u6307\u4ee4\u4e0b\u8fbe");
        this.setBsSimbol("\u90ae\u4ef6\u6307\u4ee4\u4e0b\u8fbe");
        this.setConfirmSimbol("\u90ae\u4ef6\u6307\u4ee4\u4e0b\u8fbe\u786e\u8ba4");
        this.setBi(this.bi);
        this.setModel(this.model);
        super.initialize();
        this.model.getGear().removeNode("100");
        this.model.getGear().removeNode("-100");
    }

    private void initPortfAccntModel() {
        this.model.setInstructionPanelType("1");
        this.instDistModel.setMail(true);
        this.instDistModel.setInstructType("1");
        try {
            this.instDistModel.create();
        }
        catch (MException e) {
            logger.error("\u521b\u5efa\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u521b\u5efa\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25");
        }
    }

    @Override
    protected BasketSubmitResult doAction() throws MException {
        return this.model.submitInstruction();
    }

    @Override
    protected void showPart() {
        if (this.settings.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.portfolio.instruct.mail.query");
        }
    }

    @Override
    @FXML
    protected void order() {
        if (!this.getAlert().check(this.model.getAccList().size() > 0 || "3".equals(this.model.getInstructionPanelType()) || "4".equals(this.model.getInstructionPanelType()), Alert.AlertType.ERROR, this.getAccntSizeTip())) {
            return;
        }
        if (!this.getAlert().check(this.getBi().getBasket() != null, Alert.AlertType.ERROR, "\u672a\u9009\u62e9\u7bee\u5b50")) {
            return;
        }
        if (!this.getAlert().check(this.model.getSelectedList().size() > 0, Alert.AlertType.ERROR, "\u672a\u9009\u62e9\u6210\u4efd\u80a1")) {
            return;
        }
        if (!this.getAlert().check(this.model.getTotalQuantity() > 0L, Alert.AlertType.ERROR, "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5")) {
            return;
        }
        boolean canStarBuy = true;
        boolean canStarSell = true;
        this.model.getInsExpiredMap().clear();
        this.model.getFundTraderMap().clear();
        BasketEntrustConfirmDialog obj = (BasketEntrustConfirmDialog)this.of.create(BasketEntrustConfirmDialog.class);
        obj.setInstructionPanelType(this.model.getInstructionPanelType());
        obj.setMail(true);
        obj.setInstructionType(this.model.isNormal() ? "5" : "13");
        if ("0".equals(this.model.getInstructionPanelType()) || "4".equals(this.model.getInstructionPanelType())) {
            obj.setInstruction(true);
            obj.setExecution(true);
            ObservableList entrustList = FxUtils.newList();
            entrustList.addAll(this.model.getEntrustList(canStarBuy, canStarSell));
            FilteredList selectedItems = this.model.getItems().filtered(pd -> pd.isSelected() && pd.isVisible() && pd.getAvailableQty() > 0L);
            FilteredList errorItems = this.model.getItems().filtered(pd -> pd.isSelected() && pd.isVisible() && pd.getAvailableQty() > 0L && pd.getAmt(pd.getBsTrade().getRaw().equals("49")) == 0.0 && pd.getItem().getMktItem().getStop().getValue() == false);
            StringBuilder sb = new StringBuilder();
            sb.append("\u76ee\u6807\u6210\u5206\u80a1").append(selectedItems.size()).append("\u53ea\uff0c\u5b9e\u9645\u59d4\u6258\u6210\u5206\u80a1").append(entrustList.size()).append("\u53ea,");
            Iterator<BasketOrderAdvice> iterator = errorItems.iterator();
            while (iterator.hasNext()) {
                BasketTradeItem basketTradeItem = (BasketTradeItem)iterator.next();
                sb.append(basketTradeItem.getItem().getRefItem().getCode()).append(basketTradeItem.getItem().getRefItem().getName()).append("\u672a\u53d6\u5230\u91d1\u989d ");
            }
            obj.setEntrustInfo(sb.toString());
            Collections.sort(entrustList, (o1, o2) -> o2.getTip().compareTo(o1.getTip()));
            obj.setList(entrustList);
        } else {
            obj.setInstruction(true);
            obj.setExecution(false);
            obj.setBsSymbol(this.currentBsSimbol);
            ObservableList<BasketTradeItem> entrustBasket = this.model.getEntrustBasket();
            if ("2".equals(this.model.getInstructionPanelType()) || "1".equals(this.model.getInstructionPanelType())) {
                for (BasketTradeItem en : entrustBasket) {
                    WorkFlowDescriptor workFlow = this.model.getWorkFlowByPortfolioId(en.getPortfolioId());
                    if (workFlow == null || WorkflowTemplete.TWO_STEP_INST.getId() != workFlow.getId() && WorkflowTemplete.THREE_STEP_RISK.getId() != workFlow.getId()) continue;
                    AppointedTraderSetting traderSetting = this.model.buildTraderSetting(workFlow);
                    traderSetting.setWt(WorkflowTemplete.getWorkflowTemplete((int)workFlow.getId()));
                    this.model.getFundTraderMap().put((FundAccount)en.getAcc(), traderSetting);
                }
            }
            obj.setList(this.model.getEntrustBasket());
            obj.setInsExpiredMap(this.model.getInsExpiredMap());
            obj.setFundTraderMap(this.model.getFundTraderMap());
        }
        obj.setShowWarning(false);
        MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSimbol) ? "\u4e0b\u5355\u786e\u8ba4" : this.confirmSimbol);
        if (dialog.launch() == ButtonType.OK) {
            if (this.model.getInstruction() != null) {
                this.model.getInstruction().setPostil(obj.getPostil());
            }
            this.model.setPostil(obj.getPostil());
            try {
                List<BasketOrderAdvice> orderAdvices = this.model.getBasketOrderAdvice();
                ArrayList<String> portfolioIds = new ArrayList<String>();
                ArrayList checkRes = new ArrayList();
                for (BasketOrderAdvice advice : orderAdvices) {
                    portfolioIds.add(advice.getPortfolioId());
                    ArrayList items = new ArrayList();
                    List basketSecInstList = advice.getItemList();
                    for (BasketSecurityInst basketSecInst : basketSecInstList) {
                        if (basketSecInst.getSide() != 50) continue;
                        PInstructionManagement.CheckItem.Builder newBuilder = PInstructionManagement.CheckItem.newBuilder();
                        newBuilder.setMarket(basketSecInst.getMarket());
                        newBuilder.setOrderQty(basketSecInst.getOrderQty());
                        newBuilder.setSecurityId(basketSecInst.getSecurityId());
                        newBuilder.setSecurityType(basketSecInst.getSecurityType());
                        newBuilder.setSubSecAccntId(basketSecInst.getSubSecAccntId());
                        items.add(newBuilder.build());
                    }
                    if (CollectionUtil.isEmpty((Collection)items)) continue;
                    checkRes.addAll(this.model.getInsModel().checkAvalidPosition(advice.getPortfolioId(), "", "", (List)items));
                }
                if (!CollectionUtil.isEmpty(checkRes)) {
                    String secName;
                    RefItem item;
                    StringBuilder sb;
                    boolean permitOrder = true;
                    for (String portfolioId : portfolioIds) {
                        if (!permitOrder) continue;
                        permitOrder = this.model.getInsModel().permitOrder(portfolioId);
                    }
                    if (permitOrder) {
                        sb = new StringBuilder("");
                        for (PInstructionManagement.CheckResult result : checkRes) {
                            item = null;
                            secName = "";
                            item = "SHSC".equals(result.getMarket()) || "SZSC".equals(result.getMarket()) ? this.refMng.getItem(String.valueOf(result.getSecurityType()) + result.getMarket(), result.getMarket(), result.getSecurityId()) : this.refMng.getItem(result.getSecurityType(), result.getMarket(), result.getSecurityId());
                            if (item != null) {
                                secName = item.getName();
                            }
                            sb.append(StringUtils.rightPad((String)result.getSecurityId(), (int)6)).append(StringUtils.rightPad((String)secName, (int)4)).append("\u5356\u51fa\uff1a").append(result.getOrderQty()).append(" \u53ef\u7528\uff1a").append(result.getAvalidPos()).append("\r\n");
                        }
                        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u6307\u4ee4\u7684\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u662f\u5426\u7ee7\u7eed\u4e0b\u5355\uff1f\r\n" + sb.toString())) {
                            return;
                        }
                    } else {
                        sb = new StringBuilder("");
                        for (PInstructionManagement.CheckResult result : checkRes) {
                            item = null;
                            secName = "";
                            item = "SHSC".equals(result.getMarket()) || "SZSC".equals(result.getMarket()) ? this.refMng.getItem(String.valueOf(result.getSecurityType()) + result.getMarket(), result.getMarket(), result.getSecurityId()) : this.refMng.getItem(result.getSecurityType(), result.getMarket(), result.getSecurityId());
                            if (item != null) {
                                secName = item.getName();
                            }
                            sb.append(StringUtils.rightPad((String)result.getSecurityId(), (int)6)).append(StringUtils.rightPad((String)secName, (int)4)).append("\u5356\u51fa\uff1a").append(result.getOrderQty()).append(" \u53ef\u7528\uff1a").append(result.getAvalidPos()).append("\r\n");
                        }
                        this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u7684\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\r\n" + sb.toString());
                        return;
                    }
                }
                BasketSubmitResult submitResult = this.doAction();
                this.es.postEvent("refresh.mail.position", null);
                if (submitResult != null) {
                    if (submitResult.getFailedTimes().get() > 0) {
                        this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, "\u63d0\u4ea4\u6210\u529f" + submitResult.getSuccessedTimes().get() + "\u7b14" + " " + "\u5931\u8d25" + submitResult.getFailedTimes().get() + "\u7b14 " + submitResult.getDesc());
                    } else {
                        this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u63d0\u4ea4\u6210\u529f" + submitResult.getSuccessedTimes().get() + "\u7b14" + " " + "\u5931\u8d25" + submitResult.getFailedTimes().get() + "\u7b14 " + submitResult.getDesc());
                    }
                }
            }
            catch (MException e) {
                this.getAlert().alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error("\u6295\u7ec4\u7bee\u5b50\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
            }
            catch (Exception e) {
                this.getAlert().alert(Alert.AlertType.ERROR, "\u6295\u7ec4\u7bee\u5b50\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
                logger.error("\u6295\u7ec4\u7bee\u5b50\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
            }
            this.showPart();
            this.searchTxt.setText("");
            this.model.calSecs();
        }
    }
}

