/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio.basket.mail;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoMiseDefaultDialog;
import cms.tmx.algorithm.viewers.AlgoMiseWapDialog;
import cms.tmx.api.trade.info.MiseRequset;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.entity.trade.instruction.BasketOrderAdvice;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.RespResult;
import cms.tmx.instructions.models.basket.BasketAlgoModel;
import cms.tmx.instructions.models.portfolio.InstrPortfoDistributionModel;
import cms.tmx.instructions.models.portfolio.basket.UserSettingPortfBasketTrade;
import cms.tmx.instructions.viewers.portfolio.basket.mail.InstructionPortfBsktMailTradeModel;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.portfolio.AlgoFuncControl;
import cms.tmx.trade.models.basket.BasketInfo;
import cms.tmx.trade.models.basket.BasketMngModel;
import cms.tmx.trade.utils.BsCell;
import cms.tmx.trade.utils.ItemPriceCell;
import cms.tmx.trade.views.basket.BasketEntrustConfirmDialog;
import cms.tmx.trade.views.basket.TrialCalculateDialog;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class InstructionPortfBsktMailBasePart
extends MxPart {
    @Inject
    private InstructionPortfBsktMailTradeModel model;
    @Inject
    protected UserSettingPortfBasketTrade settings;
    @Inject
    private BasketInfo bi;
    @Inject
    protected InstrPortfoDistributionModel instDistModel;
    protected List<Portfolio> portfolioList = new ArrayList<Portfolio>();
    @Inject
    protected BasketMngModel basketMngModel;
    @FXML
    protected Button btnOrder;
    @FXML
    protected TableView<BasketTradeItem> tableItems;
    @FXML
    protected TableColumn<BasketTradeItem, Boolean> colSelected;
    @FXML
    protected TableColumn<BasketTradeItem, String> colCode;
    @FXML
    protected TableColumn<BasketTradeItem, String> colName;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colCount;
    @FXML
    protected TableColumn<BasketTradeItem, String> colUnit;
    @FXML
    protected TableColumn<BasketTradeItem, MxNode> colDirection;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colPrice;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colPct;
    @FXML
    protected TableColumn<BasketTradeItem, String> colState;
    @FXML
    protected TableColumn<BasketTradeItem, String> colMarket;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colBuyCount;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colBuyPrice;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colLimitUp;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colSellCount;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colSellPrice;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colLimitLow;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colAvailableQty;
    @FXML
    protected TableColumn<BasketTradeItem, Number> colTargetQty;
    @FXML
    protected TableColumn<BasketTradeItem, CcsFundAccount> colAcc;
    @FXML
    protected TableColumn<BasketTradeItem, SecAccount> colSecAcc;
    @FXML
    protected TableColumn<BasketTradeItem, String> colBuy;
    @FXML
    protected TableColumn<BasketTradeItem, String> colSell;
    @FXML
    protected TableColumn<BasketTradeItem, String> colPortfolioName;
    @FXML
    protected Label lbMoney;
    @FXML
    protected Tooltip tpAmt;
    @FXML
    private Label lbPortfContent;
    @FXML
    protected Label lbCount;
    @FXML
    protected Label lbCountAll;
    @FXML
    protected Label lbCountUp;
    @FXML
    protected Label lbCountDown;
    @FXML
    protected Label lbCountStop;
    @FXML
    protected CheckBox cboxDown;
    @FXML
    protected CheckBox cboxUp;
    protected CheckBox cboxAll = new CheckBox();
    @FXML
    protected TextField searchTxt;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Label lbMailPortfolio;
    @FXML
    protected Label lbAssetPct;
    @FXML
    protected Label lbMonney;
    @FXML
    protected Label lbCanBuyPct;
    @FXML
    protected Label lbCanSellPct;
    @FXML
    protected Label lbBasketName;
    @FXML
    protected Label btnCalculate;
    @FXML
    protected CheckComboBox<Portfolio> cmbPortfolio;
    @FXML
    protected ComboBox<Basket> cmbBasket;
    @FXML
    protected ComboBox<MxNode> cmbPrice;
    @FXML
    protected ComboBox<MxNode> cmbLmtPriceType;
    @FXML
    protected ComboBox<MxNode> cmbStg;
    @FXML
    protected RadioButton radioBuy;
    @FXML
    protected RadioButton radioSell;
    @FXML
    protected RadioButton radioBuySell;
    @FXML
    protected Spinner<Double> spinFloat;
    @FXML
    protected Spinner<Double> spinExeRatio;
    @FXML
    private TextField txtCount;
    @FXML
    protected TextField txtCountForAdj;
    @FXML
    protected TextField txtMoney;
    @FXML
    protected TextField txtAssetPct;
    @FXML
    protected TextField txtCanBuyPct;
    @FXML
    protected TextField txtCanSellPct;
    @FXML
    protected HBox hboxMoney;
    @FXML
    protected HBox hboxAsset;
    @FXML
    protected HBox hboxCanBuy;
    @FXML
    protected HBox hboxCanSell;
    @FXML
    protected HBox hboxCount;
    @FXML
    protected HBox hboxCountForAdj;
    @FXML
    protected HBox hboxExeRatio;
    @FXML
    private Label lbErrInfo;
    @FXML
    private VBox vBoxItems;
    @FXML
    private Label amtMag;
    @FXML
    private Label qtyMag;
    @Inject
    protected CcsAccountMap accMng;
    ObservableList<MxNode> regularBasketAlgoAll;
    ObservableList<MxNode> regularBasketAlgo = FxUtils.newList();
    ObservableList<MxNode> regularBasketAlgoLimit = FxUtils.newList();
    List<String> limitAlgoRaws = Arrays.asList("19", "20");
    private String accntSizeTip = "\u672a\u9009\u62e9\u6295\u7ec4";
    protected DoubleSpinnerCtrl ctrlFloat = new DoubleSpinnerCtrl(false, 6, 3);
    protected DoubleSpinnerCtrl ctrlRatio = new DoubleSpinnerCtrl(false, 6, 3);
    protected static final Logger logger = LogManager.getLogger(InstructionPortfBsktMailBasePart.class);
    protected ObservableList<CcsFundAccount> listAccount = FxUtils.newList();
    private boolean hasRender = false;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected UserPreOrderTips setTips;
    @Inject
    protected IUIService uiService;
    @Inject
    protected AlgoFuncControl algoFunc;
    protected Instruction instruction;
    private String buySimbol = "\u4e70\u5165";
    private String sellSimbol = "\u5356\u51fa";
    private String bsSimbol = "\u4e70\u5356";
    protected String currentBsSimbol = "";
    protected String confirmSimbol = "";
    @FXML
    protected TabPane tabParam;
    @FXML
    protected Tab tabNormal;
    @FXML
    protected Tab tabAlgo;
    @FXML
    protected VBox hbContent;
    @FXML
    protected VBox hbParam;
    @FXML
    protected Label lbParamBuy;
    @FXML
    protected Label lbParamSell;
    @FXML
    protected ComboBox<MxNode> cmbAlgoBuy;
    @FXML
    protected ComboBox<MxNode> cmbAlgoSell;
    @FXML
    private Label lbStatusBuy;
    @FXML
    private Label lbStatusSell;
    @FXML
    private Label lbPriceLmtType;
    private Boolean buyIsSet = false;
    private Boolean sellIsSet = false;
    protected MxList<BasketTradeItem> mxList = new MxList();
    protected Predicate<BasketTradeItem> pd = en -> {
        String text = this.searchTxt.getText().trim();
        if (en.getItem().getSecurityId().contains(text) || en.getItem().getSecurityName().contains(text)) {
            en.setVisible(true);
            return true;
        }
        en.setVisible(false);
        return false;
    };
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getItems(), this.pd);
    private ChangeListener<? super Boolean> itemListener = (ob, old, now) -> {
        List<BasketTradeItem> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<BasketTradeItem> observableList = this.model.getItems();
        synchronized (observableList) {
            newList.addAll((Collection<BasketTradeItem>)this.model.getItems());
            int i = 0;
            while (i < this.model.getItems().size()) {
                ((BasketTradeItem)this.model.getItems().get(i)).selectedProperty().addListener(this.model.lstn);
                ++i;
            }
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            if (this.p != null) {
                this.p.layout();
            }
            this.tableItems.layout();
        });
    };
    private ChangeListener<? super Boolean> basketLis = (ob, old, now) -> {
        Basket lastBsk = (Basket)this.cmbBasket.getSelectionModel().getSelectedItem();
        this.cmbBasket.getItems().clear();
        this.cmbBasket.getSelectionModel().clearSelection();
        for (Basket bskt : this.basketMngModel.getList()) {
            this.cmbBasket.getItems().add((Object)bskt.copy(false));
        }
        if (this.basketMngModel.getList().contains((Object)lastBsk)) {
            this.cmbBasket.getSelectionModel().select((Object)lastBsk);
        } else {
            this.cmbBasket.getSelectionModel().clearAndSelect(0);
        }
    };
    private ChangeListener<Boolean> lstnRefMng = (ob, old, now) -> Platform.runLater(() -> this.renderBasket((boolean)now));
    @Inject
    protected MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    @Inject
    private AlgoStrategyQueryModel algoStrategyQueryModel;
    @Inject
    protected ExecutorService exe;
    @Inject
    private PortfolioAccountModel accountMap;

    @FXML
    public void initialize() {
        this.initBuySellColumn();
        this.initPriceType();
        this.initCtrls();
        this.btnCalculate.setOnMouseClicked(event -> this.trialCalculate());
        this.tableItems.setPlaceholder((Node)new Label());
        this.renderBasket(this.refMng.doneProperty().get());
        this.refMng.doneProperty().addListener(this.lstnRefMng);
        this.model.changedProperty().addListener(this.itemListener);
        this.basketMngModel.changedProperty().addListener(this.basketLis);
        this.searchTxt.textProperty().addListener(this.lstnSearch);
        this.initAlgo();
        this.initUserPre();
        this.lbPriceLmtType.getTooltip().setText("\u4e0a\u9650\uff1a\u6307\u4ee4\u751f\u6210\u7684\u4ef7\u683c\u4e3a\u4ea4\u6613\u4e70\u5165\u6267\u884c\u7684\u4e0a\u9650\u4ef7\u683c\r\n\u4e0b\u9650\uff1a\u6307\u4ee4\u751f\u6210\u7684\u4ef7\u683c\u4e3a\u4ea4\u6613\u5356\u51fa\u6267\u884c\u7684\u4e0b\u9650\u4ef7\u683c\r\n\u4e0d\u9650\uff1a\u6307\u4ee4\u751f\u6210\u7684\u4ef7\u683c\u53ea\u505a\u53c2\u8003\uff0c\u4e0d\u9650\u5236\u4ea4\u6613\u6267\u884c\u65f6\u7684\u771f\u5b9e\u4ef7\u683c");
    }

    public void initUserPre() {
        this.settings.setType("6", "200065001");
        this.settings.doSet();
    }

    private void trialCalculate() {
        if (!this.getAlert().check(this.model.getSelectedList().size() > 0, Alert.AlertType.WARNING, "\u6ca1\u6709\u6709\u6548\u7684\u6210\u5206\u80a1")) {
            return;
        }
        TrialCalculateDialog trialDialog = (TrialCalculateDialog)this.of.create(TrialCalculateDialog.class);
        MxDialog dialog = this.df.create((DialogObj)trialDialog, "\u7bee\u5b50\u8bd5\u7b97");
        trialDialog.create(this.model.getItems());
        dialog.launch();
    }

    private void initAlgo() {
        this.tabAlgo.getTabPane().getTabs().remove((Object)this.tabAlgo);
        this.model.algoModel.setBasketTradeModel(this.model);
        this.tabParam.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            old.setContent(null);
            now.setContent((Node)this.hbContent);
            this.model.setNormal(now != this.tabAlgo);
            this.algoShowChange();
            this.hideAndShow();
        });
        this.hbParam.getChildren().remove((Object)this.lbParamBuy.getParent());
        this.hbParam.getChildren().remove((Object)this.lbParamSell.getParent());
        this.lbParamBuy.getStyleClass().add((Object)"btnOperation");
        this.lbParamSell.getStyleClass().add((Object)"btnOperation");
        FxUtils.makePC((Node)this.lbParamBuy, (String)"red", (boolean)true);
        FxUtils.makePC((Node)this.lbParamSell, (String)"red", (boolean)true);
        this.lbParamBuy.setOnMouseClicked(event -> {
            if (this.setParam(this.cmbAlgoBuy, this.model.algoModel.getAlgoBuy(), true)) {
                this.buyIsSet = true;
                if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3"})) {
                    FxUtils.makePC((Node)this.lbStatusBuy, (String)"right", (boolean)true);
                }
                this.lbParamBuy.setText("\u5df2\u8bbe\u7f6e");
                FxUtils.makePC((Node)this.lbParamBuy, (String)"red", (boolean)false);
            } else if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3"})) {
                FxUtils.makePC((Node)this.lbStatusBuy, (String)"error", (boolean)true);
            }
        });
        this.lbParamSell.setOnMouseClicked(event -> {
            if (this.setParam(this.cmbAlgoSell, this.model.algoModel.getAlgoSell(), false)) {
                this.sellIsSet = true;
                if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3"})) {
                    this.lbStatusSell.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"right"), true);
                }
                this.lbParamSell.setText("\u5df2\u8bbe\u7f6e");
                FxUtils.makePC((Node)this.lbParamSell, (String)"red", (boolean)false);
            } else if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3"})) {
                this.lbStatusSell.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
            }
        });
        this.cmbAlgoBuy.valueProperty().bindBidirectional(this.model.algoModel.algoTypeBuyProperty());
        this.cmbAlgoBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.buyIsSet = false;
            this.lbParamBuy.setText("\u672a\u8bbe\u7f6e");
            FxUtils.makePC((Node)this.lbParamBuy, (String)"red", (boolean)true);
            this.lbStatusBuy.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"right"), false);
            this.lbStatusBuy.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
        });
        this.cmbAlgoSell.valueProperty().bindBidirectional(this.model.algoModel.algoTypeSellProperty());
        this.cmbAlgoSell.getSelectionModel().selectedItemProperty().addListener(ob -> {
            this.sellIsSet = false;
            this.lbParamSell.setText("\u672a\u8bbe\u7f6e");
            FxUtils.makePC((Node)this.lbParamSell, (String)"red", (boolean)true);
            this.lbStatusSell.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"right"), false);
            this.lbStatusSell.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
        });
        this.regularBasketAlgoAll = this.algoFunc.getRegularBasketAlgo();
        this.regularBasketAlgo.addAll(this.regularBasketAlgoAll);
        for (MxNode algoNode : this.regularBasketAlgoAll) {
            if (!"19".equals(algoNode.getRaw()) && !"20".equals(algoNode.getRaw())) continue;
            this.regularBasketAlgoLimit.add((Object)algoNode);
        }
        if (this.regularBasketAlgoAll.size() > 0) {
            this.cmbAlgoBuy.setItems(this.regularBasketAlgoAll);
            this.cmbAlgoBuy.getSelectionModel().select(0);
            this.cmbAlgoSell.setItems(this.regularBasketAlgo);
            this.cmbAlgoSell.getSelectionModel().select(0);
        }
        this.cmbAlgoSell.getParent().setDisable(true);
    }

    private void algoShowChange() {
        this.hbParam.getChildren().remove((Object)this.lbParamBuy.getParent());
        this.hbParam.getChildren().remove((Object)this.lbParamSell.getParent());
        if (!((Tab)this.tabParam.getSelectionModel().getSelectedItem()).equals(this.tabAlgo)) {
            return;
        }
        if (this.radioBuySell.isSelected()) {
            this.hbParam.getChildren().add(5, (Object)this.lbParamBuy.getParent());
            this.hbParam.getChildren().add(6, (Object)this.lbParamSell.getParent());
            return;
        }
        this.hbParam.getChildren().add(5, (Object)(this.radioBuy.isSelected() ? this.lbParamBuy.getParent() : this.lbParamSell.getParent()));
        this.hbParam.getChildren().remove((Object)(this.radioBuy.isSelected() ? this.lbParamSell.getParent() : this.lbParamBuy.getParent()));
    }

    private boolean setParam(ComboBox<MxNode> cmbAlgo, AlgoModel algoModel, boolean isBuy) {
        String algoType = ((MxNode)cmbAlgo.getSelectionModel().getSelectedItem()).getRaw();
        boolean isRepo = this.isAllRepo((Basket)this.cmbBasket.getSelectionModel().getSelectedItem());
        MxDialog dialog = null;
        Boolean isLimitUp = null;
        switch (algoType) {
            case "14": {
                AlgoMiseDefaultDialog obj = (AlgoMiseDefaultDialog)this.of.create(AlgoMiseDefaultDialog.class);
                if (this.settings.isAlgoEnable()) {
                    obj.start = this.settings.getAlgoBeginTime();
                    obj.end = this.settings.getAlgoEndTime();
                }
                obj.setMise(algoModel);
                obj.isAllRepo = isRepo;
                dialog = this.df.create((DialogObj)obj, "\u53c2\u6570\u8bbe\u7f6e");
                if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3", "4"})) break;
                if (this.instruction != null && this.instruction.isCanModify()) {
                    obj.anchorPane.setDisable(false);
                    break;
                }
                obj.anchorPane.setDisable(true);
                break;
            }
            case "19": 
            case "20": {
                isLimitUp = isBuy;
            }
            case "15": 
            case "16": {
                AlgoMiseWapDialog objWap = (AlgoMiseWapDialog)this.of.create(AlgoMiseWapDialog.class);
                if (this.settings.isAlgoEnable()) {
                    objWap.start = this.settings.getAlgoBeginTime();
                    objWap.end = this.settings.getAlgoEndTime();
                }
                objWap.setMise(algoModel);
                objWap.setLimitPriceHint(isLimitUp);
                objWap.isAllRepo = isRepo;
                dialog = this.df.create((DialogObj)objWap, "\u53c2\u6570\u8bbe\u7f6e");
                if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3", "4"})) break;
                if (this.instruction != null && this.instruction.isCanModify()) {
                    objWap.setDisable(false);
                    break;
                }
                objWap.setDisable(true);
            }
        }
        return dialog != null && dialog.launch() == ButtonType.OK;
    }

    private boolean isAllRepo(Basket basket) {
        boolean isRepo = true;
        for (BasketItem ba : basket.getList()) {
            if (ba.getSecurityType().equals("REPO")) continue;
            isRepo = false;
            break;
        }
        return isRepo;
    }

    @PreDestroy
    private void close() {
        this.refMng.doneProperty().removeListener(this.lstnRefMng);
        this.model.changedProperty().removeListener(this.itemListener);
        this.basketMngModel.changedProperty().removeListener(this.basketLis);
        this.model.getItems().clear();
    }

    private void initBuySellColumn() {
        this.addVisibleListerner(this.colSellCount, this.colSell);
        this.addVisibleListerner(this.colSellPrice, this.colSell);
        this.addVisibleListerner(this.colLimitLow, this.colSell);
        this.addVisibleListerner(this.colBuyCount, this.colBuy);
        this.addVisibleListerner(this.colBuyPrice, this.colBuy);
        this.addVisibleListerner(this.colLimitUp, this.colBuy);
    }

    private void addVisibleListerner(TableColumn<?, ?> col, TableColumn<?, ?> colParent) {
        col.visibleProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                colParent.setVisible(true);
            }
        });
    }

    protected void renderBasket(boolean done) {
        if (done && !this.hasRender) {
            this.hasRender = true;
            this.cmbBasket.getItems().setAll((Collection)this.basketMngModel.getList());
            this.cmbBasket.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
                this.getBi().setBasket(now);
                if (now == null) {
                    return;
                }
                boolean allRepo = this.isAllRepo((Basket)now);
                if (!allRepo && this.buyIsSet.booleanValue() && this.model.algoModel.getAlgoBuy().getEndHour() == 15) {
                    this.buyIsSet = false;
                    if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3", "4"})) {
                        this.lbStatusBuy.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"right"), false);
                        this.lbStatusBuy.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
                    }
                }
                if (!allRepo && this.sellIsSet.booleanValue() && this.model.algoModel.getAlgoSell().getEndHour() == 15) {
                    this.sellIsSet = false;
                    if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3", "4"})) {
                        this.lbStatusSell.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"right"), false);
                        this.lbStatusSell.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
                    }
                }
            });
            if (!this.cmbBasket.getItems().isEmpty()) {
                this.cmbBasket.getSelectionModel().select(0);
            } else {
                Basket basket = new Basket();
                this.cmbBasket.getItems().add((Object)basket);
                this.cmbBasket.getSelectionModel().select((Object)basket);
            }
            this.cmbBasket.setOnMouseClicked(event -> {
                Basket lastBsk = (Basket)this.cmbBasket.getSelectionModel().getSelectedItem();
                this.cmbBasket.getItems().setAll((Collection)this.basketMngModel.getList());
                if (this.basketMngModel.getList().contains((Object)lastBsk)) {
                    this.cmbBasket.getSelectionModel().select((Object)lastBsk);
                } else {
                    this.cmbBasket.getSelectionModel().clearAndSelect(0);
                }
            });
            this.createTable();
        }
    }

    protected void initCtrls() {
        this.initAcc();
        this.initBuyOrSell();
        this.cmbPrice.setItems(this.model.getGear().getNodes());
        this.cmbPrice.getSelectionModel().select((Object)this.model.getGear());
        this.cmbPrice.selectionModelProperty().addListener((ob, oldV, newV) -> {
            if (newV != null && "11".equals(((MxNode)this.cmbPrice.getSelectionModel().getSelectedItem()).getRaw())) {
                this.spinFloat.getEditor().setText("");
                this.spinFloat.setDisable(true);
            } else {
                this.spinFloat.setDisable(false);
            }
            Platform.runLater(() -> {
                if (this.p != null) {
                    this.p.layout();
                }
            });
        });
        this.model.gearProperty().bind((ObservableValue)this.cmbPrice.getSelectionModel().selectedItemProperty());
        this.ctrlFloat.ctrl(this.spinFloat);
        SpinnerUtils.arrowsStyle(this.spinFloat);
        MxBindings.bindSDMinus((Property)this.spinFloat.getEditor().textProperty(), (Property)this.model.floatingProperty());
        this.spinFloat.getEditor().setText("");
        this.onUnit();
        this.model.pctUnitProperty().addListener(ob -> this.onUnit());
        this.lbUnit.getStyleClass().add((Object)"lbPercentYuan");
        this.ctrlRatio.ctrl(this.spinExeRatio);
        this.ctrlRatio.setScale(2);
        this.ctrlRatio.setLen(3);
        this.ctrlRatio.setMax(100.0);
        SpinnerUtils.arrowsStyle(this.spinExeRatio);
        MxBindings.bindSDMinus((Property)this.spinExeRatio.getEditor().textProperty(), (Property)this.model.exeRatioProperty());
        this.cmbStg.setItems(this.model.getStg().getNodes());
        this.cmbStg.getSelectionModel().select((Object)this.model.getStg());
        this.cmbStg.valueProperty().bindBidirectional(this.model.stgProperty());
        this.hboxCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("1"), (Observable[])new Observable[]{this.model.stgProperty()}));
        this.txtCount.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 9, 2)));
        MxBindings.bindSD((Property)this.txtCount.textProperty(), (Property)this.model.countBskProperty());
        this.txtCount.setText(StringUtils.toPriceStr((String)this.txtCount.getText()));
        this.qtyMag.visibleProperty().bind((ObservableValue)this.hboxCount.visibleProperty());
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.txtCount);
        this.hboxCountForAdj.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("6"), (Observable[])new Observable[]{this.model.stgProperty()}));
        MxBindings.bindSD((Property)this.txtCountForAdj.textProperty(), (Property)this.model.countBskForAdgustProperty());
        this.txtCountForAdj.setTextFormatter(new TextFormatter((UnaryOperator)new DoubleFilter(true, 9, 2)));
        this.txtCountForAdj.setText(StringUtils.toPriceStr((String)this.txtCountForAdj.getText()));
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("2"), (Observable[])new Observable[]{this.model.stgProperty()}));
        this.txtMoney.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        MxBindings.bindSD((Property)this.txtMoney.textProperty(), (Property)this.model.moneyProperty());
        this.txtMoney.setText(StringUtils.toPriceStr((String)this.txtMoney.getText()));
        this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
        TextFieldUtils.showMagnitude((Label)this.amtMag, (TextField)this.txtMoney);
        this.hboxAsset.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("3"), (Observable[])new Observable[]{this.model.stgProperty()}));
        this.hboxCanBuy.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("4"), (Observable[])new Observable[]{this.model.stgProperty()}));
        this.hboxCanSell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getStg().is("5"), (Observable[])new Observable[]{this.model.stgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtAssetPct);
        MxBindings.bindSD((Property)this.txtAssetPct.textProperty(), (Property)this.model.assetPctProperty());
        this.txtAssetPct.setText(StringUtils.toPriceStr((String)this.txtAssetPct.getText()));
        TextFieldUtils.setLess100((TextField)this.txtCanBuyPct);
        MxBindings.bindSD((Property)this.txtCanBuyPct.textProperty(), (Property)this.model.canBuyPctProperty());
        this.txtCanBuyPct.setText(StringUtils.toPriceStr((String)this.txtCanBuyPct.getText()));
        TextFieldUtils.setLess100((TextField)this.txtCanSellPct);
        MxBindings.bindSD((Property)this.txtCanSellPct.textProperty(), (Property)this.model.canSellPctProperty());
        this.txtCanSellPct.setText(StringUtils.toPriceStr((String)this.txtCanSellPct.getText()));
        this.model.setBuySell(true);
        MxBindings.bindSD((Property)this.lbMoney.textProperty(), (ObservableNumberValue)this.model.amountProperty(), (int)2);
        MxBindings.bindSD((Property)this.tpAmt.textProperty(), (ObservableNumberValue)this.model.amountProperty(), (int)2);
        MxBindings.bindSI((Property)this.lbCountAll.textProperty(), (Property)this.getBi().totalCountProperty());
        MxBindings.bindSI((Property)this.lbCount.textProperty(), (Property)this.model.numProperty());
        MxBindings.bindSI((Property)this.lbCountUp.textProperty(), (Property)this.getBi().upCountProperty());
        MxBindings.bindSI((Property)this.lbCountDown.textProperty(), (Property)this.getBi().downCountProperty());
        MxBindings.bindSI((Property)this.lbCountStop.textProperty(), (Property)this.getBi().stopCountProperty());
        Bindings.bindBidirectional((Property)this.cboxDown.selectedProperty(), (Property)this.model.filterDownProperty());
        Bindings.bindBidirectional((Property)this.cboxUp.selectedProperty(), (Property)this.model.filterUpProperty());
        Bindings.bindBidirectional((Property)this.cboxAll.selectedProperty(), (Property)this.model.filterAllProperty());
        Bindings.bindBidirectional((Property)this.lbErrInfo.textProperty(), (Property)this.model.errInfoProperty());
        this.vBoxItems.getChildren().remove((Object)this.lbErrInfo);
        Tooltip tooltip = new Tooltip();
        this.lbErrInfo.setTooltip(tooltip);
        this.model.errInfoProperty().addListener((ob, oldV, newV) -> {
            tooltip.setText(newV);
            if (StringUtils.isEmpty((String)newV)) {
                this.vBoxItems.getChildren().remove((Object)this.lbErrInfo);
            } else {
                this.vBoxItems.getChildren().add(0, (Object)this.lbErrInfo);
            }
        });
    }

    private void initPriceType() {
        this.cmbLmtPriceType.setItems(this.model.getPriceLimitType().getNodes());
        this.cmbPrice.getSelectionModel().select((Object)this.model.getPriceLimitType());
        this.cmbLmtPriceType.valueProperty().bindBidirectional(this.model.priceLimitTypeProperty());
        this.cmbLmtPriceType.valueProperty().addListener((ob, oldV, newV) -> this.controlsDisable());
        this.model.normalProperty().addListener((ob, oldV, newV) -> this.normalAlgoChange((boolean)newV));
        this.model.priceLimitTypeBuy((MxNode)this.model.priceLimitTypeProperty().get());
    }

    private void normalAlgoChange(boolean newV) {
        this.model.reloadBuyStgAndPriceType();
        if (!newV && this.instruction != null && this.instruction.getBasketOrderAdvice() != null) {
            if ("12".equals(Integer.toString(this.instruction.getBasketOrderAdvice().getPriceType())) && this.isExePart()) {
                this.cmbPrice.setDisable(false);
                this.model.getGear().removeNode("12");
            } else {
                this.cmbPrice.getSelectionModel().select((Object)this.model.getGear().getNode(Integer.toString(this.instruction.getBasketOrderAdvice().getPriceType())));
            }
            if (this.instruction.getBasketOrderAdvice().getFloatPrice() == 0.0) {
                this.model.setPctUnit(true);
                this.lbUnit.setText("%");
                this.spinFloat.getEditor().setText(String.valueOf(this.instruction.getBasketOrderAdvice().getFloatPercent()));
            } else {
                this.model.setPctUnit(false);
                this.lbUnit.setText("\u5143");
                this.spinFloat.getEditor().setText(String.valueOf(this.instruction.getBasketOrderAdvice().getFloatPrice()));
            }
        }
        this.model.calSecs();
        this.controlsDisable();
    }

    private void controlsDisable() {
        block23: {
            block22: {
                if (this.cmbLmtPriceType.getValue() == null) {
                    return;
                }
                if ("3".equals(this.model.getInstructionPanelType())) {
                    this.priceControlDisable(true);
                } else {
                    this.priceControlDisable(false);
                }
                if (!this.model.isNormal()) break block22;
                "2".equals(((MxNode)this.cmbLmtPriceType.getValue()).getRaw());
                break block23;
            }
            if ("4".equals(this.model.getInstructionPanelType())) {
                this.priceControlDisable(true);
            }
            switch (((MxNode)this.cmbLmtPriceType.getValue()).getRaw()) {
                case "1": 
                case "4": 
                case "5": {
                    String sellOldRaw;
                    String buyOldRaw;
                    if (this.regularBasketAlgoLimit.size() == 0) {
                        this.cmbAlgoBuy.setItems(this.regularBasketAlgoLimit);
                        this.cmbAlgoBuy.setValue(null);
                        this.cmbAlgoSell.setItems(this.regularBasketAlgoLimit);
                        this.cmbAlgoSell.setValue(null);
                        return;
                    }
                    this.cmbAlgoBuy.setItems(this.regularBasketAlgoLimit);
                    this.cmbAlgoSell.setItems(this.regularBasketAlgoLimit);
                    if (this.cmbAlgoBuy.getValue() == null) {
                        this.cmbAlgoBuy.getSelectionModel().select(0);
                    }
                    if (this.cmbAlgoSell.getValue() == null) {
                        this.cmbAlgoSell.getSelectionModel().select(0);
                    }
                    if (!this.limitAlgoRaws.contains(buyOldRaw = ((MxNode)this.cmbAlgoBuy.getValue()).getRaw())) {
                        this.cmbAlgoBuy.getSelectionModel().select(0);
                    }
                    if (this.limitAlgoRaws.contains(sellOldRaw = ((MxNode)this.cmbAlgoSell.getValue()).getRaw())) break;
                    this.cmbAlgoSell.getSelectionModel().select(0);
                    break;
                }
                case "3": {
                    this.priceControlDisable(true);
                    this.cmbAlgoBuy.setItems(this.regularBasketAlgo);
                    this.cmbAlgoSell.setItems(this.regularBasketAlgo);
                    break;
                }
                default: {
                    this.cmbAlgoBuy.setItems(this.regularBasketAlgo);
                    this.cmbAlgoSell.setItems(this.regularBasketAlgo);
                }
            }
        }
        this.hideAndShow();
    }

    private void initBuyOrSell() {
        ToggleGroup group = new ToggleGroup();
        this.radioBuy.setToggleGroup(group);
        this.radioSell.setToggleGroup(group);
        this.radioBuySell.setToggleGroup(group);
        group.selectedToggleProperty().addListener((ob, oldV, newV) -> {
            if (!(newV instanceof RadioButton)) {
                return;
            }
            RadioButton radio = (RadioButton)RadioButton.class.cast(newV);
            switch (radio.getId()) {
                case "radioBuy": {
                    this.bi.setBuy(true);
                    this.bi.setSell(false);
                    this.model.setSell(false);
                    this.model.setBuySell(false);
                    this.model.setBuy(true);
                    this.cmbAlgoSell.getParent().setDisable(true);
                    this.cmbAlgoBuy.getParent().setDisable(false);
                    break;
                }
                case "radioSell": {
                    this.bi.setSell(true);
                    this.bi.setBuy(false);
                    this.model.setBuy(false);
                    this.model.setBuySell(false);
                    this.model.setSell(true);
                    this.cmbAlgoBuy.getParent().setDisable(true);
                    this.cmbAlgoSell.getParent().setDisable(false);
                    break;
                }
                case "radioBuySell": {
                    this.bi.setBuy(false);
                    this.bi.setSell(false);
                    this.model.setBuy(false);
                    this.model.setSell(false);
                    this.model.setBuySell(true);
                    this.cmbAlgoBuy.getParent().setDisable(false);
                    this.cmbAlgoSell.getParent().setDisable(false);
                    break;
                }
            }
            this.algoShowChange();
            this.hideAndShow();
            this.onBsChange();
            this.model.onBsChange(true);
        });
        this.radioBuy.setDisable(true);
        this.radioSell.setDisable(true);
        this.radioBuySell.setDisable(true);
        this.radioBuySell.setSelected(true);
        this.model.setBuy(false);
        this.model.setSell(false);
        this.model.setBuySell(true);
        this.model.reloadBuyStgAndPriceType();
    }

    protected void initAcc() {
        this.portfolioList = new ArrayList<Portfolio>(this.instDistModel.getPortfolios());
        this.portfolioList.removeIf(portfolio -> this.instDistModel.getAccSecsMap((Portfolio)portfolio) == null || this.instDistModel.getAccSecsMap((Portfolio)portfolio).isEmpty());
        this.cmbPortfolio.getItems().setAll(this.portfolioList);
        this.cmbPortfolio.getCheckModel().getCheckedItems().addListener(change -> {
            this.model.onPortfolioChange((ListChangeListener.Change<? extends Portfolio>)change);
            this.showTips();
        });
        if (!this.cmbPortfolio.getItems().isEmpty()) {
            this.cmbPortfolio.getCheckModel().clearChecks();
        }
    }

    protected void onUnit() {
        if (this.model.isPctUnit()) {
            this.ctrlFloat.setScale(2);
            this.ctrlFloat.setLen(2);
            this.ctrlFloat.setMax(100.0);
            this.spinFloat.getEditor().setText("0.00");
            this.lbUnit.setText("%");
        } else {
            this.ctrlFloat.setScale(3);
            this.ctrlFloat.setLen(3);
            this.ctrlFloat.setMax(1000.0);
            this.ctrlFloat.ctrl(this.spinFloat);
            this.lbUnit.setText("\u5143");
            this.spinFloat.getEditor().setText("0.00");
        }
    }

    protected void onBsChange() {
        if (this.radioBuy.isSelected()) {
            this.btnOrder.setText(this.getBuySimbol());
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.currentBsSimbol = this.getBuySimbol();
        } else if (this.radioSell.isSelected()) {
            this.btnOrder.setText(this.getSellSimbol());
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.currentBsSimbol = this.getSellSimbol();
        } else {
            this.btnOrder.setText(this.getBsSimbol());
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.currentBsSimbol = this.getBsSimbol();
        }
    }

    @FXML
    protected void onFloatingUnit() {
        this.model.setPctUnit(!this.model.isPctUnit());
    }

    protected void createTable() {
        this.tableItems.setPlaceholder((Node)new Label());
        this.tableItems.setEditable(true);
        this.colSelected.setGraphic((Node)this.cboxAll);
        this.colSelected.setEditable(true);
        this.colSelected.setCellFactory(m -> new BasketCheckBoxCell());
        this.colSelected.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).selectedProperty());
        this.colCode.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().securityIdProperty());
        this.colName.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().securityNameProperty());
        this.colCount.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().countProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().unitProperty());
        this.colDirection.setCellFactory(cell -> new BsCell());
        this.colDirection.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).bsTradeProperty());
        this.colPrice.setCellFactory(cell -> new ItemPriceCell());
        this.colPrice.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().getMktItem() != null ? ((BasketTradeItem)m.getValue()).getItem().getMktItem().nowPriceProperty() : new SimpleDoubleProperty(0.0));
        this.colPct.setCellFactory(cell -> new ItemFloatCell(2, true));
        this.colPct.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().getMktItem() != null ? ((BasketTradeItem)m.getValue()).getItem().getMktItem().pctProperty() : new SimpleDoubleProperty(0.0));
        this.colState.setCellFactory(cell -> new ItemStateCell());
        this.colState.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().getMktItem() != null ? ((BasketTradeItem)m.getValue()).getItem().getMktItem().statusProperty() : new SimpleStringProperty());
        this.colMarket.setCellValueFactory(data -> ((BasketTradeItem)data.getValue()).marketProperty());
        this.colBuyCount.setCellFactory(cell -> new ItemCountCell(true));
        this.colBuyCount.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).buyCountProperty());
        this.colBuyPrice.setCellFactory(cell -> new EditPriceCell());
        this.colBuyPrice.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).buyPriceProperty());
        this.colLimitUp.setCellFactory(cell -> new ItemPriceCell());
        this.colLimitUp.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).upperLimitPriceProperty());
        this.colSellCount.setCellFactory(cell -> new ItemCountCell(false));
        this.colSellCount.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).sellCountProperty());
        this.colSellPrice.setCellFactory(cell -> new EditPriceCell());
        this.colSellPrice.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).sellPriceProperty());
        this.colLimitLow.setCellFactory(cell -> new ItemPriceCell());
        this.colLimitLow.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).lowerLimitPriceProperty());
        this.colSell.setVisible(false);
        this.colAvailableQty.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).availableQtyProperty());
        this.colAvailableQty.setCellFactory(cell -> new NumberTableCell());
        this.colTargetQty.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).targetCountProperty());
        this.colTargetQty.setCellFactory(cell -> new NumberTableCell());
        this.colAcc.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).accProperty());
        this.colSecAcc.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).secAccProperty());
        this.colPortfolioName.setCellValueFactory(m -> {
            CcsFundAccount acc = ((BasketTradeItem)m.getValue()).getAcc();
            if (acc instanceof CcsSubFundAccount) {
                CcsSubFundAccount subAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(acc);
                return new SimpleStringProperty(subAcc.getPortfolioName());
            }
            return new SimpleStringProperty();
        });
        this.tableItems.setItems(this.mxList.getList());
    }

    @FXML
    protected void order() {
        if (!(this.radioSell.isSelected() || this.buyIsSet.booleanValue() || this.model.isNormal())) {
            if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3", "4"})) {
                this.lbStatusBuy.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
                this.getAlert().alert(Alert.AlertType.ERROR, "\u4e70\u5165\u7b97\u6cd5\u53c2\u6570\u672a\u8bbe\u7f6e");
                return;
            }
            if ("4".equals(this.model.getInstructionPanelType()) && this.instruction != null && this.instruction.isCanModify()) {
                this.lbStatusBuy.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
                this.getAlert().alert(Alert.AlertType.ERROR, "\u4e70\u5165\u7b97\u6cd5\u53c2\u6570\u672a\u8bbe\u7f6e");
                return;
            }
        }
        if (!(this.radioBuy.isSelected() || this.sellIsSet.booleanValue() || this.model.isNormal())) {
            if (!StringUtils.belongto((String)this.model.getInstructionPanelType(), (String[])new String[]{"3", "4"})) {
                this.lbStatusSell.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
                this.getAlert().alert(Alert.AlertType.ERROR, "\u5356\u51fa\u7b97\u6cd5\u53c2\u6570\u672a\u8bbe\u7f6e");
                return;
            }
            if ("4".equals(this.model.getInstructionPanelType()) && this.instruction != null && this.instruction.isCanModify()) {
                this.lbStatusSell.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"error"), true);
                this.getAlert().alert(Alert.AlertType.ERROR, "\u5356\u51fa\u7b97\u6cd5\u53c2\u6570\u672a\u8bbe\u7f6e");
                return;
            }
        }
        if (!this.getAlert().check(this.model.getAccList().size() > 0 || "3".equals(this.model.getInstructionPanelType()) || "4".equals(this.model.getInstructionPanelType()), Alert.AlertType.ERROR, this.getAccntSizeTip())) {
            return;
        }
        if (!this.getAlert().check(this.getBi().getBasket() != null, Alert.AlertType.ERROR, "\u672a\u9009\u62e9\u7bee\u5b50")) {
            return;
        }
        if (!this.getAlert().check(this.model.getSelectedList().size() > 0, Alert.AlertType.ERROR, "\u672a\u9009\u62e9\u6210\u4efd\u80a1")) {
            return;
        }
        if (!this.getAlert().check(this.model.getTotalQuantity() > 0L, Alert.AlertType.ERROR, "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5")) {
            return;
        }
        boolean canStarBuy = true;
        boolean canStarSell = true;
        if (!this.model.isNormal()) {
            if (this.buyIsSet.booleanValue()) {
                canStarBuy = BasketAlgoModel.canStart(((MxNode)this.cmbAlgoBuy.getValue()).getRaw());
            }
            if (this.sellIsSet.booleanValue()) {
                canStarSell = BasketAlgoModel.canStart(((MxNode)this.cmbAlgoSell.getValue()).getRaw());
            }
            if (!canStarBuy || !canStarSell) {
                for (BasketTradeItem item : this.model.getItems()) {
                    if (!item.isSelected() || !item.isVisible() || !item.getItem().getSecurityId().startsWith("688") || "49".equals(item.getBsTrade().getRaw()) && canStarBuy || "50".equals(item.getBsTrade().getRaw()) && canStarSell) continue;
                    String info = "\u60a8\u7684\u7bee\u5b50\u4e2d\u5b58\u5728\u79d1\u521b\u677f\u8bc1\u5238,\u6682\u4e0d\u652f\u6301\u7bee\u5b50\u9ed8\u8ba4\u7b97\u6cd5\u3002\n\u79d1\u521b\u677f\u8bc1\u5238\u4f1a\u88ab\u8fc7\u6ee4,\u662f\u5426\u7ee7\u7eed\u4e0b\u5355?";
                    if (this.alert.check(false, Alert.AlertType.CONFIRMATION, info)) break;
                    return;
                }
            }
        }
        this.model.getInsExpiredMap().clear();
        this.model.getFundTraderMap().clear();
        BasketEntrustConfirmDialog obj = (BasketEntrustConfirmDialog)this.of.create(BasketEntrustConfirmDialog.class);
        obj.setInstructionPanelType(this.model.getInstructionPanelType());
        obj.setMail(true);
        obj.setInstructionType(this.model.isNormal() ? "5" : "13");
        if ("0".equals(this.model.getInstructionPanelType()) || "4".equals(this.model.getInstructionPanelType())) {
            obj.setInstruction(true);
            obj.setExecution(true);
            ObservableList entrustList = FxUtils.newList();
            entrustList.addAll(this.model.getEntrustList(canStarBuy, canStarSell));
            FilteredList selectedItems = this.model.getItems().filtered(pd -> pd.isSelected() && pd.isVisible() && pd.getAvailableQty() > 0L);
            FilteredList errorItems = this.model.getItems().filtered(pd -> pd.isSelected() && pd.isVisible() && pd.getAvailableQty() > 0L && pd.getAmt(pd.getBsTrade().getRaw().equals("49")) == 0.0 && pd.getItem().getMktItem().getStop().getValue() == false);
            StringBuilder sb = new StringBuilder();
            sb.append("\u76ee\u6807\u6210\u5206\u80a1").append(selectedItems.size()).append("\u53ea\uff0c\u5b9e\u9645\u59d4\u6258\u6210\u5206\u80a1").append(entrustList.size()).append("\u53ea,");
            for (BasketTradeItem basketTradeItem : errorItems) {
                sb.append(basketTradeItem.getItem().getRefItem().getCode()).append(basketTradeItem.getItem().getRefItem().getName()).append("\u672a\u53d6\u5230\u91d1\u989d ");
            }
            obj.setEntrustInfo(sb.toString());
            Collections.sort(entrustList, (o1, o2) -> o2.getTip().compareTo(o1.getTip()));
            obj.setList(entrustList);
        } else {
            obj.setInstruction(true);
            obj.setExecution(false);
            obj.setBsSymbol(this.currentBsSimbol);
            ObservableList<BasketTradeItem> entrustBasket = this.model.getEntrustBasket();
            if ("2".equals(this.model.getInstructionPanelType()) || "1".equals(this.model.getInstructionPanelType())) {
                for (BasketTradeItem en : entrustBasket) {
                    WorkFlowDescriptor workFlow = this.model.getWorkFlowByPortfolioId(en.getPortfolioId());
                    if (workFlow == null || WorkflowTemplete.TWO_STEP_INST.getId() != workFlow.getId() && WorkflowTemplete.THREE_STEP_RISK.getId() != workFlow.getId()) continue;
                    AppointedTraderSetting traderSetting = this.model.buildTraderSetting(workFlow);
                    traderSetting.setWt(WorkflowTemplete.getWorkflowTemplete((int)workFlow.getId()));
                    this.model.getFundTraderMap().put((FundAccount)en.getAcc(), traderSetting);
                }
            }
            obj.setList(this.model.getEntrustBasket());
            obj.setInsExpiredMap(this.model.getInsExpiredMap());
            obj.setFundTraderMap(this.model.getFundTraderMap());
        }
        obj.setShowWarning(false);
        MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSimbol) ? "\u4e0b\u5355\u786e\u8ba4" : this.confirmSimbol);
        if (dialog.launch() == ButtonType.OK) {
            if (!this.model.isNormal() && "0".equals(this.model.getInstructionPanelType())) {
                this.basketAlgoOrder();
                return;
            }
            if (this.model.getInstruction() != null) {
                this.model.getInstruction().setPostil(obj.getPostil());
            }
            this.model.setPostil(obj.getPostil());
            try {
                BasketSubmitResult submitResult = this.doAction();
                if (submitResult != null) {
                    if (submitResult.getFailedTimes().get() > 0) {
                        this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, "\u63d0\u4ea4\u6210\u529f" + submitResult.getSuccessedTimes().get() + "\u7b14" + " " + "\u5931\u8d25" + submitResult.getFailedTimes().get() + "\u7b14 " + submitResult.getDesc());
                    } else {
                        this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u63d0\u4ea4\u6210\u529f" + submitResult.getSuccessedTimes().get() + "\u7b14" + " " + "\u5931\u8d25" + submitResult.getFailedTimes().get() + "\u7b14 " + submitResult.getDesc());
                    }
                }
            }
            catch (MException e) {
                this.getAlert().alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error("\u6295\u7ec4\u7bee\u5b50\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
            }
            catch (Exception e) {
                this.getAlert().alert(Alert.AlertType.ERROR, "\u6295\u7ec4\u7bee\u5b50\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
                logger.error("\u6295\u7ec4\u7bee\u5b50\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
            }
            this.showPart();
            this.searchTxt.setText("");
            this.model.calSecs();
        }
    }

    protected void showPart() {
    }

    private void basketAlgoOrder() {
        RespResult result = new RespResult();
        ArrayList<Boolean> side = new ArrayList<Boolean>();
        if (this.model.isBuy()) {
            side.add(true);
        } else if (this.model.isSell()) {
            side.add(false);
        } else if (this.model.isBuySell()) {
            side.add(true);
            side.add(false);
        }
        LinkedList<MiseRequset> listReq = new LinkedList<MiseRequset>();
        for (Boolean isBuy : side) {
            for (CcsFundAccount acc : this.model.getAccList()) {
                try {
                    String algoType = isBuy != false ? ((MxNode)this.cmbAlgoBuy.getSelectionModel().getSelectedItem()).getRaw() : ((MxNode)this.cmbAlgoSell.getSelectionModel().getSelectedItem()).getRaw();
                    Basket bskItem = (Basket)this.cmbBasket.getSelectionModel().getSelectedItem();
                    MiseRequset request = this.model.algoModel.getMiseRequest(bskItem, acc, isBuy, algoType, "", "");
                    listReq.add(request);
                }
                catch (MException e) {
                    logger.error("basket algo request pack faild", (Throwable)e);
                    result.incrementFailed(e.getMessage());
                }
            }
        }
        this.exe.execute(() -> {
            for (MiseRequset request : listReq) {
                try {
                    this.model.algoModel.submit(request);
                    result.incrementSuccessed();
                }
                catch (MException e) {
                    logger.error("basket algo request faild", (Throwable)e);
                    result.incrementFailed(e.getMessage());
                }
            }
            Platform.runLater(() -> {
                Alert.AlertType aType = result.hasFailed() ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION;
                Platform.runLater(() -> this.alert.check(!this.setTips.getOrderTips(), aType, result.getDesc("\u63d0\u4ea4")));
            });
            this.algoStrategyQueryModel.query();
        });
        this.uiService.showPart("cms.tmx.instructions.part.portfolio.basket.algorithm.query");
    }

    public void basketAlgoOrder(Instruction instruction) {
        RespResult result = new RespResult();
        ArrayList<Boolean> side = new ArrayList<Boolean>();
        if (this.model.isBuy()) {
            side.add(true);
        } else if (this.model.isSell()) {
            side.add(false);
        } else if (this.model.isBuySell()) {
            side.add(true);
            side.add(false);
        }
        HashSet set = new HashSet();
        instruction.getBasketOrderAdvice().getItemList().forEach(item -> {
            boolean bl = set.add(item.getSubAccntId());
        });
        LinkedList<MiseRequset> listReq = new LinkedList<MiseRequset>();
        for (Boolean isBuy : side) {
            for (String acc : set) {
                try {
                    String algoType = String.valueOf(isBuy != false ? instruction.getBasketOrderAdvice().getAlgoTypeBuy() : instruction.getBasketOrderAdvice().getAlgoTypeSell());
                    if (StringUtils.isEmpty((String)algoType) || "0".equals(algoType)) {
                        algoType = isBuy != false ? ((MxNode)this.cmbAlgoBuy.getSelectionModel().getSelectedItem()).getRaw() : ((MxNode)this.cmbAlgoSell.getSelectionModel().getSelectedItem()).getRaw();
                    }
                    Basket basket = (Basket)this.cmbBasket.getSelectionModel().getSelectedItem();
                    MiseRequset request = this.model.algoModel.getMiseRequest(basket, (CcsFundAccount)this.accountMap.getSubFundAccountById(acc), isBuy, algoType, instruction.getId(), instruction.getResource().getId());
                    listReq.add(request);
                }
                catch (MException e) {
                    logger.error("basket algo request pack faild", (Throwable)e);
                    result.incrementFailed(e.getMessage());
                }
            }
        }
        this.exe.execute(() -> {
            for (MiseRequset request : listReq) {
                try {
                    this.model.algoModel.submit(request);
                    result.incrementSuccessed();
                }
                catch (MException e) {
                    logger.error("basket algo request faild", (Throwable)e);
                    result.incrementFailed(e.getMessage());
                }
            }
            Platform.runLater(() -> {
                Alert.AlertType aType = result.hasFailed() ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION;
                this.alert.check(!this.setTips.getOrderTips(), aType, result.getDesc("\u63d0\u4ea4"));
                this.clearFill();
            });
            this.algoStrategyQueryModel.query();
        });
        this.uiService.showPart("cms.tmx.instructions.part.portfolio.basket.algorithm.query");
    }

    protected BasketSubmitResult doAction() throws MException {
        return this.model.entrust();
    }

    protected void showTips() {
        this.lbPortfContent.setText(this.cmbPortfolio.getCheckModel().getCheckedItems().toString().substring(1, this.cmbPortfolio.getCheckModel().getCheckedItems().toString().length() - 1));
        this.lbPortfContent.setTooltip(new Tooltip(this.lbPortfContent.getText()));
    }

    @FXML
    public void refresh() {
        this.getBi().refresh();
    }

    @FXML
    public void copy() {
        TableUtils.basketCopyContentWithTwoHead(this.tableItems, (int)0, (int)0, this.colPct, this.colPct);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.basketWriteTwoHeadExcel(this.tableItems, (String)this.tableItems.getId(), (int)0, (int)0, this.colPct, this.colPct);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void hideAndShow() {
        if (this.model.isBuy()) {
            this.colSell.visibleProperty().set(false);
            this.colBuy.visibleProperty().set(true);
            if (!this.model.isNormal()) {
                this.colBuyPrice.setVisible(false);
                this.colLimitUp.setVisible(!this.isUnLimitPrice());
            } else if (this.isUnLimitPrice()) {
                this.colBuyPrice.setVisible(this.isExePart());
                this.colLimitUp.setVisible(false);
            } else if (this.isLimitPrice()) {
                this.colLimitUp.setVisible(true);
                this.colBuyPrice.setVisible(this.isExePart());
            } else {
                this.colLimitUp.setVisible(false);
                this.colBuyPrice.setVisible(true);
            }
            return;
        }
        if (this.model.isSell()) {
            this.colSell.visibleProperty().set(true);
            this.colBuy.visibleProperty().set(false);
            if (!this.model.isNormal()) {
                this.colSellPrice.setVisible(false);
                this.colLimitLow.setVisible(!this.isUnLimitPrice());
            } else if (this.isUnLimitPrice()) {
                this.colSellPrice.setVisible(this.isExePart());
                this.colLimitLow.setVisible(false);
            } else if (this.isLimitPrice()) {
                this.colLimitLow.setVisible(true);
                this.colSellPrice.setVisible(this.isExePart());
            } else {
                this.colLimitLow.setVisible(false);
                this.colSellPrice.setVisible(true);
            }
            return;
        }
        if (this.model.isBuySell()) {
            this.colSell.visibleProperty().set(true);
            this.colBuy.visibleProperty().set(true);
            if (!this.model.isNormal()) {
                this.colBuyPrice.setVisible(false);
                this.colSellPrice.setVisible(false);
                this.colLimitUp.setVisible(!this.isUnLimitPrice());
                this.colLimitLow.setVisible(!this.isUnLimitPrice());
            } else if (this.isUnLimitPrice()) {
                this.colBuyPrice.setVisible(this.isExePart());
                this.colLimitUp.setVisible(false);
                this.colSellPrice.setVisible(this.isExePart());
                this.colLimitLow.setVisible(false);
            } else if (this.isLimitPrice()) {
                this.colLimitUp.setVisible(true);
                this.colBuyPrice.setVisible(this.isExePart());
                this.colLimitLow.setVisible(true);
                this.colSellPrice.setVisible(this.isExePart());
            } else {
                this.colLimitUp.setVisible(false);
                this.colBuyPrice.setVisible(true);
                this.colLimitLow.setVisible(false);
                this.colSellPrice.setVisible(true);
            }
        }
    }

    private boolean isExePart() {
        return "4".equals(this.model.getInstructionPanelType());
    }

    private void checkShowlimit(ComboBox<MxNode> algo, TableColumn<BasketTradeItem, Number> columb) {
        block9: {
            MxNode node = (MxNode)algo.getSelectionModel().getSelectedItem();
            if (node == null) break block9;
            switch (node.getRaw()) {
                case "19": 
                case "20": {
                    columb.setVisible(true);
                    break;
                }
                default: {
                    columb.setVisible(false);
                }
            }
        }
    }

    protected void onApprove(boolean disable) {
        this.cmbPortfolio.setDisable(disable);
        this.lbPortfContent.setDisable(disable);
        this.cmbBasket.setDisable(disable);
        this.radioBuySell.setDisable(disable);
        this.radioBuy.setDisable(disable);
        this.radioSell.setDisable(disable);
        this.cmbPrice.setDisable(disable);
        this.spinFloat.setDisable(disable);
        this.cmbStg.setDisable(disable);
        this.txtCount.setDisable(disable);
        this.txtMoney.setDisable(disable);
        this.txtCountForAdj.setDisable(disable);
        this.txtAssetPct.setDisable(disable);
        this.txtCanBuyPct.setDisable(disable);
        this.txtCanSellPct.setDisable(disable);
        this.btnOrder.setDisable(disable);
        this.cboxDown.setDisable(disable);
        this.cboxUp.setDisable(disable);
        this.cboxAll.setDisable(disable);
        this.lbMailPortfolio.setDisable(disable);
        this.lbUnit.setDisable(disable);
    }

    protected void onExecution(boolean disable) {
        this.cmbPortfolio.setDisable(disable);
        this.cmbBasket.setDisable(disable);
        this.radioBuySell.setDisable(disable);
        this.radioBuy.setDisable(disable);
        this.radioSell.setDisable(disable);
        this.cmbStg.setDisable(disable);
        this.txtCount.setDisable(disable);
        this.txtMoney.setDisable(disable);
        this.txtAssetPct.setDisable(disable);
        this.txtCanBuyPct.setDisable(disable);
        this.txtCanSellPct.setDisable(disable);
        this.txtCountForAdj.setDisable(disable);
        this.btnOrder.setDisable(disable);
        this.cboxDown.setDisable(!disable);
        this.cboxUp.setDisable(!disable);
        this.cboxAll.setDisable(!disable);
        this.lbMailPortfolio.setDisable(disable);
        this.cmbPrice.setDisable(disable);
        this.spinFloat.setDisable(disable);
        this.lbUnit.setDisable(disable);
        this.hboxExeRatio.setVisible(true);
        this.spinExeRatio.setDisable(false);
        this.colAvailableQty.setVisible(true);
        this.colTargetQty.setVisible(true);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = ((Object)((Object)this)).getClass().getSuperclass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected void clearFill() {
        this.lbAssetPct.setVisible(false);
        this.lbMonney.setVisible(false);
        this.lbCanBuyPct.setVisible(false);
        this.lbCanSellPct.setVisible(false);
        this.lbBasketName.setVisible(false);
        this.lbPortfContent.setText("");
        this.radioBuy.setSelected(true);
        this.cboxDown.setSelected(false);
        this.cboxUp.setSelected(false);
        this.cboxAll.setSelected(false);
        this.spinFloat.getEditor().setText("");
        this.model.getItems().clear();
        this.btnOrder.setDisable(true);
        this.spinExeRatio.getEditor().setText("");
        this.spinExeRatio.setDisable(true);
        this.p.layout();
    }

    protected void fillInstruction(boolean isApprove) {
        this.colPrice.setEditable(true);
        this.cmbPrice.setDisable(true);
        this.lbAssetPct.setVisible(true);
        this.lbMonney.setVisible(true);
        this.lbCanBuyPct.setVisible(true);
        this.lbCanSellPct.setVisible(true);
        this.lbBasketName.setVisible(true);
        this.spinExeRatio.setDisable(false);
        this.cmbLmtPriceType.setDisable(true);
        this.lbPortfContent.setText(this.instruction.getPortfolioName());
        BasketOrderAdvice basketOrderAdvice = this.instruction.getBasketOrderAdvice();
        Basket basket = new Basket();
        basket.setId(String.valueOf(basketOrderAdvice.getBasketId()) + "_ins");
        basket.setName(basketOrderAdvice.getBasketName());
        MxNode nodePrice = MxNodeFactory.create((String)"basket_price_type", (String)basketOrderAdvice.getFixedPriceLimit());
        this.cmbLmtPriceType.getSelectionModel().select((Object)nodePrice);
        this.cmbBasket.getItems().add((Object)basket);
        this.cmbBasket.getSelectionModel().select((Object)basket);
        this.lbBasketName.setText(basketOrderAdvice.getBasketName());
        this.reSelectDirection();
        if (this.instruction.getType().getRaw().equals("13")) {
            MxNode node = MxNodeFactory.create((String)"basket_algorithm_type", (String)String.valueOf(basketOrderAdvice.getAlgoTypeBuy()));
            this.cmbAlgoBuy.getSelectionModel().select((Object)node);
            node.setRaw(String.valueOf(basketOrderAdvice.getAlgoTypeSell()));
            this.cmbAlgoSell.getSelectionModel().select((Object)node);
            this.cmbAlgoBuy.setDisable(true);
            this.cmbAlgoSell.setDisable(true);
            this.model.algoModel.getAlgoBuy().update((Object)basketOrderAdvice.getAlgoParamBuy());
            this.model.algoModel.getAlgoSell().update((Object)basketOrderAdvice.getAlgoParamSell());
            this.lbParamBuy.setText("\u5df2\u8bbe\u7f6e");
            this.lbParamSell.setText("\u5df2\u8bbe\u7f6e");
            FxUtils.makePC((Node)this.lbParamBuy, (String)"red", (boolean)false);
            FxUtils.makePC((Node)this.lbParamSell, (String)"red", (boolean)false);
            FxUtils.makePC((Node)this.lbStatusBuy, (String)"right", (!this.radioSell.isSelected() ? 1 : 0) != 0);
            FxUtils.makePC((Node)this.lbStatusSell, (String)"right", (!this.radioBuy.isSelected() ? 1 : 0) != 0);
            this.tabParam.getSelectionModel().select((Object)this.tabAlgo);
            this.tabAlgo.setDisable(false);
            this.tabNormal.setDisable(true);
            this.priceControlDisable(true);
        } else {
            this.tabParam.getSelectionModel().select((Object)this.tabNormal);
            this.tabNormal.setDisable(false);
            this.tabAlgo.setDisable(!this.instruction.isCanModify());
            if (this.instruction.isCanModify() && !isApprove) {
                if (1 == this.instruction.getBasketOrderAdvice().getSide()) {
                    this.cmbAlgoBuy.getParent().setDisable(false);
                    this.cmbAlgoBuy.setDisable(false);
                } else if (2 == this.instruction.getBasketOrderAdvice().getSide()) {
                    this.cmbAlgoSell.getParent().setDisable(false);
                    this.cmbAlgoSell.setDisable(false);
                } else {
                    this.cmbAlgoBuy.getParent().setDisable(false);
                    this.cmbAlgoBuy.setDisable(false);
                    this.cmbAlgoSell.getParent().setDisable(false);
                    this.cmbAlgoSell.setDisable(false);
                }
            } else {
                this.cmbAlgoSell.getParent().setDisable(true);
                this.cmbAlgoBuy.getParent().setDisable(true);
            }
            if (isApprove || "2".equals(basketOrderAdvice.getFixedPriceLimit())) {
                this.priceControlDisable(true);
            } else {
                this.priceControlDisable(false);
            }
        }
        this.colSellPrice.setEditable(this.isLimitPrice());
        this.colBuyPrice.setEditable(this.isLimitPrice());
        if ("12".equals(Integer.toString(basketOrderAdvice.getPriceType())) && !isApprove) {
            this.cmbPrice.setDisable(false);
            this.model.getGear().removeNode("12");
        } else {
            this.cmbPrice.getSelectionModel().select((Object)this.model.getGear().getNode(Integer.toString(basketOrderAdvice.getPriceType())));
        }
        if (basketOrderAdvice.getFloatPrice() == 0.0) {
            this.model.setPctUnit(true);
            this.lbUnit.setText("%");
            this.spinFloat.getEditor().setText(String.valueOf(basketOrderAdvice.getFloatPercent()));
        } else {
            this.model.setPctUnit(false);
            this.lbUnit.setText("\u5143");
            this.spinFloat.getEditor().setText(String.valueOf(basketOrderAdvice.getFloatPrice()));
        }
        this.model.reloadStg();
        this.cmbStg.getSelectionModel().select((Object)this.model.getStg().getNode(Integer.toString(basketOrderAdvice.getStrategyType())));
        if ("1".equals(String.valueOf(this.instruction.getBasketOrderAdvice().getStrategyType()))) {
            this.txtCount.setText(String.valueOf(basketOrderAdvice.getStrategyValue()));
        } else if ("6".equals(String.valueOf(this.instruction.getBasketOrderAdvice().getStrategyType()))) {
            this.txtCountForAdj.setText(String.valueOf(basketOrderAdvice.getStrategyValue()));
        }
        this.btnOrder.setDisable(false);
        this.hideAndShow();
        try {
            this.model.fillBasketTradeItems(this.instruction, isApprove);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u56de\u586b\u6210\u5206\u80a1\u4fe1\u606f\u5931\u8d25");
            logger.error(String.valueOf(this.instruction.getId()) + "\u56de\u586b\u6210\u5206\u80a1\u4fe1\u606f\u5931\u8d25:", (Throwable)e);
        }
        Platform.runLater(() -> this.tableItems.refresh());
    }

    private void reSelectDirection() {
        switch (this.instruction.getBasketOrderAdvice().getSide()) {
            case 1: {
                this.radioBuy.setSelected(true);
                break;
            }
            case 2: {
                this.radioSell.setSelected(true);
                break;
            }
            case 3: {
                this.radioBuySell.setSelected(true);
                break;
            }
        }
    }

    private boolean isLimitPrice() {
        MxNode selectedItem = (MxNode)this.cmbLmtPriceType.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return false;
        }
        return "4".equals(selectedItem.getRaw()) || "1".equals(selectedItem.getRaw()) || "5".equals(selectedItem.getRaw());
    }

    private boolean isUnLimitPrice() {
        MxNode selectedItem = (MxNode)this.cmbLmtPriceType.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return false;
        }
        return "3".equals(selectedItem.getRaw());
    }

    private boolean isFixedPrice() {
        MxNode selectedItem = (MxNode)this.cmbLmtPriceType.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return false;
        }
        return "2".equals(selectedItem.getRaw());
    }

    private void priceControlDisable(boolean disable) {
        this.spinFloat.setDisable(disable);
        this.lbUnit.setDisable(disable);
        this.cmbPrice.setDisable(disable);
    }

    public ObservableList<CcsFundAccount> getListAccount() {
        return this.listAccount;
    }

    public void setListAccount(ObservableList<CcsFundAccount> listAccount) {
        this.listAccount = listAccount;
    }

    public MxAlert getAlert() {
        return this.alert;
    }

    public void setAlert(MxAlert alert) {
        this.alert = alert;
    }

    public BasketInfo getBi() {
        return this.bi;
    }

    public String getAccntSizeTip() {
        return this.accntSizeTip;
    }

    public void setAccntSizeTip(String accntSizeTip) {
        this.accntSizeTip = accntSizeTip;
    }

    public void setModel(InstructionPortfBsktMailTradeModel model) {
        this.model = model;
    }

    public void setBi(BasketInfo bi) {
        this.bi = bi;
    }

    public void setBuySimbol(String buySimbol) {
        this.buySimbol = buySimbol;
    }

    public void setSellSimbol(String sellSimbol) {
        this.sellSimbol = sellSimbol;
    }

    public String getBuySimbol() {
        return this.buySimbol;
    }

    public String getSellSimbol() {
        return this.sellSimbol;
    }

    public String getBsSimbol() {
        return this.bsSimbol;
    }

    public void setBsSimbol(String bsSimbol) {
        this.bsSimbol = bsSimbol;
    }

    public String getConfirmSimbol() {
        return this.confirmSimbol;
    }

    public void setConfirmSimbol(String confirmSimbol) {
        this.confirmSimbol = confirmSimbol;
    }

    protected class BasketCheckBoxCell
    extends TableCell<BasketTradeItem, Boolean> {
        protected BasketCheckBoxCell() {
        }

        public void updateItem(Boolean bFlag, boolean empty) {
            if (!empty) {
                CheckBox checkBox = new CheckBox();
                BasketTradeItem item = (BasketTradeItem)BasketTradeItem.class.cast(this.getTableRow().getItem());
                if (item != null) {
                    checkBox.selectedProperty().bindBidirectional((Property)item.selectedProperty());
                    checkBox.disableProperty().bindBidirectional((Property)item.disabledProperty());
                    checkBox.setOnMouseClicked(event -> item.setManuallySelected(item.isSelected()));
                }
                this.setGraphic((Node)checkBox);
            } else {
                this.setGraphic(null);
            }
        }
    }

    private class EditPriceCell
    extends EditTableCell<BasketTradeItem> {
        int scale = 3;

        private EditPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null || item.doubleValue() < 0.0) {
                    return;
                }
                if (item.doubleValue() == 0.0) {
                    this.setText("");
                    return;
                }
                BasketTradeItem bskItem = (BasketTradeItem)BasketTradeItem.class.cast(this.getTableRow().getItem());
                RefItem refItem = InstructionPortfBsktMailBasePart.this.refMng.getItem(bskItem.getItem().getSecurityType(), bskItem.getItem().getMarket().getRaw(), bskItem.getItem().getSecurityId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setNum(this.scale);
                this.setFormat("%1$,." + this.scale + "f");
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }

        public void commitEdit(Number newValue) {
            super.commitEdit(newValue);
            BasketTradeItem bskItem = (BasketTradeItem)BasketTradeItem.class.cast(this.getTableRow().getItem());
            bskItem.setManualModify(true);
            double newPrice = newValue.doubleValue();
            if (bskItem.getUpperLimitPrice() > 0.0 || bskItem.getLowerLimitPrice() > 0.0) {
                if (bskItem.getBsTrade().getRaw().equals("49")) {
                    bskItem.setBuyPrice(newPrice > bskItem.getUpperLimitPrice() ? bskItem.getUpperLimitPrice() : newPrice);
                } else {
                    bskItem.setSellPrice(newPrice < bskItem.getLowerLimitPrice() ? bskItem.getLowerLimitPrice() : newPrice);
                }
            }
        }

        public void startEdit() {
            super.startEdit();
            BasketTradeItem bskItem = (BasketTradeItem)BasketTradeItem.class.cast(this.getTableRow().getItem());
            bskItem.setManualModify(true);
        }
    }

    protected class ItemCountCell
    extends TableCell<BasketTradeItem, Number> {
        protected boolean isBuy = true;

        ItemCountCell(boolean isBuy) {
            this.isBuy = isBuy;
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            BasketTradeItem item = (BasketTradeItem)BasketTradeItem.class.cast(this.getTableRow().getItem());
            if (item != null && this.isBuy && !item.getBsTrade().getRaw().equals("49")) {
                this.setText(null);
                return;
            }
            if (item != null && !this.isBuy && item.getBsTrade().getRaw().equals("49")) {
                this.setText(null);
                return;
            }
            this.setText(StringUtils.toThousands((String)value.toString()));
        }
    }

    protected class ItemFloatCell
    extends TableCell<BasketTradeItem, Number> {
        protected int scale = 0;
        protected boolean isPercent = false;
        protected Label label = new Label();

        ItemFloatCell(int i, boolean isPercent) {
            this.scale = i;
            this.isPercent = isPercent;
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty || value.doubleValue() == 0.0) {
                this.setGraphic(null);
                return;
            }
            String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)this.scale);
            this.label.setText(this.isPercent ? String.valueOf(text) + "%" : text);
            CssUtils.checkPct((Control)this.label, (double)value.doubleValue());
            this.setGraphic((Node)this.label);
        }
    }

    protected class ItemStateCell
    extends TableCell<BasketTradeItem, String> {
        private Label label = new Label();
        private static final String SEC_LIMIT_UP_STR = "\u6da8\u505c";
        private static final String SEC_LIMIT_DOWN_STR = "\u8dcc\u505c";

        public ItemStateCell() {
            CssUtils.priceTag((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty || value == null) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            if (value.equals(SEC_LIMIT_UP_STR)) {
                CssUtils.makeRise((Control)this.label);
            } else if (value.equals(SEC_LIMIT_DOWN_STR)) {
                CssUtils.makeFall((Control)this.label);
            } else {
                CssUtils.makeEven((Control)this.label);
            }
            this.setGraphic((Node)this.label);
        }
    }
}

