/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio.basket.mail;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.viewers.portfolio.basket.mail.InstructionPortfBsktInfoMailApprove;
import cms.tmx.instructions.viewers.portfolio.basket.mail.InstructionPortfBsktMailApproveModel;
import cms.tmx.instructions.viewers.portfolio.basket.mail.InstructionPortfBsktMailBasePart;
import cms.tmx.utils.StringUtils;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionPortfBsktMailApprovePart
extends InstructionPortfBsktMailBasePart {
    @Inject
    private InstructionPortfBsktMailApproveModel model;
    @Inject
    private InstructionPortfBsktInfoMailApprove bi;
    protected MEvent instructEvent = new MEvent();
    protected boolean isInstructionEvent = false;
    protected boolean initFinished = false;
    protected MEventHandler hSetCodeApp = event -> {
        this.instructEvent = event;
        if (this.instructEvent.get((Object)"instruction") == null || !(this.instructEvent.get((Object)"instruction") instanceof Instruction)) {
            return;
        }
        Instruction ins = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };

    @PostConstruct
    public void init() {
        super.init();
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @PreDestroy
    private void dispose() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    @FXML
    public void initialize() {
        this.bi.setMail(true);
        this.initPortfAccntModel();
        this.setBuySimbol("\u90ae\u4ef6\u6307\u4ee4\u5ba1\u6279\u901a\u8fc7");
        this.setSellSimbol("\u90ae\u4ef6\u6307\u4ee4\u5ba1\u6279\u901a\u8fc7");
        this.setBsSimbol("\u90ae\u4ef6\u6307\u4ee4\u5ba1\u6279\u901a\u8fc7");
        this.setConfirmSimbol("\u90ae\u4ef6\u6307\u4ee4\u5ba1\u6279\u786e\u8ba4");
        this.setBi(this.bi);
        this.setModel(this.model);
        this.onApprove(true);
        super.initialize();
        this.initFinished = true;
        this.doFill();
    }

    @Override
    protected BasketSubmitResult doAction() throws MException {
        return this.model.submitApprove(this.instruction);
    }

    @Override
    protected void showPart() {
        this.clearFill();
        this.uiService.showPart("cms.tmx.instructions.part.portfolio.instruct.mail.query");
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished || this.instruction == null) {
                return;
            }
            try {
                if (StringUtils.belongto((String)this.instruction.getType().getRaw(), (String[])new String[]{"5", "13"})) {
                    this.fillInstruction(true);
                }
            }
            catch (Exception e) {
                logger.error("\u7bee\u5b50\u586b\u5355\u51fa\u9519", (Throwable)e);
            }
        });
    }

    private void initPortfAccntModel() {
        this.model.setInstructionPanelType("3");
        this.instDistModel.setInstructType("3");
        try {
            this.instDistModel.create();
        }
        catch (MException e) {
            logger.error("\u521b\u5efa\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u521b\u5efa\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25");
        }
    }

    private boolean validOrderFill(Instruction ins) {
        return StringUtils.belongto((String)ins.getType().getRaw(), (String[])new String[]{"5", "13"}) && !ins.getIsOrderStep() && ins.isMail();
    }
}

