/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio.basket;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.instructions.models.portfolio.basket.InstructionPortfBasketAccSetModel;
import cms.tmx.portfolio.uitls.AccCollapseCell;
import cms.tmx.portfolio.uitls.PortfoCollapseCell;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructionPortfBsktAccSetDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(InstructionPortfBsktAccSetDialog.class);
    private static final PseudoClass PCMX_SELECTED = PseudoClass.getPseudoClass((String)"mselected");
    @Inject
    private InstructionPortfBasketAccSetModel portfBsktAccSecModel;
    private List<Portfolio> portfolioList = new ArrayList<Portfolio>();
    @FXML
    protected TreeTableView<PortfolioAccountDistribution> portfBasketAcctTreeTable;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Portfolio> portfolioCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, SecAccount> secAcctCol;
    private TreeItem<PortfolioAccountDistribution> root;
    @Inject
    private MxAlert alert;
    private String instructType;

    @FXML
    public void initialize() {
    }

    private void createTree() {
        this.root = this.portfBsktAccSecModel.getRoot();
        this.portfBasketAcctTreeTable.setRoot(this.root);
        this.portfBasketAcctTreeTable.setShowRoot(false);
        this.portfBasketAcctTreeTable.setPlaceholder((Node)new Label());
        this.checkBoxCol.setCellFactory(p -> new PortfolioBasketCheckBoxCell());
        this.portfolioCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).portfolioProperty());
        this.portfolioCol.setCellFactory(p -> new PortfoCollapseCell(this.portfBsktAccSecModel.getPortfDistModel().isSingle()));
        this.accountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccCollapseCell(this.portfBsktAccSecModel.getPortfDistModel().isSingle()));
        this.secAcctCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).secAccProperty());
        TreeItem root = new TreeItem();
        root.setExpanded(true);
    }

    public InstructionPortfBasketAccSetModel getPortfolioBasketAccSetModel() {
        return this.portfBsktAccSecModel;
    }

    protected boolean isOK(ButtonType bt) {
        this.getPortfolioBasketAccSetModel().clearSelect();
        this.getSelectedPortfolio().clear();
        for (TreeItem portfItem : this.root.getChildren()) {
            if (!((PortfolioAccountDistribution)portfItem.getValue()).isSelected()) continue;
            this.getSelectedPortfolio().add(((PortfolioAccountDistribution)portfItem.getValue()).getPortfolio());
            int accCount = 0;
            for (TreeItem accItem : portfItem.getChildren()) {
                if (!((PortfolioAccountDistribution)accItem.getValue()).isSelected()) continue;
                ++accCount;
                boolean hasXshg = false;
                boolean hasXshe = false;
                int xshgSelected = 0;
                int xsheSelected = 0;
                for (TreeItem secItem : accItem.getChildren()) {
                    if ("XSHG".equals(((PortfolioAccountDistribution)secItem.getValue()).getSecAcc().getExchange().getRaw())) {
                        hasXshg = true;
                        if (!((PortfolioAccountDistribution)secItem.getValue()).isSelected()) continue;
                        ++xshgSelected;
                        continue;
                    }
                    if (!"XSHE".equals(((PortfolioAccountDistribution)secItem.getValue()).getSecAcc().getExchange().getRaw())) continue;
                    hasXshe = true;
                    if (!((PortfolioAccountDistribution)secItem.getValue()).isSelected()) continue;
                    ++xsheSelected;
                }
                if (hasXshg && xshgSelected < 1) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u8d44\u91d1\u8d26\u53f7" + ((PortfolioAccountDistribution)accItem.getValue()).getAcc().getInvestId() + "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6caa\u5e02\u8bc1\u5238\u8d26\u53f7\uff01");
                    return false;
                }
                if (!hasXshe || xsheSelected >= true) continue;
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u8d44\u91d1\u8d26\u53f7" + ((PortfolioAccountDistribution)accItem.getValue()).getAcc().getInvestId() + "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6df1\u5e02\u8bc1\u5238\u8d26\u53f7\uff01");
                return false;
            }
            if (accCount >= true) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u6295\u7ec4" + ((PortfolioAccountDistribution)portfItem.getValue()).getPortfolio().getName() + "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff01");
            return false;
        }
        return true;
    }

    public void create() {
        try {
            LinkedList<Portfolio> list = new LinkedList<Portfolio>(this.getPortfolioList());
            this.portfBsktAccSecModel.setPortfolioList(list);
            this.portfBsktAccSecModel.setInstructType(this.instructType);
            this.portfBsktAccSecModel.createTree();
        }
        catch (MException e) {
            logger.error("\u521d\u59cb\u5316\u7bee\u5b50\u6295\u7ec4\u8d26\u53f7\u9009\u62e9\u5931\u8d25", (Throwable)e);
        }
        this.createTree();
    }

    public List<Portfolio> getPortfolioList() {
        return this.portfolioList;
    }

    public void setPortfolioList(List<Portfolio> portfolioList) {
        this.portfolioList = portfolioList;
    }

    public List<Portfolio> getSelectedPortfolio() {
        return this.portfBsktAccSecModel.getSelectedPortfolioList();
    }

    public String getInstructType() {
        return this.instructType;
    }

    public void setInstructType(String instructType) {
        this.instructType = instructType;
    }

    private class PortfolioBasketCheckBoxCell<T>
    extends TreeTableCell<PortfolioAccountDistribution, Boolean> {
        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(PCMX_SELECTED, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    if (treeItem.isLeaf()) {
                        this.disableProperty().bind((ObservableValue)((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((PortfolioAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                treeItem.getParent().getChildren().forEach(each -> {
                                    if (!each.equals(treeItem) && ((PortfolioAccountDistribution)each.getValue()).getSecAcc().getExchange().getRaw().equals(((PortfolioAccountDistribution)treeItem.getValue()).getSecAcc().getExchange().getRaw())) {
                                        ((PortfolioAccountDistribution)each.getValue()).setSelected(false);
                                    }
                                });
                            }
                            this.getTreeTableView().refresh();
                        });
                    } else {
                        if (treeItem.getParent().getParent() != null) {
                            checkBox.selectedProperty().addListener((ob, old, newV) -> {
                                if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null && !((PortfolioAccountDistribution)treeItem.getParent().getValue()).isSelected()) {
                                    ((PortfolioAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                }
                                this.getTreeTableView().refresh();
                            });
                            checkBox.setOnMouseClicked(event -> {
                                if (((PortfolioAccountDistribution)treeItem.getValue()).isSelected()) {
                                    this.checkDefaultSec((TreeItem<PortfolioAccountDistribution>)treeItem);
                                    ((PortfolioAccountDistribution)treeItem.getParent().getValue()).setSelected(true);
                                } else {
                                    treeItem.getChildren().forEach(accItem -> ((PortfolioAccountDistribution)accItem.getValue()).setSelected(false));
                                }
                            });
                            treeItem.expandedProperty().addListener((ob, old, newV) -> this.getTreeTableView().refresh());
                        } else {
                            checkBox.selectedProperty().addListener((ob, old, newV) -> {
                                if (newV.booleanValue()) {
                                    this.getTreeTableView().refresh();
                                }
                            });
                            treeItem.expandedProperty().addListener((ob, old, newV) -> this.getTreeTableView().refresh());
                            checkBox.setOnMouseClicked(event -> {
                                if (((PortfolioAccountDistribution)treeItem.getValue()).isSelected()) {
                                    TreeItem accItem2 = (TreeItem)treeItem.getChildren().get(0);
                                    ((PortfolioAccountDistribution)accItem2.getValue()).setSelected(true);
                                    this.checkDefaultSec((TreeItem<PortfolioAccountDistribution>)accItem2);
                                } else {
                                    treeItem.getChildren().forEach(accItem -> {
                                        ((PortfolioAccountDistribution)accItem.getValue()).setSelected(false);
                                        accItem.getChildren().forEach(secItem -> ((PortfolioAccountDistribution)secItem.getValue()).setSelected(false));
                                    });
                                }
                            });
                        }
                        treeItem.expandedProperty().addListener((ob, old, newV) -> this.getTreeTableView().refresh());
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }

        private void checkDefaultSec(TreeItem<PortfolioAccountDistribution> treeItem) {
            boolean xshg = true;
            boolean xshe = true;
            for (TreeItem cadItem : treeItem.getChildren()) {
                ((PortfolioAccountDistribution)cadItem.getValue()).setSelected(false);
                if (!((PortfolioAccountDistribution)treeItem.getValue()).isSelected()) continue;
                if (xshg && "XSHG".equals(((PortfolioAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) {
                    ((PortfolioAccountDistribution)cadItem.getValue()).setSelected(true);
                    xshg = false;
                }
                if (!xshe || !"XSHE".equals(((PortfolioAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) continue;
                ((PortfolioAccountDistribution)cadItem.getValue()).setSelected(true);
                xshe = false;
            }
        }
    }
}

