/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.instructions.viewers.portfolio.InstructionPortfolioBasePart;
import cms.tmx.instructions.viewers.portfolio.LoadPartModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.portfolio.AlgoFuncControl;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javax.inject.Inject;

public class InstructionPortfolioPassivePart
extends InstructionPortfolioBasePart {
    @FXML
    private StackPane stkPaneCommon;
    @FXML
    private HBox hboxCanBS;
    protected OrderAdvice advice;
    protected AlgoParam algoAdvice;
    protected Instruction instruction;
    protected MEvent instructEvent = new MEvent();
    protected boolean isInstructionEvent = false;
    private boolean inApprove = false;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    protected AlgoFuncControl algoFunc;
    @FXML
    private Label lbUpDownPrice;
    @Inject
    private LoadPartModel load;
    protected MEventHandler hSetCode = event -> Platform.runLater(() -> {
        this.instructEvent = event;
        if (this.instructEvent.get((Object)"instruction") == null || !(this.instructEvent.get((Object)"instruction") instanceof Instruction)) {
            return;
        }
        if (!this.validOrderFill()) {
            return;
        }
        this.algoNode.instruction = this.instruction = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        this.doSetCode();
    });
    protected boolean initFinished = false;
    protected ChangeListener<Boolean> lstnFocusPrice = (ob, old, newV) -> {
        if (this.advice == null) {
            return;
        }
        if (this.model.isUpLimit() && !newV.booleanValue() && this.model.getPrice() > this.advice.getPrice()) {
            this.model.setPrice(this.advice.getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
        if (this.model.isDownLimit() && !newV.booleanValue() && this.model.getPrice() < this.advice.getPrice()) {
            this.model.setPrice(this.advice.getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    };
    protected ChangeListener<Boolean> lstnFocusQuantity = (ob, old, newV) -> {
        if (this.advice == null) {
            return;
        }
        if (newV.booleanValue()) {
            return;
        }
        this.modifyQuantity();
    };

    public boolean isInApprove() {
        return this.inApprove;
    }

    public void setInApprove(boolean inApprove) {
        this.inApprove = inApprove;
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Inject
    public InstructionPortfolioPassivePart() {
    }

    @Override
    @FXML
    public void initialize() {
        this.protectedPriceSpn.setDisable(true);
        this.hboxCanBS.setVisible(false);
        this.lbUpDownPrice.setVisible(false);
        super.initialize();
        this.buyRadio.setDisable(true);
        this.sellRadio.setDisable(true);
        this.cmbPriceType.setDisable(true);
        this.cmbPriceTypeAfterHours.setDisable(true);
        this.cmbPriceTypeLimited.setDisable(true);
        this.lbUpDownPrice.setDisable(true);
        this.cmbPriceTypeMkt.setDisable(true);
        this.cmbPriceTypeBidAsk.setDisable(true);
        this.countStg.setDisable(true);
        this.stkPaneCommon.setDisable(true);
        this.tabNormal.setDisable(false);
        this.tabAlgo.setDisable(false);
        this.priceSpn.getEditor().focusedProperty().addListener(this.lstnFocusPrice);
        this.quantitySpn.getEditor().focusedProperty().addListener(this.lstnFocusQuantity);
        this.initFinished = true;
        Platform.runLater(() -> this.doSetCode());
    }

    protected void doSetCode() {
        if (!this.initFinished || this.instruction == null) {
            return;
        }
        this.initPanel();
        if (this.instruction.getType().getRaw().equals("3")) {
            Algorithm old;
            this.tabNormal.getTabPane().getSelectionModel().select((Object)this.tabNormal);
            this.advice = this.instruction.getOrderAdvice();
            this.model.setInstruction(this.instruction);
            if (this.advice == null) {
                return;
            }
            if (this.instruction.getIsOrderStep()) {
                this.stkPaneCommon.setDisable(false);
            }
            RefItem refItem = this.refMng.getItem(this.advice.getSecType(), this.advice.getMarket(), this.advice.getSec());
            this.txtCode.setUserData((Object)refItem);
            this.algoNode.txtCode.setUserData((Object)refItem);
            if (this.instruction.isCanModify() && (old = (Algorithm)this.algoNode.cmbAlgo.getSelectionModel().getSelectedItem()) != null) {
                this.algoNode.disable(old.getType(), false, false);
            }
            this.doSecurityChange(refItem, this.advice.getSec());
        } else if (this.instruction.getType().getRaw().equals("9")) {
            this.tabAlgo.getTabPane().getSelectionModel().select((Object)this.tabAlgo);
            this.algoAdvice = this.instruction.getAlgoParam();
            this.model.setInstruction(this.instruction);
            if (this.algoAdvice == null) {
                return;
            }
            RefItem refItem = this.refMng.getItem(this.algoAdvice.getType(), this.algoAdvice.getMarket(), this.algoAdvice.getCode());
            this.txtCode.setUserData((Object)refItem);
            this.algoNode.txtCode.setUserData((Object)refItem);
            this.doSecurityChange(refItem, this.algoAdvice.getCode());
        }
        this.portfolioTreeTable.refresh();
        this.layout();
    }

    private void doSecurityChange(RefItem refItem, String secCode) {
        super.doChange(refItem, secCode);
        if (this.isInstructionEvent && this.advice != null && this.getValidRef() != null && this.instruction.getType().getRaw().equals("3")) {
            this.isInstructionEvent = false;
            this.doOrderFill();
        }
        if (this.isInstructionEvent && this.algoAdvice != null && this.getValidRef() != null && this.instruction.getType().getRaw().equals("9")) {
            this.isInstructionEvent = false;
            this.doAlgoOrderFill();
        }
    }

    protected boolean validOrderFill() {
        return false;
    }

    private void doOrderFill() {
        this.lbUpDownPrice.setVisible(false);
        if (this.getValidRef() == null) {
            return;
        }
        long effectiveQuantity = this.instruction.getIsOrderStep() ? this.advice.getOrderAvailableQuantity() : this.advice.getOrderQty();
        this.quantitySpn.getEditor().setText(Long.toString(effectiveQuantity));
        this.model.getAccDisModel().fillPorfolio(this.instruction);
        this.lbUpDownPrice.setText(StringUtils.toPriceStr((double)this.advice.getPrice(), (double)this.getValidRef().getPriceUnit()));
        this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode(Integer.toString(this.advice.getOrdType())));
        if (this.advice.getSide() == 50 || this.advice.getSide() == 70) {
            this.sellRadio.setSelected(true);
        } else {
            this.buyRadio.setSelected(true);
        }
        if (this.model.getPriceTypeLimitedStg() != null && this.advice.getPriceLimit() != 0) {
            this.cmbPriceTypeLimited.getSelectionModel().select((Object)this.model.getPriceTypeLimitedStg().getNode(Integer.toString(this.advice.getPriceLimit())));
        }
        if (this.model.getPriceTypeMktStg() != null && !this.advice.getMarketPriceLimit().isEmpty()) {
            this.cmbPriceTypeMkt.getSelectionModel().select((Object)this.model.getPriceTypeMktStg().getNode(this.advice.getMarketPriceLimit()));
            this.model.setMktPrice();
        }
        if (this.model.getPriceTypeBidAskStg() != null) {
            this.cmbPriceTypeBidAsk.getSelectionModel().select((Object)this.model.getPriceTypeBidAskStg().getNode(Integer.toString(this.advice.getPriceTypeBidAsk())));
            this.model.setBidAskPrice();
        }
        if (this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            if (this.model.isSpecify()) {
                this.model.setPrice(this.advice.getPrice());
            } else {
                this.priceSpn.getEditor().clear();
            }
        }
        if (!this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            this.model.setPrice(this.advice.getPrice());
        }
        if (this.instruction.getOrderAdvice().getOrdType() == 99) {
            this.model.setPrice(this.advice.getPrice());
        }
        if (this.instruction.getSecurityCode().startsWith("688")) {
            this.model.setPriceProtected(this.advice.getProtectedLimitPrice());
        }
        if (this.model.isUpLimit()) {
            this.lbUpDownPrice.setVisible(true);
        }
        if (this.model.isDownLimit()) {
            this.lbUpDownPrice.setVisible(true);
        }
        if (this.instruction.isCanModify()) {
            ArrayList<RefItem> list;
            this.algoNode.cmbAlgo.setItems(this.getAlgoList());
            this.algoNode.cmbAlgo.getSelectionModel().select(0);
            this.algoNode.txtCode.setText(this.instruction.getOrderAdvice().getSec());
            this.algoNode.txtCode.setEditable(false);
            this.algoNode.buyRadio.setDisable(true);
            this.algoNode.sellRadio.setDisable(true);
            this.algoNode.buyRadio.setSelected(this.buyRadio.isSelected());
            this.algoNode.sellRadio.setSelected(this.sellRadio.isSelected());
            this.algoNode.spnQty.getEditor().setText(Long.toString(effectiveQuantity));
            this.algoNode.model.setCountAlgo(effectiveQuantity);
            this.algoNode.priceUpLimit = 0.0;
            this.algoNode.priceDownLimit = 0.0;
            if (this.model.isUpLimit()) {
                this.algoNode.spnPriceUp.getEditor().setText(StringUtils.toPriceStr((double)this.advice.getPrice(), (double)this.getValidRef().getPriceUnit()));
                list = new ArrayList();
                list.add(this.model.getMI().getRefItem());
                this.mktMng.query(list, new Gears());
                this.algoNode.spnPriceLow.getEditor().setText(StringUtils.toPriceStr((double)this.mktMng.getInfo((IRefItem)this.model.getMI().getRefItem()).getDownLimitPrice(), (double)this.getValidRef().getPriceUnit()));
                this.algoNode.priceUpLimit = this.advice.getPrice();
            }
            if (this.model.isDownLimit()) {
                list = new ArrayList<RefItem>();
                list.add(this.model.getMI().getRefItem());
                this.mktMng.query(list, new Gears());
                this.algoNode.spnPriceUp.getEditor().setText(StringUtils.toPriceStr((double)this.mktMng.getInfo((IRefItem)this.model.getMI().getRefItem()).getUpLimitPrice(), (double)this.getValidRef().getPriceUnit()));
                this.algoNode.spnPriceLow.getEditor().setText(StringUtils.toPriceStr((double)this.advice.getPrice(), (double)this.getValidRef().getPriceUnit()));
                this.algoNode.priceDownLimit = this.advice.getPrice();
            }
            this.checkBoxModify.setVisible(true);
            this.checkBoxModify.setSelected(true);
            this.checkBoxModify.setDisable(true);
        } else {
            this.checkBoxModify.setSelected(false);
            this.algoNode.priceUpLimit = 0.0;
            this.algoNode.priceDownLimit = 0.0;
        }
        this.algoNode.scale = this.getValidRef().getScale();
        if (this.model.isUpLimit() || this.model.isDownLimit() || this.model.isUnlimited()) {
            this.checkBoxModify.setVisible(true);
            this.checkBoxModify.setDisable(true);
        } else {
            this.checkBoxModify.setVisible(false);
        }
        this.onApprove(true);
    }

    private ObservableList<Algorithm> getAlgoList() {
        ObservableList list = FxUtils.newList();
        this.algoNode.cmbEngine.getSelectionModel().select((Object)"Apama\u5f15\u64ce");
        if (this.model.isUpLimit() || this.model.isDownLimit()) {
            List listApama = this.algoNode.getAlgos("Apama\u5f15\u64ce");
            if (!listApama.isEmpty()) {
                for (Algorithm algo : listApama) {
                    if (algo.getType() != 12 && algo.getType() != 13) continue;
                    Algorithm a = new Algorithm();
                    a.update(algo);
                    list.add((Object)a);
                }
            } else {
                this.algoNode.cmbEngine.getSelectionModel().select((Object)"Mise\u5f15\u64ce");
                List listMise = this.algoNode.getAlgos("Mise\u5f15\u64ce");
                if (!listMise.isEmpty()) {
                    for (Algorithm algo : this.algoNode.getAlgos("Mise\u5f15\u64ce")) {
                        if (algo.getType() != 19 && algo.getType() != 20) continue;
                        Algorithm a = new Algorithm();
                        a.update(algo);
                        list.add((Object)a);
                    }
                }
            }
            return list;
        }
        this.algoNode.cmbEngine.setDisable(false);
        if (this.advice.getSide() == 50 || this.advice.getSide() == 70) {
            this.algoNode.isBuy = false;
            for (Algorithm algo : this.algoNode.getAlgos("Apama\u5f15\u64ce")) {
                if (algo.getType() == 10) continue;
                Algorithm a = new Algorithm();
                a.update(algo);
                list.add((Object)a);
            }
        } else {
            this.algoNode.isBuy = true;
            for (Algorithm algo : this.algoNode.getAlgos("Apama\u5f15\u64ce")) {
                if (algo.getType() == 11) continue;
                Algorithm a = new Algorithm();
                a.update(algo);
                list.add((Object)a);
            }
        }
        return list;
    }

    private void doAlgoOrderFill() {
        if (this.getValidRef() == null) {
            return;
        }
        this.cmbDist.getSelectionModel().select(1);
        this.model.getAccDisModel().fillPorfolio(this.instruction);
        AlgoParam algo = this.instruction.getAlgoParam();
        String engine = "Apama\u5f15\u64ce";
        switch (algo.getAlgorithm().getType()) {
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                engine = "Mise\u5f15\u64ce";
            }
        }
        this.algoNode.cmbEngine.getSelectionModel().select((Object)engine);
        for (Algorithm a : this.algoFunc.getPortfolioAlgo(engine, algo.isBuy() ? Boolean.valueOf(true) : null)) {
            if (a.getType() != algo.getAlgorithm().getType()) continue;
            this.algoNode.cmbAlgo.getSelectionModel().select((Object)a);
            break;
        }
        this.algoNode.buyRadio.setSelected(algo.isBuy());
        this.algoNode.sellRadio.setSelected(!algo.isBuy());
        long effectiveQuantity = this.instruction.getIsOrderStep() ? algo.getOrderAvailableQuantity() : algo.getCount();
        this.algoNode.spnQty.getEditor().setText(String.valueOf(effectiveQuantity));
        this.algoNode.priceUpLimit = 0.0;
        this.algoNode.priceDownLimit = 0.0;
        RefItem item = this.refMng.getItem(algo.getType(), algo.getMarket(), algo.getCode());
        int scale = item == null ? 3 : item.getScale();
        switch (algo.getAlgorithm().getType()) {
            case 7: {
                this.algoNode.spnPriceUp.getEditor().setText(StringUtils.toStr((double)this.instruction.getAlgoParam().getPriceUp(), (int)scale));
                this.algoNode.spnPriceLow.getEditor().setText(StringUtils.toStr((double)this.instruction.getAlgoParam().getPriceLow(), (int)scale));
                this.algoNode.cmbDepth.getSelectionModel().select((Object)this.algoNode.nodeDepth.getNode(String.valueOf(this.instruction.getAlgoParam().getDepth())));
                this.algoNode.cmbTimeSlice.getSelectionModel().select((Object)this.algoNode.nodeInterval.getNode(String.valueOf(this.instruction.getAlgoParam().getSlice())));
                break;
            }
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                this.algoNode.txtStartHour.setText(String.valueOf(this.instruction.getAlgoParam().getStartHour()));
                this.algoNode.txtStartMinute.setText(String.valueOf(this.instruction.getAlgoParam().getStartMinute()));
                this.algoNode.txtEndHour.setText(String.valueOf(this.instruction.getAlgoParam().getEndHour()));
                this.algoNode.txtEndMinute.setText(String.valueOf(this.instruction.getAlgoParam().getEndMinute()));
                this.algoNode.cmbAggress.getSelectionModel().select((Object)this.algoNode.nodeAggress.getNode(String.valueOf(this.instruction.getAlgoParam().getAggress())));
                this.sliceCheck(this.algoNode.txtStartHour);
                this.sliceCheck(this.algoNode.txtStartMinute);
                this.sliceCheck(this.algoNode.txtEndHour);
                this.sliceCheck(this.algoNode.txtEndMinute);
                this.algoNode.spnTimeSlice.getEditor().setText(String.valueOf(this.instruction.getAlgoParam().getSlice()));
                break;
            }
            case 10: 
            case 11: {
                this.algoNode.cmbDepth.getSelectionModel().select((Object)this.algoNode.nodeDepth.getNode(String.valueOf(this.instruction.getAlgoParam().getDepth())));
                this.algoNode.txtPercent.setText(String.valueOf((int)(100.0 * this.instruction.getAlgoParam().getPercentDepth())));
                this.algoNode.txtDelay.setText(String.valueOf(this.instruction.getAlgoParam().getDelay()));
                if (String.valueOf(this.instruction.getAlgoParam().getBasePrice()).equals("0")) {
                    double price = algo.getPriceMost();
                    this.algoNode.spnPriceMost.getEditor().setText(StringUtils.toStr((double)price, (int)scale));
                    break;
                }
                this.algoNode.cboxRise.setSelected(true);
                if (algo.getPercentRise() == 1.0) {
                    this.algoNode.txtRise.setText("100");
                } else {
                    this.algoNode.txtRise.setText(String.format("%1$,.2f", algo.getPercentRise() * 100.0));
                }
                this.algoNode.cmbPriceBase.getSelectionModel().select((Object)((MxNode)this.algoNode.cmbPriceBase.getValue()).getNode(String.valueOf(this.instruction.getAlgoParam().getBasePrice())));
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 20: {
                this.algoNode.spnPriceUp.getEditor().setText(StringUtils.toStr((double)this.instruction.getAlgoParam().getPriceUp(), (int)scale));
                this.algoNode.spnPriceLow.getEditor().setText(StringUtils.toStr((double)this.instruction.getAlgoParam().getPriceLow(), (int)scale));
                this.algoNode.txtStartHour.setText(String.valueOf(this.instruction.getAlgoParam().getStartHour()));
                this.algoNode.txtStartMinute.setText(String.valueOf(this.instruction.getAlgoParam().getStartMinute()));
                this.algoNode.txtEndHour.setText(String.valueOf(this.instruction.getAlgoParam().getEndHour()));
                this.algoNode.txtEndMinute.setText(String.valueOf(this.instruction.getAlgoParam().getEndMinute()));
                this.algoNode.cmbAggress.getSelectionModel().select((Object)this.algoNode.nodeAggress.getNode(String.valueOf(this.instruction.getAlgoParam().getAggress())));
                this.sliceCheck(this.algoNode.txtStartHour);
                this.sliceCheck(this.algoNode.txtStartMinute);
                this.sliceCheck(this.algoNode.txtEndHour);
                this.sliceCheck(this.algoNode.txtEndMinute);
                this.algoNode.spnTimeSlice.getEditor().setText(String.valueOf(this.instruction.getAlgoParam().getSlice()));
            }
        }
        this.disable(true);
    }

    protected void sliceCheck(TextField tf) {
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    protected void disable(boolean disable) {
        this.algoNode.disable(this.instruction.getAlgoParam().getAlgorithm().getType(), disable, true);
    }

    @Override
    @FXML
    public void order() {
        super.order();
    }

    private void clearPanel() {
        this.setInApprove(false);
        this.advice = null;
        this.instruction = null;
        this.algoNode.instruction = null;
        this.lbUpDownPrice.setVisible(false);
        this.txtCode.requestFocus();
        this.txtCode.clear();
        this.onSecurityChange(this.txtCode, "");
        this.buyRadio.setSelected(true);
        this.cmbPriceType.getSelectionModel().select(0);
        this.cmbPriceTypeLimited.getSelectionModel().select(0);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.model.getAccDisModel().removeTree();
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new Instruction());
        this.onApprove(false);
        this.model.getAccDisModel().setActive(true);
        this.tabNormal.setDisable(false);
        this.tabAlgo.setDisable(false);
        this.stkPaneCommon.setDisable(true);
    }

    private void initPanel() {
        this.setInApprove(true);
        this.isInstructionEvent = true;
        this.lbUpDownPrice.setVisible(false);
        this.txtCode.clear();
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new Instruction());
        this.onApprove(true);
        this.model.getAccDisModel().setActive(false);
        this.buyRadio.setSelected(true);
        this.tabNormal.setDisable(false);
        this.tabAlgo.setDisable(false);
        this.stkPaneCommon.setDisable(true);
    }

    protected void onApprove(boolean disable) {
        this.txtCode.setEditable(!disable);
    }

    @Override
    protected void submitOrder() {
        super.submitOrder();
        if ("3".equals(this.model.getAccDisModel().getInstructType())) {
            this.clearPanel();
        } else if (this.preModel.isClearAfterOrder()) {
            this.clearCountCheck();
            this.updateInstruction(false);
        } else {
            this.updateInstruction(true);
        }
    }

    private void updateInstruction(final boolean updateCount) {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    try {
                        InstructionPortfolioPassivePart.this.model.getInstructionModel().refreshResource(InstructionPortfolioPassivePart.this.instruction);
                    }
                    catch (MException mException) {
                        InstructionPortfolioPassivePart.this.alert.alert(Alert.AlertType.ERROR, "\u81ea\u52a8\u586b\u5165\u5269\u4f59\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u624b\u52a8\u518d\u6b21\u6267\u884c\u586b\u5355");
                    }
                    if (InstructionPortfolioPassivePart.this.instruction.getResource().getAvailOrderQty() <= 0L) {
                        InstructionPortfolioPassivePart.this.clearCountCheckForce();
                        return;
                    }
                    InstructionPortfolioPassivePart.this.model.getAccDisModel().fillPorfolio(InstructionPortfolioPassivePart.this.instruction);
                    InstructionPortfolioPassivePart.this.advice = InstructionPortfolioPassivePart.this.instruction.getOrderAdvice();
                    InstructionPortfolioPassivePart.this.model.onSecChange();
                    if (updateCount) {
                        InstructionPortfolioPassivePart.this.quantitySpn.getEditor().setText(StringUtils.toStr((double)InstructionPortfolioPassivePart.this.instruction.getResource().getAvailOrderQty(), (int)0));
                    }
                });
            }
        };
        timer.schedule(task, 1000L);
    }

    @Override
    public boolean valid() {
        String tip1 = "\u8bf7\u4ece\u6307\u4ee4\u5217\u8868\u4e2d\u586b\u5165\u6307\u4ee4";
        if (!this.alert.check(this.isInApprove(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        return super.valid();
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() && !this.model.isAfterHoursPrice() || this.model.isUnlimited() || this.model.isSpecify() || this.model.getAccDisModel().isActive(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty(), this.model.getAccDisModel().activeProperty()}));
    }

    @Override
    protected void quantityDisableBind() {
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1") || this.model.getAccDisModel().isActive(), (Observable[])new Observable[]{this.model.countStgProperty(), this.model.getAccDisModel().activeProperty()}));
    }

    @Override
    public void setPrice(double price) {
        if ((this.model.isLimitPrice() || this.model.isAfterHoursPrice()) && price > 0.0 && !this.model.isUnlimited() && !this.priceSpn.isDisabled()) {
            this.priceSpn.getValueFactory().setValue((Object)price);
        }
    }

    @Override
    protected void checkRepo() {
    }

    @Override
    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.modifyQuantity();
            this.order();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    private void modifyQuantity() {
        long effectiveQuantity;
        long l = effectiveQuantity = this.instruction.getIsOrderStep() ? this.advice.getOrderAvailableQuantity() : this.advice.getOrderQty();
        if (this.model.getCount() > effectiveQuantity) {
            this.model.setCount(effectiveQuantity);
            this.quantitySpn.getEditor().requestFocus();
            this.quantitySpn.getEditor().selectAll();
        }
    }

    protected boolean isMail(Instruction ins) {
        return ins.getDescId() == WorkflowTemplete.MAIL.getId();
    }
}

