/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio;

import cms.tmx.core.MException;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.instructions.viewers.portfolio.InstructionPortfolioBasePart;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.utils.StringUtils;
import cn.hutool.core.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javax.inject.Inject;

public class InstructionPortfolioMailInstructPart
extends InstructionPortfolioBasePart {
    @Inject
    public InstructionPortfolioMailInstructPart() {
    }

    @Override
    @FXML
    public void initialize() {
        this.checkBoxModify.setVisible(false);
        this.portfolioTreeTable.getColumns().remove((Object)this.canBuyCol);
        this.portfolioTreeTable.getColumns().remove((Object)this.canSellCol);
        this.portfolioTreeTable.getColumns().remove((Object)this.assetCol);
        this.model.getAccDisModel().setMail(true);
        this.model.create("1");
        TabPane tabPane = this.tabNormal.getTabPane();
        tabPane.getTabs().remove((Object)this.tabAlgo);
        this.algoNode.instructionType = "1";
        this.setBuySymbol("\u4e0b\u8fbe\u90ae\u4ef6\u6307\u4ee4");
        this.setSellSymbol("\u4e0b\u8fbe\u90ae\u4ef6\u6307\u4ee4");
        this.setDialogSymbol("\u4e0b\u8fbe\u90ae\u4ef6\u6307\u4ee4\u786e\u8ba4");
        super.initialize();
        this.availableCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).isPortDist() ? ((PortfolioAccountDistribution)data.getValue().getValue()).getPortfolio().extAvailableProperty() : new SimpleDoubleProperty(0.0));
        this.mktItem.changedProperty().addListener(ob -> this.setPrePrice());
        this.checkBoxModify.setSelected(true);
        this.checkBoxModify.setVisible(false);
        this.refresh();
    }

    @Override
    protected void onBSChange(Boolean now) {
        if (now.booleanValue()) {
            if (this.model.getValidRef() == null || !"REPO".equals(this.model.getValidRef().getType())) {
                this.lbCan.setText("\u53ef\u4e70");
            }
            this.btnOrder.setText(this.getBuySymbol());
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.model.getAccDisModel().setShowCanBuy(true);
        } else {
            this.btnOrder.setText(this.getSellSymbol());
            this.lbCan.setText("");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.model.getAccDisModel().setShowCanBuy(false);
        }
        this.model.setBuy(now);
        if (((Algorithm)this.algoNode.cmbAlgo.getSelectionModel().getSelectedItem()).getType() != 10 && ((Algorithm)this.algoNode.cmbAlgo.getSelectionModel().getSelectedItem()).getType() != 11) {
            this.algoNode.buyRadio.setSelected(now.booleanValue());
            this.algoNode.sellRadio.setSelected(now == false);
        }
        this.layout();
    }

    @Override
    protected void submitOrder() {
        try {
            List<OrderAdvice> orderAdvices = this.model.getOrderAdvice();
            if (!this.model.isBuy()) {
                ArrayList<String> portfolioIds = new ArrayList<String>();
                ArrayList checkRes = new ArrayList();
                for (OrderAdvice advice : orderAdvices) {
                    portfolioIds.add(advice.getPortfolioId());
                    ArrayList<PInstructionManagement.CheckItem> items = new ArrayList<PInstructionManagement.CheckItem>();
                    List accSecInfoList = advice.getAccSecInfoList();
                    for (AccntSecInfo accSecInfo : accSecInfoList) {
                        PInstructionManagement.CheckItem.Builder newBuilder = PInstructionManagement.CheckItem.newBuilder();
                        newBuilder.setMarket(accSecInfo.getMarket());
                        newBuilder.setOrderQty((double)accSecInfo.getOrderQty());
                        newBuilder.setSecurityId(advice.getSec());
                        newBuilder.setSecurityType(advice.getSecType());
                        newBuilder.setSubSecAccntId(accSecInfo.getSecAccntId());
                        items.add(newBuilder.build());
                    }
                    checkRes.addAll(this.model.getInstructionModel().checkAvalidPosition(advice.getPortfolioId(), "", "", items));
                }
                if (!CollectionUtil.isEmpty(checkRes)) {
                    StringBuilder sb;
                    boolean permitOrder = true;
                    for (String portfolioId : portfolioIds) {
                        if (!permitOrder) continue;
                        permitOrder = this.model.getInstructionModel().permitOrder(portfolioId);
                    }
                    if (permitOrder) {
                        sb = new StringBuilder("");
                        checkRes.stream().forEach(item -> {
                            StringBuilder stringBuilder2 = sb.append(StringUtils.rightPad((String)item.getSecurityId(), (int)6)).append(StringUtils.rightPad((String)(this.mktItem.getRefItem() != null ? this.mktItem.getRefItem().getName() : ""), (int)4)).append(" \u5356\u51fa\uff1a").append(item.getOrderQty()).append(" \u53ef\u7528\uff1a").append(item.getAvalidPos()).append("\r\n");
                        });
                        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u6307\u4ee4\u7684\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u662f\u5426\u7ee7\u7eed\u4e0b\u5355\uff1f\r\n" + sb.toString())) {
                            return;
                        }
                    } else {
                        sb = new StringBuilder("");
                        checkRes.stream().forEach(item -> {
                            StringBuilder stringBuilder2 = sb.append(StringUtils.rightPad((String)item.getSecurityId(), (int)6)).append(StringUtils.rightPad((String)(this.mktItem.getRefItem() != null ? this.mktItem.getRefItem().getName() : ""), (int)4)).append(" \u5356\u51fa\uff1a").append(item.getOrderQty()).append(" \u53ef\u7528\uff1a").append(item.getAvalidPos()).append("\r\n");
                        });
                        this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u7684\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\r\n" + sb.toString());
                        return;
                    }
                }
            }
            try {
                String result = this.doAction();
                this.es.postEvent("refresh.mail.position", null);
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, result);
            }
            catch (MException e) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, e.getMessage());
                this.logger.error("\u6295\u7ec4\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
            }
            catch (Exception e) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, "\u6295\u7ec4\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
                this.logger.error("\u6295\u7ec4\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
            }
            this.clearCountCheck();
        }
        catch (MException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String doAction() throws MException {
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.portfolio.instruct.mail.query");
        }
        return this.model.submitInstruction();
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(!this.model.isLimitPrice() || this.model.isUnlimited() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        return !this.model.isBidAskPrice() || this.alert.check(this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    protected void onPriceTypeLimitedChange(MxNode newV) {
        this.countStg.setDisable(false);
        this.checkBoxModify.setVisible(false);
        super.onPriceTypeLimitedChange(newV);
        if (newV.is("3")) {
            this.countStg.getSelectionModel().select(0);
            this.countStg.setDisable(true);
        }
    }

    @Override
    protected void onPriceTypeChange() {
        super.onPriceTypeChange();
        boolean isDisable = ((MxNode)this.cmbPriceType.getValue()).is("50") && ((MxNode)this.cmbPriceTypeLimited.getValue()).is("3");
        this.countStg.setDisable(isDisable);
        if (isDisable) {
            this.countStg.getSelectionModel().select(0);
        }
    }

    @Override
    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.portfolioCol.getText()) + "\t" + this.accountCol.getText() + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + '\n');
        for (TreeItem item : this.model.getAccDisModel().getRoot().getChildren()) {
            PortfolioAccountDistribution portfDis = (PortfolioAccountDistribution)item.getValue();
            clipboardString.append(portfDis.getPortfolio() + "\t" + "\t" + "\t" + portfDis.getPortfolio().getExtAvailable() + "\t" + portfDis.getWeight() + "\t" + portfDis.getCount() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                PortfolioAccountDistribution accDis = (PortfolioAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + accDis.getAcc() + "\t" + "\t" + "\t" + (accDis.getWeight() == 0 ? "" : Integer.valueOf(0)) + "\t" + accDis.getCount() + "\t" + '\n');
                for (TreeItem secItem : subItem.getChildren()) {
                    PortfolioAccountDistribution secAccDis = (PortfolioAccountDistribution)secItem.getValue();
                    clipboardString.append("\t\t" + secAccDis.getSecAcc() + "\t" + "\t" + (secAccDis.getWeight() == 0 ? "" : Integer.valueOf(0)) + "\t" + secAccDis.getCount() + "\t" + '\n');
                }
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    @Override
    protected void refresh() {
        this.model.refreshAvailable();
    }
}

