/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.viewers.portfolio.InstructionPortfolioPassivePart;
import cms.tmx.javafx.MxNode;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionPortfolioMailApprovePart
extends InstructionPortfolioPassivePart {
    @Inject
    public InstructionPortfolioMailApprovePart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.es.subscribe("instruction.set.on.panel", this.hSetCode);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    @FXML
    public void initialize() {
        this.checkBoxModify.setVisible(false);
        this.portfolioTreeTable.getColumns().remove((Object)this.canBuyCol);
        this.portfolioTreeTable.getColumns().remove((Object)this.canSellCol);
        this.portfolioTreeTable.getColumns().remove((Object)this.assetCol);
        this.model.getAccDisModel().setMail(true);
        this.model.create("3");
        this.algoNode.instructionType = "3";
        this.tabNormal.getTabPane().getTabs().remove((Object)this.tabAlgo);
        this.setBuySymbol("\u90ae\u4ef6\u6307\u4ee4\u5ba1\u6279\u901a\u8fc7");
        this.setSellSymbol("\u90ae\u4ef6\u6307\u4ee4\u5ba1\u6279\u901a\u8fc7");
        this.setDialogSymbol("\u90ae\u4ef6\u6307\u4ee4\u5ba1\u6279\u786e\u8ba4");
        super.initialize();
        this.availableCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).isPortDist() ? ((PortfolioAccountDistribution)data.getValue().getValue()).getPortfolio().extAvailableProperty() : new SimpleDoubleProperty(0.0));
        this.refresh();
    }

    @PreDestroy
    public void destroy() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    protected boolean validOrderFill() {
        Instruction eventInstr = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        return "3".equals(eventInstr.getType().getRaw()) && !eventInstr.getIsOrderStep() && this.isMail(eventInstr);
    }

    @Override
    protected String doAction() throws MException {
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.portfolio.instruct.mail.query");
        }
        return this.model.submitApprove(this.instruction);
    }

    @Override
    protected void disable(boolean disable) {
        this.algoNode.disable(this.instruction.getAlgoParam().getAlgorithm().getType(), disable, false);
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.setDisable(true);
    }

    @Override
    protected void quantityDisableBind() {
        this.quantitySpn.setDisable(true);
    }

    @Override
    protected void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (!this.model.isSpecify() && !this.model.isAfterHours()) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.model.priceTypeLimitedStgProperty(), this.model.priceStgProperty()}));
        this.hboxProtectedPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (((MxNode)this.cmbPriceType.getValue()).is("49") && this.model.isStar()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty(), this.mktItem.changedProperty()}));
    }

    @Override
    protected boolean priceValid() {
        return true;
    }

    @Override
    protected void doSetCode() {
        super.doSetCode();
        if (!this.initFinished || this.instruction == null) {
            return;
        }
        if (this.instruction.getType().getRaw().equals("3")) {
            this.tabNormal.setDisable(false);
            this.tabAlgo.setDisable(true);
        } else if (this.instruction.getType().getRaw().equals("9")) {
            this.tabNormal.setDisable(true);
            this.tabAlgo.setDisable(false);
        }
        this.layout();
    }

    @Override
    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.portfolioCol.getText()) + "\t" + this.accountCol.getText() + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + '\n');
        for (TreeItem item : this.model.getAccDisModel().getRoot().getChildren()) {
            PortfolioAccountDistribution portfDis = (PortfolioAccountDistribution)item.getValue();
            clipboardString.append(portfDis.getPortfolio() + "\t" + "\t" + "\t" + portfDis.getPortfolio().getExtAvailable() + "\t" + portfDis.getWeight() + "\t" + portfDis.getCount() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                PortfolioAccountDistribution accDis = (PortfolioAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + accDis.getAcc() + "\t" + "\t" + "\t" + (accDis.getWeight() == 0 ? "" : Integer.valueOf(0)) + "\t" + accDis.getCount() + "\t" + '\n');
                for (TreeItem secItem : subItem.getChildren()) {
                    PortfolioAccountDistribution secAccDis = (PortfolioAccountDistribution)secItem.getValue();
                    clipboardString.append("\t\t" + secAccDis.getSecAcc() + "\t" + "\t" + (secAccDis.getWeight() == 0 ? "" : Integer.valueOf(0)) + "\t" + secAccDis.getCount() + "\t" + '\n');
                }
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    @Override
    protected void refresh() {
        this.model.refreshAvailable();
    }
}

