/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.portfolio;

import cms.tmx.core.MException;
import cms.tmx.instructions.viewers.portfolio.InstructionPortfolioBasePart;
import cms.tmx.javafx.MxNode;
import cms.tmx.utils.StringUtils;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.inject.Inject;

public class InstructionPortfolioInstructPart
extends InstructionPortfolioBasePart {
    @Inject
    public InstructionPortfolioInstructPart() {
    }

    @Override
    @FXML
    public void initialize() {
        this.model.create("1");
        this.algoNode.instructionType = "1";
        this.setBuySymbol("\u6307\u4ee4\u4e70\u5165");
        this.setSellSymbol("\u6307\u4ee4\u5356\u51fa");
        this.setDialogSymbol("\u4e0b\u8fbe\u6307\u4ee4\u786e\u8ba4");
        super.initialize();
        this.mktItem.changedProperty().addListener(ob -> this.setPrePrice());
        this.checkBoxModify.setSelected(true);
        this.checkBoxModify.setVisible(true);
    }

    @Override
    protected String doAction() throws MException {
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.portfolio.instruct.query");
        }
        return this.model.submitInstruction();
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(!this.model.isLimitPrice() || this.model.isUnlimited() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        return !this.model.isBidAskPrice() || this.alert.check(this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    protected void onPriceTypeLimitedChange(MxNode newV) {
        this.countStg.setDisable(false);
        this.checkBoxModify.setVisible(false);
        super.onPriceTypeLimitedChange(newV);
        if (newV.is("3")) {
            this.countStg.getSelectionModel().select(0);
            this.countStg.setDisable(true);
        }
        if (StringUtils.belongto((String)newV.getRaw(), (String[])new String[]{"3", "1", "4"})) {
            this.checkBoxModify.setVisible(true);
        }
    }

    @Override
    protected void onPriceTypeChange() {
        super.onPriceTypeChange();
        boolean isDisable = ((MxNode)this.cmbPriceType.getValue()).is("50") && ((MxNode)this.cmbPriceTypeLimited.getValue()).is("3");
        this.countStg.setDisable(isDisable);
        if (isDisable) {
            this.countStg.getSelectionModel().select(0);
        }
        isDisable = ((MxNode)this.cmbPriceType.getValue()).is("50") && StringUtils.belongto((String)((MxNode)this.cmbPriceTypeLimited.getValue()).getRaw(), (String[])new String[]{"3", "1", "4"});
        this.checkBoxModify.setVisible(isDisable);
    }
}

