/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.light;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.instruction.ObLightingInstruction;
import cms.tmx.http.instruction.dto.LightingInsStatus;
import cms.tmx.instructions.models.lighting.LightingInstructionModel;
import cms.tmx.instructions.viewers.light.InstructionLightingDialog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;

public class InstructionLightingExecutePart
extends MxPart {
    @FXML
    protected TableView<ObLightingInstruction> tableInstruction;
    @FXML
    protected TableColumn<ObLightingInstruction, String> colInsId;
    @FXML
    protected TableColumn<ObLightingInstruction, String> colBelongTo;
    @FXML
    protected TableColumn<ObLightingInstruction, String> colInsType;
    @FXML
    protected TableColumn<ObLightingInstruction, Object> colDetails;
    @FXML
    protected TableColumn<ObLightingInstruction, String> colExeStatus;
    @FXML
    protected TableColumn<ObLightingInstruction, String> colInsBeginTime;
    @FXML
    protected TableColumn<ObLightingInstruction, String> colInsEndTime;
    @FXML
    protected TableColumn<ObLightingInstruction, String> colOperation;
    private static final Set<String> STATUS_SET = new HashSet<String>(Arrays.asList(String.valueOf(LightingInsStatus.kCreated.getValue()), String.valueOf(LightingInsStatus.kSubmitted.getValue())));
    @FXML
    private Button btnHotExe;
    @FXML
    private TextField searchText;
    @FXML
    private Label lbExeHotkey;
    @FXML
    private CheckBox cbExecuted;
    @Inject
    protected MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    protected MxList<ObLightingInstruction> mxList = new MxList();
    @Inject
    protected LightingInstructionModel model;
    protected static final int DOUBLE_CLICK_COUNT = 2;
    protected Predicate<ObLightingInstruction> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObLightingInstruction)en)) {
            return false;
        }
        if (StringUtils.isEmpty((String)text)) {
            return true;
        }
        if (!(en.getId().contains(text) || en.getBelongTo() == null || en.getBelongTo().contains(text) || en.getSecCode().contains(text))) {
            return false;
        }
        if (this.extend((ObLightingInstruction)en)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnModel = ob -> {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList().getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.tableInstruction.sort();
        });
    };
    private InvalidationListener lstnSearch = ob -> {
        ArrayList newList = new ArrayList();
        Platform.runLater(() -> {
            ObservableList observableList = this.model.getList().getList();
            synchronized (observableList) {
                newList.addAll(this.model.getList().getList());
                this.mxList.filter(newList, this.pd);
            }
            this.tableInstruction.sort();
        });
    };
    private NativeKeyListener nativeLis = new NativeKeyListener(){

        public void nativeKeyTyped(NativeKeyEvent nativeEvent) {
        }

        public void nativeKeyReleased(NativeKeyEvent nativeEvent) {
            Platform.runLater(() -> {
                if (nativeEvent.getKeyCode() == 61) {
                    List exeList = InstructionLightingExecutePart.this.model.getList().getList().stream().filter(item -> STATUS_SET.contains(item.getExeStatus())).collect(Collectors.toList());
                    InstructionLightingExecutePart.this.hotkeyExe(exeList);
                }
            });
        }

        public void nativeKeyPressed(NativeKeyEvent nativeEvent) {
        }
    };

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.checkAuth();
    }

    @FXML
    private void hotkeyExe() {
        List<ObLightingInstruction> exeList = this.model.getList().getList().stream().filter(item -> STATUS_SET.contains(item.getExeStatus())).collect(Collectors.toList());
        this.hotkeyExe(exeList);
    }

    private void hotkeyExe(List<ObLightingInstruction> exeList) {
        if (exeList.isEmpty()) {
            return;
        }
        this.batchExe(exeList);
    }

    private void batchExe(List<ObLightingInstruction> exeList) {
        this.model.batchLightingExe(exeList);
    }

    private void initGlobalHotKey() {
        try {
            GlobalScreen.registerNativeHook();
            Logger l = Logger.getLogger(GlobalScreen.class.getPackage().getName());
            l.setLevel(Level.WARNING);
            GlobalScreen.addNativeKeyListener((NativeKeyListener)this.nativeLis);
        }
        catch (NativeHookException e) {
            this.logger.error("\u5feb\u6377\u6267\u884c\u9875\u9762\u6ce8\u518c\u5168\u5c40\u5feb\u6377\u952e\u5931\u8d25", (Throwable)e);
        }
    }

    protected void checkAuth() {
        this.initGlobalHotKey();
    }

    protected void createTable() {
        this.colInsId.setCellValueFactory(data -> ((ObLightingInstruction)data.getValue()).idProperty());
        this.colBelongTo.setCellValueFactory(data -> ((ObLightingInstruction)data.getValue()).belongToProperty());
        this.colInsType.setCellValueFactory(data -> ((ObLightingInstruction)data.getValue()).typeNameProperty());
        this.colInsBeginTime.setCellValueFactory(data -> ((ObLightingInstruction)data.getValue()).beginTimeProperty());
        this.colInsEndTime.setCellValueFactory(data -> ((ObLightingInstruction)data.getValue()).endTimeProperty());
        this.colExeStatus.setCellValueFactory(data -> ((ObLightingInstruction)data.getValue()).exeStatusNameProperty());
        this.colDetails.setCellValueFactory(data -> this.setOperate((ObLightingInstruction)data.getValue()));
        this.tableInstruction.setItems(this.mxList.getList());
        this.tableInstruction.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableInstruction);
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.colInsId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableInstruction.getSortOrder().add(this.colInsId);
        this.tableInstruction.sort();
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected InvalidationListener getLstnSearch() {
        return this.lstnSearch;
    }

    public boolean premise(ObLightingInstruction ins) {
        if (this.cbExecuted.isSelected()) {
            return true;
        }
        return STATUS_SET.contains(ins.getExeStatus());
    }

    public boolean extend(ObLightingInstruction ins) {
        return false;
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.getLstnModel());
        this.searchText.textProperty().addListener(this.getLstnSearch());
        this.cbExecuted.selectedProperty().addListener((ob, oldV, newV) -> this.lstnSearch.invalidated(null));
    }

    protected ReadOnlyObjectWrapper<Object> setOperate(ObLightingInstruction instruction) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button btn = new Button("\u8be6\u60c5");
        btn.setMinWidth(100.0);
        btn.setOnAction(event -> this.showDetails(instruction));
        btn.getStyleClass().add((Object)"btnOperation");
        box.getChildren().add((Object)btn);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void showDetails(ObLightingInstruction instruction) {
        this.selectRow(instruction);
        InstructionLightingDialog obj = (InstructionLightingDialog)((Object)this.of.create(InstructionLightingDialog.class));
        obj.setObLightingInstruction(instruction);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u8be6\u60c5" + instruction.getId());
        dialog.launch();
    }

    private void selectRow(ObLightingInstruction ins) {
        this.tableInstruction.getSelectionModel().select((Object)ins);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableInstruction);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableInstruction, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

