/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.light;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObLightingInstruction;
import cms.tmx.http.instruction.dto.ObLightingInsExecLeg;
import cms.tmx.instructions.models.lighting.LightingInstructionDialogModel;
import cms.tmx.javafx.MxList;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import cmx.tmx.data.IRefDataMng;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructionLightingDialog
extends DialogObj {
    protected ObLightingInstruction ObLightingInstruction;
    @FXML
    protected TableView<ObLightingInsExecLeg> tableDetails;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colInstructionId;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colLegId;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colClOrdId;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colSecId;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colSecName;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colSide;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colSecType;
    @FXML
    private TableColumn<ObLightingInsExecLeg, Number> colPrice;
    @FXML
    private TableColumn<ObLightingInsExecLeg, Number> colQty;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colOrdStatus;
    @FXML
    private TableColumn<ObLightingInsExecLeg, Number> colCumQty;
    @FXML
    private TableColumn<ObLightingInsExecLeg, Number> colRatio;
    @FXML
    private TableColumn<ObLightingInsExecLeg, String> colLegStatus;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private HttpClientService https;
    @Inject
    private LightingInstructionDialogModel model;
    private MxList<ObLightingInsExecLeg> legs = new MxList();
    private static final Logger logger = LogManager.getLogger(InstructionLightingDialog.class);
    @Inject
    private MxAlert alert;
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.legs.update(this.model.getList());
        this.tableDetails.sort();
    });

    @FXML
    public void initialize() {
        this.listener();
        this.createExecutionTable();
        this.refreshExecution();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
    }

    public void onDlgClosed() {
        super.onDlgClosed();
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    @FXML
    public void copyExecution() {
        TableUtils.copyContentWithHead(this.tableDetails);
    }

    @FXML
    public void refreshExecution() {
        try {
            if (StringUtils.isEmpty((String)this.ObLightingInstruction.getId())) {
                throw new MException(999997, String.valueOf(this.ObLightingInstruction.getId()) + "\u6307\u4ee4ID\u4e3a\u7a7a");
            }
            this.model.query(this.ObLightingInstruction.getId());
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportExecution() {
        try {
            ExcelUtils.writeExcel(this.tableDetails, (String)"\u6210\u4ea4\u8be6\u60c5");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createExecutionTable() {
        this.colLegId.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).idProperty());
        this.colLegId.setSortType(TableColumn.SortType.DESCENDING);
        this.colInstructionId.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).listIdProperty());
        this.colClOrdId.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).clOrdIdProperty());
        this.colSecId.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).securityIdProperty());
        this.colSecName.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).securityIdProperty());
        this.colSide.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).sideProperty());
        this.colSecType.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).securityTypeProperty());
        this.colOrdStatus.setCellValueFactory(data -> new SimpleStringProperty("\u5f85\u5b9e\u73b0"));
        this.colPrice.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).priceProperty());
        this.colPrice.setCellFactory(data -> new DoubleTableCell());
        this.colQty.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).orderQtyProperty());
        this.colQty.setCellFactory(data -> new DoubleTableCell(0));
        this.colCumQty.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).cumQtyProperty());
        this.colCumQty.setCellFactory(data -> new DoubleTableCell(0));
        this.colRatio.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).ratioProperty());
        this.colRatio.setCellFactory(data -> new DoubleTableCell(0));
        this.colLegStatus.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).legStatusProperty());
        this.colOrdStatus.setCellValueFactory(data -> ((ObLightingInsExecLeg)data.getValue()).ordStatusProperty());
        this.tableDetails.getSortOrder().add(this.colInstructionId);
        this.tableDetails.sort();
        this.tableDetails.setPlaceholder((Node)new Label());
        this.tableDetails.setItems(this.legs.getList());
        TableUtils.orgnizeClmWidth(this.tableDetails);
    }

    private void selectRow(ObLightingInsExecLeg execution) {
        this.tableDetails.getSelectionModel().select((Object)execution);
    }

    public ObLightingInstruction getInstruction() {
        return this.ObLightingInstruction;
    }

    public void setObLightingInstruction(ObLightingInstruction ObLightingInstruction2) {
        this.ObLightingInstruction = ObLightingInstruction2;
    }
}

