/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.hkwolun;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.User;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.instructions.models.regular.InstructionCcsBaseModel;
import cms.tmx.instructions.models.regular.InstructionHkwolunBaseModel;
import cms.tmx.instructions.models.regular.UserPreCtrlHkwolun;
import cms.tmx.instructions.viewers.hkwolun.AlgoNodeHkwolunInstruction;
import cms.tmx.instructions.viewers.hkwolun.LoadPartModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.query.current.models.HkwolunUnfinishedOrderModel;
import cms.tmx.rights.IUiRightService;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.api.ITradePart;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.utils.TradeAcctCountFilter;
import cms.tmx.trade.views.CcsEntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class InstructionHkwolunBasePart
extends MxPart
implements ITradePart {
    @FXML
    protected HBox hboxAlgo;
    @Inject
    public AlgoNodeHkwolunInstruction algoNode;
    @FXML
    protected TabPane tabPane;
    @FXML
    protected Tab tabNormal;
    @FXML
    protected Tab tabAlgo;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    protected ComboBox<MxNode> cmbMarket;
    @FXML
    protected ComboBox<MxNode> cmbAlgoMkt;
    @FXML
    protected ComboBox<MxNode> cmbOfferWay;
    @FXML
    protected TextField txtCode;
    @FXML
    protected GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    protected Label lbSide;
    @FXML
    protected RadioButton buyRadio;
    @FXML
    protected RadioButton sellRadio;
    @FXML
    protected StackPane stkPaneCommon;
    @FXML
    protected ComboBox<MxNode> countStg;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeMkt;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeAfterHours;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Spinner<Double> protectedPriceSpn;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    private Label lbPer;
    @FXML
    private Label lbPerSymbol;
    @FXML
    private TextField txtPerCount;
    @FXML
    protected Spinner<Double> moneySpn;
    @FXML
    private Label lbRate;
    @FXML
    protected Label lbOfferPrice;
    @FXML
    private Label lbOfferCount;
    @FXML
    private Label lbInitAmt;
    @FXML
    private Label lbPosAmt;
    @FXML
    private Label lbRateWay;
    @FXML
    private Label lbExchangeRate;
    @FXML
    protected Label lbLatest;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canSellCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private Label lbAmountOne;
    @FXML
    private Label lbAmountTwo;
    @FXML
    private Label lbAmountThree;
    @FXML
    private Label lbAmountFour;
    @FXML
    private Label lbTotalOne;
    @FXML
    private Label lbTotalTwo;
    @FXML
    private Label lbTotalThree;
    @FXML
    private Label lbTotalFour;
    @FXML
    private Label lbCanbuyOne;
    @FXML
    private Label lbCanbuyTwo;
    @FXML
    private Label lbCanbuyThree;
    @FXML
    private Label lbCanbuyFour;
    @FXML
    private Label lbCansellOne;
    @FXML
    private Label lbCansellTwo;
    @FXML
    private Label lbCansellThree;
    @FXML
    private Label lbCansellFour;
    @FXML
    private HBox hboxCounts;
    @FXML
    private Label priceMag;
    @FXML
    private Label amtMag;
    @FXML
    private Label qtyMag;
    @FXML
    private HBox hboxPer;
    @FXML
    private HBox hboxMoney;
    @FXML
    private HBox hboxCommAmount;
    @FXML
    private HBox hboxTotalAsset;
    @FXML
    private HBox hboxCanbuy;
    @FXML
    private HBox hboxCansell;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, String> accntNameCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> posiCapitalCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> buyCostCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> floatPlCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> realPlCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> totalPlCol;
    @FXML
    private HBox hbSum;
    @FXML
    private Label lbNum;
    @FXML
    private Label lbPosiAmt;
    @FXML
    private Label lbPosiCapital;
    @FXML
    private Label lbFloatPL;
    @FXML
    private Label lbRealPl;
    @FXML
    private Label lbTotalPl;
    @FXML
    protected Label lbCan;
    @FXML
    protected Label lbCanCount;
    @FXML
    protected Button btnOrder;
    @FXML
    private ComboBox<MxNode> cmbAccFilter;
    @FXML
    private HBox hBoxPartlyAccCount;
    @FXML
    private Label lbSecAccCount;
    @FXML
    private TextField textAccCount;
    @FXML
    private TextField txtSearch;
    @FXML
    protected CheckBox checkBoxModify;
    @FXML
    protected HBox hboxProtectedPrice;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected InstructionHkwolunBaseModel ccsModel;
    @Inject
    protected UserPreCtrlHkwolun preModel;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    @Inject
    protected IUIService uiService;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private IFundAccountService fundService;
    @Inject
    private IUiRightService right;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected MarketItem mktItem;
    private SecConverter secCvt;
    protected String confirmSymbol = "";
    protected boolean priceSettle = false;
    @Inject
    private HkwolunUnfinishedOrderModel unfinishedModel;
    @Inject
    private ExecutorService exe;
    protected Map<String, List<CcsOrder>> map;
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {
        ObservableList list = this.unfinishedModel.getList();
        this.map = list.stream().collect(Collectors.groupingBy(t -> t.getInstrument().getSecId()));
        this.MonitOnRefChange();
    });
    private InvalidationListener lstnFundService = ob -> Platform.runLater(() -> this.acctTreeTable.layout());
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleSpinnerCtrl ctrlMoney = new DoubleSpinnerCtrl(true, 12, 2);
    protected SecSuggest spCode = new SecSuggest();
    protected AutoCompletion<RefItem> autoCompletionNormal;
    protected AutoCompletion<RefItem> autoCompletionAlgo;
    private MEventHandler hSetPst = event -> {
        if ("3".equals(this.ccsModel.getAccDisModel().getInstructType()) || "4".equals(this.ccsModel.getAccDisModel().getInstructType())) {
            return;
        }
        if (this.autoCompletionAlgo == null || this.autoCompletionNormal == null) {
            return;
        }
        String market = event.getStr("tMarket");
        if (!"SHSC".equals(market) && !"SZSC".equals(market)) {
            return;
        }
        MxNode node = MxNodeFactory.create((String)"hkwolun_market_code", (String)"SHSC");
        node.setRaw(event.getStr("tMarket"));
        this.cmbMarket.setValue((Object)node);
        String secCode = event.getStr("sec_code");
        this.txtCode.setText(secCode);
        RefItem item = this.refMng.getItem("STOCK" + market, market, secCode);
        this.txtCode.setUserData((Object)item);
        this.ccsModel.setPstAcct(event.getStr("secAccount"), event.getStr("tMarket"));
        this.sellRadio.setSelected(event.getBool("side_sell"));
        if (this.tabAlgo.isSelected()) {
            this.autoCompletionAlgo.setChange(secCode);
            this.onSecurityChange(this.algoNode.getTxtCode(), secCode);
        } else {
            this.autoCompletionNormal.setChange(secCode);
            this.onSecurityChange(this.txtCode, secCode);
        }
        this.ccsModel.setCount(event.getLong("count"));
        this.ccsModel.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
    };
    private InvalidationListener listener = ob -> {
        MxNode node = (MxNode)this.cmbMarket.getSelectionModel().getSelectedItem();
        String market = node == null ? "SHSC" : node.getRaw();
        Collection list = this.refMng.getItems(new String[]{"STOCK" + market});
        this.spCode.setAllSuggestions(list);
    };
    private InvalidationListener lstnHkRate = ob -> Platform.runLater(() -> {
        if (this.ccsModel.isValidRef()) {
            String rate = this.buyRadio.isSelected() ? RefItem.getAskRate() : RefItem.getBidRate();
            this.lbExchangeRate.setText(rate);
        }
    });
    protected boolean tabChange = false;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private ListChangeListener<TreeItem<CcsAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    checkBox.setDisable(!InstructionHkwolunBasePart.this.ccsModel.getAccDisModel().isActive());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(InstructionHkwolunBasePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> InstructionHkwolunBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem));
                        InstructionHkwolunBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                InstructionHkwolunBasePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> InstructionHkwolunBasePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(((CcsAccountDistribution)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };
    @Inject
    protected LoadPartModel load;

    @Inject
    public InstructionHkwolunBasePart() {
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener(this.listenerUnfinish);
        this.unfinishedModel.changedProperty().addListener(this.listenerUnfinish);
        this.exe.execute(() -> {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                this.logger.error("\u521d\u59cb\u5316\u4ea4\u6613\u9762\u677f\u67e5\u8be2\u59d4\u6258\u5931\u8d25", (Throwable)e);
            }
            this.unfinishedModel.query();
        });
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            List<CcsOrder> orders = this.map.get(this.mktItem.getRefItem().getCode());
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
        }
    }

    public void onShowEvent(MEvent event) {
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listener);
        this.refMng.changedProperty().removeListener(this.lstnHkRate);
        this.mktItem.changedProperty().removeListener(this.listenerUnfinish);
        this.unfinishedModel.changedProperty().removeListener(this.listenerUnfinish);
        this.fundService.changedProperty().removeListener(this.lstnFundService);
        this.es.unSubscribe("trade.panel.set.code", this.hSetPst);
    }

    @FXML
    public void initialize() {
        this.algoNode.setBaseModel(this.ccsModel);
        this.mktItem = this.ccsModel.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> Platform.runLater(() -> this.onRefChange()));
        this.mktItem.changedProperty().addListener(ob -> Platform.runLater(() -> this.onMktItemChange()));
        this.refMng.changedProperty().addListener(this.listener);
        this.refMng.changedHkRateProperty().addListener(this.lstnHkRate);
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTree();
        this.fundService.changedProperty().addListener(this.lstnFundService);
        this.es.subscribe("trade.panel.set.code", this.hSetPst);
        this.hboxAlgo.getChildren().add((Object)this.algoNode.getContent());
    }

    protected void initControls() {
        boolean authority = this.right.registerCheck(new String[]{"cms.tmx.instructions.part.hkwolun.regular.algo"});
        if (!authority) {
            this.tabAlgo.setDisable(true);
            this.tabAlgo.setText("");
        }
        this.ccsModel.normalProperty().bind((ObservableValue)this.tabNormal.selectedProperty());
        this.tabNormal.selectedProperty().addListener((ob, old, now) -> {
            this.tabChange = true;
            if (!now.booleanValue()) {
                this.algoNode.txtCode.requestFocus();
                this.algoNode.txtCode.selectEnd();
                this.algoNode.txtCode.deselect();
                this.algoNode.onBSChange(this.algoNode.buyRadio.isSelected());
                this.autoCompletionAlgo.setChange(this.txtCode.getText());
            } else {
                this.buyRadio.setSelected(this.algoNode.buyRadio.isSelected());
                this.sellRadio.setSelected(!this.algoNode.buyRadio.isSelected());
                this.autoCompletionNormal.setChange(this.algoNode.getTxtCode().getText());
            }
        });
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (this.tabChange) {
                this.tabChange = false;
                return;
            }
            this.algoNode.getTxtCode().setUserData(this.txtCode.getUserData());
            this.onSecurityChange(this.txtCode, (String)newV);
            this.tableMarketBuy.refresh();
            this.tableMarketSell.refresh();
            this.acctTreeTable.refresh();
            this.layout();
        }));
        this.autoCompletionAlgo = Search.bindAutoCompletion((TextField)this.algoNode.getTxtCode(), (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionAlgo.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (this.tabChange) {
                this.tabChange = false;
                return;
            }
            this.txtCode.setUserData(this.algoNode.getTxtCode().getUserData());
            this.onSecurityChange(this.algoNode.getTxtCode(), (String)newV);
            this.tableMarketBuy.refresh();
            this.tableMarketSell.refresh();
            this.acctTreeTable.refresh();
            this.layout();
        }));
        MxNode node = MxNodeFactory.create((String)"hkwolun_market_code", (String)"SHSC");
        this.cmbMarket.setItems(node.getNodes());
        this.cmbMarket.setValue((Object)node);
        this.cmbAlgoMkt.setItems(node.getNodes());
        this.cmbAlgoMkt.valueProperty().bindBidirectional((Property)this.cmbMarket.valueProperty());
        this.listener.invalidated(null);
        this.cmbMarket.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.spCode.setAllSuggestions(this.refMng.getItems(new String[]{"STOCK" + now.getRaw()}));
                this.txtCode.clear();
                this.txtCode.setUserData(null);
                this.onSecurityChange(this.txtCode, "");
            }
        });
        this.cmbOfferWay.setItems(this.ccsModel.getOfferWay().getNodes());
        this.cmbOfferWay.valueProperty().bindBidirectional(this.ccsModel.offerWayProperty());
        this.cmbOfferWay.setValue((Object)this.ccsModel.getOfferWay());
        this.offerWayDisableBind();
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 5)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.ccsModel.securityProperty());
        Tooltip tooltip = new Tooltip();
        this.lbName.setTooltip(tooltip);
        tooltip.textProperty().bind((ObservableValue)this.lbName.textProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.ccsModel.nameProperty());
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.setSelected(true);
        this.algoNode.buyRadio.selectedProperty().addListener((ob, old, now) -> {
            this.buyRadio.setSelected(now.booleanValue());
            this.sellRadio.setSelected(now == false);
        });
        this.cmbPriceType.setItems(this.ccsModel.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.ccsModel.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.onPriceTypeChange());
        this.cmbPriceType.setDisable(true);
        this.cmbPriceTypeLimited.setItems(this.ccsModel.getPriceTypeLimitedStg().getNodes());
        this.cmbPriceTypeLimited.valueProperty().bindBidirectional(this.ccsModel.priceTypeLimitedStgProperty());
        this.cmbPriceTypeLimited.valueProperty().addListener((ob, old, newV) -> this.onPriceTypeLimitedChange((MxNode)newV));
        this.cmbPriceTypeMkt.setItems(this.ccsModel.getPriceTypeMktStg().getNodes());
        this.cmbPriceTypeMkt.valueProperty().bindBidirectional(this.ccsModel.priceTypeMktStgProperty());
        this.cmbPriceTypeBidAsk.setItems(this.ccsModel.getPriceTypeBidAskStg().getNodes());
        this.cmbPriceTypeBidAsk.valueProperty().bindBidirectional(this.ccsModel.priceTypeBidAskStgProperty());
        this.cmbPriceTypeAfterHours.setItems(this.ccsModel.getPriceTypeAfterHours().getNodes());
        this.cmbPriceTypeAfterHours.valueProperty().bindBidirectional(this.ccsModel.priceTypeAfterHoursProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.ccsModel.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().setText("");
        this.ctrlPrice.ctrl(this.protectedPriceSpn);
        MxBindings.bindSD((Property)this.protectedPriceSpn.getEditor().textProperty(), (Property)this.ccsModel.priceProtectedProperty());
        this.protectedPriceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.protectedPriceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.protectedPriceSpn.getEditor().setText("");
        this.priceDisableBind();
        this.priceVisibleBind();
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        SpinnerUtils.arrowsStyle(this.moneySpn);
        TextFieldUtils.showMagnitude((Label)this.amtMag, (TextField)this.moneySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.quantitySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.priceMag, (TextField)this.priceSpn.getEditor());
        this.setPriceUnit();
        this.lbCan.visibleProperty().bind((ObservableValue)this.ccsModel.getAccDisModel().showCanBuyProperty());
        this.lbCanCount.visibleProperty().bind((ObservableValue)this.ccsModel.getAccDisModel().showCanBuyProperty());
        MxBindings.bindSI((Property)this.lbCanCount.textProperty(), (Property)this.ccsModel.getAccDisModel().canBuyProperty());
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantityDisableBind();
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.ccsModel.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> Platform.runLater(() -> this.quantityKeyPress((KeyEvent)event)));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.countStg.setItems(this.ccsModel.getCountStg().getNodes());
        this.countStg.valueProperty().addListener((ob, old, now) -> this.onCountStgChange());
        this.countStg.valueProperty().bindBidirectional(this.ccsModel.countStgProperty());
        this.countStg.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.cmbStgKeyPress((KeyEvent)event));
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().is("1"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.hboxPer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().is("3") || this.ccsModel.getCountStg().is("2") || this.ccsModel.getCountStg().is("4"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtPerCount);
        MxBindings.bindSD((Property)this.txtPerCount.textProperty(), (Property)this.ccsModel.countPerProperty());
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
        this.ctrlMoney.ctrl(this.moneySpn);
        this.moneySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.txtPerCount.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        MxBindings.bindSDTwoScale((Property)this.moneySpn.getEditor().textProperty(), (Property)this.ccsModel.moneyProperty());
        this.moneySpn.getEditor().setText(String.format("%1$,.2f", this.ccsModel.getMoney()));
        this.hboxCommAmount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.hboxTotalAsset.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("2"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.hboxCanbuy.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("3"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.hboxCansell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.ccsModel.getCountStg().getRaw().equals("4"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
        this.checkBoxModify.selectedProperty().bindBidirectional((Property)this.ccsModel.canModifyProperty());
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        TableUtils.beforeClick(this.tableMarketBuy, item -> this.onMktItemClicked((HandicapInfo)item));
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        TableUtils.beforeClick(this.tableMarketSell, item -> this.onMktItemClicked((HandicapInfo)item));
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.lbRate.textProperty());
        this.lbRate.setTooltip(tooltip);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    protected void afterTableRestore() {
        this.canBuyCol.setVisible(true);
        this.canSellCol.setVisible(true);
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.ccsModel.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.ccsModel.distStgProperty());
        this.cmbAccFilter.setItems(this.ccsModel.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.ccsModel.accFilterStgProperty());
        this.hBoxPartlyAccCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getAccFilterStg().getRaw().equals("1"), (Observable[])new Observable[]{this.ccsModel.accFilterStgProperty()}));
        MxBindings.bindSI((Property)this.lbSecAccCount.textProperty(), (Property)this.ccsModel.getAccDisModel().effectiveSecAccCountProperty());
        MxBindings.bindSI((Property)this.textAccCount.textProperty(), (Property)this.ccsModel.getAccDisModel().customSecAccCountProperty());
        this.textAccCount.setTextFormatter(new TextFormatter((UnaryOperator)new TradeAcctCountFilter(true, 9, this.ccsModel.getAccDisModel().effectiveSecAccCountProperty())));
        this.txtSearch.textProperty().bindBidirectional((Property)this.ccsModel.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(data -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().hkAvailableProperty());
        this.availableCol.setCellFactory(data -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canSellCol.setCellFactory(data -> new NumberTreeTableCell());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty());
        this.assetCol.setCellFactory(data -> new MoneyCell(2));
        this.ccsModel.getAccDisModel().repoProperty().addListener((ob, old, newV) -> {
            this.canBuyCol.setVisible(newV == false);
            this.canSellCol.setVisible(newV == false);
        });
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(data -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(data -> new NumberTreeTableCell());
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.acctTreeTable.setRoot(this.ccsModel.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.ccsModel.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
        this.checkIsAutotrophy();
    }

    protected boolean isAutotrophy() {
        return false;
    }

    private void checkIsAutotrophy() {
        if (this.isAutotrophy()) {
            this.accntNameCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accntNameProperty());
            this.posiCapitalCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).capitalizationProperty());
            this.posiCapitalCol.setCellFactory(data -> new NumberCell());
            this.buyCostCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).buyCostAmtProperty());
            this.buyCostCol.setCellFactory(data -> new NumberCell());
            this.floatPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).floatPlProperty());
            this.floatPlCol.setCellFactory(data -> new NumberCell());
            this.realPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).realPlProperty());
            this.realPlCol.setCellFactory(data -> new NumberCell());
            this.totalPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).totalPlProperty());
            this.totalPlCol.setCellFactory(data -> new NumberCell());
            MxBindings.bindSD((Property)this.lbNum.textProperty(), (Property)this.ccsModel.getAccDisModel().numProperty());
            MxBindings.bindSDTwoScale((Property)this.lbPosiAmt.textProperty(), (Property)this.ccsModel.getAccDisModel().buyCostAmtProperty());
            MxBindings.bindSDTwoScale((Property)this.lbPosiCapital.textProperty(), (Property)this.ccsModel.getAccDisModel().capitalProperty());
            MxBindings.bindSDTwoScale((Property)this.lbFloatPL.textProperty(), (Property)this.ccsModel.getAccDisModel().floatPlProperty());
            MxBindings.bindSDTwoScale((Property)this.lbRealPl.textProperty(), (Property)this.ccsModel.getAccDisModel().realPlProperty());
            MxBindings.bindSDTwoScale((Property)this.lbTotalPl.textProperty(), (Property)this.ccsModel.getAccDisModel().totalPlProperty());
            this.countStg.setVisible(false);
            this.stkPaneCommon.setVisible(false);
        } else {
            this.acctTreeTable.getColumns().remove(this.accntNameCol);
            this.acctTreeTable.getColumns().remove(this.posiCapitalCol);
            this.acctTreeTable.getColumns().remove(this.buyCostCol);
            this.acctTreeTable.getColumns().remove(this.floatPlCol);
            this.acctTreeTable.getColumns().remove(this.realPlCol);
            this.acctTreeTable.getColumns().remove(this.totalPlCol);
            ((VBox)this.hbSum.getParent()).getChildren().remove((Object)this.hbSum);
        }
    }

    protected void acctTreeSupplement() {
        this.ccsModel.countStgProperty().addListener(ob -> {
            String stg = this.ccsModel.getCountStg().getRaw();
            if (stg.equals("1") || stg.equals("5")) {
                this.cmbDist.setDisable(false);
            } else {
                this.cmbDist.setDisable(true);
            }
        });
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    protected void onRefChange() {
        this.changeUnit();
    }

    protected void onMktItemChange() {
        if (this.ccsModel.isBidAskPrice()) {
            this.ccsModel.setBidAskPrice();
        }
        this.check();
        RefItem ref = (RefItem)this.txtCode.getUserData();
        if (ref != null) {
            this.lbOfferPrice.setText(String.valueOf(ref.getPriceUnit()));
            this.ctrlPrice.setUnit(ref.getPriceUnit());
            this.ctrlPrice.setScale(ref.getScale());
            this.algoNode.ctrlPriceUp.setScale(ref.getScale());
            this.algoNode.ctrlPriceLow.setScale(ref.getScale());
        } else {
            this.lbOfferPrice.setText("");
        }
        this.lbLatest.setText(StringUtils.toStr((double)this.mktItem.getNowPrice(), (int)this.mktItem.getRefItem().getScale()));
        this.tableMarketBuy.layout();
        this.tableMarketSell.layout();
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    protected void onBSChange(Boolean old, Boolean now) {
        boolean isClear = this.ccsModel.getMI().isClear();
        if (now.booleanValue()) {
            this.btnOrder.setText(this.buySymbol);
            this.lbCan.setText("\u53ef\u4e70");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.lbRateWay.setText("\u5356\u51fa\u6c47\u7387");
            this.lbExchangeRate.setText(isClear ? "" : RefItem.getAskRate());
        } else {
            this.btnOrder.setText(this.sellSymbol);
            this.lbCan.setText("\u53ef\u5356");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.lbRateWay.setText("\u4e70\u5165\u6c47\u7387");
            this.lbExchangeRate.setText(isClear ? "" : RefItem.getBidRate());
        }
        this.ccsModel.setBuy(now);
        if (this.algoNode.cmbAlgo.getSelectionModel().getSelectedItem() != null && ((Algorithm)this.algoNode.cmbAlgo.getSelectionModel().getSelectedItem()).getType() != 10 && ((Algorithm)this.algoNode.cmbAlgo.getSelectionModel().getSelectedItem()).getType() != 11) {
            this.algoNode.buyRadio.setSelected(now.booleanValue());
            this.algoNode.sellRadio.setSelected(now == false);
        }
        this.layout();
    }

    protected void onPriceTypeChange() {
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        this.hideShow();
    }

    private void hideShow() {
        if (this.cmbPriceType.getValue() == null) {
            return;
        }
        if (((MxNode)this.cmbPriceType.getValue()).is("49")) {
            this.cmbPriceTypeMkt.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("0")) {
            this.cmbPriceTypeBidAsk.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else {
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(true);
        }
    }

    private void onCountStgChange() {
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCode.setText(txtCode.getText());
        this.algoNode.txtCode.setText(txtCode.getText());
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.doChange(refItem, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void setPrePrice() {
        if (this.ccsModel.isMktPrice() && !this.priceSettle) {
            this.ccsModel.setMktPrice();
            if (this.ccsModel.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
        if (this.ccsModel.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
        this.ccsModel.setPrice(this.preModel.getDefPrice(this.buyRadio.isSelected()));
        if (this.preModel.getDefPrice(this.buyRadio.isSelected()) != 0.0) {
            this.priceSettle = true;
        }
    }

    protected void doChange(RefItem refItem, String newText) {
        this.ccsModel.getMI().setRefItem(refItem);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        if (this.ccsModel.isValidRef()) {
            this.ctrlPrice.setScale(refItem.getScale());
        }
        this.ccsModel.onSecChange();
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
        if (refItem != null) {
            boolean isRepo = refItem.getType().equals("REPO");
            this.buyRadio.setText(isRepo ? "\u6b63\u56de\u8d2d" : "\u4e70");
            this.sellRadio.setText(isRepo ? "\u9006\u56de\u8d2d" : "\u5356");
            this.txtCode.setText(refItem.getCode());
            this.algoNode.buyRadio.setText(isRepo ? "\u6b63\u56de\u8d2d" : "\u4e70");
            this.algoNode.sellRadio.setText(isRepo ? "\u9006\u56de\u8d2d" : "\u5356");
            this.algoNode.txtCode.setText(refItem.getCode());
            MEvent event = new MEvent();
            event.put((Object)"code", (Object)this.mktItem.getRefItem().getCode());
            event.put((Object)"market", (Object)this.mktItem.getRefItem().getMarket());
            this.es.postEvent("code_change", event);
            this.lbOfferCount.setText(String.valueOf(refItem.getBuyUnit()));
            String rate = this.buyRadio.isSelected() ? RefItem.getAskRate() : RefItem.getBidRate();
            this.lbExchangeRate.setText(rate);
        } else {
            this.lbOfferCount.setText("");
            this.lbExchangeRate.setText("");
        }
        this.checkQuota(refItem);
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (newText.length() >= 5) {
            this.check();
        }
        this.algoNode.doChange(refItem);
        if (this.ccsModel.isValidRef()) {
            this.checkRepo();
            this.priceSettle = false;
            this.setPrePrice();
        }
        this.layout();
    }

    protected void checkRepo() {
        if ("REPO".equals(this.ccsModel.getValidRef().getType())) {
            this.countStg.getSelectionModel().selectFirst();
            this.countStg.setDisable(true);
        } else {
            this.countStg.setDisable(false);
        }
    }

    protected void onPriceTypeLimitedChange(MxNode newV) {
        if (newV == null) {
            return;
        }
        if (newV.getNode("3") == null) {
            return;
        }
        if (newV.is("3")) {
            this.priceSpn.getEditor().clear();
        }
    }

    protected void offerWayDisableBind() {
    }

    protected void quantityDisableBind() {
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getCountStg().is("1"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
    }

    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.isLimitPrice() && !this.ccsModel.isAfterHoursPrice() || this.ccsModel.isUnlimited(), (Observable[])new Observable[]{this.ccsModel.priceStgProperty(), this.ccsModel.priceTypeLimitedStgProperty()}));
    }

    protected void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return true;
            }
            if (!(((MxNode)this.cmbPriceType.getValue()).is("50") || ((MxNode)this.cmbPriceType.getValue()).is("0") || ((MxNode)this.cmbPriceType.getValue()).is("99"))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
        this.hboxProtectedPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return false;
            }
            if (((MxNode)this.cmbPriceType.getValue()).is("49") && this.ccsModel.isStar()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty(), this.mktItem.changedProperty()}));
    }

    private void check() {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (InstructionHkwolunBasePart.this.txtCode.getText().length() < 5) {
                    return;
                }
                RefItem ref = InstructionHkwolunBasePart.this.mktItem.getRefItem();
                Platform.runLater(() -> {
                    if (ref == null || ref.getName().equals("") || InstructionHkwolunBasePart.this.ccsModel.getValidRef() == null) {
                        InstructionHkwolunBasePart.this.lbName.setText(InstructionHkwolunBasePart.INVALID_CODE);
                    } else if (InstructionHkwolunBasePart.this.mktItem.getStop().getValue().booleanValue()) {
                        InstructionHkwolunBasePart.this.lbName.setText(InstructionHkwolunBasePart.this.mktItem.getStatus());
                    } else {
                        InstructionHkwolunBasePart.this.lbName.setText(ref.getName());
                    }
                });
            }
        };
        timer.schedule(task, 500L);
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    private void changeUnit() {
        this.lbUnit.setText("");
        this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit());
        if (this.ccsModel.isBond()) {
            if ("1".equals(this.preModel.getUnit())) {
                if (this.ccsModel.isSHbond()) {
                    this.lbUnit.setText("\u624b");
                } else {
                    this.lbUnit.setText("\u5f20");
                }
            } else if ("2".equals(this.preModel.getUnit())) {
                this.lbUnit.setText("\u624b");
                if (!this.ccsModel.isSHbond()) {
                    this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit() / 10);
                }
            } else if ("3".equals(this.preModel.getUnit())) {
                this.lbUnit.setText("\u5f20");
                if (this.ccsModel.isSHbond()) {
                    this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit() * 10);
                }
            }
        }
        if (this.ccsModel.isBond()) {
            if (this.ccsModel.isSHbond()) {
                this.lbUnit.setText("\u624b");
            } else {
                this.lbUnit.setText("\u5f20");
            }
        }
        if (this.ccsModel.isStock()) {
            this.lbUnit.setText("\u80a1");
        }
        if (this.ccsModel.isFund()) {
            this.lbUnit.setText("\u4efd");
        }
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.ccsModel.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.ccsModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.ccsModel.getCount() >= 0L && this.ccsModel.getAccDisModel().isCountValid() != false, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip6 = "\u4fdd\u62a4\u4ef7\u683c\u9700\u8981\u5927\u4e8e0\uff0c\u5c0f\u4e8e1\u4e07\u5143\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
        return this.alert.check(!this.ccsModel.isStar() || !this.ccsModel.isMktPrice() || this.ccsModel.isStar() && this.ccsModel.getPriceProtected() > 0.0 && this.ccsModel.getPriceProtected() < 10000.0, Alert.AlertType.WARNING, tip6);
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(!this.ccsModel.isLimitPrice() && !this.ccsModel.isAfterHoursPrice() || this.ccsModel.isUnlimited() || this.ccsModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (CcsAccountDistribution acc : this.ccsModel.getAccDisModel().getValidSecAcc()) {
            info.append("\n\u8d26\u53f7   " + acc.getSecAcc().getInverstorSecId() + " \u59d4\u6258\u6570\u91cf   " + acc.getCount());
        }
        return info.toString();
    }

    /*
     * Unable to fully structure code
     */
    @FXML
    public void order() {
        this.ccsModel.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            if (this.ccsModel.isStar() && this.ccsModel.isMktPrice() && this.mktItem.getUpLimitPrice() > 0.0 && this.ccsModel.getPriceProtected() > this.mktItem.getUpLimitPrice() && !this.alert.alert(Alert.AlertType.CONFIRMATION, "\u60a8\u8f93\u5165\u7684\u4fdd\u62a4\u4ef7\u683c\u5927\u4e8e\u6da8\u505c\u4ef7\u683c\uff0c\u662f\u5426\u7ee7\u7eed\u59d4\u6258\uff1f")) {
                return;
            }
            if (this.preModel.isPopBeforeOrder()) {
                this.ccsModel.getFundTraderMap().clear();
                this.ccsModel.getInsExpiredMap().clear();
                entrusts = this.ccsModel.getEntrustList(false);
                if ("2".equals(this.ccsModel.getAccDisModel().getInstructType()) || "1".equals(this.ccsModel.getAccDisModel().getInstructType())) {
                    for (CcsSingleEntrust en : entrusts) {
                        workFlow = this.ccsModel.getWorkFlowByFundAccount(en.getFundAccount());
                        if (workFlow == null || workFlow.getId() != 3) continue;
                        traderSetting = this.buildTraderSetting(workFlow);
                        this.ccsModel.getFundTraderMap().put(en.getFundAccount(), traderSetting);
                    }
                }
                try {
                    obj = (CcsEntrustConfirmDialog)this.of.create(CcsEntrustConfirmDialog.class);
                    if (!"0".equals(this.ccsModel.getAccDisModel().getInstructType()) && !"4".equals(this.ccsModel.getAccDisModel().getInstructType())) {
                        obj.setIsInstruction(true);
                    } else {
                        obj.setExecution(true);
                    }
                    if (this.ccsModel.getInstruction() != null) {
                        obj.setShowWarning(this.ccsModel.getInstruction().isFrozen() == false);
                    }
                    obj.setInstructionPanelType(this.ccsModel.getAccDisModel().getInstructType());
                    obj.setFundTraderMap(this.ccsModel.getFundTraderMap());
                    obj.setInsExpiredMap(this.ccsModel.getInsExpiredMap());
                    obj.setBuySymbol(this.getBuySymbol());
                    obj.setSellSymbol(this.getSellSymbol());
                    obj.setRefItem(this.mktItem.getRefItem());
                    obj.setPriceStg(this.ccsModel.getPriceStg());
                    obj.setPriceTypeMktStg(this.ccsModel.getPriceTypeMktStg());
                    obj.setPriceTypeLimitedStg(this.ccsModel.getPriceTypeLimitedStg());
                    obj.setPriceTypeBidAskStg(this.ccsModel.getPriceTypeBidAskStg());
                    obj.setUnit(this.lbUnit.getText());
                    obj.setHkwolun(true);
                    obj.setBuy(this.buyRadio.isSelected());
                    obj.setList(entrusts);
                    dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) != false ? "\u4e0b\u5355\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
                    if (dialog.launch() != ButtonType.OK) ** GOTO lbl52
                    if (this.ccsModel.getInstruction() != null) {
                        this.ccsModel.getInstruction().setPostil(obj.getPostil());
                    }
                    this.ccsModel.setPostil(obj.getPostil());
                    this.submitOrder();
                }
                finally {
                    this.ccsModel.getFundTraderMap().clear();
                    this.ccsModel.getInsExpiredMap().clear();
                }
            } else {
                this.submitOrder();
            }
        }
lbl52:
        // 5 sources

        this.layout();
    }

    protected void submitOrder() {
        try {
            ObservableList<Boolean> listCont = this.doAction();
            if (listCont.filtered(each -> each == false).size() > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            } else {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        this.clearCountCheck();
    }

    protected ObservableList<Boolean> doAction() throws MException {
        return this.ccsModel.submit((TreeItem<CcsAccountDistribution>)this.ccsModel.getAccDisModel().getRoot());
    }

    protected void clearCountCheck() {
        if (this.preModel.isClearAfterOrder()) {
            this.clearCountCheckForce();
        }
    }

    protected void clearCountCheckForce() {
        switch (this.ccsModel.getCountStg().getRaw()) {
            case "5": {
                this.ccsModel.setMoney(0.0);
                break;
            }
            case "1": {
                this.ccsModel.setCount(0L);
                break;
            }
            default: {
                this.ccsModel.setCountPer(0.0);
            }
        }
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            if (this.ccsModel.isLimitPrice()) {
                this.priceSpn.requestFocus();
                this.preModel.selectTwoOrAllPriceDecimal();
            } else if (this.ccsModel.isMktPrice() && this.ccsModel.isStar()) {
                this.protectedPriceSpn.requestFocus();
                this.preModel.selectTwoOrAllProtectedPriceDecimal();
            } else {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("2")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("3")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("4")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("5")) {
                this.moneySpn.requestFocus();
                this.moneySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.order();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    private void cmbStgKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        }
    }

    protected boolean onMktItemClicked(HandicapInfo now) {
        if (this.tabNormal.isSelected()) {
            this.setPrice(now.getPrice());
        } else {
            this.algoNode.setPrice(now.getPrice());
        }
        return false;
    }

    public void setPrice(double price) {
        if (this.tabAlgo.isSelected()) {
            this.algoNode.setPrice(price);
            return;
        }
        if ((this.ccsModel.isLimitPrice() || this.ccsModel.isAfterHoursPrice()) && !this.ccsModel.isUnlimited() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.ccsModel.setPrice(price);
        } else {
            if (this.ccsModel.isMktPrice() || this.ccsModel.isBidAskPrice()) {
                return;
            }
            this.priceSpn.getEditor().setText("");
        }
    }

    private AppointedTraderSetting buildTraderSetting(WorkFlowDescriptor workFlow) {
        AppointedTraderSetting traderSettings = new AppointedTraderSetting();
        List postIds = ((AccntStepAttribute)workFlow.getSteps().get(workFlow.getSteps().size() - 1)).getObjIds();
        if (postIds == null || postIds.isEmpty()) {
            return traderSettings;
        }
        List users = null;
        try {
            users = this.postMng.getUserList(postIds, this.baseApi.getPartyId(), true);
        }
        catch (MException e) {
            this.logger.error("\u6839\u636e\u804c\u4f4did\uff0c\u67e5\u8be2\u5176\u6240\u6709\u7528\u6237\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (users == null || users.isEmpty()) {
            return traderSettings;
        }
        traderSettings.setUsers(users);
        for (User user : users) {
            traderSettings.getAppointedTraderIds().add(user.getId());
        }
        return traderSettings;
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.canBuyCol.getText() + "\t" + this.canSellCol.getText() + "\t" + this.productCol.getText() + "\t" + '\n');
        for (TreeItem item : this.ccsModel.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getHkAvailable() + "\t" + accDis.getAcc().getAssetAmt() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + accDis.getCanBuy() + "\t" + accDis.getCanSell() + "\t" + accDis.getAcc().getProductName() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + "\t" + secAccDis.getCanSell() + "\t" + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    public TreeTableView<CcsAccountDistribution> getAccTreeTable() {
        return this.acctTreeTable;
    }

    public ITradeModel getModel() {
        return this.ccsModel;
    }

    public InstructionCcsBaseModel createModel() {
        return (InstructionCcsBaseModel)this.of.create(InstructionCcsBaseModel.class);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public void initUserPre() {
        this.preModel.setType("5", "200058");
        this.preModel.setPart(this);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    public void checkQuota(RefItem item) {
        this.lbPosAmt.textProperty().unbind();
        this.lbInitAmt.setText("");
        this.lbPosAmt.setText("");
        if (item == null) {
            return;
        }
        MxNode node = (MxNode)this.cmbMarket.getSelectionModel().getSelectedItem();
        if ("SHSC".equals(node.getRaw())) {
            this.lbInitAmt.setText(MarketItem.getInitAmtSh());
            this.lbPosAmt.textProperty().bind((ObservableValue)MarketItem.posAmtShProperty());
        } else {
            this.lbInitAmt.setText(MarketItem.getInitAmtSz());
            this.lbPosAmt.textProperty().bind((ObservableValue)MarketItem.posAmtSzProperty());
        }
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Double> getProtectedPriceSpn() {
        return this.protectedPriceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public Spinner<Double> getMoneySpn() {
        return this.moneySpn;
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Label getLbAmountOne() {
        return this.lbAmountOne;
    }

    public Label getLbAmountTwo() {
        return this.lbAmountTwo;
    }

    public Label getLbAmountThree() {
        return this.lbAmountThree;
    }

    public Label getLbAmountFour() {
        return this.lbAmountFour;
    }

    public Label getLbTotalOne() {
        return this.lbTotalOne;
    }

    public Label getLbTotalTwo() {
        return this.lbTotalTwo;
    }

    public Label getLbTotalThree() {
        return this.lbTotalThree;
    }

    public Label getLbTotalFour() {
        return this.lbTotalFour;
    }

    public Label getLbCanbuyOne() {
        return this.lbCanbuyOne;
    }

    public Label getLbCanbuyTwo() {
        return this.lbCanbuyTwo;
    }

    public Label getLbCanbuyThree() {
        return this.lbCanbuyThree;
    }

    public Label getLbCanbuyFour() {
        return this.lbCanbuyFour;
    }

    public Label getLbCansellOne() {
        return this.lbCansellOne;
    }

    public Label getLbCansellTwo() {
        return this.lbCansellTwo;
    }

    public Label getLbCansellThree() {
        return this.lbCansellThree;
    }

    public Label getLbCansellFour() {
        return this.lbCansellFour;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStg.getValue();
    }

    public void setCount(Long buyQuantity) {
        this.ccsModel.setCount(buyQuantity);
    }

    public void setMoney(double value) {
        this.ccsModel.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.ccsModel.setCountPer(value);
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setAutoSlice(boolean slice, long size) {
        this.ccsModel.setAutoSlice(slice);
        this.ccsModel.setSliceSize(size);
    }

    public RefItem getValidRef() {
        return this.ccsModel.getValidRef();
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    public boolean getActiveFlag() {
        return this.ccsModel.getAccDisModel().isActive();
    }

    public InstructionHkwolunBaseModel getInstructionCcsBaseModel() {
        return this.ccsModel;
    }

    public boolean isHkwolumn(String market) {
        return "SHSC".equals(market) || "SZSC".equals(market);
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class NumberCell
    extends NumberTreeTableCell<CcsAccountDistribution> {
        public NumberCell() {
            super(2);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

