/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.hk;

import cms.tmx.instructions.viewers.hk.InstructionHkBasePart;
import cms.tmx.instructions.viewers.hk.LoadPartModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.api.ITradePart;
import java.net.URL;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javax.inject.Inject;

public class InstructionUSAHkBasePart
extends InstructionHkBasePart
implements ITradePart {
    @FXML
    protected ComboBox<MxNode> cmbMarket;
    @Inject
    protected LoadPartModel load;

    @Inject
    public InstructionUSAHkBasePart() {
    }

    @Override
    public void initialize() {
        this.initMarket();
        this.model.setMarketStr("XHKG");
        this.model.create("0");
        this.setBuySymbol("\u4e70\u5165");
        this.setSellSymbol("\u5356\u51fa");
        this.setUSA(false);
        super.initialize();
        this.cmbPriceTypeLimited.valueProperty().unbindBidirectional(this.model.priceTypeLimitedStgProperty());
        MxNode node = MxNodeFactory.create((String)"cstr_price_type_limited", (String)"2");
        node.removeOthers("2");
        this.cmbPriceTypeLimited.setItems(node.getNodes());
        this.cmbPriceTypeLimited.setValue((Object)node.getNode("2"));
        this.mktItem.changedProperty().addListener(ob -> this.setPrePrice());
    }

    private void initMarket() {
        MxNode node = MxNodeFactory.create((String)"hk_market_code", (String)"XHKG");
        this.cmbMarket.setItems(node.getNodes());
        this.cmbMarket.setValue((Object)node);
        this.cmbMarket.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null && !now.equals(old)) {
                this.setMarket(now.getRaw());
                this.model.setMarketStr(now.getRaw());
                this.spCode.setAllSuggestions(this.refMng.getItems(new String[]{"STOCK" + this.getMarket()}));
                this.txtCode.clear();
                this.txtCode.setUserData(null);
                this.model.setMarketStr(now.getValue());
                this.onSecurityChange(this.txtCode, "");
            }
        });
        this.cmbMarket.valueProperty().bindBidirectional(this.model.marketProperty());
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(this.model.isMktPrice() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    public boolean valid() {
        return true;
    }
}

