/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.hk;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.utils.JAXB;
import cms.tmx.core.utils.PageXml;
import cms.tmx.core.utils.XmlConfig;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.define.BsDict;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.instructions.models.regular.InstructionCcsBaseModel;
import cms.tmx.instructions.models.regular.InstructionHkBaseModel;
import cms.tmx.instructions.models.regular.UserPreCtrlHk;
import cms.tmx.instructions.viewers.hk.AlgoNodeInstructionHk;
import cms.tmx.instructions.viewers.hk.LoadPartModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.neeq.view.NeeqEntrustConfirmDialog;
import cms.tmx.query.current.models.HkwolunUnfinishedOrderModel;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.api.ITradePart;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.INewRefMng;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class InstructionHkBasePart
extends MxPart
implements ITradePart {
    @FXML
    protected HBox hboxAlgo;
    @Inject
    public AlgoNodeInstructionHk algoNode;
    @FXML
    protected TabPane tabPane;
    @FXML
    protected Tab tabNormal;
    @FXML
    protected Tab tabAlgo;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    protected ComboBox<MxNode> cmbTif;
    @FXML
    protected TextField txtCode;
    @FXML
    protected GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    protected Label lbSide;
    @FXML
    protected RadioButton buyRadio;
    @FXML
    protected RadioButton sellRadio;
    @FXML
    protected RadioButton sellShortRadio;
    @FXML
    protected StackPane stkPaneCommon;
    @FXML
    protected ComboBox<MxNode> countStg;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeMkt;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeAfterHours;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    private Label lbPer;
    @FXML
    private Label lbPerSymbol;
    @FXML
    private TextField txtPerCount;
    @FXML
    protected Spinner<Double> moneySpn;
    @FXML
    private Label lbRate;
    @FXML
    protected Label lbOfferPrice;
    @FXML
    private Label lbOfferCount;
    @FXML
    protected Label lbLatest;
    @FXML
    protected Label lbNewPrice;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, CcsFundAccount> counterCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canSellCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    protected Label lbCountFive;
    @FXML
    protected Label lbCountSix;
    @FXML
    protected Label lbCountSeven;
    @FXML
    protected Label lbCountEight;
    @FXML
    private Label lbAmountOne;
    @FXML
    private Label lbAmountTwo;
    @FXML
    private Label lbAmountThree;
    @FXML
    private Label lbAmountFour;
    @FXML
    private Label lbTotalOne;
    @FXML
    private Label lbTotalTwo;
    @FXML
    private Label lbTotalThree;
    @FXML
    private Label lbTotalFour;
    @FXML
    private Label lbCanbuyOne;
    @FXML
    private Label lbCanbuyTwo;
    @FXML
    private Label lbCanbuyThree;
    @FXML
    private Label lbCanbuyFour;
    @FXML
    private Label lbCansellOne;
    @FXML
    private Label lbCansellTwo;
    @FXML
    private Label lbCansellThree;
    @FXML
    private Label lbCansellFour;
    @FXML
    private HBox hboxCounts;
    @FXML
    private Label priceMag;
    @FXML
    private Label amtMag;
    @FXML
    private Label qtyMag;
    @FXML
    private HBox hboxPer;
    @FXML
    private HBox hboxMoney;
    @FXML
    private HBox hboxCommAmount;
    @FXML
    private HBox hboxTotalAsset;
    @FXML
    private HBox hboxCanbuy;
    @FXML
    private HBox hboxCansell;
    @FXML
    private TableView<HandicapInfo> tableHKMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount1;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private TableView<HandicapInfo> tableHKMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount1;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, String> accntNameCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> posiCapitalCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> buyCostCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> floatPlCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> realPlCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> totalPlCol;
    @FXML
    private HBox hbSum;
    @FXML
    private Label lbNum;
    @FXML
    private Label lbPosiAmt;
    @FXML
    private Label lbPosiCapital;
    @FXML
    private Label lbFloatPL;
    @FXML
    private Label lbRealPl;
    @FXML
    private Label lbTotalPl;
    @FXML
    protected Button btnOrder;
    @FXML
    protected CheckBox checkBoxModify;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected INewRefMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected InstructionHkBaseModel model;
    @Inject
    protected UserPreCtrlHk preModel;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    @Inject
    protected IUIService uiService;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected MarketItem mktItem;
    private SecConverter secCvt;
    protected String confirmSymbol = "";
    protected boolean priceSettle = false;
    boolean orderMessage = true;
    private boolean isUSA = true;
    protected ObSimpleInstruction instruction = null;
    @Inject
    private HkwolunUnfinishedOrderModel unfinishedModel;
    @Inject
    private ExecutorService exe;
    @Inject
    private JAXB jaxb;
    protected Map<String, List<CcsOrder>> map;
    private String market;
    private String partId;
    protected boolean childPage = false;
    protected boolean saveNum = false;
    public AtomicBoolean initFinished = new AtomicBoolean(false);
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {
        ObservableList list = this.unfinishedModel.getList();
        this.map = list.stream().collect(Collectors.groupingBy(t -> t.getInstrument().getSecId()));
        this.MonitOnRefChange();
    });
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleSpinnerCtrl ctrlMoney = new DoubleSpinnerCtrl(true, 12, 2);
    protected SecSuggest spCode = new SecSuggest();
    protected AutoCompletion<RefItem> autoCompletionNormal;
    protected AutoCompletion<RefItem> autoCompletionAlgo;
    private MEventHandler hSetPst = event -> {
        if ("2".equals(this.model.getAccDisModel().getInstructType()) || "3".equals(this.model.getAccDisModel().getInstructType())) {
            return;
        }
        if (this.autoCompletionAlgo == null || this.autoCompletionNormal == null) {
            return;
        }
        String market = event.getStr("tMarket");
        if (!BsDict.HKUSA_MARKET.contains(market)) {
            return;
        }
        MxNode node = MxNodeFactory.create((String)"hk_market_code", (String)"XHKG");
        node.setRaw(event.getStr("tMarket"));
        String secCode = event.getStr("sec_code");
        this.txtCode.setText(secCode);
        RefItem item = this.refMng.getItem("STOCK" + this.getMarket(), market, secCode);
        this.txtCode.setUserData((Object)item);
        this.model.setPstAcct(event.getStr("secAccount"), event.getStr("tMarket"));
        this.sellRadio.setSelected(event.getBool("side_sell"));
        if (this.tabAlgo.isSelected()) {
            this.autoCompletionAlgo.setChange(secCode);
            this.onSecurityChange(this.algoNode.getTxtCode(), secCode);
        } else {
            this.autoCompletionNormal.setChange(secCode);
            this.onSecurityChange(this.txtCode, secCode);
        }
        this.model.setCount(event.getLong("count"));
        this.model.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
    };
    private InvalidationListener listener = ob -> {
        Collection list = this.refMng.getItems(new String[]{"STOCK" + this.getMarket()});
        this.spCode.setAllSuggestions(list);
    };
    String element = "";
    protected boolean tabChange = false;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    public String sellShortSymbol = "\u5356\u7a7a";
    private ListChangeListener<TreeItem<CcsAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    checkBox.setDisable(!InstructionHkBasePart.this.model.getAccDisModel().isActive());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(InstructionHkBasePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> InstructionHkBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem));
                        InstructionHkBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                InstructionHkBasePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> InstructionHkBasePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(((CcsAccountDistribution)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };
    @Inject
    protected LoadPartModel load;

    @Inject
    public InstructionHkBasePart() {
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener(this.listenerUnfinish);
        this.unfinishedModel.changedProperty().addListener(this.listenerUnfinish);
        this.exe.execute(() -> {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                this.logger.error("\u521d\u59cb\u5316\u4ea4\u6613\u9762\u677f\u67e5\u8be2\u59d4\u6258\u5931\u8d25", (Throwable)e);
            }
            this.unfinishedModel.query();
        });
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            List<CcsOrder> orders = this.map.get(this.mktItem.getRefItem().getCode());
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CcsOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
        }
    }

    public void onShowEvent(MEvent event) {
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("trade.panel.set.code", this.hSetPst);
        this.mktItem.changedProperty().removeListener(this.listenerUnfinish);
        this.unfinishedModel.changedProperty().removeListener(this.listenerUnfinish);
    }

    public void clearPageId() {
        XmlConfig formXML = this.jaxb.getFormXML();
        for (PageXml page : formXML.getPage()) {
            page.setPageId("");
        }
        this.jaxb.writeXML();
    }

    @FXML
    public void initialize() {
        this.orderMessage = this.preModel.isPopBeforeOrder();
        this.setMarket("XHKG");
        this.algoNode.setBaseModel(this.model);
        this.mktItem = this.model.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> Platform.runLater(() -> this.onRefChange()));
        this.mktItem.changedProperty().addListener(ob -> Platform.runLater(() -> this.onMktItemChange()));
        this.refMng.changedProperty().addListener(this.listener);
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTree();
        if (this.isUSA() && "0".equals(this.model.getAccDisModel().getInstructType())) {
            this.initPage();
            this.openMulti();
        }
        this.es.subscribe("trade.panel.set.code", this.hSetPst);
        this.hboxAlgo.getChildren().add((Object)this.algoNode.getContent());
    }

    private void openMulti() {
        String id = "cms.tmx.stock.cp.hk.trade.instruction";
        MEvent event = new MEvent();
        event.putStr("part_name", (Object)"\u81ea\u5b9a\u4e49\u9762\u677f");
        event.putStr("id", (Object)id);
        XmlConfig formXML = this.jaxb.getFormXML();
        this.logger.info("\u6e2f\u80a1xml\uff1a" + formXML);
        if (formXML == null) {
            return;
        }
        if (this.childPage) {
            return;
        }
        this.es.sendEvent("ui.navigate.multi_open.hk", event);
        this.logger.info("\u6e2f\u80a1\u53d1\u9001\u591a\u5f00\u8bf7\u6c42");
    }

    private void initPage() {
        XmlConfig formXML = this.jaxb.getFormXML();
        this.logger.info(String.valueOf(this.partId) + "\u6e2f\u80a1xml\uff1a" + formXML);
        if (formXML == null) {
            return;
        }
        this.element = (String)InstructionHkBasePart.getPartHKMap().get(((Object)((Object)this)).toString());
        this.xmlAcc(formXML);
        for (PageXml page : formXML.getPage()) {
            if ("".equals(page.getPageId())) break;
            if (!((Object)((Object)this)).toString().equals(page.getPageId().split("=")[0]) && !page.getPageId().split("=")[1].equals(this.partId)) continue;
            this.preModel.self = true;
            this.preModel.getCommonQuantity()[0].set(Integer.valueOf(page.getOne()).intValue());
            this.preModel.getCommonQuantity()[1].set(Integer.valueOf(page.getTwo()).intValue());
            this.preModel.getCommonQuantity()[2].set(Integer.valueOf(page.getThree()).intValue());
            this.preModel.getCommonQuantity()[3].set(Integer.valueOf(page.getFour()).intValue());
            this.preModel.getCommonQuantity()[4].set(Integer.valueOf(page.getFive()).intValue());
            this.preModel.getCommonQuantity()[5].set(Integer.valueOf(page.getSix()).intValue());
            this.preModel.getCommonQuantity()[6].set(Integer.valueOf(page.getSeven()).intValue());
            this.preModel.getCommonQuantity()[7].set(Integer.valueOf(page.getEight()).intValue());
            this.saveNum = "1".equals(page.getSaveNum());
            this.orderMessage = "1".equals(page.getOrdMessage());
            break;
        }
    }

    private void xmlAcc(XmlConfig formXML) {
        if (formXML == null) {
            return;
        }
        for (PageXml page : formXML.getPage()) {
            if ("".equals(page.getPageId())) break;
            if (!((Object)((Object)this)).toString().equals(page.getPageId().split("=")[0]) && !page.getPageId().split("=")[1].equals(this.partId)) continue;
            this.childPage = true;
            String cashId = page.getCashId();
            if (cashId == null) break;
            this.checkAcc(cashId);
            break;
        }
    }

    private void checkAcc(String cashId) {
        Map mapSecDisMxList = this.model.getAccDisModel().getMapSecDisMxList();
        MxTreeList accMxList = this.model.getAccDisModel().getAccMxList();
        mapSecDisMxList.keySet().forEach(each -> {
            for (CcsAccountDistribution sub : ((MxTreeList)mapSecDisMxList.get(each)).getOrList()) {
                if (!sub.getSecAcc().getInverstorId().equals(cashId)) continue;
                accMxList.getOrList().filtered(pd -> pd.isShow()).forEach(accEach -> {
                    if (accEach.getAcc().getExtAccntId().equals(each)) {
                        sub.setSelected(true);
                        accEach.setSelected(true);
                    }
                });
            }
        });
    }

    protected void initControls() {
        this.checkBoxModify.setVisible(false);
        this.checkBoxModify.setDisable(true);
        this.model.normalProperty().bind((ObservableValue)this.tabNormal.selectedProperty());
        this.tabNormal.selectedProperty().addListener((ob, old, now) -> {
            this.tabChange = true;
            if (!now.booleanValue()) {
                this.algoNode.onBSChangeNormal(((RadioButton)this.group.getSelectedToggle()).getId());
                this.algoNode.txtCode.setUserData(this.txtCode.getUserData());
                this.autoCompletionAlgo.setChange(this.txtCode.getText());
            } else {
                this.buyRadio.setSelected(this.algoNode.buyRadio.isSelected());
                this.sellRadio.setSelected(this.algoNode.sellRadio.isSelected());
                this.sellShortRadio.setSelected(this.algoNode.sellShortRadio.isSelected());
                this.txtCode.setUserData(this.algoNode.txtCode.getUserData());
                this.autoCompletionNormal.setChange(this.algoNode.getTxtCode().getText());
            }
        });
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.refMng.getItems(new String[]{"STOCK" + this.getMarket()}));
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (this.tabChange) {
                this.tabChange = false;
                return;
            }
            this.onSecurityChange(this.txtCode, (String)newV);
            this.tableHKMarketBuy.refresh();
            this.tableHKMarketSell.refresh();
            this.acctTreeTable.refresh();
            this.layout();
        }));
        this.autoCompletionAlgo = Search.bindAutoCompletion((TextField)this.algoNode.getTxtCode(), (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionAlgo.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (this.tabChange) {
                this.tabChange = false;
                return;
            }
            this.onSecurityChange(this.algoNode.getTxtCode(), (String)newV);
            this.tableHKMarketBuy.refresh();
            this.tableHKMarketSell.refresh();
            this.acctTreeTable.refresh();
            this.layout();
        }));
        this.cmbTif.setItems(this.model.getTif().getNodes());
        this.cmbTif.valueProperty().bindBidirectional(this.model.tifProperty());
        this.cmbTif.setValue((Object)this.model.getTif());
        this.cmbTif.setDisable(true);
        this.offerWayDisableBind();
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 5)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        TooltipUtil.bind((Label)this.lbName);
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.sellShortRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBChange((Boolean)old, (Boolean)now));
        this.sellRadio.selectedProperty().addListener((ob, old, now) -> this.onSChange((Boolean)old, (Boolean)now));
        this.sellShortRadio.selectedProperty().addListener((ob, old, now) -> this.onSSChange((Boolean)old, (Boolean)now));
        this.buyRadio.setSelected(true);
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.onPriceTypeChange());
        this.cmbPriceTypeLimited.setItems(this.model.getPriceTypeLimitedStg().getNodes());
        this.cmbPriceTypeLimited.valueProperty().bindBidirectional(this.model.priceTypeLimitedStgProperty());
        this.cmbPriceTypeLimited.valueProperty().addListener((ob, old, newV) -> this.onPriceTypeLimitedChange((MxNode)newV));
        this.cmbPriceTypeMkt.setItems(this.model.getPriceTypeMktStg().getNodes());
        this.cmbPriceTypeMkt.valueProperty().bindBidirectional(this.model.priceTypeMktStgProperty());
        this.cmbPriceTypeBidAsk.setItems(this.model.getPriceTypeBidAskStg().getNodes());
        this.cmbPriceTypeBidAsk.valueProperty().bindBidirectional(this.model.priceTypeBidAskStgProperty());
        this.cmbPriceTypeAfterHours.setItems(this.model.getPriceTypeAfterHours().getNodes());
        this.cmbPriceTypeAfterHours.valueProperty().bindBidirectional(this.model.priceTypeAfterHoursProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().setText("");
        this.priceSpn.valueProperty().addListener((ob, old, newV) -> this.scaleAndUnit("" + newV));
        this.priceSpn.getEditor().textProperty().addListener((ob, old, newV) -> this.scaleAndUnit((String)newV));
        this.priceDisableBind();
        this.txtCodeDisable();
        this.cmbTifDisable();
        this.priceVisibleBind();
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        SpinnerUtils.arrowsStyle(this.moneySpn);
        TextFieldUtils.showMagnitude((Label)this.amtMag, (TextField)this.moneySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.quantitySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.priceMag, (TextField)this.priceSpn.getEditor());
        this.setPriceUnit();
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantityDisableBind();
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> Platform.runLater(() -> this.quantityKeyPress((KeyEvent)event)));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.countStg.setItems(this.model.getCountStg().getNodes());
        this.countStg.valueProperty().addListener((ob, old, now) -> this.onCountStgChange());
        this.countStg.valueProperty().bindBidirectional(this.model.countStgProperty());
        this.countStg.addEventFilter(KeyEvent.KEY_RELEASED, event -> this.cmbStgKeyPress((KeyEvent)event));
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxPer.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("3") || this.model.getCountStg().is("2") || this.model.getCountStg().is("4"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        TextFieldUtils.setLess100((TextField)this.txtPerCount);
        MxBindings.bindSD((Property)this.txtPerCount.textProperty(), (Property)this.model.countPerProperty());
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
        this.ctrlMoney.ctrl(this.moneySpn);
        this.moneySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.txtPerCount.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        MxBindings.bindSDTwoScale((Property)this.moneySpn.getEditor().textProperty(), (Property)this.model.moneyProperty());
        this.moneySpn.getEditor().setText(String.format("%1$,.2f", this.model.getMoney()));
        this.hboxCommAmount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("5"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxTotalAsset.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("2"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxCanbuy.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("3"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.hboxCansell.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().getRaw().equals("4"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.checkBoxModify.selectedProperty().bindBidirectional((Property)this.model.canModifyProperty());
    }

    protected void cmbTifDisable() {
    }

    protected void txtCodeDisable() {
    }

    private void scaleAndUnit(String newV) {
        this.lbOfferPrice.setText(String.valueOf(this.model.priceUnit(newV)));
        this.ctrlPrice.setUnit(this.model.priceUnit(newV));
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableHKMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableHKMarketBuy.getColumns().remove(this.indexBuy);
        this.tableHKMarketSell.getColumns().remove(this.indexSell);
        TableUtils.beforeClick(this.tableHKMarketBuy, item -> this.onMktItemClicked((HandicapInfo)item));
        this.tableHKMarketBuy.setItems(this.mktItem.getListHKBuyHandicap());
        this.tableHKMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableHKMarketSell.getItems().size() - this.tableHKMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        TableUtils.beforeClick(this.tableHKMarketSell, item -> this.onMktItemClicked((HandicapInfo)item));
        this.tableHKMarketSell.setItems((ObservableList)this.mktItem.getListHKSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableHKMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbNewPrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbNewPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.lbRate.textProperty());
        this.lbRate.setTooltip(tooltip);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    protected void afterTableRestore() {
        this.canBuyCol.setVisible(true);
        this.canSellCol.setVisible(true);
    }

    protected void createAcctTree() {
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(data -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.counterCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.counterCol.setCellFactory(data -> new CounterCell());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().hkAvailableProperty());
        this.availableCol.setCellFactory(data -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canSellCol.setCellFactory(data -> new NumberTreeTableCell());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty());
        this.assetCol.setCellFactory(data -> new MoneyCell(2));
        this.model.getAccDisModel().repoProperty().addListener((ob, old, newV) -> {
            this.canBuyCol.setVisible(newV == false);
            this.canSellCol.setVisible(newV == false);
        });
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(data -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(data -> new NumberTreeTableCell());
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.acctTreeTable.setRoot(this.model.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.acctTreeTable.getColumns().remove(this.canBuyCol);
        this.acctTreeTable.getColumns().remove(this.canSellCol);
        this.acctTreeTable.getColumns().remove(this.availableCol);
        this.acctTreeTable.getColumns().remove(this.assetCol);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.model.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
        this.checkIsAutotrophy();
    }

    protected boolean isAutotrophy() {
        return false;
    }

    private void checkIsAutotrophy() {
        if (this.isAutotrophy()) {
            this.accntNameCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accntNameProperty());
            this.posiCapitalCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).capitalizationProperty());
            this.posiCapitalCol.setCellFactory(data -> new NumberCell());
            this.buyCostCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).buyCostAmtProperty());
            this.buyCostCol.setCellFactory(data -> new NumberCell());
            this.floatPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).floatPlProperty());
            this.floatPlCol.setCellFactory(data -> new NumberCell());
            this.realPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).realPlProperty());
            this.realPlCol.setCellFactory(data -> new NumberCell());
            this.totalPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).totalPlProperty());
            this.totalPlCol.setCellFactory(data -> new NumberCell());
            MxBindings.bindSD((Property)this.lbNum.textProperty(), (Property)this.model.getAccDisModel().numProperty());
            MxBindings.bindSDTwoScale((Property)this.lbPosiAmt.textProperty(), (Property)this.model.getAccDisModel().buyCostAmtProperty());
            MxBindings.bindSDTwoScale((Property)this.lbPosiCapital.textProperty(), (Property)this.model.getAccDisModel().capitalProperty());
            MxBindings.bindSDTwoScale((Property)this.lbFloatPL.textProperty(), (Property)this.model.getAccDisModel().floatPlProperty());
            MxBindings.bindSDTwoScale((Property)this.lbRealPl.textProperty(), (Property)this.model.getAccDisModel().realPlProperty());
            MxBindings.bindSDTwoScale((Property)this.lbTotalPl.textProperty(), (Property)this.model.getAccDisModel().totalPlProperty());
            this.countStg.setVisible(false);
            this.stkPaneCommon.setVisible(false);
        } else {
            this.acctTreeTable.getColumns().remove(this.accntNameCol);
            this.acctTreeTable.getColumns().remove(this.posiCapitalCol);
            this.acctTreeTable.getColumns().remove(this.buyCostCol);
            this.acctTreeTable.getColumns().remove(this.floatPlCol);
            this.acctTreeTable.getColumns().remove(this.realPlCol);
            this.acctTreeTable.getColumns().remove(this.totalPlCol);
            ((VBox)this.hbSum.getParent()).getChildren().remove((Object)this.hbSum);
        }
    }

    protected void acctTreeSupplement() {
        this.model.countStgProperty().addListener(ob -> this.model.getCountStg().getRaw());
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    protected void onRefChange() {
        this.changeUnit();
    }

    protected void onMktItemChange() {
        if (this.model.isBidAskPrice()) {
            this.model.setBidAskPrice();
        }
        this.check();
        this.lbLatest.setText(StringUtils.toStr((double)this.mktItem.getNowPrice(), (int)this.mktItem.getRefItem().getScale()));
        this.lbNewPrice.setText(StringUtils.toStr((double)this.mktItem.getNowPrice(), (int)this.mktItem.getRefItem().getScale()));
        this.model.updateHandicapInfoList(this.mktItem);
        Platform.runLater(() -> {
            this.tableHKMarketBuy.layout();
            this.tableHKMarketSell.layout();
        });
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public String getSellShortSymbol() {
        return this.sellShortSymbol;
    }

    public void setSellShortSymbol(String sellShortSymbol) {
        this.sellShortSymbol = sellShortSymbol;
    }

    protected void onSChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText(this.sellSymbol);
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
        this.model.setBuy(50);
        this.layout();
    }

    protected void onBChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText(this.buySymbol);
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
        this.model.setBuy(49);
        this.layout();
    }

    protected void onSSChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText(this.sellShortSymbol);
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
        this.model.setBuy(53);
        this.layout();
    }

    protected void onPriceTypeChange() {
        this.priceSpn.getEditor().clear();
        this.hideShow();
    }

    private void hideShow() {
        if (this.cmbPriceType.getValue() == null) {
            return;
        }
        if (((MxNode)this.cmbPriceType.getValue()).is("49")) {
            this.cmbPriceTypeMkt.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("0")) {
            this.cmbPriceTypeBidAsk.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else {
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(true);
        }
    }

    private void onCountStgChange() {
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCode.setText(txtCode.getText());
        this.algoNode.txtCode.setText(txtCode.getText());
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.doChange(refItem, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void setPrePrice() {
        if (this.model.isMktPrice() && !this.priceSettle) {
            this.model.setMktPrice();
            if (this.model.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
        if (this.model.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
        this.model.setPrice(this.preModel.getDefPrice(this.buyRadio.isSelected()));
        if (this.preModel.getDefPrice(this.buyRadio.isSelected()) != 0.0) {
            this.priceSettle = true;
        }
    }

    protected void doChange(RefItem refItem, String newText) {
        this.model.getMI().setRefItem(refItem);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        if (this.model.isValidRef()) {
            this.ctrlPrice.setScale(refItem.getScale());
        }
        this.model.onSecChange();
        this.preModel.onCountStgChange(this.buyRadio.isSelected());
        if (refItem != null) {
            this.txtCode.setText(refItem.getCode());
            this.algoNode.txtCode.setText(refItem.getCode());
            MEvent event = new MEvent();
            event.put((Object)"code", (Object)this.mktItem.getRefItem().getCode());
            event.put((Object)"market", (Object)this.mktItem.getRefItem().getMarket());
            this.es.postEvent("code_change", event);
            this.lbOfferCount.setText(String.valueOf(refItem.getBuyUnit()));
        } else {
            this.lbOfferCount.setText("");
        }
        this.checkQuota(refItem);
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (newText.length() >= 5) {
            this.check();
        }
        this.algoNode.doChange(refItem);
        if (this.model.isValidRef()) {
            this.priceSettle = false;
            this.setPrePrice();
        }
        this.layout();
    }

    protected void onPriceTypeLimitedChange(MxNode newV) {
        if (newV == null) {
            return;
        }
        if (newV.getNode("3") == null) {
            return;
        }
        if (newV.is("3")) {
            this.priceSpn.getEditor().clear();
        }
    }

    protected void offerWayDisableBind() {
    }

    protected void quantityDisableBind() {
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
    }

    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() && !this.model.isAfterHoursPrice() || this.model.isUnlimited(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty()}));
    }

    protected void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return true;
            }
            if (!(((MxNode)this.cmbPriceType.getValue()).is("50") || ((MxNode)this.cmbPriceType.getValue()).is("0") || ((MxNode)this.cmbPriceType.getValue()).is("99"))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        Platform.runLater(() -> {
            if (ref == null || ref.getName().equals("") || this.model.getValidRef() == null) {
                this.lbName.setText(INVALID_CODE);
            } else if (this.mktItem.getStop().getValue().booleanValue()) {
                this.lbName.setText(this.mktItem.getStatus());
            } else {
                this.lbName.setText(ref.getName());
            }
        });
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    private void changeUnit() {
        this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit());
        if (this.model.isBond()) {
            if ("1".equals(this.preModel.getUnit())) {
                if (this.model.isSHbond()) {
                    this.lbUnit.setText("\u624b");
                } else {
                    this.lbUnit.setText("\u5f20");
                }
            } else if ("2".equals(this.preModel.getUnit())) {
                this.lbUnit.setText("\u624b");
                if (!this.model.isSHbond()) {
                    this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit() / 10);
                }
            } else if ("3".equals(this.preModel.getUnit())) {
                this.lbUnit.setText("\u5f20");
                this.model.isSHbond();
                this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit() * 10);
            }
        }
        if (this.model.isBond()) {
            if (this.model.isSHbond()) {
                this.lbUnit.setText("\u624b");
            } else {
                this.lbUnit.setText("\u5f20");
            }
        }
        if (this.model.isStock()) {
            this.lbUnit.setText("\u80a1");
        }
        if (this.model.isFund()) {
            this.lbUnit.setText("\u4efd");
        }
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.model.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.model.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        return this.alert.check(this.model.getCount() >= 0L && this.model.getAccDisModel().isCountValid() != false, Alert.AlertType.WARNING, tip5);
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(!this.model.isLimitPrice() && !this.model.isAfterHoursPrice() || this.model.isUnlimited() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (CcsAccountDistribution acc : this.model.getAccDisModel().getValidSecAcc()) {
            info.append("\n\u8d26\u53f7   " + acc.getSecAcc().getInverstorSecId() + " \u59d4\u6258\u6570\u91cf   " + acc.getCount());
        }
        return info.toString();
    }

    /*
     * Unable to fully structure code
     */
    @FXML
    public void order() {
        this.model.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            if (!this.model.setWorkFlow().booleanValue()) {
                return;
            }
            entrusts = this.model.getEntrustList(false);
            num = this.model.getCount() % (long)Integer.valueOf(this.lbOfferCount.getText()).intValue();
            if (this.buyRadio.isSelected() && num != 0.0) {
                this.alert.alert(Alert.AlertType.WARNING, "\u60a8\u8f93\u5165\u7684\u6570\u91cf\u5fc5\u987b\u662f\u6700\u5c0f\u5355\u4f4d\u7684\u500d\u6570.");
                return;
            }
            if (this.orderMessage) {
                try {
                    obj = (NeeqEntrustConfirmDialog)this.of.create(NeeqEntrustConfirmDialog.class);
                    if (!"4".equals(this.model.getAccDisModel().getInstructType()) && !"3".equals(this.model.getAccDisModel().getInstructType())) {
                        obj.setInstruction(true);
                        if (!"2".equals(this.model.getAccDisModel().getInstructType()) && !"3".equals(this.model.getAccDisModel().getInstructType())) {
                            iterator = entrusts.iterator();
                            while (iterator.hasNext()) {
                                if (!iterator.hasNext() || this.model.getWorkFlowAccountMap().get(iterator.next().getInvestorId()) != null) continue;
                                iterator.remove();
                            }
                        }
                    } else {
                        obj.setExecution(true);
                    }
                    if ((var6_5 = this.model.getWorkFlowAccountMap().values().iterator()).hasNext()) {
                        workflowTemplate = var6_5.next();
                        obj.setShowWarning("1".equals(workflowTemplate.getNode().getFrozenCapital()) == false);
                    }
                    obj.setInstructionPanelType(this.model.getAccDisModel().getInstructType());
                    obj.setBuySymbol(this.buySymbol);
                    obj.setSellSymbol(this.sellSymbol);
                    obj.setRefItem(this.mktItem.getRefItem());
                    obj.setPriceStg(this.model.getPriceStg());
                    obj.setPriceTypeMktStg(this.model.getPriceTypeMktStg());
                    obj.setPriceTypeLimitedStg(this.model.getPriceTypeLimitedStg());
                    obj.setPriceTypeBidAskStg(this.model.getPriceTypeBidAskStg());
                    obj.setUnit(this.lbUnit.getText());
                    obj.setBuy(this.buyRadio.isSelected());
                    obj.setHk(true);
                    obj.setList(entrusts);
                    dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) != false ? "\u4e0b\u5355\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
                    obj.setDialog(dialog);
                    if (dialog.launch() != ButtonType.OK) ** GOTO lbl50
                    this.submitOrder();
                }
                finally {
                    this.model.getFundTraderMap().clear();
                    this.model.getInsExpiredMap().clear();
                }
            } else {
                this.submitOrder();
            }
        }
lbl50:
        // 5 sources

        this.layout();
    }

    protected void submitOrder() {
        Result result = null;
        try {
            result = this.doAction();
            if (result.failed > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14" + result.getReason().toString());
            } else {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
            }
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u5931\u8d25" + e.toString());
            this.logger.error(String.valueOf(this.confirmSymbol) + "\u5931\u8d25", (Throwable)e);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error(String.valueOf(this.confirmSymbol) + "\u5931\u8d25", (Throwable)e);
        }
        this.clearCountCheck();
    }

    protected Result doAction() throws MException {
        return this.model.submit((TreeItem<CcsAccountDistribution>)this.model.getAccDisModel().getRoot());
    }

    protected void clearCountCheck() {
        if (!this.saveNum) {
            this.clearCountCheckForce();
        }
    }

    protected void clearCountCheckForce() {
        switch (this.model.getCountStg().getRaw()) {
            case "5": {
                this.model.setMoney(0.0);
                break;
            }
            case "1": {
                this.model.setCount(0L);
                break;
            }
            default: {
                this.model.setCountPer(0.0);
            }
        }
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            if (this.model.isLimitPrice()) {
                this.priceSpn.requestFocus();
                this.preModel.selectTwoOrAllPriceDecimal();
            } else if (this.model.isMktPrice() && this.model.isStar()) {
                this.preModel.selectTwoOrAllProtectedPriceDecimal();
            } else {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("2")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("3")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("4")) {
                this.txtPerCount.requestFocus();
                this.txtPerCount.selectAll();
            } else if (((MxNode)this.countStg.getValue()).getRaw().equals("5")) {
                this.moneySpn.requestFocus();
                this.moneySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        }
    }

    private void cmbStgKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        }
    }

    protected boolean onMktItemClicked(HandicapInfo now) {
        if (now == null) {
            return false;
        }
        if (this.tabNormal.isSelected()) {
            this.setPrice(now.getPrice());
        } else {
            this.algoNode.setPrice(now.getPrice());
        }
        return false;
    }

    public void setPrice(double price) {
        if ((this.model.isLimitPrice() || this.model.isAfterHoursPrice()) && !this.model.isUnlimited() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.model.setPrice(price);
        } else {
            if (this.model.isMktPrice() || this.model.isBidAskPrice()) {
                return;
            }
            this.priceSpn.getEditor().setText("");
        }
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(this.accountCol.getText()).append("\t");
        clipboardString.append(this.secAcctCol.getText()).append("\t");
        clipboardString.append(this.counterCol.getText()).append("\t");
        clipboardString.append(this.weightCol.getText()).append("\t");
        clipboardString.append(this.amountCol.getText()).append("\t");
        clipboardString.append(this.productCol.getText()).append("\n");
        for (TreeItem item : this.model.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc()).append("\t");
            clipboardString.append("\t");
            clipboardString.append(accDis.getAcc().getCounterName()).append("\t");
            clipboardString.append(accDis.getWeight()).append("\t");
            clipboardString.append(accDis.getCount()).append("\t");
            clipboardString.append(accDis.getAcc().getProductName()).append("\n");
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t");
                clipboardString.append(secAccDis.getSecAcc()).append("\t");
                clipboardString.append("\t");
                clipboardString.append(secAccDis.getWeight()).append("\t");
                clipboardString.append(secAccDis.getCount()).append("\n");
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    public TreeTableView<CcsAccountDistribution> getAccTreeTable() {
        return this.acctTreeTable;
    }

    public ITradeModel getModel() {
        return this.model;
    }

    public InstructionCcsBaseModel createModel() {
        return (InstructionCcsBaseModel)this.of.create(InstructionCcsBaseModel.class);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public void initUserPre() {
        this.preModel.setType("1", "141300");
        this.preModel.setPart(this);
        this.preModel.initControls();
    }

    public void checkQuota(RefItem item) {
        if (item == null) {
            return;
        }
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public Spinner<Double> getMoneySpn() {
        return this.moneySpn;
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Label getLbAmountOne() {
        return this.lbAmountOne;
    }

    public Label getLbAmountTwo() {
        return this.lbAmountTwo;
    }

    public Label getLbAmountThree() {
        return this.lbAmountThree;
    }

    public Label getLbAmountFour() {
        return this.lbAmountFour;
    }

    public Label getLbTotalOne() {
        return this.lbTotalOne;
    }

    public Label getLbTotalTwo() {
        return this.lbTotalTwo;
    }

    public Label getLbTotalThree() {
        return this.lbTotalThree;
    }

    public Label getLbTotalFour() {
        return this.lbTotalFour;
    }

    public Label getLbCanbuyOne() {
        return this.lbCanbuyOne;
    }

    public Label getLbCanbuyTwo() {
        return this.lbCanbuyTwo;
    }

    public Label getLbCanbuyThree() {
        return this.lbCanbuyThree;
    }

    public Label getLbCanbuyFour() {
        return this.lbCanbuyFour;
    }

    public Label getLbCansellOne() {
        return this.lbCansellOne;
    }

    public Label getLbCansellTwo() {
        return this.lbCansellTwo;
    }

    public Label getLbCansellThree() {
        return this.lbCansellThree;
    }

    public Label getLbCansellFour() {
        return this.lbCansellFour;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStg.getValue();
    }

    public void setCount(Long buyQuantity) {
        this.model.setCount(buyQuantity);
    }

    public void setMoney(double value) {
        this.model.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.model.setCountPer(value);
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setAutoSlice(boolean slice, long size) {
        this.model.setAutoSlice(slice);
        this.model.setSliceSize(size);
    }

    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    public boolean getActiveFlag() {
        return this.model.getAccDisModel().isActive();
    }

    public InstructionHkBaseModel getInstructionCcsBaseModel() {
        return this.model;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public void setPartId(String id) {
        this.partId = id;
    }

    public boolean isUSA() {
        return this.isUSA;
    }

    public void setUSA(boolean isUSA) {
        this.isUSA = isUSA;
    }

    public boolean isHk(String market) {
        return "XHKG".equals(market);
    }

    public Label getLbCountFive() {
        return this.lbCountFive;
    }

    public Label getLbCountSix() {
        return this.lbCountSix;
    }

    public Label getLbCountSeven() {
        return this.lbCountSeven;
    }

    public Label getLbCountEight() {
        return this.lbCountEight;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class CounterCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        CounterCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setText(item == null ? null : item.getCounterName());
            } else {
                this.setText(null);
            }
        }
    }

    public class HandicapCountCell<E extends HandicapInfo>
    extends TableCell<HandicapInfo, Number> {
        private MarketItem info;
        private static final int INVALID_COUNT = -1;

        public HandicapCountCell(MarketItem info) {
            this.info = info;
        }

        public void updateItem(Number item, boolean empty) {
            HandicapInfo handiInfo;
            if (!(empty || item.longValue() == -1L || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear() || this.info.isClear())) {
                if (this.info.getRefItem() instanceof CtpRefItem) {
                    this.setText(String.valueOf(item));
                } else {
                    int unit = this.info.getRefItem().getBuyUnit();
                    if (BsDict.HKUSA_MARKET.contains(this.info.getRefItem().getMarket())) {
                        String price = StringUtils.toThousands((String)String.valueOf(item.longValue()));
                        Tooltip tooltip = null;
                        if (!empty && price != null && !price.isEmpty()) {
                            tooltip = new Tooltip();
                            tooltip.setText(price);
                            tooltip.setMaxWidth(400.0);
                            tooltip.setWrapText(true);
                        }
                        this.setTooltip(tooltip);
                        this.setText(price);
                    } else if (unit != 0) {
                        this.setText(String.valueOf(item.longValue() / (long)unit));
                    }
                }
                return;
            }
            this.setText(null);
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class NumberCell
    extends NumberTreeTableCell<CcsAccountDistribution> {
        public NumberCell() {
            super(2);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    public class PriceCell<E extends HandicapInfo>
    extends TableCell<HandicapInfo, String> {
        private MarketItem info;

        public PriceCell(MarketItem info) {
            CssUtils.priceTag((Control)this);
            this.info = info;
        }

        public void updateItem(String item, boolean empty) {
            HandicapInfo handiInfo;
            if (!(empty || item.isEmpty() || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear() || this.info.isClear())) {
                double price = Double.parseDouble(item);
                CssUtils.checkPrice((Control)this, (double)this.info.getClosePrice(), (double)price);
                if (price > 0.0) {
                    String txt = String.format("%." + this.info.getRefItem().getScale() + "f", price);
                    if (this.info.getRefItem().getMarket().equals("XHKG")) {
                        txt = String.format("%.3f", price);
                    }
                    this.setText(txt);
                    return;
                }
            }
            this.setText(null);
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

