/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.hk;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.instruction.RespResult;
import cms.tmx.instructions.models.regular.InstructionHkAlgoModel;
import cms.tmx.instructions.models.regular.InstructionHkBaseModel;
import cms.tmx.instructions.viewers.hk.AlgoNodeInstruction;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.neeq.view.NeeqEntrustConfirmDialog;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoNodeInstructionHk
extends AlgoNodeInstruction {
    @Inject
    public InstructionHkAlgoModel model;
    @Inject
    private UserPreOrderTips setTips;
    protected String confirmSymbol = "";

    @FXML
    public void initialize() {
        this.model.baseModel = (InstructionHkBaseModel)this.of.create(InstructionHkBaseModel.class);
        this.initAlgo();
        this.initControl();
        this.checks();
    }

    public void initControl() {
        super.initControl();
        MxBindings.bindSI((Property)this.spnQty.getEditor().textProperty(), (Property)this.model.countAlgoProperty());
    }

    public void onSecurityChange(TextField txtCode) {
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.doChange(refItem);
    }

    public void doChange(RefItem refItem) {
        this.lbName.setText(this.model.baseModel.getName());
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        this.refItem = refItem;
        if (refItem == null) {
            return;
        }
        int scale = 0;
        String unit = "";
        if (refItem != null) {
            String type = refItem.getType();
            String market = refItem.getMarket();
            unit = QueryUtils.getUnit((String)type, (String)market);
            scale = refItem.getScale();
            this.ctrlCount.setUnit(refItem.getBuyUnit());
        }
        this.lbUnit.setText(unit);
        this.ctrlPrice.setScale(scale);
        this.clear(false);
    }

    public void order() {
        this.txtCode.requestFocus();
        if (this.refItem.getCode().startsWith("688")) {
            this.alert.alert(Alert.AlertType.ERROR, "\u79d1\u521b\u677f\u6682\u4e0d\u652f\u6301\u7b97\u6cd5\u4ea4\u6613\uff01");
            return;
        }
        if (!this.valid()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef\uff01");
            return;
        }
        if (this.model.baseModel.getMI() != null && this.model.baseModel.getMI().getStop().getValue().booleanValue()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bc1\u5238\u505c\u724c");
            return;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.model.baseModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return;
        }
        if (!this.model.baseModel.setWorkFlow().booleanValue()) {
            return;
        }
        this.submitParam();
        this.model.baseModel.getInsExpiredMap().clear();
        NeeqEntrustConfirmDialog obj = (NeeqEntrustConfirmDialog)this.of.create(NeeqEntrustConfirmDialog.class);
        if ("0".equals(this.model.baseModel.getAccDisModel().getInstructType()) || "4".equals(this.model.baseModel.getAccDisModel().getInstructType())) {
            obj.setExecution(true);
        }
        obj.setBuySymbol(this.buySymbol);
        obj.setSellSymbol(this.sellSymbol);
        obj.setUnit(this.lbUnit.getText());
        obj.setBuy(this.buyRadio.isSelected());
        obj.setHk(true);
        obj.setList(this.model.getEntrustList());
        MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u5355\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
        obj.setDialog(dialog);
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        RespResult result = null;
        String operation = "";
        try {
            switch (this.instructionType) {
                case "0": {
                    result = this.model.submitAdvice();
                    operation = "\u6307\u4ee4\u63d0\u4ea4";
                    break;
                }
                case "1": {
                    result = this.model.submitAdvice();
                    operation = "\u5efa\u8bae\u63d0\u4ea4";
                    break;
                }
                case "2": {
                    result = this.model.submitApprove(this.instruction);
                    operation = "\u5ba1\u6279\u63d0\u4ea4";
                    this.clearPanel();
                    break;
                }
                case "3": {
                    String status = this.instruction.getStatus();
                    if ("61".equals(status)) {
                        this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5df2\u64a4\u9500\uff0c\u6267\u884c\u5931\u8d25");
                        return;
                    }
                    if ("4".equals(status)) {
                        this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5df2\u5b8c\u6210\uff0c\u6267\u884c\u5931\u8d25");
                        return;
                    }
                    this.exe.execute(() -> {
                        RespResult respOrder = this.model.execute(this.instruction);
                        Platform.runLater(() -> {
                            this.clearPanel();
                            this.respResultAlert(respOrder, "\u4e0b\u5355\u63d0\u4ea4", "cms.tmx.instructions.part.regular.algo.query");
                        });
                    });
                    return;
                }
                case "4": {
                    this.exe.execute(() -> {
                        RespResult respOrder = this.model.submitOrder();
                        Platform.runLater(() -> this.respResultAlert(respOrder, "\u4e0b\u5355\u63d0\u4ea4", "cms.tmx.stock.cp.hk.order"));
                    });
                    return;
                }
            }
            this.respResultAlert(result, operation, "cms.tmx.instructions.part.regular.instruct.query");
        }
        catch (MException e) {
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u7b97\u6cd5\u6307\u4ee4\u4e0b\u8fbe\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, e.toString());
            logger.error("\u7b97\u6cd5\u6307\u4ee4\u4e0b\u8fbe\u5931\u8d25", (Throwable)e);
        }
    }

    private void respResultAlert(RespResult respResult, String operation, String part) {
        this.clear(true);
        Alert.AlertType aType = respResult.hasFailed() ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION;
        this.alert.check(!this.setTips.getOrderTips(), aType, respResult.getDesc(operation));
    }

    private void clearPanel() {
        this.model.baseModel.getAccDisModel().removeTree();
        this.model.baseModel.getAccDisModel().setActive(true);
    }

    protected void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() == 6 && this.model.baseModel.getMI().getStop().getValue().booleanValue()) {
            this.lbName.setText(this.model.baseModel.getMI().getStatus());
        }
    }

    protected void submitParam() {
        RefItem refItem = this.model.baseModel.getMI().getRefItem();
        this.model.setParam(super.submitParam(refItem));
    }

    public void setBaseModel(InstructionHkBaseModel baseModel) {
        this.model.baseModel = baseModel;
        this.model.initAlgo();
    }

    @Override
    public IntegerProperty minuteProperty() {
        return this.model.minuteProperty();
    }

    public List<Algorithm> getAlgos(String engine, Boolean isBuy) {
        return null;
    }
}

