/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.hk;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoNodeHk;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.javafx.MxNode;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public abstract class AlgoNodeInstruction
extends AlgoNodeHk {
    protected Map<String, List<Node>> mapParent = new HashMap<String, List<Node>>();
    public ObSimpleInstruction instruction;
    protected String instructionType = "0";

    protected void initAlgo() {
        super.initAlgo();
        List<Node> list = this.getNodeParent(new Node[]{this.cmbTif, this.spnQty, this.spnPrice, this.txtStartHour, this.txtEndHour});
        this.mapParent.put("50#SHORTSELL", list);
        this.mapParent.put("50#TWAP", list);
        this.mapParent.put("50#VWAP", list);
        list = this.getNodeParent(new Node[]{this.cmbTif, this.spnQty, this.txtStartHour, this.txtEndHour});
        this.mapParent.put("49#SHORTSELL", list);
        this.mapParent.put("49#TWAP", list);
        this.mapParent.put("49#VWAP", list);
        list = this.getNodeParent(new Node[]{this.cmbTif, this.spnQty, this.spnPrice, this.txtStartHour, this.txtEndHour, this.txtDealPercent});
        this.mapParent.put("50#POV", list);
        list = this.getNodeParent(new Node[]{this.cmbTif, this.spnQty, this.txtStartHour, this.txtEndHour, this.txtDealPercent});
        this.mapParent.put("49#POV", list);
    }

    protected List<Node> getNodeParent(Node ... nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            list.add((Node)node.getParent());
            ++n2;
        }
        return list;
    }

    protected void checks() {
        super.checks();
        this.registerCheck((Node)this.lbQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int count = this.getInt(this.spnQty.getEditor());
            if (count == 0) {
                this.lbQtyErr.setText("\u8bf7\u8f93\u5165\u59d4\u6258\u6570\u91cf");
                return false;
            }
            long canCount = 0L;
            if (this.instruction != null) {
                if (this.instruction.getJobs() != null && this.instruction.getJobs().size() > 0) {
                    ExecJob job = (ExecJob)this.instruction.getJobs().get(0);
                    canCount = (long)job.getAvailOrderQty();
                }
                if ((long)count > canCount) {
                    this.lbQtyErr.setText("\u4e0d\u80fd\u8d85\u8fc7\u6307\u4ee4\u6570\u91cf" + canCount);
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQty.getEditor().textProperty()}));
        if (this.algoConf.limitTime()) {
            this.registerCheck((Node)this.lbEndErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                int end = this.getInt(this.txtEndHour) * 60 + this.getInt(this.txtEndMinute);
                if (!AlgoModel.timeIsValidHk((int)end)) {
                    this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:59");
                    return false;
                }
                if (end <= start) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u8d77\u59cb\u65f6\u95f4");
                    return false;
                }
                Calendar calender = Calendar.getInstance();
                calender.get(11);
                calender.get(12);
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty(), this.minuteProperty()}));
        }
    }

    public void onBSChangeNormal(String now) {
        if (this.sellShortRadio.isSelected() && !this.sellShortRadio.getId().equals(now)) {
            this.cmbAlgo.getSelectionModel().select(0);
        }
        if (this.buyRadio.getId().equals(now)) {
            this.buyRadio.setSelected(true);
        } else if (this.sellRadio.getId().equals(now)) {
            this.sellRadio.setSelected(true);
        } else {
            this.sellShortRadio.setSelected(true);
        }
    }

    private void setBtnSymbol() {
        String pre = "";
        switch (this.instructionType) {
            case "1": {
                pre = "\u6307\u4ee4";
                break;
            }
            case "2": {
                pre = "\u5efa\u8bae";
                break;
            }
            case "3": {
                pre = "\u5ba1\u6279";
                break;
            }
            case "0": 
            case "4": {
                pre = "";
            }
        }
        this.buySymbol = String.valueOf(pre) + this.buySymbol;
        this.sellSymbol = String.valueOf(pre) + this.sellSymbol;
        this.sellShortSymbol = String.valueOf(pre) + this.sellShortSymbol;
    }

    public void disable(String algoType, boolean disable, boolean passQty) {
        for (Node node : this.mapParent.get(algoType)) {
            node.setDisable(disable);
        }
        this.lbStart.setDisable(disable);
        this.lbEnd.setDisable(disable);
        this.spnPrice.getParent().setDisable(disable);
        if (passQty) {
            this.spnQty.getParent().setDisable(false);
        }
        this.cmbAlgo.getParent().setDisable(disable);
        this.txtCode.setEditable(!disable);
        this.buyRadio.getParent().setDisable(disable);
        if (!disable) {
            this.txtCode.clear();
            this.lbName.setText("");
            this.txtCode.requestFocus();
            this.spnPrice.getEditor().clear();
            this.spnQty.getEditor().clear();
            AlgoModel.timeLimitHk((TextField)this.txtStartHour, (TextField)this.txtStartMinute, (TextField)this.txtEndHour, (TextField)this.txtEndMinute);
        }
    }

    public void setPrice(Double price) {
        MxNode algo = (MxNode)this.cmbAlgo.getSelectionModel().getSelectedItem();
        if (algo == null) {
            return;
        }
        this.spnPrice.getEditor().setText(price.toString());
    }

    public TextField getTxtCode() {
        return this.txtCode;
    }

    protected void checkRadioName() {
        this.txtCode.setText(this.refItem.getCode());
    }

    public abstract IntegerProperty minuteProperty();

    public String getInstructionType() {
        return this.instructionType;
    }

    public void setInstructionType(String instructionType) {
        this.instructionType = instructionType;
        this.setBtnSymbol();
    }
}

