/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fix;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.instructions.models.fix.FixUnfinishedOrderModel;
import cms.tmx.javafx.MxGroup;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.current.views.CcsReplaceConfirmDialog;
import cms.tmx.query.utils.SideCell;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class FixUnfinishedOrderQueryPart
extends MxPart {
    @FXML
    private TableView<Order> tableFixUnfinished;
    @FXML
    private TableColumn<Order, Boolean> selected;
    @FXML
    private TableColumn<Order, String> securityId;
    @FXML
    private TableColumn<Order, String> market;
    @FXML
    private TableColumn<Order, String> securityName;
    @FXML
    private TableColumn<Order, MxNode> side;
    @FXML
    private TableColumn<Order, Number> price;
    @FXML
    private TableColumn<Order, Number> orderQty;
    @FXML
    private TableColumn<Order, String> ordType;
    @FXML
    private TableColumn<Order, String> unit;
    @FXML
    private TableColumn<Order, String> reference;
    @FXML
    private TableColumn<Order, Number> orderAmount;
    @FXML
    private TableColumn<Order, Number> cumQty;
    @FXML
    private TableColumn<Order, Number> donePercent;
    @FXML
    private TableColumn<Order, Number> wthQty;
    @FXML
    private TableColumn<Order, Number> avgPx;
    @FXML
    private TableColumn<Order, Number> cumAmount;
    @FXML
    private TableColumn<Order, Number> frozenMargin;
    @FXML
    private TableColumn<Order, String> ordTime;
    @FXML
    private TableColumn<Order, MxNode> ordStatus;
    @FXML
    private TableColumn<Order, String> orderId;
    @FXML
    private TableColumn<Order, String> investorId;
    @FXML
    private TableColumn<Order, String> inverstorSecId;
    @FXML
    private TableColumn<Order, String> ordDate;
    @FXML
    private TableColumn<Order, String> userId;
    @FXML
    private TableColumn<Order, String> userName;
    @FXML
    private TableColumn<Order, String> extOrderId;
    @FXML
    private TableColumn<Order, String> errInfo;
    @FXML
    private TextField searchText;
    @FXML
    private Button btnCancelAndOrder;
    @FXML
    private Button btnOrderCancel;
    @FXML
    private ComboBox<MxNode> cmbPriceTp;
    @FXML
    private Spinner<Double> spnPriceFlP;
    @FXML
    private Spinner<Double> spnPriceFlU;
    @FXML
    private Label labFloatU;
    @Inject
    private FixUnfinishedOrderModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private IUserService userService;
    @Inject
    private IUiRightService rightsModel;
    @Inject
    private MEventService es;
    @Inject
    private CcsCancelFactory ccf;
    private static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    private CheckBox checkBox = new CheckBox();
    private MxList<Order> mxList = new MxList();
    private MxGroup group = new MxGroup();
    public static final String PRICE_ADJUST_UNIT = "price_adjust_unit";
    public static final String PRICE_ADJUST_UNIT_PERCENT = "1";
    private Predicate<Order> pd = t -> {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        String name = t.getInstrument().getSymbol().toUpperCase();
        if (t.getOrdStatus() == null) {
            return false;
        }
        if (!Order.CAN_CANCEL_STATUS.contains(t.getOrdStatus().getValue())) {
            return false;
        }
        return code.contains(text) || name.contains(text);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        List<Order> list = this.model.getList();
        synchronized (list) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
        this.tableFixUnfinished.refresh();
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList<Order> newList = new ArrayList<Order>();
        List<Order> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableFixUnfinished.refresh();
        });
    }

    @FXML
    private void initialize() {
        this.initValues();
        this.createTableView();
        this.bind();
        this.checkRights();
        this.refresh();
    }

    @PreDestroy
    private void destroy() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    protected void bind() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
        this.cmbPriceTp.setItems(this.model.getPriceType().getNodes());
        this.model.priceFloatProperty().bindBidirectional((Property)this.spnPriceFlP.getEditor().textProperty());
        this.model.floatUnitProperty().bindBidirectional((Property)this.labFloatU.textProperty());
        this.cmbPriceTp.valueProperty().bindBidirectional(this.model.priceTypeProperty());
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getList();
            synchronized (observableList) {
                this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
    }

    private void checkRights() {
        this.rightsModel.registerCheck((Control)this.btnOrderCancel, new String[]{"cms.tmx.instructions.part.fix.unfinished.order.query_cancel"});
        this.rightsModel.registerCheck((Control)this.btnCancelAndOrder, new String[]{"cms.tmx.instructions.part.fix.unfinished.order.query_cancelAndOrder"});
    }

    @FXML
    private void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        if (this.createDialog((List<Order>)list, "\u64a4\u5355\u786e\u8ba4")) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = new MEvent();
        event.setObj((Object)list);
        this.es.sendEvent("fix.cancel.order", event);
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        if (event.getInt("fail.count") > 0) {
            type = Alert.AlertType.ERROR;
        }
        this.alert.check(false, type, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14\n" + event.get((Object)"fail.message"));
    }

    @FXML
    private void cancelAndOrder() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        CcsReplaceConfirmDialog obj = (CcsReplaceConfirmDialog)this.of.create(CcsReplaceConfirmDialog.class);
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        HashMap<CcsCancelEntrust, Order> enOrMap = new HashMap<CcsCancelEntrust, Order>();
        this.model.queryMarketItem((List<Order>)list);
        for (Order or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle("", "");
            en.setSec(or.getInstrument().getSecurityId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInvestorSecId());
            en.setSecType(or.getInstrument().getSecurityType());
            en.setMarket(or.getInstrument().getMarket());
            en.setOrderType(Integer.valueOf(or.getOrdType().getValue()).intValue());
            en.setSide(new MxNode().load("side", or.getSide().getValue()));
            en.setTip("".equals(or.getExtOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getExtOrderId());
            en.setQuantity((long)(or.getOrderQty() - or.getCumQty()));
            en.setPrice(or.getPrice());
            en.setAmt((double)en.getQuantity() * en.getPrice());
            if ("99".equals(or.getOrdType().getValue())) {
                en.setOrderTypeStr("\u76d8\u540e\u56fa\u5b9a\u4ef7");
            }
            en.setOrderId(or.getOrderId());
            en.setQuantity(new Double(or.getOrderQty() - or.getCumQty()).longValue());
            en.setSide(new MxNode().load("side", or.getSide().getValue()));
            en.setPrice(this.model.getNewPrice(or, StringUtils.parseInt((String)this.model.getPriceType().getRaw()), this.model.getFloatUnit(), this.model.getPriceFloat()));
            or.setNewPrice(en.getPrice());
            en.setAmt((double)en.getQuantity() * en.getPrice());
            enList.add(en);
            enOrMap.put(en, or);
        }
        this.sort(enList);
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355\u91cd\u4e0b");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u91cd\u4e0b\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\u91cd\u4e0b\uff01");
            return;
        }
        MEvent event = new MEvent();
        event.setObj((Object)list);
        this.es.sendEvent("fix.cancel.and.order", event);
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        String des = "";
        if (event.getInt("fail.count") > 0) {
            type = Alert.AlertType.ERROR;
            des = event.getStr("fail.message");
        }
        this.alert.check(false, type, "\u64a4\u5355\u91cd\u4e0b\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14\n" + des);
    }

    private void sort(List<CcsCancelEntrust> enList) {
        Collections.sort(enList, new Comparator<CcsCancelEntrust>(){

            @Override
            public int compare(CcsCancelEntrust o1, CcsCancelEntrust o2) {
                if (o2.isIsModified() && !o1.isIsModified()) {
                    return 1;
                }
                if (o1.isIsModified() && !o2.isIsModified()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private boolean createDialog(List<Order> list, String dialogName) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)this.of.create(CcsCancelConfirmDialog.class);
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (Order or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle("", "");
            en.setSec(or.getInstrument().getSecurityId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInvestorSecId());
            en.setSecType(or.getInstrument().getSecurityType());
            en.setMarket(or.getInstrument().getMarket());
            en.setOrderType(Integer.valueOf(or.getOrdType().getValue()).intValue());
            en.setSide(new MxNode().load("side", or.getSide().getValue()));
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getExtOrderId());
            en.setQuantity((long)(or.getOrderQty() - or.getCumQty()));
            en.setPrice(or.getPrice());
            en.setAmt((double)en.getQuantity() * en.getPrice());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, dialogName);
        return dialog.launch() != ButtonType.OK;
    }

    private void createTableView() {
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((Order)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.securityId.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getInstrument().getSecurityId()));
        this.securityName.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getInstrument().getSymbol()));
        this.side.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("side", ((Order)cell.getValue()).getSide().getValue())));
        this.reference.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getReference()));
        this.ordType.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getOrdTypeDesc()));
        this.donePercent.setCellValueFactory(cell -> {
            double per = 0.0;
            if (((Order)cell.getValue()).getCumQty() > 0.0 && ((Order)cell.getValue()).getOrderQty() > 0.0) {
                per = ((Order)cell.getValue()).getCumQty() * 100.0 / ((Order)cell.getValue()).getOrderQty();
            }
            return new SimpleDoubleProperty(Double.valueOf(per).doubleValue());
        });
        this.unit.setCellValueFactory(cell -> new SimpleStringProperty("\u80a1"));
        this.market.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getMarket()));
        this.price.setCellValueFactory(cell -> new SimpleDoubleProperty(((Order)cell.getValue()).getPrice()));
        this.orderQty.setCellValueFactory(cell -> new SimpleDoubleProperty(((Order)cell.getValue()).getOrderQty()));
        this.orderAmount.setCellValueFactory(cell -> new SimpleDoubleProperty(((Order)cell.getValue()).getOrderAmount()));
        this.cumQty.setCellValueFactory(cell -> new SimpleDoubleProperty(((Order)cell.getValue()).getCumQty()));
        this.wthQty.setCellValueFactory(cell -> new SimpleDoubleProperty((double)((Order)cell.getValue()).getWthQty()));
        this.avgPx.setCellValueFactory(cell -> new SimpleDoubleProperty(((Order)cell.getValue()).getAvgPx()));
        this.cumAmount.setCellValueFactory(cell -> new SimpleDoubleProperty(((Order)cell.getValue()).getTotalValue()));
        this.frozenMargin.setCellValueFactory(cell -> new SimpleDoubleProperty(((Order)cell.getValue()).getFrozenMargin()));
        this.ordStatus.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("ord_status", ((Order)cell.getValue()).getOrdStatus() == null ? "0" : ((Order)cell.getValue()).getOrdStatus().getValue())));
        this.orderId.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getExtOrderId()));
        this.ordTime.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getOrdTime()));
        this.ordDate.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getOrdDate()));
        this.investorId.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getInvestorId()));
        this.inverstorSecId.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getInvestorSecId()));
        this.ordTime.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getOrdTime()));
        this.userId.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getUserId()));
        this.userName.setCellValueFactory(cell -> new SimpleStringProperty((String)this.userService.getUserName(((Order)cell.getValue()).getUserId()).get()));
        this.extOrderId.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getExtOrderId()));
        this.errInfo.setCellValueFactory(cell -> new SimpleStringProperty(((Order)cell.getValue()).getErrInfo()));
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.donePercent.setCellFactory(data -> new DoubleTableCell());
        this.orderQty.setCellFactory(data -> new DoubleTableCell());
        this.orderAmount.setCellFactory(data -> new DoubleTableCell());
        this.cumQty.setCellFactory(data -> new DoubleTableCell());
        this.wthQty.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellFactory(data -> new DoubleTableCell());
        this.cumAmount.setCellFactory(data -> new DoubleTableCell());
        this.frozenMargin.setCellFactory(data -> new DoubleTableCell());
        this.side.setCellFactory(cell -> new SideCell());
        this.tableFixUnfinished.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableFixUnfinished.setItems(this.mxList.getList());
    }

    @FXML
    private void refresh() {
        this.exe.execute(() -> {
            try {
                this.model.query();
            }
            catch (MException | Exception e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                this.logger.error(e.getMessage(), e);
            }
        });
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableFixUnfinished, (String)"\u672a\u5b8c\u6210\u59d4\u6258", (int)1, (int)(this.tableFixUnfinished.getColumns().size() - 1));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableFixUnfinished, (int)1, (int)0);
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)PRICE_ADJUST_UNIT, (String)PRICE_ADJUST_UNIT_PERCENT);
        this.labFloatU.textProperty().setValue(node.getValue());
        this.labFloatU.setOnMouseClicked(event -> this.changePriceUnit());
        this.labFloatU.getStyleClass().add((Object)"lbPercentYuan");
        this.group.add(new Control[]{this.spnPriceFlU, this.spnPriceFlP}).setVisible(new Control[]{this.spnPriceFlP});
        this.spnPriceFlU.getEditor().setText("0.000");
        this.spnPriceFlP.getEditor().setText("0.00");
        SpinnerUtils.arrowsStyle(this.spnPriceFlP);
        SpinnerUtils.arrowsStyle(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 3, 3, 1000.0).ctrl(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 2, 2, 100.0).ctrl(this.spnPriceFlP);
    }

    private void changePriceUnit() {
        if ("%".equals(this.labFloatU.getText())) {
            this.labFloatU.setText("\u5143");
            this.group.setVisible(new Control[]{this.spnPriceFlU});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlP.getEditor().textProperty(), (Property)this.spnPriceFlU.getEditor().textProperty());
        } else {
            this.labFloatU.setText("%");
            this.group.setVisible(new Control[]{this.spnPriceFlP});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlU.getEditor().textProperty(), (Property)this.spnPriceFlP.getEditor().textProperty());
        }
    }
}

