/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fix;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.Result;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.instructions.viewers.fix.FixTradeBasePart;
import cms.tmx.utils.StringUtils;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;

public class FixTradeExecutePart
extends FixTradeBasePart {
    protected MEventHandler hSetCodeApp = event -> {
        if (event.get((Object)"instruction") == null || !(event.get((Object)"instruction") instanceof ObSimpleInstruction)) {
            return;
        }
        ObSimpleInstruction ins = (ObSimpleInstruction)ObSimpleInstruction.class.cast(event.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };
    protected ChangeListener<Boolean> lstnFocusPrice = (ob, old, newV) -> {
        if (this.instruction == null) {
            return;
        }
        if (this.ccsModel.isUpLimit() && !newV.booleanValue() && this.ccsModel.getPrice() > this.instruction.getOrderDetail().getPrice()) {
            this.ccsModel.setPrice(this.instruction.getOrderDetail().getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
        if (this.ccsModel.isDownLimit() && !newV.booleanValue() && this.ccsModel.getPrice() < this.instruction.getOrderDetail().getPrice()) {
            this.ccsModel.setPrice(this.instruction.getOrderDetail().getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    };
    protected ChangeListener<Boolean> lstnFocusQuantity = (ob, old, newV) -> {
        if (this.instruction == null) {
            return;
        }
        if (newV.booleanValue()) {
            return;
        }
        this.modifyQuantity();
    };

    @PostConstruct
    public void init() {
        super.init();
        this.partType = "3";
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    public void initialize() {
        this.ccsModel.create("3");
        this.setConfirmSymbol("\u6307\u4ee4\u6267\u884c");
        this.onApprove(false);
        super.initialize();
        this.lbCan.visibleProperty().unbind();
        this.lbCanCount.visibleProperty().unbind();
        this.lbCan.setVisible(false);
        this.lbCanCount.setVisible(false);
        this.priceSpn.getEditor().focusedProperty().addListener(this.lstnFocusPrice);
        this.quantitySpn.getEditor().focusedProperty().addListener(this.lstnFocusQuantity);
        this.initFinished.set(true);
        this.doFill();
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.isLimitPrice() || this.ccsModel.isSpecify() || this.ccsModel.getAccDisModel().isActive(), (Observable[])new Observable[]{this.ccsModel.priceStgProperty(), this.ccsModel.priceTypeLimitedStgProperty(), this.ccsModel.getAccDisModel().activeProperty()}));
    }

    private boolean validOrderFill(ObSimpleInstruction ins) {
        return StringUtils.belongto((String)ins.getType(), (String[])new String[]{"SimpleDetail"}) && ins.getIsOrderStep();
    }

    @Override
    protected void submitOrder() {
        super.submitOrder();
        super.clearInfo();
    }

    @Override
    protected Result doAction() throws MException {
        return this.ccsModel.submit((TreeItem<CcsAccountDistribution>)this.ccsModel.getAccDisModel().getRoot(), this.instruction);
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            try {
                this.fillInstruction();
                this.btnOrder.setDisable(false);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }

    private void modifyQuantity() {
        long effectiveQuantity = this.instruction.getAvailOrderQty();
        if (this.ccsModel.getCount() > effectiveQuantity) {
            this.ccsModel.setCount(effectiveQuantity);
            this.quantitySpn.getEditor().requestFocus();
            this.quantitySpn.getEditor().selectAll();
        }
    }
}

