/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fix;

import cms.tmx.algorithm.viewers.AlgoUtils;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.instructions.models.fix.FixTradeBaseModel;
import cms.tmx.instructions.viewers.fix.LoadPartModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.neeq.view.NeeqEntrustConfirmDialog;
import cms.tmx.trade.utils.TradeAcctCountFilter;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class FixTradeBasePart
extends MxPart {
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    protected TextField txtCode;
    @FXML
    protected GridPane gridPanel;
    @FXML
    private Label lbName;
    @FXML
    protected Label lbSide;
    @FXML
    protected RadioButton buyRadio;
    @FXML
    protected RadioButton sellRadio;
    @FXML
    protected StackPane stkPaneCommon;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeMkt;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeAfterHours;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Spinner<Double> protectedPriceSpn;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Spinner<Integer> quantitySpn;
    @FXML
    private Label lbPer;
    @FXML
    private Label lbPerSymbol;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    protected Label lbUpLimit;
    @FXML
    protected Label lbDownLimit;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canSellCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @FXML
    private Label priceMag;
    @FXML
    private Label amtMag;
    @FXML
    private Label qtyMag;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, String> accntNameCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> posiCapitalCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> buyCostCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> floatPlCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> realPlCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Number> totalPlCol;
    @FXML
    private HBox hbSum;
    @FXML
    private Label lbNum;
    @FXML
    private Label lbPosiAmt;
    @FXML
    private Label lbPosiCapital;
    @FXML
    private Label lbFloatPL;
    @FXML
    private Label lbRealPl;
    @FXML
    private Label lbTotalPl;
    @FXML
    protected Label lbCan;
    @FXML
    protected Label lbCanCount;
    @FXML
    protected Button btnOrder;
    @FXML
    private ComboBox<MxNode> cmbAccFilter;
    @FXML
    private HBox hBoxPartlyAccCount;
    @FXML
    private Label lbSecAccCount;
    @FXML
    private TextField textAccCount;
    @FXML
    private TextField txtSearch;
    @FXML
    protected CheckBox checkBoxModify;
    @FXML
    protected HBox hboxProtectedPrice;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected FixTradeBaseModel ccsModel;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    @Inject
    protected IUIService uiService;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected MarketItem mktItem;
    private SecConverter secCvt;
    protected String confirmSymbol = "";
    protected boolean priceSettle = false;
    protected ObSimpleInstruction instruction = null;
    protected boolean isInstructionEvent = false;
    protected String partType = "";
    protected AtomicBoolean initFinished = new AtomicBoolean(false);
    protected Map<String, List<CcsOrder>> map;
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {});
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleSpinnerCtrl ctrlMoney = new DoubleSpinnerCtrl(true, 12, 2);
    protected SecSuggest spCode = new SecSuggest();
    protected AutoCompletion<RefItem> autoCompletionNormal;
    private MEventHandler hSetPst = event -> {
        if ("3".equals(this.ccsModel.getAccDisModel().getInstructType()) || "4".equals(this.ccsModel.getAccDisModel().getInstructType())) {
            return;
        }
        if (this.autoCompletionNormal == null) {
            return;
        }
        String market = event.getStr("tMarket");
        if (!"XSHE".equals(market) && !"XSHG".equals(market)) {
            return;
        }
        String secCode = event.getStr("sec_code");
        this.txtCode.setText(secCode);
        RefItem item = null;
        for (RefItem it : this.getRefItems()) {
            if (!it.getCode().equals(secCode) || !it.getMarket().equals(market)) continue;
            item = it;
        }
        this.txtCode.setUserData(item);
        this.ccsModel.setPstAcct(event.getStr("secAccount"), event.getStr("tMarket"));
        this.sellRadio.setSelected(event.getBool("side_sell"));
        this.autoCompletionNormal.setChange(secCode);
        this.onSecurityChange(this.txtCode, secCode);
        this.ccsModel.setCount(event.getLong("count"));
        this.ccsModel.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
    };
    private InvalidationListener listener = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private ListChangeListener<TreeItem<CcsAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    checkBox.setDisable(!FixTradeBasePart.this.ccsModel.getAccDisModel().isActive());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(FixTradeBasePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> FixTradeBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem));
                        FixTradeBasePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                FixTradeBasePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> FixTradeBasePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(((CcsAccountDistribution)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };
    @Inject
    protected LoadPartModel load;

    @Inject
    public FixTradeBasePart() {
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
    }

    public void onShowEvent(MEvent event) {
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("trade.panel.set.code", this.hSetPst);
    }

    @FXML
    public void initialize() {
        this.mktItem = this.ccsModel.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> Platform.runLater(() -> this.onRefChange()));
        this.mktItem.changedProperty().addListener(ob -> Platform.runLater(() -> this.onMktItemChange()));
        this.refMng.changedProperty().addListener(this.listener);
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTree();
        this.es.subscribe("trade.panel.set.code", this.hSetPst);
    }

    protected Collection<RefItem> getRefItems() {
        return this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
    }

    protected void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.getRefItems());
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChange(this.txtCode, (String)newV);
            this.tableMarketBuy.refresh();
            this.tableMarketSell.refresh();
            this.acctTreeTable.refresh();
            this.layout();
        }));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.ccsModel.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.ccsModel.nameProperty());
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.setSelected(true);
        this.cmbPriceType.setItems(this.ccsModel.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.ccsModel.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.onPriceTypeChange());
        this.cmbPriceTypeLimited.setItems(this.ccsModel.getPriceTypeLimitedStg().getNodes());
        this.cmbPriceTypeLimited.valueProperty().bindBidirectional(this.ccsModel.priceTypeLimitedStgProperty());
        this.cmbPriceTypeLimited.valueProperty().addListener((ob, old, newV) -> this.onPriceTypeLimitedChange((MxNode)newV));
        this.cmbPriceTypeLimited.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.limitKeyPress((KeyEvent)event));
        this.cmbPriceTypeMkt.setItems(this.ccsModel.getPriceTypeMktStg().getNodes());
        this.cmbPriceTypeMkt.valueProperty().bindBidirectional(this.ccsModel.priceTypeMktStgProperty());
        this.cmbPriceTypeMkt.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.mktKeyPress((KeyEvent)event));
        this.cmbPriceTypeBidAsk.setItems(this.ccsModel.getPriceTypeBidAskStg().getNodes());
        this.cmbPriceTypeBidAsk.valueProperty().bindBidirectional(this.ccsModel.priceTypeBidAskStgProperty());
        this.cmbPriceTypeBidAsk.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.bidaskKeyPress((KeyEvent)event));
        this.cmbPriceTypeAfterHours.setItems(this.ccsModel.getPriceTypeAfterHours().getNodes());
        this.cmbPriceTypeAfterHours.valueProperty().bindBidirectional(this.ccsModel.priceTypeAfterHoursProperty());
        this.cmbPriceTypeAfterHours.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.bidaskKeyPress((KeyEvent)event));
        this.ctrlPrice.ctrl(this.priceSpn);
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.ccsModel.priceProperty());
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setText("");
        this.ctrlPrice.ctrl(this.protectedPriceSpn);
        MxBindings.bindSD((Property)this.protectedPriceSpn.getEditor().textProperty(), (Property)this.ccsModel.priceProtectedProperty());
        this.protectedPriceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.protectedPriceSpn.getEditor().setText("");
        this.priceDisableBind();
        this.priceVisibleBind();
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.quantitySpn);
        SpinnerUtils.arrowsStyle(this.protectedPriceSpn);
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.quantitySpn.getEditor());
        TextFieldUtils.showMagnitude((Label)this.priceMag, (TextField)this.priceSpn.getEditor());
        this.setPriceUnit();
        this.lbCan.visibleProperty().bind((ObservableValue)this.ccsModel.getAccDisModel().showCanBuyProperty());
        this.lbCanCount.visibleProperty().bind((ObservableValue)this.ccsModel.getAccDisModel().showCanBuyProperty());
        MxBindings.bindSI((Property)this.lbCanCount.textProperty(), (Property)this.ccsModel.getAccDisModel().canBuyProperty());
        this.ctrlCount.ctrl(this.quantitySpn);
        this.quantityDisableBind();
        MxBindings.bindSI((Property)this.quantitySpn.getEditor().textProperty(), (Property)this.ccsModel.countProperty());
        this.quantitySpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> Platform.runLater(() -> this.quantityKeyPress((KeyEvent)event)));
        this.quantitySpn.getEditor().setOnMouseClicked(event -> this.quantitySpn.getEditor().selectAll());
        this.checkBoxModify.selectedProperty().bindBidirectional((Property)this.ccsModel.canModifyProperty());
    }

    protected void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.indexBuy.setCellFactory(cell -> new IndexCell());
        this.mktBuyPrice.setCellFactory(cell -> new BoldPriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new BoldCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellOrder.setCellFactory(cell -> new BoldOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new BoldOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        TableUtils.beforeClick(this.tableMarketBuy, item -> this.onMktItemClicked((HandicapInfo)item));
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.indexSell.setCellFactory(cell -> new IndexCell());
        this.mktSellPrice.setCellFactory(cell -> new BoldPriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new BoldCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        TableUtils.beforeClick(this.tableMarketSell, item -> this.onMktItemClicked((HandicapInfo)item));
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        Tooltip t = new Tooltip();
        t.textProperty().bind((ObservableValue)this.lbUpLimit.textProperty());
        this.lbUpLimit.setTooltip(t);
        this.lbUpLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.ccsModel.isBond() && this.ccsModel.isValidRef() && this.mktItem.getUpLimitPrice() != 0.0, (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbDownLimit.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.mktItem.isClear() && !this.ccsModel.isBond() && this.ccsModel.isValidRef() && this.mktItem.getDownLimitPrice() != 0.0, (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.lbRate.textProperty());
        this.lbRate.setTooltip(tooltip);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
    }

    protected void afterTableRestore() {
        this.canBuyCol.setVisible(true);
        this.canSellCol.setVisible(true);
    }

    protected void createAcctTree() {
        this.cmbDist.setItems(this.ccsModel.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.ccsModel.distStgProperty());
        this.cmbAccFilter.setItems(this.ccsModel.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.ccsModel.accFilterStgProperty());
        this.hBoxPartlyAccCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getAccFilterStg().getRaw().equals("1"), (Observable[])new Observable[]{this.ccsModel.accFilterStgProperty()}));
        MxBindings.bindSI((Property)this.lbSecAccCount.textProperty(), (Property)this.ccsModel.getAccDisModel().effectiveSecAccCountProperty());
        MxBindings.bindSI((Property)this.textAccCount.textProperty(), (Property)this.ccsModel.getAccDisModel().customSecAccCountProperty());
        this.textAccCount.setTextFormatter(new TextFormatter((UnaryOperator)new TradeAcctCountFilter(true, 9, this.ccsModel.getAccDisModel().effectiveSecAccCountProperty())));
        this.txtSearch.textProperty().bindBidirectional((Property)this.ccsModel.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(data -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().availableProperty());
        this.availableCol.setCellFactory(data -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canSellCol.setCellFactory(data -> new NumberTreeTableCell());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty());
        this.assetCol.setCellFactory(data -> new MoneyCell(2));
        this.ccsModel.getAccDisModel().repoProperty().addListener((ob, old, newV) -> {
            this.canBuyCol.setVisible(newV == false);
            this.canSellCol.setVisible(newV == false);
        });
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(data -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(data -> new NumberTreeTableCell());
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.acctTreeTable.setRoot(this.ccsModel.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.ccsModel.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
        this.checkIsAutotrophy();
    }

    protected boolean isAutotrophy() {
        return false;
    }

    private void checkIsAutotrophy() {
        if (this.isAutotrophy()) {
            this.accntNameCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accntNameProperty());
            this.posiCapitalCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).capitalizationProperty());
            this.posiCapitalCol.setCellFactory(data -> new NumberCell());
            this.buyCostCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).buyCostAmtProperty());
            this.buyCostCol.setCellFactory(data -> new NumberCell());
            this.floatPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).floatPlProperty());
            this.floatPlCol.setCellFactory(data -> new NumberCell());
            this.realPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).realPlProperty());
            this.realPlCol.setCellFactory(data -> new NumberCell());
            this.totalPlCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).totalPlProperty());
            this.totalPlCol.setCellFactory(data -> new NumberCell());
            MxBindings.bindSD((Property)this.lbNum.textProperty(), (Property)this.ccsModel.getAccDisModel().numProperty());
            MxBindings.bindSDTwoScale((Property)this.lbPosiAmt.textProperty(), (Property)this.ccsModel.getAccDisModel().buyCostAmtProperty());
            MxBindings.bindSDTwoScale((Property)this.lbPosiCapital.textProperty(), (Property)this.ccsModel.getAccDisModel().capitalProperty());
            MxBindings.bindSDTwoScale((Property)this.lbFloatPL.textProperty(), (Property)this.ccsModel.getAccDisModel().floatPlProperty());
            MxBindings.bindSDTwoScale((Property)this.lbRealPl.textProperty(), (Property)this.ccsModel.getAccDisModel().realPlProperty());
            MxBindings.bindSDTwoScale((Property)this.lbTotalPl.textProperty(), (Property)this.ccsModel.getAccDisModel().totalPlProperty());
            this.stkPaneCommon.setVisible(false);
        } else {
            this.acctTreeTable.getColumns().remove(this.accntNameCol);
            this.acctTreeTable.getColumns().remove(this.posiCapitalCol);
            this.acctTreeTable.getColumns().remove(this.buyCostCol);
            this.acctTreeTable.getColumns().remove(this.floatPlCol);
            this.acctTreeTable.getColumns().remove(this.realPlCol);
            this.acctTreeTable.getColumns().remove(this.totalPlCol);
            ((VBox)this.hbSum.getParent()).getChildren().remove((Object)this.hbSum);
        }
    }

    protected void acctTreeSupplement() {
        this.ccsModel.countStgProperty().addListener(ob -> {
            String stg = this.ccsModel.getCountStg().getRaw();
            if (stg.equals("1") || stg.equals("5")) {
                this.cmbDist.setDisable(false);
            } else {
                this.cmbDist.setDisable(true);
            }
        });
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    protected void onRefChange() {
        TradeBindings.priceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        this.changeUnit();
    }

    protected void onMktItemChange() {
        if (this.ccsModel.isBidAskPrice()) {
            this.ccsModel.setBidAskPrice();
        }
        this.logger.info("\u8bc1\u5238\u4ee3\u7801:" + this.txtCode.getText() + "\u8bc1\u5238\u4ea4\u6613\u8fdb\u5165\u52a8\u6001\u884c\u60c5\u53d8\u5316\u65b9\u6cd5\uff0c\u505c\u724c\u6807\u5fd7" + this.mktItem.getStop().getValue());
        this.check();
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    protected void onBSChange(Boolean old, Boolean now) {
        if (now.booleanValue()) {
            this.btnOrder.setText(this.buySymbol);
            this.lbCan.setText("\u53ef\u4e70");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText(this.sellSymbol);
            this.lbCan.setText("\u53ef\u5356");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
        this.ccsModel.setBuy(now);
        this.layout();
    }

    protected void onPriceTypeChange() {
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        this.hideShow();
    }

    private void hideShow() {
        if (this.cmbPriceType.getValue() == null) {
            return;
        }
        if (((MxNode)this.cmbPriceType.getValue()).is("49")) {
            this.cmbPriceTypeMkt.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else if (((MxNode)this.cmbPriceType.getValue()).is("0")) {
            this.cmbPriceTypeBidAsk.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(false);
        } else {
            this.cmbPriceTypeBidAsk.setVisible(false);
            this.cmbPriceTypeLimited.setVisible(false);
            this.cmbPriceTypeMkt.setVisible(false);
            this.cmbPriceTypeAfterHours.setVisible(true);
        }
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCode.setText(txtCode.getText());
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.doChange(refItem, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void setPrePrice() {
        if (this.ccsModel.isMktPrice() && !this.priceSettle) {
            this.ccsModel.setMktPrice();
            if (this.ccsModel.getPrice() > 0.0) {
                this.priceSettle = true;
            }
            return;
        }
        if (this.ccsModel.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
    }

    protected void doChange(RefItem refItem, String newText) {
        this.ccsModel.getMI().setRefItem(refItem);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        if (this.ccsModel.isValidRef()) {
            this.ctrlPrice.setScale(refItem.getScale());
        }
        this.ccsModel.onSecChange();
        if (refItem != null) {
            boolean isRepo = AlgoUtils.isRepo((RefItem)refItem);
            this.buyRadio.setText(isRepo ? "\u6b63\u56de\u8d2d" : "\u4e70");
            this.sellRadio.setText(isRepo ? "\u9006\u56de\u8d2d" : "\u5356");
            this.txtCode.setText(refItem.getCode());
            MEvent event = new MEvent();
            event.put((Object)"code", (Object)this.mktItem.getRefItem().getCode());
            event.put((Object)"market", (Object)this.mktItem.getRefItem().getMarket());
            this.es.postEvent("code_change", event);
        }
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (newText.length() >= 6) {
            this.check();
        }
        if (this.ccsModel.isValidRef()) {
            this.checkRepo();
            this.priceSettle = false;
            this.setPrePrice();
        }
        this.layout();
    }

    protected void checkRepo() {
    }

    protected void onPriceTypeLimitedChange(MxNode newV) {
        if (newV == null) {
            return;
        }
        if (newV.getNode("3") == null) {
            return;
        }
        if (newV.is("3")) {
            this.priceSpn.getEditor().clear();
        }
    }

    protected void quantityDisableBind() {
        this.quantitySpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.getCountStg().is("1"), (Observable[])new Observable[]{this.ccsModel.countStgProperty()}));
    }

    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.ccsModel.isLimitPrice() && !this.ccsModel.isAfterHoursPrice() || this.ccsModel.isUnlimited(), (Observable[])new Observable[]{this.ccsModel.priceStgProperty(), this.ccsModel.priceTypeLimitedStgProperty()}));
    }

    protected void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return true;
            }
            if (!(((MxNode)this.cmbPriceType.getValue()).is("50") || ((MxNode)this.cmbPriceType.getValue()).is("0") || ((MxNode)this.cmbPriceType.getValue()).is("99"))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
        this.hboxProtectedPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbPriceType.getValue() == null) {
                return false;
            }
            if (((MxNode)this.cmbPriceType.getValue()).is("49") && this.ccsModel.isStar()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty(), this.mktItem.changedProperty()}));
    }

    private void checkSecLabel() {
        if (this.txtCode.getText().length() < 6) {
            return;
        }
        RefItem ref = this.mktItem.getRefItem();
        Platform.runLater(() -> {
            if (ref == null || ref.getName().equals("") || this.ccsModel.getValidRef() == null) {
                this.lbName.setText(INVALID_CODE);
                this.lbName.setTooltip(null);
                this.lbName.setStyle("-fx-font-size: 12;");
            } else if (this.mktItem.getStop().getValue().booleanValue()) {
                this.lbName.setText(this.mktItem.getStatus());
                this.lbName.setTooltip(null);
                this.lbName.setStyle("-fx-font-size: 12;");
            } else if (ref.isGem()) {
                if (ref.getStatus().contains("\u4e0a\u5e02\u521d\u671f") || ref.getStatus().contains("\u4e0a\u5e02\u9996\u65e5")) {
                    this.lbName.setText(String.valueOf(ref.getName()) + " " + "\u521d");
                } else {
                    this.lbName.setText(ref.getName());
                }
                Tooltip tooltip = new Tooltip();
                StringBuilder builder = new StringBuilder();
                builder.append(ref.getNoProfit() == 0 ? "\u5df2\u76c8\u5229" : "\u672a\u76c8\u5229");
                builder.append("\r\n");
                builder.append(ref.getWeightedVotingRights() == 0 ? "\u6295\u7968\u6743\u4e0d\u5b58\u5728\u5dee\u5f02" : "\u6295\u7968\u6743\u5b58\u5728\u5dee\u5f02");
                builder.append("\r\n");
                builder.append(ref.getIsRegistration() == 0 ? "\u975e\u6ce8\u518c\u5236" : "\u6ce8\u518c\u5236");
                builder.append("\r\n");
                builder.append(ref.getIsVIE() == 0 ? "\u4e0d\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6" : "\u5177\u6709\u534f\u8bae\u63a7\u5236\u6846\u67b6");
                builder.append("\r\n");
                tooltip.setText(builder.toString());
                this.lbName.setTooltip(tooltip);
                this.lbName.setStyle("-fx-font-size: 12;");
            } else if ("FUND".equals(ref.getType())) {
                BigDecimal down = new BigDecimal(ref.getLimitDownRate());
                BigDecimal up = new BigDecimal(ref.getLimitUpRate());
                if (down.doubleValue() == 0.2 || up.doubleValue() == 0.2) {
                    this.lbName.setText(String.valueOf(ref.getName()) + "(\u6da8\u8dcc20%)");
                    this.lbName.setStyle("-fx-font-size: 10;");
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(String.valueOf(ref.getName()) + "(\u6da8\u8dcc20%)");
                    this.lbName.setTooltip(tooltip);
                } else {
                    this.lbName.setText(ref.getName());
                    this.lbName.setTooltip(null);
                }
            } else {
                this.lbName.setText(ref.getName());
                this.lbName.setTooltip(null);
                this.lbName.setStyle("-fx-font-size: 12;");
            }
        });
    }

    private void check() {
        this.checkSecLabel();
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                FixTradeBasePart.this.checkSecLabel();
            }
        };
        timer.schedule(task, 500L);
    }

    protected void setPriceUnit() {
        this.lbUnit.setText("\u80a1");
    }

    private void changeUnit() {
        this.lbUnit.setText("");
        this.ctrlCount.setUnit(this.mktItem.getRefItem().getBuyUnit());
        if (this.ccsModel.isBond()) {
            if (this.ccsModel.isSHbond()) {
                this.lbUnit.setText("\u624b");
            } else {
                this.lbUnit.setText("\u5f20");
            }
        }
        if (this.ccsModel.isStock()) {
            this.lbUnit.setText("\u80a1");
        }
        if (this.ccsModel.isFund()) {
            this.lbUnit.setText("\u4efd");
        }
    }

    public boolean valid() {
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.ccsModel.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.ccsModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.ccsModel.getCount() >= 0L && this.ccsModel.getAccDisModel().isCountValid() != false, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip6 = "\u4fdd\u62a4\u4ef7\u683c\u9700\u8981\u5927\u4e8e0\uff0c\u5c0f\u4e8e1\u4e07\u5143\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
        return this.alert.check(!this.ccsModel.isStar() || !this.ccsModel.isMktPrice() || this.ccsModel.isStar() && this.ccsModel.getPriceProtected() > 0.0 && this.ccsModel.getPriceProtected() < 10000.0, Alert.AlertType.WARNING, tip6);
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(!this.ccsModel.isLimitPrice() && !this.ccsModel.isAfterHoursPrice() || this.ccsModel.isUnlimited() || this.ccsModel.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    protected String getOrderInfo() {
        StringBuilder info = new StringBuilder();
        for (CcsAccountDistribution acc : this.ccsModel.getAccDisModel().getValidSecAcc()) {
            info.append("\n\u8d26\u53f7   " + acc.getSecAcc().getInverstorSecId() + " \u59d4\u6258\u6570\u91cf   " + acc.getCount());
        }
        return info.toString();
    }

    @FXML
    public void order() {
        this.ccsModel.getAccDisModel().getValidSecAcc();
        if (this.valid()) {
            if (this.ccsModel.isStar() && this.ccsModel.isMktPrice() && this.mktItem.getUpLimitPrice() > 0.0 && this.ccsModel.getPriceProtected() > this.mktItem.getUpLimitPrice() && !this.alert.alert(Alert.AlertType.CONFIRMATION, "\u60a8\u8f93\u5165\u7684\u4fdd\u62a4\u4ef7\u683c\u5927\u4e8e\u6da8\u505c\u4ef7\u683c\uff0c\u662f\u5426\u7ee7\u7eed\u59d4\u6258\uff1f")) {
                return;
            }
            List<NewCcsSingleEntrust> entrusts = this.ccsModel.getEntrustList(false);
            NeeqEntrustConfirmDialog obj = (NeeqEntrustConfirmDialog)this.of.create(NeeqEntrustConfirmDialog.class);
            if (!"0".equals(this.ccsModel.getAccDisModel().getInstructType()) && !"4".equals(this.ccsModel.getAccDisModel().getInstructType())) {
                obj.setInstruction(true);
            } else {
                obj.setExecution(true);
            }
            obj.setInstructionPanelType(this.ccsModel.getAccDisModel().getInstructType());
            obj.setBuySymbol(this.getBuySymbol());
            obj.setSellSymbol(this.getSellSymbol());
            obj.setRefItem(this.mktItem.getRefItem());
            obj.setPriceStg(this.ccsModel.getPriceStg());
            obj.setPriceTypeMktStg(this.ccsModel.getPriceTypeMktStg());
            obj.setPriceTypeLimitedStg(this.ccsModel.getPriceTypeLimitedStg());
            obj.setPriceTypeBidAskStg(this.ccsModel.getPriceTypeBidAskStg());
            obj.setUnit(this.lbUnit.getText());
            obj.setList(entrusts);
            MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u5355\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
            if (dialog.launch() == ButtonType.OK) {
                this.submitOrder();
            }
        }
        this.layout();
    }

    protected void submitOrder() {
        Result result = null;
        try {
            result = this.doAction();
            if (result.failed > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14" + result.getReason().toString());
            } else {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25" + e.toString());
            this.logger.error("\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25", (Throwable)e);
        }
        this.clearCountCheck();
    }

    protected Result doAction() throws MException {
        return this.ccsModel.submit((TreeItem<CcsAccountDistribution>)this.ccsModel.getAccDisModel().getRoot());
    }

    protected void clearCountCheck() {
    }

    protected void clearCountCheckForce() {
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (this.ccsModel.isLimitPrice()) {
                this.cmbPriceTypeLimited.requestFocus();
            } else if (this.ccsModel.isMktPrice()) {
                this.cmbPriceTypeMkt.requestFocus();
            } else if (this.ccsModel.isBidAskPrice()) {
                this.cmbPriceTypeBidAsk.requestFocus();
            } else {
                this.cmbPriceTypeAfterHours.requestFocus();
            }
            key.consume();
        }
    }

    public void limitKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            key.consume();
        }
    }

    public void mktKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (this.ccsModel.isMktPrice() && this.ccsModel.isStar()) {
                this.protectedPriceSpn.requestFocus();
            } else {
                this.quantitySpn.requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    public void bidaskKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.quantitySpn.requestFocus();
            this.quantitySpn.getEditor().selectAll();
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.quantitySpn.requestFocus();
            this.quantitySpn.getEditor().selectAll();
            key.consume();
        }
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.order();
            key.consume();
        }
    }

    protected boolean onMktItemClicked(HandicapInfo now) {
        this.setPrice(now.getPrice());
        return false;
    }

    public void setPrice(double price) {
        if ((this.ccsModel.isLimitPrice() || this.ccsModel.isAfterHoursPrice()) && !this.ccsModel.isUnlimited() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.ccsModel.setPrice(price);
        } else {
            if (this.ccsModel.isMktPrice() || this.ccsModel.isBidAskPrice()) {
                return;
            }
            this.priceSpn.getEditor().setText("");
        }
    }

    private void initPanel() {
        this.onApprove(true);
        this.isInstructionEvent = true;
        this.txtCode.clear();
        this.txtCode.setUserData(null);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.protectedPriceSpn.getEditor().clear();
        this.ccsModel.setInstruction(new ObSimpleInstruction());
        this.ccsModel.getAccDisModel().setActive(false);
        this.buyRadio.setSelected(true);
    }

    protected void fillInstruction() throws MException {
        this.initPanel();
        this.ccsModel.setInstruction(this.instruction);
        if (this.instruction.getOrderDetail() == null) {
            return;
        }
        RefItem refItem = this.refMng.getItem(this.instruction.getSecType(), this.instruction.getSecMarket(), this.instruction.getSecurityCode());
        this.txtCode.setUserData((Object)refItem);
        this.doChange(refItem, this.instruction.getSecurityCode());
        if (this.isInstructionEvent && this.getValidRef() != null && "SimpleDetail".equals(this.instruction.getType())) {
            this.isInstructionEvent = false;
            this.doOrderFill();
        }
    }

    private void doOrderFill() {
        if (this.getValidRef() == null) {
            return;
        }
        ExecJob job = null;
        SimpleDetail orderDetail = this.instruction.getOrderDetail();
        if (this.instruction.getJobs() != null && this.instruction.getJobs().size() > 0) {
            job = (ExecJob)this.instruction.getJobs().get(0);
        }
        long effectiveQuantity = (long)job.getAvailOrderQty();
        this.quantitySpn.getEditor().setText(Long.toString(effectiveQuantity));
        this.cmbDist.getSelectionModel().select(1);
        this.ccsModel.getAccDisModel().fillAccount(this.instruction);
        this.setPrice(new BigDecimal(orderDetail.getPrice()).setScale(this.getValidRef().getScale(), 4).doubleValue());
        if (Side.SIDE_SELL.getValue().equals(orderDetail.getSide().getValue()) || Side.SIDE_LEND.getValue().equals(orderDetail.getSide().getValue())) {
            this.sellRadio.setSelected(true);
        } else {
            this.buyRadio.setSelected(true);
        }
        if (this.ccsModel.getPriceTypeLimitedStg() != null && OrdType.ORD_TYPE_LIMIT.getValue().equals(orderDetail.getOrdType().getValue())) {
            this.cmbPriceTypeLimited.getSelectionModel().select((Object)this.ccsModel.getPriceTypeLimitedStg().getNode(Integer.toString(orderDetail.getPriceRestriction())));
        }
        if (this.ccsModel.getPriceTypeMktStg() != null && OrdType.ORD_TYPE_MARKET.getValue().equals(orderDetail.getOrdType().getValue())) {
            String marketType = MarketUtils.getNeeqMarketPriceType((int)orderDetail.getTif().getValue(), (int)orderDetail.getMaxPriceLevels());
            this.cmbPriceTypeMkt.getSelectionModel().select((Object)this.ccsModel.getPriceTypeMktStg().getNode(marketType));
            this.ccsModel.setMktPrice();
        }
        if (this.ccsModel.getPriceTypeBidAskStg() != null && OrdType.ORD_TYPE_UNDEFINED.getValue().equals(orderDetail.getOrdType().getValue())) {
            this.cmbPriceTypeBidAsk.getSelectionModel().select((Object)this.ccsModel.getPriceTypeBidAskStg().getNode(Integer.toString(orderDetail.getPlateLevels())));
            this.ccsModel.setBidAskPrice();
        }
        if (this.instruction.getIsOrderStep() && this.ccsModel.isLimitPrice()) {
            this.ccsModel.setPrice(orderDetail.getPrice());
        }
        if (!this.instruction.getIsOrderStep() && this.ccsModel.isLimitPrice()) {
            this.ccsModel.setPrice(orderDetail.getPrice());
        }
        if ("99".equals(orderDetail.getOrdType().getValue())) {
            this.ccsModel.setPrice(orderDetail.getPrice());
        }
        this.ccsModel.setPriceProtected(orderDetail.getStopPrice());
        this.checkBoxModify.setSelected(false);
        if (this.ccsModel.isUpLimit() || this.ccsModel.isDownLimit() || this.ccsModel.isUnlimited()) {
            this.checkBoxModify.setVisible(true);
            this.checkBoxModify.setDisable(true);
        } else {
            this.checkBoxModify.setVisible(false);
        }
    }

    protected void onApprove(boolean isApprove) {
        this.txtCode.setDisable(true);
        this.buyRadio.setDisable(true);
        this.sellRadio.setDisable(true);
        this.cmbPriceType.setDisable(true);
        this.cmbPriceTypeLimited.setDisable(true);
        this.cmbPriceTypeMkt.setDisable(true);
        this.cmbPriceTypeBidAsk.setDisable(true);
        this.cmbPriceTypeAfterHours.setDisable(true);
        this.checkBoxModify.setDisable(true);
        this.btnOrder.setDisable(true);
        this.acctTreeTable.setDisable(isApprove);
        this.cmbDist.setDisable(true);
        this.cmbAccFilter.setDisable(true);
        this.txtSearch.setDisable(true);
    }

    private void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.canBuyCol.getText() + "\t" + this.canSellCol.getText() + "\t" + this.productCol.getText() + "\t" + '\n');
        for (TreeItem item : this.ccsModel.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getAcc().getAssetAmt() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + accDis.getCanBuy() + "\t" + accDis.getCanSell() + "\t" + accDis.getAcc().getProductName() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + "\t" + secAccDis.getCanSell() + "\t" + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    public TreeTableView<CcsAccountDistribution> getAccTreeTable() {
        return this.acctTreeTable;
    }

    protected void clearInfo() {
        this.instruction = null;
        this.btnOrder.setDisable(true);
        this.txtCode.setText("");
        this.lbName.setText("");
        this.priceSpn.getEditor().setText("");
        this.quantitySpn.getEditor().setText("");
        this.mktItem.setRefItem(null);
        this.getFixTradeBaseModel().getAccDisModel().removeTree();
    }

    public FixTradeBaseModel createModel() {
        return (FixTradeBaseModel)this.of.create(FixTradeBaseModel.class);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public void initUserPre() {
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public Spinner<Double> getProtectedPriceSpn() {
        return this.protectedPriceSpn;
    }

    public Spinner<Integer> getQuantitySpn() {
        return this.quantitySpn;
    }

    public void setCount(Long buyQuantity) {
        this.ccsModel.setCount(buyQuantity);
    }

    public void setMoney(double value) {
        this.ccsModel.setMoney(value);
    }

    public void setCountPer(Double value) {
        this.ccsModel.setCountPer(value);
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setAutoSlice(boolean slice, long size) {
        this.ccsModel.setAutoSlice(slice);
        this.ccsModel.setSliceSize(size);
    }

    public RefItem getValidRef() {
        return this.ccsModel.getValidRef();
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    public boolean getActiveFlag() {
        return this.ccsModel.getAccDisModel().isActive();
    }

    public FixTradeBaseModel getFixTradeBaseModel() {
        return this.ccsModel;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    public class BoldCountCell
    extends HandicapCountCell<HandicapInfo> {
        public BoldCountCell(MarketItem info) {
            super(info);
            CssUtils.priceTag((Control)this);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getId().toLowerCase().contains("buy") && this.getIndex() == 0 || this.getId().toLowerCase().contains("sell") && this.getIndex() == FixTradeBasePart.this.tableMarketSell.getItems().size() - 1) {
                CssUtils.boldPrice((Control)this);
            }
        }
    }

    public class BoldOrderCell
    extends HandicapOrderCell {
        public BoldOrderCell(MarketItem info) {
            super(info);
            CssUtils.priceTag((Control)this);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getId().toLowerCase().contains("buy") && this.getIndex() == 0 || this.getId().toLowerCase().contains("sell") && this.getIndex() == FixTradeBasePart.this.tableMarketSell.getItems().size() - 1) {
                CssUtils.boldPrice((Control)this);
            }
        }
    }

    public class BoldPriceCell
    extends PriceCell<HandicapInfo> {
        public BoldPriceCell(MarketItem info) {
            super(info);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getId().toLowerCase().contains("buy") && this.getIndex() == 0 || this.getId().toLowerCase().contains("sell") && this.getIndex() == FixTradeBasePart.this.tableMarketSell.getItems().size() - 1) {
                CssUtils.boldPrice((Control)this);
            }
        }
    }

    public class IndexCell
    extends TableCell<String, String> {
        public IndexCell() {
            CssUtils.priceTag((Control)this);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && !item.isEmpty() && item != null) {
                this.setText(item);
            }
            if (this.getId().toLowerCase().contains("buy") && this.getIndex() == 0 || this.getId().toLowerCase().contains("sell") && this.getIndex() == FixTradeBasePart.this.tableMarketSell.getItems().size() - 1) {
                CssUtils.boldPrice((Control)this);
            }
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class NumberCell
    extends NumberTreeTableCell<CcsAccountDistribution> {
        public NumberCell() {
            super(2);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

