/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fix;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.instructions.viewers.fix.FixTradeBasePart;
import cms.tmx.query.current.models.NewInstructionModel;
import cms.tmx.utils.StringUtils;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class FixTradeApprovePart
extends FixTradeBasePart {
    @Inject
    private NewInstructionModel insModel;
    protected MEventHandler hSetCodeApp = event -> {
        if (event.get((Object)"instruction") == null || !(event.get((Object)"instruction") instanceof ObSimpleInstruction)) {
            return;
        }
        ObSimpleInstruction ins = (ObSimpleInstruction)ObSimpleInstruction.class.cast(event.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };

    @PostConstruct
    public void init() {
        super.init();
        this.partType = "2";
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    public void initialize() {
        this.ccsModel.create("2");
        this.setBuySymbol("\u5ba1\u6279\u901a\u8fc7");
        this.setSellSymbol("\u5ba1\u6279\u901a\u8fc7");
        this.setConfirmSymbol("\u5ba1\u6279");
        this.onApprove(true);
        super.initialize();
        this.lbCan.visibleProperty().unbind();
        this.lbCanCount.visibleProperty().unbind();
        this.lbCan.setVisible(false);
        this.lbCanCount.setVisible(false);
        this.initFinished.set(true);
        this.doFill();
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.setDisable(true);
    }

    @Override
    protected void quantityDisableBind() {
        this.quantitySpn.setDisable(true);
    }

    private boolean validOrderFill(ObSimpleInstruction ins) {
        return StringUtils.belongto((String)ins.getType(), (String[])new String[]{"SimpleDetail"}) && ins.isIsApproveStep();
    }

    @Override
    protected void submitOrder() {
        WorkflowTask task = null;
        List workflowTasks = this.instruction.getWorkflowTasks();
        String operation = "";
        for (WorkflowTask workflowTask : workflowTasks) {
            if (workflowTask.getPermissibleList().contains("2")) {
                task = workflowTask;
                operation = "2";
            }
            if (!workflowTask.getPermissibleList().contains("6")) continue;
            task = workflowTask;
            operation = "6";
        }
        if (task == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5ba1\u6279\u5931\u8d25\uff0c\u672a\u53d6\u5230\u5ba1\u6279\u4efb\u52a1");
            return;
        }
        try {
            this.insModel.complateTask(this.instruction.getId(), this.instruction.getEntryId(), operation, task, null);
        }
        catch (MException | Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5ba1\u6279\u5931\u8d25:" + e.getMessage());
            return;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u5ba1\u6279\u6210\u529f");
        this.clearInfo();
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            try {
                this.fillInstruction();
                this.btnOrder.setDisable(false);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }
}

