/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fix;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.instructions.models.fix.FixPositionModel;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.utils.FundAccountStringConverter;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.di.Focus;

public class FixPositionPart
extends MxPart {
    @FXML
    protected TextField searchText;
    @FXML
    protected ComboBox<MxNode> cmbFilter;
    @FXML
    protected CheckComboBox<FundAccount> ccmbAccnt;
    @FXML
    private Label lbAccnt;
    @FXML
    protected CheckComboBox<MxNode> ccmbMarket;
    @FXML
    private Label lbMarket;
    @FXML
    protected CheckComboBox<SecAccount> ccmbSecAcc;
    protected String filterType = "";
    @FXML
    private Label lbSecAcc;
    @FXML
    protected TableView<ObPosition> tablePosition;
    @FXML
    protected TableColumn<ObPosition, String> colSecId;
    @FXML
    protected TableColumn<ObPosition, String> colSecName;
    @FXML
    protected TableColumn<ObPosition, Number> colTotalVol;
    @FXML
    protected TableColumn<ObPosition, String> colUnit;
    @FXML
    protected TableColumn<ObPosition, Number> colCanVol;
    @FXML
    protected TableColumn<ObPosition, Number> colCost;
    @FXML
    protected TableColumn<ObPosition, Number> colCostAmt;
    @FXML
    private TableColumn<ObPosition, Number> colCapital;
    @FXML
    protected TableColumn<ObPosition, Number> colBuyCost;
    @FXML
    protected TableColumn<ObPosition, Number> colBuyCostAmt;
    @FXML
    protected TableColumn<ObPosition, Number> colTotalProfit;
    @FXML
    protected TableColumn<ObPosition, Number> colProfit;
    @FXML
    protected TableColumn<ObPosition, Number> colRealizedPl;
    @FXML
    protected TableColumn<ObPosition, Number> colTodayRealizedPl;
    @FXML
    protected TableColumn<ObPosition, Number> colYield;
    @FXML
    protected TableColumn<ObPosition, Number> colPercent;
    @FXML
    protected TableColumn<ObPosition, MxNode> colMarket;
    @FXML
    protected TableColumn<ObPosition, String> colAcc;
    @FXML
    protected TableColumn<ObPosition, String> colSecAcc;
    @FXML
    protected MenuItem miClose;
    @FXML
    protected MenuItem miClear;
    @Inject
    protected FixPositionModel model;
    @Inject
    protected MxAlert alert;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private ExecutorService exe;
    @Inject
    private MObjFactory of;
    @Inject
    private CcsCancelFactory ccf;
    @Inject
    private DialogFactory df;
    @Inject
    private IUiRightService rightModel;
    @Inject
    protected IFundAccountService fundService;
    protected boolean accFalg = false;
    protected boolean secAccFalg = false;
    protected boolean marketFalg = false;
    protected Set<String> secIds = new HashSet<String>();
    protected Set<String> accIds = new HashSet<String>();
    protected FundAccount fundAll = new FundAccount();
    protected MxList<ObPosition> mxList = new MxList();
    protected String exportName = "\u6301\u4ed3\u67e5\u8be2";
    protected Set<SecAccount> listSecAccnt;
    protected SecAccount secAccAll;
    protected Predicate<ObPosition> pd = p -> {
        String txt = this.searchText.getText().trim();
        if (!this.premise((ObPosition)p)) {
            return false;
        }
        if (p.getSecurityId().contains(txt)) {
            return true;
        }
        if (p.getSecurityName().contains(txt)) {
            return true;
        }
        return this.extend((ObPosition)p);
    };
    protected InvalidationListener lstnModel = ob -> {
        if (!this.isVisible()) {
            return;
        }
        Platform.runLater(() -> {
            ArrayList newList = new ArrayList();
            List list = this.model.getList();
            synchronized (list) {
                newList.addAll(this.model.getList());
            }
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> {
                if (o1 == null || o2 == null || "".equals(o1) || "".equals(o2)) {
                    return 0;
                }
                return o1.getSecurityId().compareTo(o2.getSecurityId());
            });
            this.tablePosition.sort();
            this.lstnExtendOperation((List<ObPosition>)this.mxList.getList());
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        this.mxList.filter(this.model.getList(), this.pd);
        this.lstnExtendOperation((List<ObPosition>)this.mxList.getList());
    };
    @Inject
    protected MEventService es;

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.onFocus();
        this.check();
        this.fxmlDone = true;
        this.initCheckComboBox();
        this.model.initQuery();
    }

    private void initCheckComboBox() {
        this.initPosFilterAcc();
        this.initPosFilterSecAcc();
        this.initPosFilterMarket();
        MxNode filterTypeNode = MxNodeFactory.createNew((String)"pos_filter_type");
        this.cmbFilter.getItems().addAll((Collection)filterTypeNode.getNodes());
        this.cmbFilter.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                this.filterType = "";
                return;
            }
            this.filterType = newV.getRaw();
            switch (newV.getRaw()) {
                case "1": {
                    this.ccmbAccnt.setVisible(true);
                    this.lbAccnt.setVisible(true);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "2": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(true);
                    this.lbSecAcc.setVisible(true);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "3": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(true);
                    this.lbMarket.setVisible(true);
                    break;
                }
            }
        });
        this.cmbFilter.getSelectionModel().select(0);
        this.accFalg = true;
        this.marketFalg = true;
        this.secAccFalg = true;
    }

    private void initPosFilterMarket() {
        MxNode marketNode = MxNodeFactory.createNew((String)"ccs_pos_market_code");
        this.ccmbMarket.getItems().addAll((Collection)marketNode.getNodes());
        this.ccmbMarket.getCheckModel().checkAll();
        MxNode nodeAll = (MxNode)marketNode.getNodes().get(0);
        int i = 1;
        while (i < marketNode.getNodes().size()) {
            this.ccmbMarket.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.marketFalg) {
                    this.marketFalg = false;
                    if (!now.booleanValue() && this.ccmbMarket.getItemBooleanProperty(0).get()) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbMarket.getItems().size() - this.ccmbMarket.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.marketFalg = true;
                }
            });
            ++i;
        }
        this.ccmbMarket.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.marketFalg) {
                this.marketFalg = false;
                if (now.booleanValue()) {
                    this.ccmbMarket.getCheckModel().checkAll();
                } else {
                    this.ccmbMarket.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.marketFalg = true;
            }
        });
        this.ccmbMarket.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbMarket.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(nodeAll)) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbMarket.setText(accStr);
            this.lbMarket.setTooltip(new Tooltip(this.lbMarket.getText()));
        });
        this.ccmbMarket.getCheckModel().checkAll();
    }

    private void initPosFilterAcc() {
        this.fundAll.setExtAccntId("\u5168\u90e8");
        this.fundAll.setInvestId("\u5168\u90e8");
        this.ccmbAccnt.getItems().add((Object)this.fundAll);
        this.ccmbAccnt.getItems().addAll((Collection)this.fundService.getFundAccountList("CCS"));
        this.ccmbAccnt.setConverter((StringConverter)new FundAccountStringConverter());
        this.ccmbAccnt.getCheckModel().checkAll();
        this.ccmbAccntLis();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(this.fundAll)) {
                accStr = "";
                for (FundAccount fundAccount : listItem) {
                    if (fundAccount == null) continue;
                    accStr = String.valueOf(accStr) + fundAccount.getInvestId() + "__" + fundAccount.getAccountName() + ",";
                }
                if (!StringUtils.isEmpty((String)accStr)) {
                    accStr = accStr.substring(0, accStr.length() - 1);
                }
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (FundAccount fundAcc : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(fundAcc.getInvestId());
            }
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    void ccmbAccntLis() {
        int i = 1;
        while (i < this.ccmbAccnt.getItems().size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.accFalg = true;
            }
        });
    }

    protected void initPosFilterSecAcc() {
        this.secAccAll = (SecAccount)this.of.create(SecAccount.class);
        this.secAccAll.getExchange().setRaw("XSHE");
        this.secAccAll.setExtSecAccntId("\u5168\u90e8");
        this.secAccAll.setInverstorSecId("\u5168\u90e8");
        this.listSecAccnt = this.model.getSecAccounts();
        this.ccmbSecAcc.getItems().add((Object)this.secAccAll);
        this.ccmbSecAcc.getItems().addAll(this.listSecAccnt);
        this.ccmbSecAcc.getCheckModel().checkAll();
        int i = 1;
        while (i < this.listSecAccnt.size()) {
            this.ccmbSecAcc.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.secAccFalg) {
                    this.secAccFalg = false;
                    if (!now.booleanValue() && this.ccmbSecAcc.getItemBooleanProperty(0).get()) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbSecAcc.getItems().size() - this.ccmbSecAcc.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(true);
                    }
                    this.lstnSearch.invalidated(null);
                    this.secAccFalg = true;
                }
            });
            ++i;
        }
        this.ccmbSecAcc.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.secAccFalg) {
                this.secAccFalg = false;
                if (now.booleanValue()) {
                    this.ccmbSecAcc.getCheckModel().checkAll();
                } else {
                    this.ccmbSecAcc.getCheckModel().clearChecks();
                }
                this.lstnSearch.invalidated(null);
                this.secAccFalg = true;
            }
        });
        this.ccmbSecAcc.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbSecAcc.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(this.secAccAll)) {
                accStr = "";
                for (SecAccount secAccount : listItem) {
                    if (secAccount == null) continue;
                    accStr = String.valueOf(accStr) + secAccount.getInverstorSecId() + ",";
                }
                if (!StringUtils.isEmpty((String)accStr)) {
                    accStr = accStr.substring(0, accStr.length() - 1);
                }
            }
            this.lbSecAcc.setText(accStr);
            this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
            this.secIds.clear();
            for (SecAccount secAccount : listItem) {
                this.secIds.add(secAccount.getInverstorSecId());
            }
        });
        this.ccmbSecAcc.getCheckModel().checkAll();
    }

    private void listener() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
    }

    @PreDestroy
    private void close() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    private void check() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String unClear = "";
        String unClose = "";
        switch (parentId) {
            case "CMS-TMX-STOCK-PART-POSITION": {
                unClear = "cms.tmx.stock.part.position_clear";
                unClose = "cms.tmx.stock.part.position_close";
                break;
            }
            case "CMS-TMX-BOND-PART-POSITION": {
                unClear = "cms.tmx.bond.part.position_clear";
                unClose = "cms.tmx.bond.part.position_close";
                break;
            }
            case "CMS-TMX-FUND-PART-POSITION": {
                unClear = "cms.tmx.fund.part.position_clear";
                unClose = "cms.tmx.fund.part.position_close";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-REGULAR-POSITION-QUERY": {
                unClear = "cms.tmx.instructions.part.regular.position.query_clear";
                unClose = "cms.tmx.instructions.part.regular.position.query_close";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-BASKET-POSITION-QUERY": {
                unClear = "cms.tmx.instructions.part.basket.position.query_clear";
                unClose = "cms.tmx.instructions.part.basket.position.query_close";
                break;
            }
            case "CMS-TMX-BOND-PART-REPO-POSITION": {
                unClear = "cms.tmx.bond.part.repo.position_clear";
                unClose = "cms.tmx.bond.part.repo.position_close";
                break;
            }
        }
        if (!this.rightModel.registerCheck(new String[]{unClear})) {
            this.miClear.setVisible(false);
        }
        if (!this.rightModel.registerCheck(new String[]{unClose})) {
            this.miClose.setVisible(false);
        }
    }

    public boolean premise(ObPosition pos) {
        if ("STD_BOND".equals(pos.getSecType())) {
            return false;
        }
        System.currentTimeMillis();
        if ("".equals(this.filterType)) {
            return true;
        }
        switch (this.filterType) {
            case "1": {
                return this.accIds.contains(pos.getInvestorId());
            }
            case "2": {
                return this.secIds.contains(pos.getInvestorSecId());
            }
            case "3": {
                ObservableList listMarket = this.ccmbMarket.getCheckModel().getCheckedItems();
                for (MxNode mxNode : listMarket) {
                    if (!"XALL".equals(mxNode.getRaw())) continue;
                    return true;
                }
                for (MxNode mktNode : listMarket) {
                    if (!mktNode.getRaw().equals(pos.getMarket().getRaw())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    public void lstnExtendOperation(List<ObPosition> list) {
    }

    @Focus
    public void onFocus() {
        this.tablePosition.refresh();
    }

    protected void createTable() {
        this.colSecId.setCellValueFactory(data -> ((ObPosition)data.getValue()).securityIdProperty());
        this.colSecName.setCellValueFactory(data -> ((ObPosition)data.getValue()).securityNameProperty());
        this.colTotalVol.setCellValueFactory(data -> ((ObPosition)data.getValue()).secBalanceProperty());
        this.colTotalVol.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((ObPosition)data.getValue()).unitProperty());
        this.colCanVol.setCellValueFactory(data -> ((ObPosition)data.getValue()).secAvailProperty());
        this.colCanVol.setCellFactory(cell -> new NumberTableCell());
        this.colCost.setCellValueFactory(data -> ((ObPosition)data.getValue()).costProperty());
        this.colCost.setCellFactory(data -> new PriceCell());
        this.colCostAmt.setCellValueFactory(data -> ((ObPosition)data.getValue()).holdCostAmtProperty());
        this.colCostAmt.setCellFactory(data -> new PriceCell());
        this.colProfit.setCellValueFactory(data -> ((ObPosition)data.getValue()).floatPnlProperty());
        this.colProfit.setCellFactory(data -> new PriceCell());
        this.colTotalProfit.setCellValueFactory(data -> ((ObPosition)data.getValue()).totalProfitProperty());
        this.colTotalProfit.setCellFactory(data -> new PriceCell());
        this.colCapital.setCellValueFactory(data -> ((ObPosition)data.getValue()).marketValueProperty());
        this.colCapital.setCellFactory(p -> new PriceCell());
        this.colBuyCost.setCellValueFactory(data -> ((ObPosition)data.getValue()).buyCostProperty());
        this.colBuyCost.setCellFactory(data -> new BuyCostCell());
        this.colBuyCostAmt.setCellValueFactory(data -> ((ObPosition)data.getValue()).buyCostAmtProperty());
        this.colBuyCostAmt.setCellFactory(data -> new BuyCostCell());
        this.colRealizedPl.setCellValueFactory(data -> ((ObPosition)data.getValue()).realPnlProperty());
        this.colRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colTodayRealizedPl.setCellValueFactory(data -> ((ObPosition)data.getValue()).todayRealizedPlProperty());
        this.colTodayRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colYield.setCellValueFactory(data -> ((ObPosition)data.getValue()).yieldProperty());
        this.colYield.setCellFactory(data -> new YieldTableCell());
        this.colPercent.setCellValueFactory(data -> ((ObPosition)data.getValue()).percentProperty());
        this.colPercent.setCellFactory(data -> new DoubleTableCell());
        this.colMarket.setCellValueFactory(data -> ((ObPosition)data.getValue()).marketProperty());
        this.colAcc.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorSecIdProperty());
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)this.exportName);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void closePosi() {
    }

    @FXML
    public void clearPosi() {
    }

    public boolean extend(ObPosition posi) {
        return false;
    }

    protected class BuyCostCell
    extends DoubleTableCell<ObPosition> {
        int scale = 3;

        protected BuyCostCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    protected class PriceCell
    extends DoubleTableCell<ObPosition> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObPosition posi = (ObPosition)ObPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = FixPositionPart.this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecurityId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    public class YieldTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");
        private Label label = new Label();

        private YieldTableCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number item, boolean empty) {
            if (!empty) {
                if (item != null) {
                    double value = item.doubleValue();
                    this.label.setText(this.sDFPrice.format(item));
                    if (value > 0.0) {
                        CssUtils.makeRise((Control)this.label);
                    } else if (value < 0.0) {
                        CssUtils.makeFall((Control)this.label);
                    } else if (value == 0.0) {
                        CssUtils.makeEven((Control)this.label);
                    }
                } else {
                    this.label.setText("");
                    this.setGraphic(null);
                    this.setText(null);
                }
            } else {
                this.label.setText("");
                this.setGraphic(null);
                this.setText(null);
            }
            this.setGraphic((Node)this.label);
        }
    }
}

