/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fix;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.query.current.views.NeeqInstructionQueryPart;
import javafx.scene.control.Alert;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class FixInstructionQueryPart
extends NeeqInstructionQueryPart {
    public void initialize() {
        super.initialize();
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.tableNewInstruction.getColumns().remove((Object)this.colSecuritySubType);
    }

    protected void sendEvent(ObSimpleInstruction instruction) {
        if (instruction == null || !"XSHE".equals(instruction.getSecMarket()) && !"XSHG".equals(instruction.getSecMarket())) {
            return;
        }
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001");
            return;
        }
        if (instruction.getIsOrderStep() || instruction.isIsApproveStep()) {
            try {
                this.model.udpateAvailableOrderQty(instruction);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519");
                this.logger.error("\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519", (Throwable)e);
                return;
            }
        }
        MEvent eCall = new MEvent();
        if ("SimpleDetail".equals(instruction.getType())) {
            MPart newPart = null;
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart("cms.tmx.instructions.part.fix.execute");
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart("cms.tmx.instructions.part.fix.approve");
            } else {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.panel", eCall);
    }
}

