/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fix;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.ObExecution;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.instructions.models.fix.FixDealModel;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.utils.ObSideCell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleGroup;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class FixDealPart
extends MxPagePart<Execution, ObExecution> {
    @FXML
    protected TableView<ObExecution> tableView;
    @FXML
    private TableColumn<ObExecution, Side> side;
    @FXML
    private TableColumn<ObExecution, Number> lastQty;
    @FXML
    private TableColumn<ObExecution, Number> lastPx;
    @FXML
    private TableColumn<ObExecution, Number> lastAmount;
    @FXML
    protected TableColumn<ObExecution, MxNode> matchType;
    @FXML
    protected TableColumn<ObExecution, String> securitySubType;
    @FXML
    protected TableColumn<ObExecution, String> securityGroup;
    @FXML
    protected TableColumn<ObExecution, String> algo;
    @FXML
    protected TableView<ObExecution> tableDealCount;
    @FXML
    private TableColumn<ObExecution, String> colCountSecId;
    @FXML
    private TableColumn<ObExecution, String> colCountSecName;
    @FXML
    private TableColumn<ObExecution, Side> colCountDir;
    @FXML
    private TableColumn<ObExecution, Number> colCountVol;
    @FXML
    private TableColumn<ObExecution, String> colCountUnit;
    @FXML
    private TableColumn<ObExecution, Number> colCountPrice;
    @FXML
    private TableColumn<ObExecution, String> colCountMkt;
    @FXML
    private TableColumn<ObExecution, Number> colCountAmount;
    @FXML
    private TableColumn<ObExecution, Number> colCount;
    @FXML
    private TableColumn<ObExecution, String> colCountAcc;
    @FXML
    protected TableColumn<ObExecution, String> colCountSecSubType;
    @FXML
    protected TableColumn<ObExecution, String> colCountSecGroup;
    @FXML
    protected TableColumn<ObExecution, MxNode> colCountMatchType;
    @FXML
    protected RadioButton detailRadio;
    @FXML
    protected RadioButton countRadio;
    @Inject
    private FixDealModel model;
    @Inject
    protected MxAlert alert;
    protected ToggleGroup group = new ToggleGroup();
    protected MxList<ObExecution> mxCountList = new MxList();
    protected List<ObExecution> countList = new LinkedList<ObExecution>();
    protected Predicate<ObExecution> pdsum = t -> this.predicateSum((ObExecution)t);
    protected InvalidationListener lstnSearch = ob -> {
        List<ObExecution> list = this.countList;
        synchronized (list) {
            this.mxCountList.filter(this.countList, this.pdsum);
        }
    };

    protected void initialize() {
        super.initialize();
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.setRadio();
        this.initPage();
        this.createCountTable();
    }

    @PreDestroy
    protected void preDestroy() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.countRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableView.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.tableDealCount.visibleProperty().bind((ObservableValue)this.countRadio.selectedProperty());
    }

    private void initPage() {
        this.lbCurrentCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbTotalCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbCountSeparator.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbPrevPage.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbNextPage.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
    }

    protected String getKey(Execution deal) {
        String key = String.valueOf(deal.getInvestorId()) + deal.getSecurityId() + deal.getSide().getValue();
        return key;
    }

    protected List<ObExecution> createCountList(List<Execution> newList) {
        HashMap<String, Execution> map = new HashMap<String, Execution>();
        LinkedList<Execution> list = new LinkedList<Execution>();
        LinkedList<ObExecution> listOb = new LinkedList<ObExecution>();
        int i = 0;
        while (i < newList.size()) {
            Execution deal = newList.get(i);
            String key = this.getKey(deal);
            if (map.get(key) == null) {
                Execution newDeal = new Execution();
                newDeal.update((Object)deal);
                newDeal.setOrderId("");
                newDeal.setLastAmountSum(Double.valueOf(newDeal.getLastPx() * newDeal.getLastQty()));
                newDeal.setDealCount(1);
                list.add(newDeal);
                map.put(key, newDeal);
            } else {
                Execution oldDeal = (Execution)map.get(key);
                double qty = deal.getLastQty();
                double price = deal.getLastPx();
                double amount = deal.getLastAmount();
                double oldQty = oldDeal.getLastQty();
                double oldAmount = oldDeal.getLastAmount();
                oldDeal.setLastQty(oldQty + qty);
                oldDeal.setLastAmount(oldAmount + amount);
                oldDeal.setDealCount(oldDeal.getDealCount() + 1);
                oldDeal.setLastAmountSum(Double.valueOf(oldDeal.getLastAmountSum() + price * qty));
            }
            ++i;
        }
        for (Execution deal : list) {
            if (deal.getLastQty() != 0.0) {
                deal.setLastPx((double)Math.round(deal.getLastAmountSum() / deal.getLastQty() * 10000.0) / 10000.0);
            } else {
                deal.setLastPx(0.0);
            }
            ObExecution ob = new ObExecution();
            ob.update((Object)deal);
            listOb.add(ob);
        }
        return listOb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        super.refreshList();
        ArrayList<Execution> newList = new ArrayList<Execution>();
        List<Execution> list = this.getList();
        synchronized (list) {
            newList.addAll(this.getList());
        }
        this.countList = this.createCountList(newList);
        this.mxCountList.update(this.countList, this.pdsum);
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.side.setCellFactory(cell -> new ObSideCell());
        this.lastQty.setCellFactory(data -> new NumberTableCell());
        this.lastPx.setCellFactory(data -> new DoubleTableCell());
        this.lastAmount.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getExecId().compareTo(o1.getExecId()));
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.getColumns().remove(this.securitySubType);
        this.tableView.getColumns().remove(this.securityGroup);
        this.tableView.getColumns().remove(this.matchType);
        this.tableView.getColumns().remove(this.algo);
    }

    protected void createCountTable() {
        this.colCountSecId.setCellValueFactory(data -> ((ObExecution)data.getValue()).securityIdProperty());
        this.colCountSecName.setCellValueFactory(data -> ((ObExecution)data.getValue()).securityNameProperty());
        this.colCountDir.setCellValueFactory(data -> ((ObExecution)data.getValue()).sideProperty());
        this.colCountDir.setCellFactory(cell -> new ObSideCell());
        this.colCountVol.setCellFactory(column -> new NumberTableCell());
        this.colCountVol.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastQtyProperty());
        this.colCountUnit.setCellValueFactory(data -> ((ObExecution)data.getValue()).unitProperty());
        this.colCountPrice.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastPxProperty());
        this.colCountPrice.setCellFactory(data -> new DoubleTableCell(4));
        this.colCountMkt.setCellValueFactory(data -> ((ObExecution)data.getValue()).marketProperty());
        this.colCountAmount.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastAmountProperty());
        this.colCountAmount.setCellFactory(p -> new DoubleTableCell());
        this.colCount.setCellValueFactory(data -> ((ObExecution)data.getValue()).dealCountProperty());
        this.colCountAcc.setCellValueFactory(data -> ((ObExecution)data.getValue()).investorIdProperty());
        this.tableDealCount.setPlaceholder((Node)new Label());
        this.tableDealCount.setItems(this.mxCountList.getList());
        TableUtils.orgnizeClmWidth(this.tableDealCount);
        this.tableDealCount.getColumns().remove(this.colCountSecSubType);
        this.tableDealCount.getColumns().remove(this.colCountSecGroup);
        this.tableDealCount.getColumns().remove(this.colCountMatchType);
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected boolean predicate(Execution t) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        return code.contains(text) || t.getInstrument().getSymbol().contains(text);
    }

    protected boolean predicateSum(ObExecution t) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getSecurityId().toUpperCase();
        return code.contains(text) || t.getSecurityName().contains(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableView, (List)listExec, (String)"\u6210\u4ea4\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    @FXML
    public void copyCount() {
        TableUtils.copyContentWithHead(this.tableDealCount);
    }

    @FXML
    public void exportExcelCount() {
        try {
            ExcelUtils.writeExcel(this.tableDealCount, (String)"\u6210\u4ea4\u6c47\u603b");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
    }

    protected List<Execution> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }
}

