/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fast;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.instruction.ObTopSpeedInstruction;
import cms.tmx.instructions.models.topspeed.TopSpeedInstructionModel;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;

public class InstructionTopSpeedExecutePart
extends MxPart {
    @FXML
    protected TableView<ObTopSpeedInstruction> tableInstruction;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colInsId;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colBelongTo;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colInsType;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colSecCode;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colSecName;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, Number> colQty;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colInsPrice;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colSide;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colExeStatus;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colInsBeginTime;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colInsEndTime;
    @FXML
    protected TableColumn<ObTopSpeedInstruction, String> colOperation;
    @FXML
    private Button btnHotExe;
    @FXML
    private TextField searchText;
    @FXML
    private Label lbExeHotkey;
    @FXML
    private CheckBox cbExecuted;
    @Inject
    protected MxAlert alert;
    protected MxList<ObTopSpeedInstruction> mxList = new MxList();
    @Inject
    protected TopSpeedInstructionModel model;
    protected static final int DOUBLE_CLICK_COUNT = 2;
    protected Predicate<ObTopSpeedInstruction> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObTopSpeedInstruction)en)) {
            return false;
        }
        if (!(en.getId().contains(text) || en.getBelongTo() == null || en.getBelongTo().contains(text) || en.getSecCode().contains(text))) {
            return false;
        }
        if (this.extend((ObTopSpeedInstruction)en)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnModel = ob -> {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList().getList());
        }
        List exeIns = newList.stream().filter(item -> item.isProductRegular()).collect(Collectors.toList());
        Platform.runLater(() -> {
            this.mxList.update(exeIns, this.pd);
            this.tableInstruction.sort();
        });
    };
    private InvalidationListener lstnSearch = ob -> {
        ArrayList newList = new ArrayList();
        Platform.runLater(() -> {
            ObservableList observableList = this.model.getList().getList();
            synchronized (observableList) {
                newList.addAll(this.model.getList().getList());
                this.mxList.filter(newList, this.pd);
            }
            this.tableInstruction.sort();
        });
    };
    private NativeKeyListener nativeLis = new NativeKeyListener(){

        public void nativeKeyTyped(NativeKeyEvent nativeEvent) {
        }

        public void nativeKeyReleased(NativeKeyEvent nativeEvent) {
            Platform.runLater(() -> {
                if (nativeEvent.getKeyCode() == 61) {
                    List exeList = null;
                    List cancelList = null;
                    ObservableList observableList = InstructionTopSpeedExecutePart.this.model.getList().getList();
                    synchronized (observableList) {
                        exeList = InstructionTopSpeedExecutePart.this.model.getList().getList().stream().filter(item -> "1".equals(item.getExeStatus())).collect(Collectors.toList());
                        cancelList = InstructionTopSpeedExecutePart.this.model.getList().getList().stream().filter(item -> "3".equals(item.getExeStatus())).collect(Collectors.toList());
                    }
                    InstructionTopSpeedExecutePart.this.hotkeyExe(exeList, cancelList);
                }
            });
        }

        public void nativeKeyPressed(NativeKeyEvent nativeEvent) {
        }
    };

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.checkAuth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private void hotkeyExe() {
        List<ObTopSpeedInstruction> exeList = null;
        List<ObTopSpeedInstruction> cancelList = null;
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            exeList = this.model.getList().getList().stream().filter(item -> "1".equals(item.getExeStatus())).collect(Collectors.toList());
            cancelList = this.model.getList().getList().stream().filter(item -> "3".equals(item.getExeStatus())).collect(Collectors.toList());
        }
        this.hotkeyExe(exeList, cancelList);
    }

    private void hotkeyExe(List<ObTopSpeedInstruction> exeList, List<ObTopSpeedInstruction> cancelList) {
        if (exeList.isEmpty() && cancelList.isEmpty()) {
            return;
        }
        this.batchExe(exeList, cancelList);
    }

    private void batchExe(List<ObTopSpeedInstruction> exeList, List<ObTopSpeedInstruction> cancelList) {
        this.model.batchTopSpeedExe(exeList, cancelList);
    }

    private void initGlobalHotKey() {
        Platform.runLater(() -> {
            try {
                this.logger.info("top speed ===================>");
                GlobalScreen.registerNativeHook();
                Logger l = Logger.getLogger(GlobalScreen.class.getPackage().getName());
                l.setLevel(Level.WARNING);
                GlobalScreen.addNativeKeyListener((NativeKeyListener)this.nativeLis);
            }
            catch (NativeHookException e) {
                this.logger.error("\u5feb\u6377\u6267\u884c\u9875\u9762\u6ce8\u518c\u5168\u5c40\u5feb\u6377\u952e\u5931\u8d25", (Throwable)e);
            }
        });
    }

    protected void checkAuth() {
        this.initGlobalHotKey();
    }

    protected void createTable() {
        this.colInsId.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).idProperty());
        this.colBelongTo.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).belongToProperty());
        this.colInsType.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).typeNameProperty());
        this.colInsPrice.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).insPriceProperty());
        this.colInsBeginTime.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).beginTimeProperty());
        this.colInsEndTime.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).endTimeProperty());
        this.colQty.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).totalExpectationQtyProperty());
        this.colExeStatus.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).exeStatusNameProperty());
        this.colQty.setCellFactory(cell -> new NumberTableCell());
        this.colSecCode.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).secCodeProperty());
        this.colSecName.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).secNameProperty());
        this.colSide.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).sideProperty());
        this.colOperation.setCellValueFactory(data -> ((ObTopSpeedInstruction)data.getValue()).operationProperty());
        this.tableInstruction.setItems(this.mxList.getList());
        this.tableInstruction.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableInstruction);
        this.tableInstruction.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> event.getClickCount());
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.colInsId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableInstruction.getSortOrder().add(this.colInsId);
        this.tableInstruction.sort();
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected InvalidationListener getLstnSearch() {
        return this.lstnSearch;
    }

    public boolean premise(ObTopSpeedInstruction ins) {
        if (this.cbExecuted.isSelected()) {
            return true;
        }
        return "1".equals(ins.getExeStatus()) || "3".equals(ins.getExeStatus());
    }

    public boolean extend(ObTopSpeedInstruction ins) {
        return false;
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.getLstnModel());
        this.searchText.textProperty().addListener(this.getLstnSearch());
        this.cbExecuted.selectedProperty().addListener((ob, oldV, newV) -> this.lstnSearch.invalidated(null));
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableInstruction);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableInstruction, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

