/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.fast;

import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.query.current.views.InstructionQueryPart;
import cms.tmx.query.history.views.InstructionSideCell;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;

public class InstructionFastExecutePart
extends InstructionQueryPart {
    @FXML
    protected Button btnHotExe;
    @FXML
    protected Label lbExeHotkey;
    @FXML
    private CheckBox cbExecuted;
    @FXML
    protected TableColumn<Instruction, Boolean> colExeSelected;
    protected Predicate<Instruction> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((Instruction)en)) {
            return false;
        }
        if (!(en.getId().contains(text) || en.getBelongTo() == null || en.getBelongTo().contains(text) || en.getSecurityCode().contains(text))) {
            return false;
        }
        if (this.extend((Instruction)en)) {
            return true;
        }
        return true;
    };
    private InvalidationListener lstnModel = ob -> {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList().getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList().getList());
        }
        List exeIns = newList.stream().filter(item -> (item.isProductRegular() && item.getOrderAdvice().getPriceLimit() == 2 || item.isFutures() && item.getOrderAdvice().getPriceLimit() == 2) && (this.cbExecuted.isSelected() || item.isCanHotKeyExe()) && item.getDescId() == 1).collect(Collectors.toList());
        Platform.runLater(() -> {
            this.mxList.update(exeIns, this.pd);
            this.handleCheckBox();
            this.tableInstruction.sort();
        });
    };
    private InvalidationListener lstnSearch = ob -> {
        ArrayList newList = new ArrayList();
        Platform.runLater(() -> {
            ObservableList observableList = this.model.getList().getList();
            synchronized (observableList) {
                newList.addAll(this.model.getList().getList());
                List exeIns = newList.stream().filter(item -> (item.isProductRegular() && item.getOrderAdvice().getPriceLimit() == 2 || item.isFutures() && item.getOrderAdvice().getPriceLimit() == 2) && (this.cbExecuted.isSelected() || item.isCanHotKeyExe()) && item.getDescId() == 1).collect(Collectors.toList());
                this.mxList.filter(exeIns, this.pd);
            }
            this.tableInstruction.sort();
        });
    };
    private ChangeListener<? super Boolean> lstnCheckbox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> {
                if (e.isCanHotKeyExe()) {
                    e.setExeSelected(now.booleanValue());
                }
            });
        }
    };
    private NativeKeyListener nativeLis = new NativeKeyListener(){

        public void nativeKeyTyped(NativeKeyEvent nativeEvent) {
        }

        public void nativeKeyReleased(NativeKeyEvent nativeEvent) {
            Platform.runLater(() -> {
                if (nativeEvent.getKeyCode() == 63) {
                    List instructions = InstructionFastExecutePart.this.model.getList().getList().stream().filter(item -> item.isExeSelected() && (item.isProductRegular() && item.getOrderAdvice().getPriceLimit() == 2 || item.isFutures() && item.getOrderAdvice().getPriceLimit() == 2) && item.getDescId() == 1).collect(Collectors.toList());
                    InstructionFastExecutePart.this.hotkeyExe(instructions);
                }
            });
        }

        public void nativeKeyPressed(NativeKeyEvent nativeEvent) {
        }
    };

    @FXML
    private void hotkeyExe() {
        this.hotkeyExe(this.model.getList().getList().stream().filter(item -> item.isExeSelected() && (item.isProductRegular() && item.getOrderAdvice().getPriceLimit() == 2 || item.isFutures() && item.getOrderAdvice().getPriceLimit() == 2) && item.getDescId() == 1).collect(Collectors.toList()));
    }

    private void hotkeyExe(List<Instruction> instructions) {
        if (instructions.isEmpty()) {
            return;
        }
        this.batchExe(instructions);
    }

    private void batchExe(List<Instruction> instructionsCanBeExe) {
        this.model.batchExe(instructionsCanBeExe);
    }

    protected void handleCheckBox() {
        boolean hasSelectedItem = false;
        boolean hasCanHotExe = false;
        for (Instruction instruction : this.mxList.getList()) {
            if (instruction.isExeSelected()) {
                hasSelectedItem = true;
            }
            if (!instruction.isCanHotKeyExe()) continue;
            hasCanHotExe = true;
        }
        if (hasSelectedItem) {
            this.checkBox.setSelected(true);
            this.checkBox.setDisable(false);
            this.btnHotExe.setDisable(false);
        } else if (hasCanHotExe) {
            this.checkBox.setSelected(false);
            this.checkBox.setDisable(false);
            this.btnHotExe.setDisable(false);
        } else {
            this.checkBox.setSelected(false);
            this.checkBox.setDisable(true);
            this.btnHotExe.setDisable(true);
        }
    }

    private void initGlobalHotKey() {
        Platform.runLater(() -> {
            try {
                this.logger.info("fastExe ===================>");
                GlobalScreen.registerNativeHook();
                Logger l = Logger.getLogger(GlobalScreen.class.getPackage().getName());
                l.setLevel(Level.WARNING);
                GlobalScreen.addNativeKeyListener((NativeKeyListener)this.nativeLis);
            }
            catch (NativeHookException e) {
                this.logger.error("\u5feb\u6377\u6267\u884c\u9875\u9762\u6ce8\u518c\u5168\u5c40\u5feb\u6377\u952e\u5931\u8d25", (Throwable)e);
            }
        });
    }

    protected void checkAuth() {
        this.initGlobalHotKey();
        this.cbExecuted.selectedProperty().addListener((ob, oldV, newV) -> this.lstnSearch.invalidated(null));
    }

    protected void createTable() {
        this.colExeSelected.setGraphic((Node)this.checkBox);
        this.colExeSelected.setCellValueFactory(data -> ((Instruction)data.getValue()).exeSelectedProperty());
        this.colExeSelected.setCellFactory(data -> new MxCheckBoxTableCellIns());
        this.colExeSelected.setSortable(false);
        this.colExeSelected.getTableView().setEditable(true);
        this.colInsId.setCellValueFactory(data -> ((Instruction)data.getValue()).idProperty());
        this.colBelongTo.setCellValueFactory(data -> ((Instruction)data.getValue()).belongToProperty());
        this.colInsType.setCellValueFactory(data -> ((Instruction)data.getValue()).exTypeProperty());
        this.colInsProgress.setCellValueFactory(data -> ((Instruction)data.getValue()).ratioProperty());
        this.colInsProgress.setCellFactory(p -> new DoubleTableCell());
        this.colInsStatus.setCellValueFactory(data -> ((Instruction)data.getValue()).oprAndStatusProperty());
        this.colInsPrice.setCellValueFactory(data -> ((Instruction)data.getValue()).insPriceProperty());
        this.colInsOption.setCellValueFactory(data -> ((Instruction)data.getValue()).actionListProperty());
        this.colInsOption.setCellFactory(this.cellFactory);
        this.colInsDetail.setCellValueFactory(data -> this.setDetail((Instruction)data.getValue()));
        this.colInsBeginTime.setCellValueFactory(data -> ((Instruction)data.getValue()).beginTimeProperty());
        this.colInsEndTime.setCellValueFactory(data -> ((Instruction)data.getValue()).endTimeProperty());
        this.colInsObj.setCellValueFactory(data -> ((Instruction)data.getValue()).orderObjProperty());
        this.colQty.setCellValueFactory(data -> ((Instruction)data.getValue()).totalExpectationQtyProperty());
        this.colQty.setCellFactory(cell -> new NumberTableCell());
        this.colSide.setCellValueFactory(data -> ((Instruction)data.getValue()).sideProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.colInsInfo.setCellValueFactory(data -> ((Instruction)data.getValue()).errInfoProperty());
        this.colInsInfo.setCellFactory(data -> new TooltipTableCell<Instruction, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((Instruction)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colCumAmount.setCellValueFactory(data -> ((Instruction)data.getValue()).cumAmountProperty());
        this.colCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.colAvgPx.setCellValueFactory(data -> ((Instruction)data.getValue()).avgPxProperty());
        this.colAvgPx.setCellFactory(cell -> new ZeroDoubleTableCell());
        this.tableInstruction.setItems(this.mxList.getList());
        this.tableInstruction.getColumns().remove((Object)this.colOrdRatio);
        this.tableInstruction.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth((TableView)this.tableInstruction);
        this.tableInstruction.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                Instruction instruction = (Instruction)this.tableInstruction.getSelectionModel().getSelectedItem();
                this.sendEvent(instruction);
            }
        });
    }

    protected InvalidationListener getLstnModel() {
        return this.lstnModel;
    }

    protected InvalidationListener getLstnSearch() {
        return this.lstnSearch;
    }

    public ChangeListener<? super Boolean> getLstnCheckbox() {
        return this.lstnCheckbox;
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.getLstnModel());
        this.searchText.textProperty().addListener(this.getLstnSearch());
        this.checkBox.selectedProperty().addListener(this.getLstnCheckbox());
    }

    private class MxCheckBoxTableCellIns
    extends CheckBoxTableCell<Instruction, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    this.checkbox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                        if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                            return;
                        }
                        Instruction inst = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                        inst.setExeManualSelected(true);
                    });
                    Instruction ins = (Instruction)Instruction.class.cast(this.getTableRow().getItem());
                    this.disableProperty().bind((ObservableValue)ins.canHotKeyExeProperty().not());
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

