/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.basket;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.models.basket.InstructionBasketExecutionModel;
import cms.tmx.instructions.models.basket.InstructionBasketInfoExecution;
import cms.tmx.instructions.viewers.basket.InstructionBasketBasePart;
import cms.tmx.utils.StringUtils;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionBasketExecutionShortPart
extends InstructionBasketBasePart {
    @Inject
    private InstructionBasketExecutionModel model;
    @Inject
    private InstructionBasketInfoExecution bi;
    protected MEvent instructEvent = new MEvent();
    protected boolean initFinished = false;
    protected MEventHandler hSetCodeExe = event -> {
        this.instructEvent = event;
        if (this.instructEvent.get((Object)"instruction") == null || !(this.instructEvent.get((Object)"instruction") instanceof Instruction)) {
            return;
        }
        Instruction ins = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };

    @PostConstruct
    public void init() {
        super.init();
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeExe);
        this.model.getGear().removeNode("100");
        this.model.getGear().removeNode("-100");
    }

    @PreDestroy
    private void dispose() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCodeExe);
    }

    @Override
    @FXML
    public void initialize() {
        this.initPortfAccntModel();
        this.setBuySimbol("\u4e70\u5165");
        this.setSellSimbol("\u5356\u51fa");
        this.setBsSimbol("\u4e00\u952e\u4e70\u5356");
        this.setConfirmSimbol("\u6267\u884c\u786e\u8ba4");
        this.setBi(this.bi);
        this.setModel(this.model);
        this.onExecution(true);
        super.initialize();
        this.initFinished = true;
        this.doFill();
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished || this.instruction == null) {
                return;
            }
            if (StringUtils.belongto((String)this.instruction.getType().getRaw(), (String[])new String[]{"4", "12"})) {
                this.fillInstruction(false);
            }
        });
    }

    @Override
    protected BasketSubmitResult doAction() throws MException {
        this.model.execute(this.instruction);
        if (!this.model.isNormal()) {
            this.basketAlgoOrder(this.instruction);
            return null;
        }
        return super.doAction();
    }

    @Override
    protected void showPart() {
        if (!this.model.isNormal()) {
            if (this.settings.isUnfinishedAfterOrder()) {
                this.uiService.showPart("cms.tmx.instructions.part.shortcut.instruct.query");
            }
        } else {
            this.clearFill();
            if (this.settings.isUnfinishedAfterOrder()) {
                this.uiService.showPart("cms.tmx.instructions.part.shortcut.instruct.query");
            }
        }
    }

    private void initPortfAccntModel() {
        this.model.create("4");
        this.instDistModel.setInstructPanelType("4");
        try {
            this.instDistModel.create();
        }
        catch (MException e) {
            logger.error("\u521b\u5efa\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u521b\u5efa\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25");
        }
    }

    private boolean validOrderFill(Instruction ins) {
        return StringUtils.belongto((String)ins.getType().getRaw(), (String[])new String[]{"4", "12"}) && ins.getIsOrderStep();
    }
}

