/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.basket;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.models.basket.InstructionBasketApproveModel;
import cms.tmx.instructions.models.basket.InstructionBasketInfoApprove;
import cms.tmx.instructions.viewers.basket.InstructionBasketBasePart;
import cms.tmx.utils.StringUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionBasketApprovePart
extends InstructionBasketBasePart {
    @Inject
    private InstructionBasketApproveModel model;
    @Inject
    private InstructionBasketInfoApprove bi;
    protected MEvent instructEvent = new MEvent();
    protected AtomicBoolean initFinished = new AtomicBoolean(false);
    protected MEventHandler hSetCodeApp = event -> {
        this.instructEvent = event;
        if (this.instructEvent.get((Object)"instruction") == null || !(this.instructEvent.get((Object)"instruction") instanceof Instruction)) {
            return;
        }
        Instruction ins = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };

    @PostConstruct
    public void init() {
        super.init();
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @PreDestroy
    private void dispose() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    @FXML
    public void initialize() {
        this.initPortfAccntModel();
        this.setBuySimbol("\u5ba1\u6279\u901a\u8fc7");
        this.setSellSimbol("\u5ba1\u6279\u901a\u8fc7");
        this.setBsSimbol("\u5ba1\u6279\u901a\u8fc7");
        this.setConfirmSimbol("\u5ba1\u6279\u786e\u8ba4");
        this.setBi(this.bi);
        this.setModel(this.model);
        this.onApprove(true);
        super.initialize();
        this.initFinished.set(true);
        this.doFill();
        this.model.getGear().removeNode("100");
        this.model.getGear().removeNode("-100");
    }

    @Override
    protected BasketSubmitResult doAction() throws MException {
        return this.model.submitApprove(this.instruction);
    }

    @Override
    protected void showPart() {
        this.clearFill();
        if (this.settings.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.instructions.part.basket.instruction.query");
        }
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            if (StringUtils.belongto((String)this.instruction.getType().getRaw(), (String[])new String[]{"4", "12"})) {
                this.fillInstruction(true);
            }
        });
    }

    private void initPortfAccntModel() {
        this.model.create("3");
        this.instDistModel.setInstructPanelType("3");
        try {
            this.instDistModel.create();
        }
        catch (MException e) {
            logger.error("\u521b\u5efa\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u521b\u5efa\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25");
        }
    }

    private boolean validOrderFill(Instruction ins) {
        return StringUtils.belongto((String)ins.getType().getRaw(), (String[])new String[]{"4", "12"}) && !ins.getIsOrderStep();
    }
}

