/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.adjust;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.instructions.models.adjust.PortfAdjPosAlgoCapitalModel;
import cms.tmx.portfolio.uitls.AccCollapseCell;
import cms.tmx.portfolio.uitls.PortfoCollapseCell;
import javafx.beans.property.Property;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortfAdjPosCapitalDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(PortfAdjPosCapitalDialog.class);
    private static final PseudoClass PCMX_SELECTED = PseudoClass.getPseudoClass((String)"mselected");
    private PortfAdjPosAlgoCapitalModel accModel;
    @FXML
    protected TreeTableView<PortfolioAccountDistribution> portfBasketAcctTreeTable;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, Portfolio> portfolioCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<PortfolioAccountDistribution, SecAccount> secAcctCol;
    private TreeItem<PortfolioAccountDistribution> root;
    @Inject
    private MxAlert alert;

    @FXML
    public void initialize() {
        this.root = this.accModel.getRoot();
        this.createTree();
    }

    private void createTree() {
        this.portfBasketAcctTreeTable.setRoot(this.root);
        this.portfBasketAcctTreeTable.setShowRoot(false);
        this.portfBasketAcctTreeTable.setPlaceholder((Node)new Label());
        this.checkBoxCol.setCellFactory(data -> new PortfolioBasketCheckBoxCell());
        this.portfolioCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).portfolioProperty());
        this.portfolioCol.setCellFactory(data -> new PortfoCollapseCell(this.accModel.getPortfDistModel().isSingle()));
        this.accountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(data -> new AccCollapseCell(this.accModel.getPortfDistModel().isSingle()));
        this.secAcctCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.root.setExpanded(true);
        this.root.getChildren().forEach(each -> each.setExpanded(false));
    }

    protected boolean isOK(ButtonType bt) {
        Portfolio portf = null;
        CcsFundAccount fund = null;
        SecAccount secXshg = null;
        SecAccount secXshe = null;
        for (TreeItem portfItem : this.root.getChildren()) {
            if (!((PortfolioAccountDistribution)portfItem.getValue()).isSelected()) continue;
            portf = ((PortfolioAccountDistribution)portfItem.getValue()).getPortfolio();
            for (TreeItem accItem : portfItem.getChildren()) {
                if (!((PortfolioAccountDistribution)accItem.getValue()).isSelected()) continue;
                fund = ((PortfolioAccountDistribution)accItem.getValue()).getAcc();
                for (TreeItem secItem : accItem.getChildren()) {
                    CcsAccountDistribution dest = (CcsAccountDistribution)secItem.getValue();
                    SecAccount sec = dest.getSecAcc();
                    String market = sec.getExchange().getRaw();
                    if ("XSHG".equals(market) && dest.isSelected()) {
                        secXshg = sec;
                        continue;
                    }
                    if (!"XSHE".equals(market) || !dest.isSelected()) continue;
                    secXshe = sec;
                }
                String investId = ((PortfolioAccountDistribution)accItem.getValue()).getAcc().getInvestId();
                if (secXshg == null) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u8d44\u91d1\u8d26\u53f7" + investId + "\u9009\u62e9\u4e00\u4e2a\u6caa\u5e02\u8bc1\u5238\u8d26\u53f7\uff01");
                    return false;
                }
                if (secXshe != null) continue;
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u8d44\u91d1\u8d26\u53f7" + investId + "\u9009\u62e9\u4e00\u4e2a\u6df1\u5e02\u8bc1\u5238\u8d26\u53f7\uff01");
                return false;
            }
            if (fund != null) continue;
            String name = ((PortfolioAccountDistribution)portfItem.getValue()).getPortfolio().getName();
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u6295\u7ec4" + name + "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\uff01");
            return false;
        }
        if (portf == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6295\u7ec4\uff01");
            return false;
        }
        this.accModel.selectedCapital(portf, fund, secXshg, secXshe);
        return true;
    }

    public void setCapitalModel(PortfAdjPosAlgoCapitalModel model) {
        this.accModel = model;
    }

    private class PortfolioBasketCheckBoxCell<T>
    extends TreeTableCell<PortfolioAccountDistribution, Boolean> {
        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(PCMX_SELECTED, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.setSelected(((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).isSelected());
                    checkBox.selectedProperty().bindBidirectional((Property)((PortfolioAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    TreeItem parent = treeItem.getParent();
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, now) -> {
                            if (now.booleanValue() && parent != null && parent.getValue() != null) {
                                ((PortfolioAccountDistribution)parent.getValue()).setSelected(now.booleanValue());
                                ((PortfolioAccountDistribution)parent.getParent().getValue()).setSelected(now.booleanValue());
                                parent.getChildren().forEach(each -> {
                                    String eachMarket = ((PortfolioAccountDistribution)each.getValue()).getSecAcc().getExchange().getRaw();
                                    String itemMarket = ((PortfolioAccountDistribution)treeItem.getValue()).getSecAcc().getExchange().getRaw();
                                    if (!each.equals(treeItem) && eachMarket.equals(itemMarket)) {
                                        ((PortfolioAccountDistribution)each.getValue()).setSelected(false);
                                    }
                                });
                            }
                            this.getTreeTableView().refresh();
                        });
                    } else if (treeItem.getParent().getParent() != null) {
                        checkBox.selectedProperty().addListener((ob, old, now) -> {
                            if (now.booleanValue() && parent != null && parent.getValue() != null) {
                                parent.getChildren().forEach(p -> {
                                    if (!p.equals(treeItem)) {
                                        ((PortfolioAccountDistribution)p.getValue()).setSelected(false);
                                        p.getChildren().forEach(c -> ((PortfolioAccountDistribution)c.getValue()).setSelected(false));
                                    }
                                });
                            }
                            this.getTreeTableView().refresh();
                        });
                        checkBox.setOnMouseClicked(event -> {
                            if (((PortfolioAccountDistribution)treeItem.getValue()).isSelected()) {
                                this.checkDefaultSec((TreeItem<PortfolioAccountDistribution>)treeItem);
                                ((PortfolioAccountDistribution)treeItem.getParent().getValue()).setSelected(true);
                            } else {
                                treeItem.getChildren().forEach(accItem -> ((PortfolioAccountDistribution)accItem.getValue()).setSelected(false));
                            }
                        });
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, now) -> {
                            if (now.booleanValue() && parent != null && parent.getValue() != null) {
                                parent.getChildren().forEach(p -> {
                                    if (!p.equals(treeItem)) {
                                        ((PortfolioAccountDistribution)p.getValue()).setSelected(false);
                                        p.getChildren().forEach(f -> {
                                            ((PortfolioAccountDistribution)f.getValue()).setSelected(false);
                                            f.getChildren().forEach(s -> ((PortfolioAccountDistribution)s.getValue()).setSelected(false));
                                        });
                                    }
                                });
                            }
                            this.getTreeTableView().refresh();
                        });
                        checkBox.setOnMouseClicked(event -> {
                            if (((PortfolioAccountDistribution)treeItem.getValue()).isSelected()) {
                                TreeItem accItem2 = (TreeItem)treeItem.getChildren().get(0);
                                ((PortfolioAccountDistribution)accItem2.getValue()).setSelected(true);
                                this.checkDefaultSec((TreeItem<PortfolioAccountDistribution>)accItem2);
                            } else {
                                treeItem.getChildren().forEach(accItem -> {
                                    ((PortfolioAccountDistribution)accItem.getValue()).setSelected(false);
                                    accItem.getChildren().forEach(secItem -> ((PortfolioAccountDistribution)secItem.getValue()).setSelected(false));
                                });
                            }
                        });
                    }
                    treeItem.expandedProperty().addListener((ob, old, newV) -> this.getTreeTableView().refresh());
                    this.setGraphic((Node)checkBox);
                }
            }
        }

        private void checkDefaultSec(TreeItem<PortfolioAccountDistribution> treeItem) {
            boolean xshg = true;
            boolean xshe = true;
            for (TreeItem cadItem : treeItem.getChildren()) {
                ((PortfolioAccountDistribution)cadItem.getValue()).setSelected(false);
                if (!((PortfolioAccountDistribution)treeItem.getValue()).isSelected()) continue;
                if (xshg && "XSHG".equals(((PortfolioAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) {
                    ((PortfolioAccountDistribution)cadItem.getValue()).setSelected(true);
                    xshg = false;
                }
                if (!xshe || !"XSHE".equals(((PortfolioAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) continue;
                ((PortfolioAccountDistribution)cadItem.getValue()).setSelected(true);
                xshe = false;
            }
        }
    }
}

