/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.adjust;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.instructions.models.adjust.AdjPosAlgoModel;
import cms.tmx.instructions.models.adjust.PortfAdjPosAlgoCapitalModel;
import cms.tmx.instructions.models.adjust.PortfAdjPosAlgoInstructModel;
import cms.tmx.instructions.viewers.adjust.PortfAdjPosAlgoPart;
import cms.tmx.trade.message.MessagePromptMng;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortfAdjPosAlgoInstructPart
extends PortfAdjPosAlgoPart {
    private static final Logger logger = LogManager.getLogger(PortfAdjPosAlgoInstructPart.class);
    @Inject
    private PortfAdjPosAlgoInstructModel model;
    @Inject
    private MessagePromptMng msg;

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.setParam();
    }

    @Override
    @FXML
    protected void order() {
        if (!this.valid()) {
            return;
        }
        if (this.entrustConfirm("1", "\u6307\u4ee4")) {
            try {
                String id = this.model.submit();
                this.clearThenTrial();
                this.btnParam.setText("\u8bf7\u8bbe\u7f6e\u7b97\u6cd5\u53c2\u6570");
                this.showPart();
                this.sendMsg(id);
                this.alert.alert(Alert.AlertType.INFORMATION, "\u4e0b\u8fbe\u6307\u4ee4\u6210\u529f:" + id);
            }
            catch (MException e) {
                this.sendMsg((Object)e);
                logger.error((Object)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
    }

    private void sendMsg(Object obj) {
        if (this.model.getCapitalModel() instanceof PortfAdjPosAlgoCapitalModel) {
            this.model.setPortfolioId(((PortfAdjPosAlgoCapitalModel)PortfAdjPosAlgoCapitalModel.class.cast(this.model.getCapitalModel())).getSelectedPortf().getId());
            this.model.setPortfolioName(((PortfAdjPosAlgoCapitalModel)PortfAdjPosAlgoCapitalModel.class.cast(this.model.getCapitalModel())).getSelectedPortf().getName());
        }
        this.msg.algoMise((AdjustPosAdvice)this.model, "2", obj);
    }

    @Override
    protected boolean valid() {
        if (!super.valid()) {
            return false;
        }
        if (this.model.isRunningStatusInst()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8be5\u8d26\u53f7\u5b58\u5728\u8c03\u4ed3\u6307\u4ee4\uff01");
            return false;
        }
        return true;
    }

    @Override
    protected AdjPosAlgoModel getModel() {
        return this.model;
    }

    @Override
    protected PortfAdjPosAlgoCapitalModel getCapitalModel() {
        return (PortfAdjPosAlgoCapitalModel)this.model.getCapitalModel();
    }

    @Override
    protected String getInstructionPanelType() {
        return "1";
    }

    @Override
    protected String getBtnOrderTxt() {
        return "\u6307\u4ee4\u8c03\u4ed3";
    }

    @Override
    protected void showPart() {
        this.uiService.showPart("cms.tmx.instructions.part.port.adj.instruction.query");
    }
}

