/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.adjust;

import cms.tmx.api.data.IRefItem;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.instructions.models.adjust.AdjPosAlgoModel;
import cms.tmx.instructions.models.adjust.PortfAdjPosAlgoCapitalModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;

public class CcsAdjPosConfirmDialog
extends DialogObj {
    @FXML
    private TableView<BasketAlgoItem> tableItems;
    @FXML
    private TableColumn<BasketAlgoItem, String> index;
    @FXML
    private TableColumn<BasketAlgoItem, String> colCode;
    @FXML
    private TableColumn<BasketAlgoItem, String> colName;
    @FXML
    private TableColumn<BasketAlgoItem, String> colMkt;
    @FXML
    private TableColumn<BasketAlgoItem, MxNode> colDirection;
    @FXML
    private TableColumn<BasketAlgoItem, Number> colCount;
    @FXML
    private TableColumn<BasketAlgoItem, Number> colAmt;
    @FXML
    private TableColumn<BasketAlgoItem, String> colAcc;
    @FXML
    private TableColumn<BasketAlgoItem, String> colSecAcc;
    @FXML
    private TableColumn<BasketAlgoItem, String> colPorfolio;
    @FXML
    private TableColumn<BasketAlgoItem, String> colTip;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    @Inject
    protected IMarketDataMng mktMng;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private ExecutorService exe;
    private ObservableList<BasketAlgoItem> list = FxUtils.newList();
    private long totalCount = 0L;
    private double totalAmt = 0.0;
    private String strTip = "";
    private AdjPosAlgoModel model;
    private boolean triggered = false;
    private String instructionType = "";
    private String text = "";
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";

    @FXML
    public void initialize() {
        this.initValues();
        this.createTable();
    }

    private void initValues() {
        this.exe.execute(() -> {
            for (BasketAlgoItem item : this.list) {
                String type = item.getType();
                String market = item.getMarket().getRaw();
                String code = item.getCode();
                RefItem ref = this.refMng.getItem(type, market, code);
                MarketItem info = this.mktMng.getInfo((IRefItem)ref);
                int unit = 1;
                if ("BOND".equals(item.getType()) && "XSHG".equals(item.getMarket().getRaw())) {
                    unit = 10;
                }
                if (info.getNowPrice() != 0.0) {
                    item.setAmt((item.isBs() ? (double)item.getOrderQtyBuy() * info.getNowPrice() : (double)item.getOrderQtySell() * info.getNowPrice()) * (double)unit);
                } else {
                    item.setAmt((item.isBs() ? (double)item.getOrderQtyBuy() * info.getClosePrice() : (double)item.getOrderQtySell() * info.getClosePrice()) * (double)unit);
                }
                if (this.model.getCapitalModel().getSelectedFund() != null) {
                    item.setExtAccntId(this.model.getCapitalModel().getSelectedFund().getInvestId());
                }
                if (this.model.getCapitalModel().getSelectedSec(item.getMarket().getRaw()) != null) {
                    item.setExtSecAccntId(this.model.getCapitalModel().getSelectedSec(item.getMarket().getRaw()).getInverstorSecId());
                }
                if (this.model.getCapitalModel() instanceof PortfAdjPosAlgoCapitalModel) {
                    item.setPortfolioId(((PortfAdjPosAlgoCapitalModel)PortfAdjPosAlgoCapitalModel.class.cast(this.model.getCapitalModel())).getSelectedPortf().getName());
                }
                this.totalAmt += item.getAmt();
                this.totalCount += item.isBs() ? item.getOrderQtyBuy() : item.getOrderQtySell();
                if (this.triggered || StringUtils.isEmpty((String)item.getRemark())) continue;
                this.triggered = true;
            }
            if (this.triggered) {
                this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            }
            Platform.runLater(() -> this.initControl());
        });
    }

    private void initControl() {
        this.lbTotalCount.setText(this.totalCount == 0L ? "" : StringUtils.toThousands((String)String.valueOf(this.totalCount)));
        this.lbTotalAmt.setText(this.totalAmt == 0.0 ? "" : StringUtils.toPriceStr((double)this.totalAmt, (int)2));
        this.totalTip.getStyleClass().add((Object)"priceTag");
        this.totalTip.setText(this.strTip);
        CssUtils.makeRise((Control)this.totalTip);
        this.tpTip.setText(this.strTip);
    }

    private void createTable() {
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colCode.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).codeProperty());
        this.colName.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).nameProperty());
        this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(((BasketAlgoItem)m.getValue()).getMarket().getValue()));
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colDirection.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).bsProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colCount.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).isBs() ? ((BasketAlgoItem)m.getValue()).orderQtyBuyProperty() : ((BasketAlgoItem)m.getValue()).orderQtySellProperty());
        this.colAmt.setCellFactory(cell -> new AmtDoubleTableCell());
        this.colAmt.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).amtProperty());
        this.colAcc.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).extAccntIdProperty());
        this.colSecAcc.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).extSecAccntIdProperty());
        this.colPorfolio.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).portfolioIdProperty());
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colTip.setCellValueFactory(m -> ((BasketAlgoItem)m.getValue()).remarkProperty());
        this.tableItems.setItems(this.list);
    }

    public void setList(List<BasketAlgoItem> list) {
        this.list.setAll(list);
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public void setInstructionType(String instructionType) {
        this.instructionType = instructionType;
    }

    public AdjPosAlgoModel getModel() {
        return this.model;
    }

    public void setModel(AdjPosAlgoModel model) {
        this.model = model;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    static /* synthetic */ String access$0(CcsAdjPosConfirmDialog ccsAdjPosConfirmDialog) {
        return ccsAdjPosConfirmDialog.buySymbol;
    }

    static /* synthetic */ String access$1(CcsAdjPosConfirmDialog ccsAdjPosConfirmDialog) {
        return ccsAdjPosConfirmDialog.sellSymbol;
    }

    static /* synthetic */ String access$2(CcsAdjPosConfirmDialog ccsAdjPosConfirmDialog) {
        return ccsAdjPosConfirmDialog.instructionType;
    }

    static /* synthetic */ String access$3(CcsAdjPosConfirmDialog ccsAdjPosConfirmDialog) {
        return ccsAdjPosConfirmDialog.text;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class SideCell
    extends TableCell<BasketAlgoItem, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        /*
         * Exception decompiling
         */
        public void updateItem(MxNode value, boolean empty) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl56 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl56 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class TipCell
    extends TableCell<BasketAlgoItem, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }
}

