/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.adjust;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.instructions.models.adjust.CcsAdjPosAlgoCapitalModel;
import cms.tmx.javafx.MxNode;
import javafx.beans.property.Property;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsAdjPosCapitalDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(CcsAdjPosCapitalDialog.class);
    private CcsAdjPosAlgoCapitalModel accModel;
    @FXML
    protected TreeTableView<CcsAccountDistribution> basketAcctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @Inject
    private MxAlert alert;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private TreeItem<CcsAccountDistribution> root;
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(null);
            TreeTableRow row = this.getTreeTableRow();
            CcsAccountDistribution rowItem = (CcsAccountDistribution)row.getItem();
            TreeItem treeItem = row.getTreeItem();
            if (empty) {
                this.setGraphic(null);
                row.pseudoClassStateChanged(NOT_LEAF, false);
                row.pseudoClassStateChanged(LEAF, false);
                row.pseudoClassStateChanged(pcMxSelected, false);
            } else if (row.getItem() != null) {
                CheckBox checkBox = new CheckBox();
                rowItem.setDisable(false);
                checkBox.selectedProperty().bindBidirectional((Property)rowItem.selectedProperty());
                if (treeItem == null) {
                    return;
                }
                if (treeItem.isLeaf()) {
                    checkBox.selectedProperty().addListener((ob, old, now) -> {
                        TreeItem parent = treeItem.getParent();
                        if (now.booleanValue() && parent != null && parent.getValue() != null) {
                            ((CcsAccountDistribution)parent.getValue()).setSelected(now.booleanValue());
                            row.pseudoClassStateChanged(pcMxSelected, now != false && parent.isExpanded());
                            parent.getChildren().forEach(each -> {
                                MxNode eachNode = ((CcsAccountDistribution)each.getValue()).getSecAcc().getExchange();
                                if (eachNode != null) {
                                    String eachMarket = eachNode.getRaw();
                                    String itemMarket = ((CcsAccountDistribution)treeItem.getValue()).getSecAcc().getExchange().getRaw();
                                    if (!each.equals(treeItem) && eachMarket.equals(itemMarket)) {
                                        ((CcsAccountDistribution)each.getValue()).setSelected(false);
                                    }
                                }
                            });
                        } else {
                            row.pseudoClassStateChanged(pcMxSelected, false);
                        }
                    });
                    row.pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                    row.pseudoClassStateChanged(LEAF, true);
                    row.pseudoClassStateChanged(NOT_LEAF, false);
                } else {
                    checkBox.selectedProperty().addListener((ob, old, newV) -> {
                        row.pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                        if (newV.booleanValue()) {
                            TreeItem parent = treeItem.getParent();
                            parent.getChildren().forEach(p -> {
                                if (!p.equals(treeItem)) {
                                    ((CcsAccountDistribution)p.getValue()).setSelected(false);
                                }
                                p.getChildren().forEach(c -> {
                                    if (!((CcsAccountDistribution)p.getValue()).isSelected()) {
                                        ((CcsAccountDistribution)c.getValue()).setSelected(false);
                                    }
                                });
                            });
                            CcsAdjPosCapitalDialog.this.basketAcctTreeTable.refresh();
                        }
                    });
                    treeItem.expandedProperty().addListener((ob, old, newV) -> CcsAdjPosCapitalDialog.this.basketAcctTreeTable.refresh());
                    checkBox.setOnMouseClicked(event -> {
                        boolean xshg = true;
                        boolean xshe = true;
                        for (TreeItem cadItem : treeItem.getChildren()) {
                            ((CcsAccountDistribution)cadItem.getValue()).setSelected(false);
                            if (!((CcsAccountDistribution)treeItem.getValue()).isSelected()) continue;
                            String market = ((CcsAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw();
                            if (xshg && "XSHG".equals(market)) {
                                ((CcsAccountDistribution)cadItem.getValue()).setSelected(true);
                                xshg = false;
                            }
                            if (!xshe || !"XSHE".equals(market)) continue;
                            ((CcsAccountDistribution)cadItem.getValue()).setSelected(true);
                            xshe = false;
                        }
                    });
                    row.pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                    row.pseudoClassStateChanged(NOT_LEAF, true);
                    row.pseudoClassStateChanged(LEAF, false);
                }
                this.setGraphic((Node)checkBox);
            }
        }
    };

    @FXML
    public void initialize() {
        this.root = this.accModel.getRoot();
        this.createTree();
    }

    private void createTree() {
        this.basketAcctTreeTable.setRoot(this.root);
        this.basketAcctTreeTable.setShowRoot(false);
        this.basketAcctTreeTable.setPlaceholder((Node)new Label());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.root.setExpanded(true);
        this.root.getChildren().forEach(each -> each.setExpanded(false));
    }

    protected boolean isOK(ButtonType bt) {
        CcsFundAccount selectedFund = null;
        SecAccount secXshg = null;
        SecAccount secXshe = null;
        for (TreeItem accItem : this.accModel.getRoot().getChildren()) {
            if (!((CcsAccountDistribution)accItem.getValue()).isSelected()) continue;
            selectedFund = ((CcsAccountDistribution)accItem.getValue()).getAcc();
            for (TreeItem secItem : accItem.getChildren()) {
                CcsAccountDistribution dest = (CcsAccountDistribution)secItem.getValue();
                SecAccount sec = dest.getSecAcc();
                String market = sec.getExchange().getRaw();
                if ("XSHG".equals(market) && dest.isSelected()) {
                    secXshg = ((CcsAccountDistribution)secItem.getValue()).getSecAcc();
                    continue;
                }
                if (!"XSHE".equals(market) || !dest.isSelected()) continue;
                secXshe = ((CcsAccountDistribution)secItem.getValue()).getSecAcc();
            }
            String investId = ((CcsAccountDistribution)accItem.getValue()).getAcc().getInvestId();
            if (secXshg == null) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u8d44\u91d1\u8d26\u53f7" + investId + "\u9009\u62e9\u4e00\u4e2a\u6caa\u5e02\u8bc1\u5238\u8d26\u53f7\uff01");
                return false;
            }
            if (secXshe != null) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e3a\u8d44\u91d1\u8d26\u53f7" + investId + "\u9009\u62e9\u4e00\u4e2a\u6df1\u5e02\u8bc1\u5238\u8d26\u53f7\uff01");
            return false;
        }
        this.accModel.selectedCapital(selectedFund, secXshg, secXshe);
        return true;
    }

    public void setCapitalModel(CcsAdjPosAlgoCapitalModel model) {
        this.accModel = model;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }
}

