/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.adjust;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.models.adjust.AdjPosAlgoModel;
import cms.tmx.instructions.models.adjust.CcsAdjPosAlgoCapitalModel;
import cms.tmx.instructions.models.adjust.CcsAdjPosAlgoInstructModel;
import cms.tmx.instructions.viewers.adjust.CcsAdjPosAlgoPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.trade.models.basket.BasketMngModel;
import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsAdjPosAlgoApprovePart
extends CcsAdjPosAlgoPart {
    private static final Logger logger = LogManager.getLogger(CcsAdjPosAlgoApprovePart.class);
    @Inject
    private CcsAdjPosAlgoInstructModel model;
    protected Instruction instruction;
    protected AtomicBoolean initFinished = new AtomicBoolean(false);
    protected MEventHandler hSetCodeApp = event -> {
        Instruction inst = (Instruction)event.get(Instruction.class, "instruction");
        if (!this.validOrderFill(inst)) {
            return;
        }
        this.instruction = inst;
        this.doFill();
    };
    @Inject
    private CcsAccountMap accMng;
    @Inject
    protected BasketMngModel basketModel;

    @PostConstruct
    public void init() {
        super.init();
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.initFinished.set(true);
        this.doFill();
    }

    @PreDestroy
    private void dispose() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    private boolean validOrderFill(Instruction inst) {
        if (inst == null) {
            return false;
        }
        String type = inst.getType().getRaw();
        if (!"16".equals(type)) {
            return false;
        }
        return !inst.getIsOrderStep();
    }

    private void doFill() {
        if (!this.initFinished.get() || this.instruction == null) {
            return;
        }
        Platform.runLater(() -> {
            AdjustPosAdvice advice = this.instruction.getAdjustPosAdvice();
            this.setAccnt(advice);
            this.cmbAdjType.getSelectionModel().select((Object)advice.getAdjType());
            this.setBasket(this.instruction);
            this.cmbAdjWay.getSelectionModel().select((Object)advice.getAdjWay());
            if ("1".equals(advice.getAdjWay().getRaw())) {
                this.txtCount.setText(String.valueOf(advice.getCountBsk()));
            } else if ("2".equals(advice.getAdjWay().getRaw())) {
                BigDecimal big = new BigDecimal(advice.getMoneyStg());
                this.txtMoney.setText(big.toString());
            } else if ("7".equals(advice.getAdjWay().getRaw())) {
                this.spnStgPct.getEditor().setText(StringUtils.toThousands((Number)advice.getPctStg()));
                this.rdoBuy.setSelected(advice.isPtcStgBuy());
                this.rdoSell.setSelected(!advice.isPtcStgBuy());
            }
            this.cbxAdjMoney.setSelected(advice.isControlMoney());
            this.txtAdjMoney.setText(String.valueOf(advice.getMoney()));
            this.cbxControlImpact.setSelected(advice.isControlImpact());
            this.txtControlPercent.setText(String.valueOf(advice.getPercent()));
            this.getModel().setAlgoParam(advice.getAlgoParam());
            this.btnParam.setText("\u7bee\u5b50\u8c03\u4ed3\u7b97\u6cd5");
            this.exe.execute(() -> {
                try {
                    this.getModel().trial(advice);
                }
                catch (MException e) {
                    logger.error((Object)e, (Throwable)e);
                    Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                }
            });
        });
    }

    private void setAccnt(AdjustPosAdvice advice) {
        String investorId = advice.getInvestorId();
        CcsFundAccount accnt = this.accMng.getFundAcc(investorId);
        this.cmbCapital.setPromptText(investorId);
        SecAccount xshg = this.accMng.getSecAcc(advice.getSecIdXshg(), "XSHG");
        SecAccount xshe = this.accMng.getSecAcc(advice.getSecIdXshe(), "XSHE");
        this.getCapitalModel().selectedCapital(accnt, xshg, xshe);
    }

    private void setBasket(Instruction inst) {
        Basket basket = new Basket();
        basket.setId(inst.getAdjustPosAdvice().getBasketId());
        basket.setName(inst.getAdjustPosAdvice().getBasketName());
        this.getModel().setBasket(basket);
        ObservableList list = FxUtils.newList();
        list.add((Object)basket);
        this.cmbDestBasket.setItems(list);
        this.cmbDestBasket.getSelectionModel().select((Object)basket);
    }

    @Override
    @FXML
    protected void order() {
        if (this.entrustConfirm("3", "\u6307\u4ee4\u5ba1\u6279")) {
            try {
                this.model.approve(this.instruction);
                this.clearParam();
                this.btnParam.setText("\u8bf7\u8bbe\u7f6e\u7b97\u6cd5\u53c2\u6570");
                this.cmbCapital.setPromptText("");
                this.showPart();
                this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u5ba1\u6279\u6210\u529f\uff01");
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                logger.error((Object)e);
            }
        }
    }

    @Override
    @FXML
    public void calculate() {
        Basket bsk = (Basket)this.cmbDestBasket.getSelectionModel().getSelectedItem();
        if (bsk == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u76ee\u6807\u7bee\u5b50");
            return;
        }
        if (this.cbxControlImpact.isSelected() && this.getDouble(this.txtControlPercent.getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u51b2\u51fb\u63a7\u5236\u4e0d\u80fd\u4e3a\u7a7a\u62160");
            return;
        }
        this.tableBasket.getItems().clear();
        this.getMlist().clear();
        this.getModel().getItems().clear();
        this.exe.execute(() -> {
            try {
                AdjustPosAdvice advice = this.instruction.getAdjustPosAdvice();
                this.getModel().trial(advice);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @Override
    protected AdjPosAlgoModel getModel() {
        return this.model;
    }

    @Override
    protected CcsAdjPosAlgoCapitalModel getCapitalModel() {
        return (CcsAdjPosAlgoCapitalModel)this.model.getCapitalModel();
    }

    @Override
    protected String getInstructionPanelType() {
        return "3";
    }

    @Override
    protected String getBtnOrderTxt() {
        return "\u5ba1\u6279\u901a\u8fc7";
    }

    @Override
    protected void showPart() {
        this.uiService.showPart("cms.tmx.instructions.part.ccs.adj.instruction.query");
    }
}

