/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.adjust;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.instructions.models.adjust.AdjCheckBoxCell;
import cms.tmx.instructions.models.adjust.AdjItemBsCell;
import cms.tmx.instructions.models.adjust.AdjItemNumberCell;
import cms.tmx.instructions.models.adjust.AdjPosAlgoModel;
import cms.tmx.instructions.models.adjust.AlgoFactory;
import cms.tmx.instructions.models.adjust.IAdjPosAlgoCapitalModel;
import cms.tmx.instructions.viewers.adjust.CcsAdjPosConfirmDialog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.views.AdjTypeDescDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.trade.models.basket.BasketMngModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AdjPosAlgoPart<T>
extends MxPart {
    private static final Logger logger = LogManager.getLogger(AdjPosAlgoPart.class);
    @FXML
    protected VBox vbAdjustParam;
    @FXML
    protected HBox vbAlgoParam;
    @FXML
    protected HBox hbDestMoney;
    @FXML
    protected Label lbCapital;
    @FXML
    protected ComboBox<T> cmbCapital;
    @FXML
    protected ComboBox<MxNode> cmbAdjType;
    @FXML
    protected Label lbBasket;
    @FXML
    protected ComboBox<Basket> cmbDestBasket;
    @FXML
    protected ComboBox<String> cmbAdjScale;
    @FXML
    protected ComboBox<MxNode> cmbAdjWay;
    @FXML
    protected HBox hboxCount;
    @FXML
    protected TextField txtCount;
    @FXML
    private Label qtyMag;
    @FXML
    protected HBox hboxMoney;
    @FXML
    protected TextField txtMoney;
    @FXML
    private Label amtMag;
    @FXML
    protected HBox hboxPct;
    @FXML
    protected Spinner<Double> spnStgPct;
    @FXML
    protected Button btnParam;
    @FXML
    private TextField txtSearch;
    @FXML
    private RadioButton rdoAllVarieties;
    @FXML
    private RadioButton rdoAdjVarieties;
    @FXML
    private Label lbExplain;
    @FXML
    private Tooltip tpExplain;
    @FXML
    protected CheckBox cbxAdjMoney;
    @FXML
    protected TextField txtAdjMoney;
    @FXML
    protected Label lbMoneyErr;
    @FXML
    protected CheckBox cbxControlImpact;
    @FXML
    protected TextField txtControlPercent;
    @FXML
    protected RadioButton rdoBuy;
    @FXML
    protected RadioButton rdoSell;
    @FXML
    protected Button btnTrial;
    @FXML
    protected Button btnOrder;
    @FXML
    protected TableView<BasketAlgoItem> tableBasket;
    @FXML
    protected TableColumn<BasketAlgoItem, Boolean> selected;
    @FXML
    private TableColumn<BasketAlgoItem, MxNode> bs;
    @FXML
    private TableColumn<BasketAlgoItem, Number> nowPos;
    @FXML
    private TableColumn<BasketAlgoItem, Number> destPos;
    @FXML
    private TableColumn<BasketAlgoItem, String> nowWeight;
    @FXML
    private TableColumn<BasketAlgoItem, Number> destWeight;
    @FXML
    private TableColumn<BasketAlgoItem, Number> stgPct;
    @FXML
    private TableColumn<BasketAlgoItem, Number> orderQtyBuy;
    @FXML
    private TableColumn<BasketAlgoItem, Number> orderQtySell;
    @FXML
    private TableColumn<BasketAlgoItem, Number> buyMoney;
    @FXML
    private TableColumn<BasketAlgoItem, Number> sellMoney;
    @FXML
    private TableColumn<BasketAlgoItem, Number> dailyAvgQty;
    @FXML
    private TableColumn<BasketAlgoItem, Number> capitalization;
    @FXML
    private TableColumn<BasketAlgoItem, Number> targetMktValue;
    @FXML
    private TableColumn<BasketAlgoItem, String> remark;
    @FXML
    private CheckBox cbxAll;
    @FXML
    private Label lbNum;
    @FXML
    private Label lbCapitalization;
    @FXML
    private Label lbBuyMoney;
    @FXML
    private Label lbSellMoney;
    @Inject
    protected BasketMngModel basketMng;
    @Inject
    protected MObjFactory of;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MxAlert alert;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected IUIService uiService;
    @Inject
    protected IUiRightService right;
    protected DoubleSpinnerCtrl ctrlPct = new DoubleSpinnerCtrl(false, 3, 2);
    private ToggleGroup groupVarieties = new ToggleGroup();
    private MxList<BasketAlgoItem> mlist = new MxList();
    private Map<String, List<TableColumn<BasketAlgoItem, ?>>> mapColumn = new HashMap();
    private Basket bskBuffer = null;
    private boolean hasRender = false;
    private ToggleGroup group = new ToggleGroup();
    private ChangeListener<? super Boolean> lstnRef = (ob, old, now) -> Platform.runLater(() -> this.renderBasket((boolean)now));
    protected Predicate<BasketAlgoItem> pd = en -> {
        String text = this.txtSearch.getText().trim();
        if (this.rdoAdjVarieties.isSelected() && !en.isAdjust()) {
            return false;
        }
        return en.getCode().contains(text) || en.getName().contains(text);
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        if (this.rdoAdjVarieties.isSelected()) {
            this.rdoAllVarieties.setSelected(true);
        } else {
            this.mlist.setAll(this.getModel().getItems());
            this.tableBasket.sort();
        }
        this.tableBasket.refresh();
        if (this.cbxAll.isSelected()) {
            this.checkAll(true);
        } else {
            this.cbxAll.setSelected(true);
        }
        this.tableBasket.layout();
        this.thenOrder();
    });
    private InvalidationListener lstnModelMkt = ob -> this.lstnExtendOperation((ObservableList<BasketAlgoItem>)this.mlist.getList());
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<BasketAlgoItem> observableList = this.getModel().getItems();
        synchronized (observableList) {
            this.mlist.filter(this.getModel().getItems(), this.pd);
            this.tableBasket.refresh();
            this.tableBasket.sort();
        }
    };
    private InvalidationListener lstnBasket = ob -> {
        Basket lastBsk;
        MxNode nodeAdj = (MxNode)this.cmbAdjType.getSelectionModel().getSelectedItem();
        if (nodeAdj == null) {
            return;
        }
        ObservableList list = FxUtils.newList();
        this.basketMng.getList().forEach(basket -> {
            if (!basket.getList().isEmpty()) {
                MxNode nodeBs = ((BasketItem)basket.getList().get(0)).getBs();
                if (nodeBs == null || "0".equals(nodeBs.getRaw()) && "0".equals(nodeAdj.getRaw())) {
                    list.add(basket);
                } else if (!"0".equals(nodeBs.getRaw()) && "1".equals(nodeAdj.getRaw())) {
                    list.add(basket);
                }
            }
        });
        this.bskBuffer = lastBsk = (Basket)this.cmbDestBasket.getSelectionModel().getSelectedItem();
        this.cmbDestBasket.setItems(list);
        this.cmbDestBasket.getSelectionModel().select((Object)this.bskBuffer);
    };
    @Inject
    protected ExecutorService exe;
    @Inject
    private AlgoFactory factory;
    protected static final String ADJ_ALGO = "\u7bee\u5b50\u8c03\u4ed3\u7b97\u6cd5";
    protected static final String PLEASE = "\u8bf7\u8bbe\u7f6e\u7b97\u6cd5\u53c2\u6570";

    public AdjPosAlgoPart() {
        this.path = "AdjPosAlgoPart.fxml";
    }

    @FXML
    public void initialize() {
        this.initModel();
        this.initControl();
        this.listener();
        this.createTable();
        this.getModel().setInstructionPanelType(this.getInstructionPanelType());
        this.disableParam();
    }

    private void checkAll(boolean selected) {
        this.mlist.getList().forEach(item -> {
            boolean isApprove;
            if (item.isAdjust()) {
                item.setSelected(selected);
            }
            item.setDisable((isApprove = "3".equals(this.getInstructionPanelType())) ? true : !item.isAdjust());
        });
        this.lstnExtendOperation((ObservableList<BasketAlgoItem>)this.mlist.getList());
    }

    private void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.getModel().changedMktProperty().addListener(this.lstnModelMkt);
        this.txtSearch.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.groupVarieties.selectedToggleProperty().addListener(ob -> {
            if (this.txtSearch.getText().isEmpty()) {
                this.lstnSearch.invalidated(null);
            } else {
                this.txtSearch.clear();
            }
        });
        this.refMng.doneProperty().addListener(this.lstnRef);
        this.cbxAll.selectedProperty().addListener((ob, old, now) -> this.checkAll((boolean)now));
    }

    @PreDestroy
    public void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.getModel().changedMktProperty().removeListener(this.lstnModelMkt);
        this.refMng.doneProperty().removeListener(this.lstnRef);
        this.basketMng.changedProperty().removeListener(this.lstnBasket);
    }

    public void lstnExtendOperation(ObservableList<BasketAlgoItem> list) {
        int num = 0;
        double capitalization = 0.0;
        double buyMoney = 0.0;
        double sellMoney = 0.0;
        for (BasketAlgoItem item : list) {
            if (!item.isSelected()) continue;
            if (item.isBs()) {
                buyMoney += item.getBuyMoney();
            } else {
                sellMoney += item.getSellMoney();
            }
            ++num;
            capitalization += item.getCapitalization();
        }
        this.lbNum.setText(StringUtils.toThousands((Number)num));
        this.lbCapitalization.setText(StringUtils.toThousands((Number)capitalization, (int)2));
        this.lbBuyMoney.setText(StringUtils.toThousands((Number)buyMoney, (int)2));
        this.lbSellMoney.setText(StringUtils.toThousands((Number)sellMoney, (int)2));
    }

    private void initControl() {
        this.initCapital();
        MxNode node = MxNodeFactory.createNew((String)"adj_type", (String)"0");
        this.cmbAdjType.setItems(node.getNodes());
        this.cmbAdjType.getSelectionModel().select((Object)node);
        this.getModel().adjTypeProperty().bind((ObservableValue)this.cmbAdjType.valueProperty());
        this.adjTypeControl();
        this.cmbAdjType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now.getRaw().equals("0")) {
                this.vbAdjustParam.getChildren().add(2, (Object)this.cmbAdjScale.getParent());
                this.rdoAllVarieties.setVisible(true);
                this.rdoAdjVarieties.setVisible(true);
                this.cmbAdjWay.setDisable(false);
                this.lbBasket.setText("\u76ee\u6807\u7bee\u5b50");
            } else {
                this.vbAdjustParam.getChildren().remove((Object)this.cmbAdjScale.getParent());
                this.rdoAllVarieties.setVisible(false);
                this.rdoAdjVarieties.setVisible(false);
                this.cmbAdjWay.getSelectionModel().select(0);
                this.cmbAdjWay.setDisable(true);
                this.lbBasket.setText("\u6807\u7684\u7bee\u5b50");
            }
            this.cmbDestBasket.getSelectionModel().clearSelection();
            this.lstnBasket.invalidated(null);
        });
        this.lstnBasket.invalidated(null);
        this.renderBasket(true);
        node = MxNodeFactory.create((String)"adj_way_type", (String)"1");
        this.cmbAdjWay.setItems(node.getNodes());
        this.cmbAdjWay.getSelectionModel().select((Object)node);
        this.getModel().adjWayProperty().bind((ObservableValue)this.cmbAdjWay.valueProperty());
        this.cmbAdjWay.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.clearThenTrial();
            boolean editable = false;
            boolean disable = false;
            switch (this.getInstructionPanelType()) {
                case "0": 
                case "1": 
                case "2": {
                    if (!now.getRaw().equals("7")) break;
                    editable = true;
                    disable = true;
                    this.cmbDestBasket.getSelectionModel().clearSelection();
                }
            }
            this.tableBasket.setEditable(editable);
            this.cmbDestBasket.setDisable(disable);
            String key = now.getRaw();
            if (now.getRaw().equals("7")) {
                key = String.valueOf(key) + this.rdoBuy.isSelected();
                this.vbAdjustParam.getChildren().add(10, (Object)this.rdoBuy.getParent());
            } else {
                this.vbAdjustParam.getChildren().remove((Object)this.rdoBuy.getParent());
            }
            this.tableBasket.getColumns().setAll((Collection)this.mapColumn.get(key));
        });
        this.vbAdjustParam.getChildren().remove((Object)this.rdoBuy.getParent());
        this.txtCount.setDisable(true);
        this.hboxCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.getModel().getAdjWay().is("1"), (Observable[])new Observable[]{this.getModel().adjWayProperty()}));
        this.txtCount.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 9, 2)));
        MxBindings.bindSD((Property)this.txtCount.textProperty(), (Property)this.getModel().countBskProperty());
        this.txtCount.setText(StringUtils.toPriceStr((String)this.txtCount.getText()));
        this.qtyMag.visibleProperty().bind((ObservableValue)this.hboxCount.visibleProperty());
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.txtCount);
        this.hboxMoney.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.getModel().getAdjWay().is("2"), (Observable[])new Observable[]{this.getModel().adjWayProperty()}));
        this.txtMoney.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        MxBindings.bindSD((Property)this.txtMoney.textProperty(), (Property)this.getModel().moneyStgProperty());
        this.txtMoney.textProperty().addListener((ob, old, now) -> {
            if (this.getDouble((String)now) != this.getDouble((String)old)) {
                this.clearThenTrial();
            }
        });
        this.txtMoney.setText(StringUtils.toPriceStr((String)this.txtMoney.getText()));
        this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
        TextFieldUtils.showMagnitude((Label)this.amtMag, (TextField)this.txtMoney);
        this.hboxPct.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.getModel().getAdjWay().is("7"), (Observable[])new Observable[]{this.getModel().adjWayProperty()}));
        this.ctrlPct.ctrl(this.spnStgPct);
        this.ctrlPct.setUnit(1.0);
        this.spnStgPct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$", 5));
        MxBindings.bindSD((Property)this.spnStgPct.getEditor().textProperty(), (Property)this.getModel().pctStgProperty());
        this.spnStgPct.getEditor().textProperty().addListener((ob, old, now) -> {
            if (this.getDouble((String)now) != this.getDouble((String)old)) {
                this.clearThenTrial();
            }
        });
        SpinnerUtils.arrowsStyle(this.spnStgPct);
        this.spnStgPct.getEditor().setText("");
        this.cmbAdjScale.setItems(null);
        this.lbExplain.getStyleClass().add((Object)"btnOperation");
        this.tpExplain.setText("\u8ba1\u7b97\u516c\u5f0f\u8bf4\u660e\uff1a\n\u65e5\u5747\u6210\u4ea4\u91cf= \u2211\u5f53\u65e5\u6743\u91cd*\u5f53\u65e5\u6210\u4ea4\u91cf / \u2211\u6bcf\u65e5\u6743\u91cd \uff1b\n\u6628\u65e5\u6743\u91cd\uff08T\u65e5\uff09=1 \uff1b \nT-1\u65e5\u6743\u91cd=T\u65e5\u6743\u91cd-\u9012\u51cf\u6bd4\u4f8b\uff1b\u9ed8\u8ba4\u503c0\uff0c\u8868\u793a\u6bcf\u65e5\u6743\u91cd\u76f8\u7b49");
        this.tpExplain.setPrefWidth(400.0);
        this.tpExplain.setWrapText(true);
        this.rdoAllVarieties.setToggleGroup(this.groupVarieties);
        this.rdoAdjVarieties.setToggleGroup(this.groupVarieties);
        this.groupVarieties.selectToggle((Toggle)this.rdoAllVarieties);
        Tooltip tool = new Tooltip();
        this.cmbDestBasket.setTooltip(tool);
        this.cmbDestBasket.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null && now != this.bskBuffer) {
                this.basketChange();
                tool.setText(now.getName());
            } else {
                tool.setText("");
            }
        });
        this.txtAdjMoney.setDisable(true);
        this.txtAdjMoney.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 9, 2)));
        this.txtAdjMoney.textProperty().addListener((ob, old, now) -> {
            boolean pass = this.getModel().checkMoney(this.getDouble((String)now));
            this.lbMoneyErr.setOpacity((double)(!pass ? 1 : 0));
        });
        this.cbxAdjMoney.selectedProperty().addListener((ob, old, now) -> {
            this.txtAdjMoney.setDisable(now == false);
            this.getModel().setControlMoney((boolean)now);
        });
        this.cbxAdjMoney.setSelected(true);
        this.txtControlPercent.setDisable(true);
        this.txtControlPercent.setText("10.00");
        String precent = "^((([0-9]|([1-9][0-9])|([1-9][0-9][0-9])))(\\.(\\d){0,2})?)$";
        this.txtControlPercent.setTextFormatter((TextFormatter)new MxFormatter(precent, 9));
        this.txtControlPercent.textProperty().addListener((ob, old, now) -> {
            this.getModel().setPercent(this.getDouble((String)now));
            this.clearThenTrial();
        });
        this.txtControlPercent.focusedProperty().addListener((ob, old, now) -> {
            String txt = StringUtils.toThousands((String)this.txtControlPercent.getText(), (int)2);
            this.txtControlPercent.setText(txt);
        });
        this.cbxControlImpact.selectedProperty().addListener((ob, old, now) -> {
            this.txtControlPercent.setDisable(now == false);
            this.getModel().setControlImpact((boolean)now);
            this.clearThenTrial();
        });
        this.rdoBuy.setToggleGroup(this.group);
        this.rdoSell.setToggleGroup(this.group);
        this.rdoSell.setSelected(true);
        this.getModel().ptcStgBuyProperty().bind((ObservableValue)this.rdoBuy.selectedProperty());
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            this.clearThenTrial();
            this.tableBasket.getColumns().setAll((Collection)this.mapColumn.get("7" + this.rdoBuy.isSelected()));
        });
        this.btnParam.setDisable(true);
        this.btnOrder.setText(this.getBtnOrderTxt());
        this.btnOrder.setDisable(true);
        CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
    }

    protected void renderBasket(boolean done) {
        if (done && !this.hasRender) {
            this.hasRender = true;
            this.basketMng.changedProperty().addListener(this.lstnBasket);
        }
    }

    protected double getDouble(String txt) {
        return StringUtils.parseDouble((String)txt);
    }

    protected void createTable() {
        TableUtils.initValueFactory(this.tableBasket);
        this.selected.setSortable(false);
        this.selected.setCellValueFactory(data -> ((BasketAlgoItem)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new AdjCheckBoxCell(this.getModel()));
        this.bs.setCellFactory(data -> new AdjItemBsCell());
        this.nowPos.setCellFactory(data -> new NumberTableCell());
        this.destPos.setCellFactory(data -> new NumberTableCell());
        this.destWeight.setCellFactory(data -> new DoubleTableCell(4));
        this.stgPct.setCellFactory(data -> new stgPctCell(2));
        this.orderQtyBuy.setCellValueFactory(data -> ((BasketAlgoItem)data.getValue()).orderQtyBuyProperty());
        this.orderQtyBuy.setCellFactory(data -> new AdjItemNumberCell(true));
        this.orderQtySell.setCellValueFactory(data -> ((BasketAlgoItem)data.getValue()).orderQtySellProperty());
        this.orderQtySell.setCellFactory(data -> new AdjItemNumberCell(false));
        this.buyMoney.setCellValueFactory(data -> ((BasketAlgoItem)data.getValue()).buyMoneyProperty());
        this.buyMoney.setCellFactory(data -> new AdjItemNumberCell(true, 2));
        this.sellMoney.setCellValueFactory(data -> ((BasketAlgoItem)data.getValue()).sellMoneyProperty());
        this.sellMoney.setCellFactory(data -> new AdjItemNumberCell(false, 2));
        this.capitalization.setCellValueFactory(data -> ((BasketAlgoItem)data.getValue()).capitalizationProperty());
        this.capitalization.setCellFactory(data -> new DoubleTableCell(2));
        this.targetMktValue.setCellValueFactory(data -> ((BasketAlgoItem)data.getValue()).targetMktValueProperty());
        this.targetMktValue.setCellFactory(data -> new DoubleTableCell(2));
        this.dailyAvgQty.setCellFactory(data -> new NumberTableCell());
        this.tableBasket.setPlaceholder((Node)new Label());
        this.tableBasket.setItems(this.mlist.getList());
        this.tableBasket.getColumns().remove(this.nowWeight);
        this.remark.setSortType(TableColumn.SortType.DESCENDING);
        this.tableBasket.getSortOrder().add(this.remark);
        LinkedList listQty = new LinkedList(this.tableBasket.getColumns());
        listQty.remove(this.targetMktValue);
        listQty.remove(this.stgPct);
        this.mapColumn.put("1", listQty);
        LinkedList listMoney = new LinkedList(this.tableBasket.getColumns());
        listMoney.remove(this.stgPct);
        this.mapColumn.put("2", listMoney);
        LinkedList listPctBuy = new LinkedList(this.tableBasket.getColumns());
        listPctBuy.remove(this.destWeight);
        listPctBuy.remove(this.targetMktValue);
        listPctBuy.remove(this.orderQtySell.getParentColumn());
        this.mapColumn.put("7true", listPctBuy);
        LinkedList listPctSell = new LinkedList(this.tableBasket.getColumns());
        listPctSell.remove(this.destWeight);
        listPctSell.remove(this.targetMktValue);
        listPctSell.remove(this.orderQtyBuy.getParentColumn());
        this.mapColumn.put("7false", listPctSell);
        this.tableBasket.getColumns().setAll(listQty);
        this.stgPct.addEventHandler(TableColumn.editCommitEvent(), event -> {
            double oldValue;
            double newValue = (Double)event.getNewValue();
            if (newValue == (oldValue = ((Double)event.getOldValue()).doubleValue())) {
                return;
            }
            BasketAlgoItem item = (BasketAlgoItem)event.getRowValue();
            item.setStgPct(newValue);
            String type = item.getType();
            String market = item.getMarket().getRaw();
            String code = item.getCode();
            RefItem ref = this.refMng.getItem(type, market, code);
            if (ref != null) {
                this.getModel().calCanQty(item, ref, true);
            }
            this.lstnExtendOperation((ObservableList<BasketAlgoItem>)this.mlist.getList());
        });
    }

    private void basketChange() {
        switch (this.getInstructionPanelType()) {
            case "3": 
            case "4": {
                return;
            }
        }
        this.clearThenTrial();
    }

    protected void clearThenTrial() {
        this.mlist.clear();
        this.getModel().clear();
        this.btnParam.setDisable(true);
        this.btnParam.setText(PLEASE);
        this.getModel().setAlgoParam(null);
        this.btnOrder.setDisable(true);
        this.btnTrial.setDisable(false);
        this.groupVarieties.selectToggle((Toggle)this.rdoAllVarieties);
        this.lbNum.setText("");
        this.lbBuyMoney.setText("");
        this.lbSellMoney.setText("");
        this.lbCapitalization.setText("");
    }

    private void thenOrder() {
        this.tableBasket.scrollToColumnIndex(0);
        this.btnParam.setDisable(false);
        this.btnOrder.setDisable(false);
    }

    @FXML
    public void calculate() {
        if (this.cmbCapital.getItems().isEmpty()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8d26\u53f7\u4e3a\u7a7a\uff01");
            return;
        }
        Basket bsk = (Basket)this.cmbDestBasket.getSelectionModel().getSelectedItem();
        MxNode node = (MxNode)this.cmbAdjWay.getSelectionModel().getSelectedItem();
        boolean isPctStg = node.getRaw().equals("7");
        if (!isPctStg && bsk == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u76ee\u6807\u7bee\u5b50");
            return;
        }
        if (node.getRaw().equals("2") && this.getDouble(this.txtMoney.getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u91d1\u989d");
            return;
        }
        if (isPctStg && this.getDouble(this.spnStgPct.getEditor().getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u8c03\u6574\u6bd4\u4f8b");
            return;
        }
        if (this.cbxControlImpact.isSelected() && this.getDouble(this.txtControlPercent.getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u51b2\u51fb\u63a7\u5236\u4e0d\u80fd\u4e3a\u7a7a\u62160");
            return;
        }
        this.tableBasket.getItems().clear();
        this.getModel().getItems().clear();
        this.mlist.clear();
        this.btnTrial.setDisable(true);
        this.btnOrder.setDisable(true);
        this.exe.execute(() -> {
            block5: {
                try {
                    try {
                        this.getModel().trial(bsk);
                    }
                    catch (MException e) {
                        logger.error((Object)e, (Throwable)e);
                        Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                        Platform.runLater(() -> {
                            this.btnTrial.setDisable(false);
                            this.btnOrder.setDisable(false);
                        });
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    Platform.runLater(() -> {
                        this.btnTrial.setDisable(false);
                        this.btnOrder.setDisable(false);
                    });
                    throw throwable;
                }
                Platform.runLater(() -> {
                    this.btnTrial.setDisable(false);
                    this.btnOrder.setDisable(false);
                });
            }
        });
    }

    @FXML
    public void algoParamSet() {
        AlgoParam param = this.getModel().getAlgoParam();
        if ((param = this.factory.adjPostionDialog(param, this.getModel().isRepo())) != null) {
            this.getModel().setAlgoParam(param);
            this.btnParam.setText(ADJ_ALGO);
        }
    }

    protected boolean valid() {
        if (!ADJ_ALGO.equals(this.btnParam.getText())) {
            this.alert.alert(Alert.AlertType.WARNING, PLEASE);
            return false;
        }
        List<BasketAlgoItem> list = this.getModel().getAdjustItems();
        if (list.isEmpty()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u65e0\u53ef\u8c03\u4ed3\u54c1\u79cd");
            return false;
        }
        if (list.size() >= 5000) {
            this.alert.alert(Alert.AlertType.WARNING, "\u4ec5\u5141\u8bb85000\u53ca\u4ee5\u4e0b\u54c1\u79cd\u8c03\u4ed3");
            return false;
        }
        if (this.getModel().isRunningStatus()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8be5\u8d26\u53f7\u5b58\u5728\u8c03\u4ed3\u7b56\u7565\uff01");
            return false;
        }
        return true;
    }

    protected void disableParam() {
        switch (this.getInstructionPanelType()) {
            case "0": 
            case "1": 
            case "2": {
                return;
            }
            case "3": {
                this.vbAdjustParam.setDisable(true);
                this.cbxAll.setDisable(true);
                break;
            }
            case "4": {
                this.vbAdjustParam.getChildren().forEach(node -> node.setDisable(!node.equals(this.vbAlgoParam)));
            }
        }
        this.rdoBuy.getParent().setDisable(true);
        this.lbMoneyErr.setVisible(false);
        this.btnTrial.setDisable(true);
    }

    protected void clearParam() {
        this.cmbCapital.getSelectionModel().select(null);
        this.cmbAdjWay.getSelectionModel().selectFirst();
        this.cmbDestBasket.getSelectionModel().select(null);
        this.cbxAdjMoney.setSelected(false);
        this.txtAdjMoney.clear();
        this.cbxControlImpact.setSelected(false);
        this.txtControlPercent.setText("10.00");
        this.mlist.clear();
        this.getModel().getItems().clear();
        this.btnParam.setDisable(true);
        this.btnParam.setText(PLEASE);
        this.getModel().setAlgoParam(null);
        this.btnOrder.setDisable(true);
        this.btnTrial.setDisable(true);
        this.groupVarieties.selectToggle((Toggle)this.rdoAllVarieties);
    }

    @FXML
    private void help() {
        AdjTypeDescDialog obj = (AdjTypeDescDialog)this.of.create(AdjTypeDescDialog.class);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u8c03\u4ed3\u65b9\u5f0f\u8bf4\u660e");
        dialog.launch();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithTwoHead(this.tableBasket, (int)0, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeOneOrTwoHeadExcel(this.tableBasket, (String)"\u8c03\u4ed3\u660e\u7ec6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void initModel() {
        this.getModel().init(this.getInstructionPanelType());
    }

    @FXML
    protected abstract void order();

    @FXML
    protected abstract void setCapital();

    protected abstract String getBtnOrderTxt();

    protected abstract void initCapital();

    protected abstract void setParam();

    protected abstract AdjPosAlgoModel getModel();

    protected abstract IAdjPosAlgoCapitalModel getCapitalModel();

    protected abstract String getInstructionPanelType();

    protected abstract void showPart();

    protected void adjTypeControl() {
    }

    protected boolean entrustConfirm(String type, String text) {
        CcsAdjPosConfirmDialog obj = (CcsAdjPosConfirmDialog)((Object)this.of.create(CcsAdjPosConfirmDialog.class));
        obj.setList(this.getModel().getAdjustItems());
        obj.setModel(this.getModel());
        obj.setInstructionType(type);
        obj.setText(text);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        return dialog.launch() == ButtonType.OK;
    }

    public MxList<BasketAlgoItem> getMlist() {
        return this.mlist;
    }

    private class stgPctCell
    extends EditTableCell<BasketAlgoItem> {
        stgPctCell(int i) {
            super(i);
        }

        public void startEdit() {
            if (this.getTableRow().getItem() != null) {
                BasketAlgoItem item = (BasketAlgoItem)this.getTableRow().getItem();
                if (item.isAdjust()) {
                    this.setEditable(true);
                    super.startEdit();
                } else {
                    this.setEditable(false);
                }
            }
            if (this.getTextField().getTextFormatter() == null) {
                this.getTextField().setTextFormatter((TextFormatter)new MxFormatter("^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$", 5));
            }
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
        }
    }
}

