/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.adjust;

import cms.tmx.algorithm.models.AlgoConfControls;
import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.util.Calendar;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;

public class AdjPosAlgoDialog
extends DialogObj {
    protected ButtonType[] btnType = new ButtonType[]{new ButtonType("\u786e\u8ba4", ButtonBar.ButtonData.OK_DONE), ButtonType.CANCEL};
    @FXML
    public ComboBox<Algorithm> cmbAlgo;
    @FXML
    public TextField txtStartHour;
    @FXML
    public TextField txtStartMinute;
    @FXML
    public TextField txtEndHour;
    @FXML
    public TextField txtEndMinute;
    @FXML
    public Spinner<Integer> spnTimeSlice;
    @FXML
    protected Label lbSliceErr;
    @FXML
    protected Label lbStartErr;
    @FXML
    protected Label lbEndErr;
    @FXML
    protected ComboBox<MxNode> cmbDepth;
    @FXML
    protected Spinner<Integer> spnSweep;
    @FXML
    protected Label lbSweepErr;
    @FXML
    protected TextField txtWithdraw;
    @FXML
    protected Label lbWithdrawErr;
    @Inject
    protected AlgoModel algo;
    @Inject
    private AlgoConfControls algoConf;
    private AlgoParam param;
    private boolean readOnly = false;
    private boolean isRepo = false;
    protected IntSpinnerCtrl ctrlSlice = new IntSpinnerCtrl(true, 3, 1);
    protected IntSpinnerCtrl ctrlPct = new IntSpinnerCtrl(true, 3, 1);
    protected int sliceMax = 0;
    protected int sliceMin = 0;

    public ButtonType[] getTypes() {
        return this.btnType;
    }

    @FXML
    public void initialize() {
        this.initControls();
        if (this.param != null) {
            this.txtStartHour.setText(AlgoModel.complement((Object)this.param.getStartHour()));
            this.txtStartMinute.setText(AlgoModel.complement((Object)this.param.getStartMinute()));
            this.txtEndHour.setText(AlgoModel.complement((Object)this.param.getEndHour()));
            this.txtEndMinute.setText(AlgoModel.complement((Object)this.param.getEndMinute()));
            this.spnTimeSlice.getEditor().setText(String.valueOf(this.param.getSlice()));
            MxNode node = MxNodeFactory.create((String)"adj_depth", (String)String.valueOf(this.param.getDepth()));
            this.cmbDepth.setValue((Object)node);
            this.spnSweep.getEditor().setText(StringUtils.toThousands((Number)(this.param.getPercentDepth() * 100.0), (int)2));
            this.txtWithdraw.setText(String.valueOf(this.param.getDelay()));
        }
        if (!this.readOnly) {
            this.checks();
        }
    }

    protected void initControls() {
        this.cmbAlgo.setDisable(true);
        this.ctrlSlice.ctrl(this.spnTimeSlice);
        this.spnTimeSlice.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnTimeSlice.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnTimeSlice, (int)0, (int)1);
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtEndHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtEndMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtEndHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtEndMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartHour));
        this.txtEndHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndHour));
        this.txtStartMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartMinute));
        this.txtEndMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndMinute));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtEndHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.txtEndMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndMinute.selectAll());
        AlgoModel.timeLimit((TextField)this.txtStartHour, (TextField)this.txtStartMinute, (TextField)this.txtEndHour, (TextField)this.txtEndMinute, (boolean)this.isRepo);
        SpinnerUtils.arrowsStyle(this.spnTimeSlice);
        MxNode node = MxNodeFactory.create((String)"adj_depth", (String)"3");
        this.cmbDepth.setItems(node.getNodes());
        this.cmbDepth.setValue((Object)node);
        this.ctrlPct.ctrl(this.spnSweep);
        this.spnSweep.getEditor().setTextFormatter((TextFormatter)new MxFormatter("^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$", 5));
        this.spnSweep.getEditor().setText("10");
        SpinnerUtils.arrowsStyle(this.spnSweep);
        this.txtWithdraw.setTextFormatter((TextFormatter)new MxFormatter("^([1-9]{1}\\d*)$", 4));
        this.txtWithdraw.setText("20");
        if (this.readOnly) {
            this.txtStartHour.setDisable(true);
            this.txtStartMinute.setDisable(true);
            this.txtEndHour.setDisable(true);
            this.txtEndMinute.setDisable(true);
            this.spnTimeSlice.setDisable(true);
            this.cmbDepth.setDisable(true);
            this.spnSweep.setDisable(true);
            this.txtWithdraw.setDisable(true);
        }
    }

    protected void sliceChange() {
        int startHour = this.getInt(this.txtStartHour);
        int startMinute = this.getInt(this.txtStartMinute);
        int endHour = this.getInt(this.txtEndHour);
        int endMinute = this.getInt(this.txtEndMinute);
        this.sliceMax = AlgoModel.computeSlice((int)startHour, (int)startMinute, (int)endHour, (int)endMinute);
        this.sliceMin = this.sliceMax / 10;
        this.sliceMin = this.sliceMin < 2 ? 1 : this.sliceMin;
        int sliceDef = this.sliceMax / 5;
        sliceDef = sliceDef < 2 ? 1 : sliceDef;
        this.spnTimeSlice.getEditor().setText(String.valueOf(sliceDef));
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    private void checks() {
        if (this.algoConf.limitTime()) {
            this.registerCheck((Node)this.lbStartErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                if (!AlgoModel.timeIsValid((int)start, (boolean)this.isRepo)) {
                    this.lbStartErr.setText(this.getTimeRange());
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty()}));
            this.registerCheck((Node)this.lbEndErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int minuter;
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                int end = this.getInt(this.txtEndHour) * 60 + this.getInt(this.txtEndMinute);
                if (!AlgoModel.timeIsValid((int)end, (boolean)this.isRepo)) {
                    this.lbEndErr.setText(this.getTimeRange());
                    return false;
                }
                if (end <= start) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u8d77\u59cb\u65f6\u95f4");
                    return false;
                }
                Calendar calender = Calendar.getInstance();
                int hour = calender.get(11);
                if (end < hour * 60 + (minuter = calender.get(12))) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty(), this.algo.minuteProperty()}));
        }
        this.registerCheck((Node)this.lbSliceErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int slice = this.getInt(this.spnTimeSlice.getEditor());
            if (slice > this.sliceMax || slice < this.sliceMin) {
                this.lbSliceErr.setText("\u8bf7\u8f93\u5165\u65f6\u95f4\u7247\u6570:" + this.sliceMin + "~" + this.sliceMax);
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnTimeSlice.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbSweepErr, (ObservableBooleanValue)this.spnSweep.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbWithdrawErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int interval = StringUtils.parseInt((String)this.txtWithdraw.getText());
            if (interval <= 3600 && interval > 0) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtWithdraw.textProperty()}));
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : StringUtils.parseInt((String)txt.getText());
    }

    protected void loseFocus(Boolean val) {
    }

    public boolean isOK(ButtonType bt) {
        this.algo.setStartHour(Integer.valueOf(this.txtStartHour.getText()).intValue());
        this.algo.setStartMinute(Integer.valueOf(this.txtStartMinute.getText()).intValue());
        this.algo.setEndHour(Integer.valueOf(this.txtEndHour.getText()).intValue());
        this.algo.setEndMinute(Integer.valueOf(this.txtEndMinute.getText()).intValue());
        this.algo.setSlice(Integer.valueOf(this.spnTimeSlice.getEditor().getText().replaceAll(",", "")).intValue());
        this.algo.setDepth(Integer.valueOf(((MxNode)this.cmbDepth.getValue()).getRaw()).intValue());
        this.algo.setPercentDepth(Double.valueOf(this.spnSweep.getEditor().getText()) / 100.0);
        this.algo.setDelay(Integer.valueOf(this.txtWithdraw.getText()).intValue());
        return true;
    }

    public AlgoParam getParam() {
        return this.algo;
    }

    public void setAlgoParam(AlgoParam param, boolean isRepo) {
        this.isRepo = isRepo;
        if (param == null) {
            return;
        }
        this.param = param;
        if (param.getAlgorithm() != null) {
            this.readOnly = true;
            this.btnType = new ButtonType[]{new ButtonType("\u5173\u95ed", ButtonBar.ButtonData.OK_DONE)};
        }
    }

    public String getTimeRange() {
        return this.isRepo ? "\u8303\u56f4 09:30-11:29 13:00-15:29" : "\u8303\u56f4 09:30-11:29 13:00-14:59";
    }
}

