/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.abroad;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.instructions.viewers.abroad.InstAbroadFutBasePart;
import cms.tmx.query.current.models.NewInstructionModel;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class InstAbroadFutPassivePart
extends InstAbroadFutBasePart {
    @Inject
    private NewInstructionModel insModel;
    protected boolean isInstructionEvent = false;
    protected MEventHandler hSetCodeApp = event -> {
        if (event.get((Object)"instruction") == null || !(event.get((Object)"instruction") instanceof ObSimpleInstruction)) {
            return;
        }
        ObSimpleInstruction ins = (ObSimpleInstruction)ObSimpleInstruction.class.cast(event.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Inject
    public InstAbroadFutPassivePart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    public void initialize() {
        this.model.create("2");
        this.setBuySymbol("\u5ba1\u6279\u901a\u8fc7");
        this.setSellSymbol("\u5ba1\u6279\u901a\u8fc7");
        this.setConfirmSymbol("\u5ba1\u6279");
        this.onApprove(true);
        super.initialize();
        this.initFinished.set(true);
        this.doFill();
    }

    protected void onApprove(boolean disable) {
        this.txtCode.setEditable(!disable);
        this.cmbTif.setEditable(!disable);
        this.cmbPriceTypeLimited.setEditable(!disable);
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.setDisable(true);
    }

    @Override
    protected void quantityDisableBind() {
        this.quantitySpn.setDisable(true);
    }

    private boolean validOrderFill(ObSimpleInstruction ins) {
        return StringUtils.belongto((String)ins.getType(), (String[])new String[]{"SimpleDetail"}) && ins.isIsApproveStep();
    }

    @Override
    protected void submitOrder() {
        WorkflowTask task = null;
        List workflowTasks = this.instruction.getWorkflowTasks();
        String operation = "";
        for (WorkflowTask workflowTask : workflowTasks) {
            if (workflowTask.getPermissibleList().contains("2")) {
                task = workflowTask;
                operation = "2";
            }
            if (!workflowTask.getPermissibleList().contains("6")) continue;
            task = workflowTask;
            operation = "6";
        }
        if (task == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5ba1\u6279\u5931\u8d25\uff0c\u672a\u53d6\u5230\u5ba1\u6279\u4efb\u52a1");
            return;
        }
        try {
            this.insModel.complateTask(this.instruction.getId(), this.instruction.getEntryId(), operation, task, null);
        }
        catch (MException | Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5ba1\u6279\u5931\u8d25:" + e.getMessage());
            return;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u5ba1\u6279\u6210\u529f");
        this.clearPanel();
    }

    public void clearPanel() {
        this.onApprove(false);
        this.instruction = null;
        this.txtCode.requestFocus();
        this.txtCode.clear();
        this.onSecurityChange(this.txtCode, "");
        this.buyRadio.setSelected(true);
        this.cmbPriceType.getSelectionModel().select(0);
        this.cmbPriceTypeLimited.getSelectionModel().select(0);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.model.getAccDisModel().removeTree();
        this.model.getAccDisModel().setActive(true);
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new ObSimpleInstruction());
        this.onApprove(false);
        this.model.getAccDisModel().setActive(true);
        this.tabNormal.setDisable(false);
        this.tabAlgo.setDisable(false);
        this.stkPaneCommon.setDisable(true);
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            try {
                this.fillInstruction();
                this.btnOrder.setDisable(false);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }

    protected void fillInstruction() throws MException {
        this.initPanel();
        this.model.setInstruction(this.instruction);
        if (this.instruction.getOrderDetail() == null) {
            return;
        }
        RefItem refItem = this.refMng.getItem(String.valueOf(this.instruction.getSecType()) + this.instruction.getSecMarket(), this.instruction.getSecMarket(), this.instruction.getSecurityCode());
        this.txtCode.setUserData((Object)refItem);
        this.doChange(refItem, this.instruction.getSecurityCode());
        if (this.isInstructionEvent && this.getValidRef() != null && "SimpleDetail".equals(this.instruction.getType())) {
            this.isInstructionEvent = false;
            this.doOrderFill();
        }
    }

    private void doOrderFill() {
        if (this.getValidRef() == null) {
            return;
        }
        ExecJob job = null;
        SimpleDetail orderDetail = this.instruction.getOrderDetail();
        if (this.instruction.getJobs() != null && this.instruction.getJobs().size() > 0) {
            job = (ExecJob)this.instruction.getJobs().get(0);
        }
        long effectiveQuantity = (long)job.getAvailOrderQty();
        this.quantitySpn.getEditor().setText(Long.toString(effectiveQuantity));
        this.model.getAccDisModel().fillAccount(this.instruction);
        StringUtils.toPriceStr((double)orderDetail.getPrice(), (double)this.getValidRef().getPriceUnit());
        this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode(orderDetail.getOrdType().getValue()));
        this.setPrice(new BigDecimal(orderDetail.getPrice()).setScale(this.getValidRef().getScale(), 4).doubleValue());
        if (Side.SIDE_SELL.getValue().equals(orderDetail.getSide().getValue()) || Side.SIDE_LEND.getValue().equals(orderDetail.getSide().getValue())) {
            this.sellRadio.setSelected(true);
        } else {
            this.buyRadio.setSelected(true);
        }
        if (this.model.getPriceTypeLimitedStg() != null && OrdType.ORD_TYPE_LIMIT.getValue().equals(orderDetail.getOrdType().getValue())) {
            this.cmbPriceTypeLimited.getSelectionModel().select((Object)this.model.getPriceTypeLimitedStg().getNode(Integer.toString(orderDetail.getPriceRestriction())));
        }
        if (this.model.getPriceTypeMktStg() != null && OrdType.ORD_TYPE_MARKET.getValue().equals(orderDetail.getOrdType().getValue())) {
            String marketType = MarketUtils.getNeeqMarketPriceType((int)orderDetail.getTif().getValue(), (int)orderDetail.getMaxPriceLevels());
            this.cmbPriceTypeMkt.getSelectionModel().select((Object)this.model.getPriceTypeMktStg().getNode(marketType));
            this.model.setMktPrice();
        }
        if (this.model.getPriceTypeBidAskStg() != null && OrdType.ORD_TYPE_UNDEFINED.getValue().equals(orderDetail.getOrdType().getValue())) {
            this.cmbPriceTypeBidAsk.getSelectionModel().select((Object)this.model.getPriceTypeBidAskStg().getNode(Integer.toString(orderDetail.getPlateLevels())));
            this.model.setBidAskPrice();
        }
        if (this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            if (this.model.isSpecify()) {
                this.model.setPrice(orderDetail.getPrice());
            } else {
                this.priceSpn.getEditor().clear();
            }
        }
        if (!this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            this.model.setPrice(orderDetail.getPrice());
        }
        if ("99".equals(orderDetail.getOrdType().getValue())) {
            this.model.setPrice(orderDetail.getPrice());
        }
        this.model.setPriceProtected(orderDetail.getStopPrice());
        this.model.getAccDisModel().setShowCanBuy(false);
        if ("3".equals(this.model.getPriceTypeLimitedStg().getRaw())) {
            this.model.setPrice(0.0);
        }
    }

    private void initPanel() {
        this.onApprove(true);
        this.isInstructionEvent = true;
        this.txtCode.clear();
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new ObSimpleInstruction());
        this.model.getAccDisModel().setActive(false);
        this.buyRadio.setSelected(true);
        this.tabNormal.setDisable(false);
        this.tabAlgo.setDisable(false);
        this.stkPaneCommon.setDisable(true);
    }
}

