/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.viewers.abroad;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.Result;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.instructions.viewers.abroad.InstAbroadFutBasePart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class InstAbroadExecutionPart
extends InstAbroadFutBasePart {
    protected boolean isInstructionEvent = false;
    protected MEventHandler hSetCodeApp = event -> {
        if (event.get((Object)"instruction") == null || !(event.get((Object)"instruction") instanceof ObSimpleInstruction)) {
            return;
        }
        ObSimpleInstruction ins = (ObSimpleInstruction)ObSimpleInstruction.class.cast(event.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.model.getAccDisModel().setIsShow(false);
        this.instruction = ins;
        this.doSetCode();
    };
    protected ChangeListener<Boolean> lstnFocusPrice = (ob, old, newV) -> {
        if (this.instruction == null) {
            return;
        }
        if (this.model.isUpLimit() && !newV.booleanValue() && this.model.getPrice() > this.instruction.getOrderDetail().getPrice()) {
            this.model.setPrice(this.instruction.getOrderDetail().getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
        if (this.model.isDownLimit() && !newV.booleanValue() && this.model.getPrice() < this.instruction.getOrderDetail().getPrice()) {
            this.model.setPrice(this.instruction.getOrderDetail().getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    };
    protected ChangeListener<Boolean> lstnFocusQuantity = (ob, old, newV) -> {
        if (this.instruction == null) {
            return;
        }
        if (newV.booleanValue()) {
            return;
        }
        this.modifyQuantity();
    };

    @Inject
    public InstAbroadExecutionPart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    public void initialize() {
        this.model.setMarketStr("XHKG");
        this.model.create("3");
        this.setConfirmSymbol("\u6307\u4ee4\u6267\u884c");
        this.setBuySymbol("\u4e70\u5165");
        this.setSellSymbol("\u5356\u51fa");
        this.onApprove(false);
        super.initialize();
        this.model.getAccDisModel().setShowCanBuy(false);
        this.priceSpn.getEditor().focusedProperty().addListener(this.lstnFocusPrice);
        this.quantitySpn.getEditor().focusedProperty().addListener(this.lstnFocusQuantity);
        this.initFinished.set(true);
        this.doSetCode();
        this.txtCodeDisable();
        this.model.getAccDisModel().setIsShow(true);
    }

    protected void onApprove(boolean disable) {
        this.txtCode.setEditable(disable);
        this.txtCode.setDisable(true);
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() || this.model.isSpecify() || this.model.getAccDisModel().isActive(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty(), this.model.getAccDisModel().activeProperty()}));
    }

    @Override
    protected void txtCodeDisable() {
        this.txtCode.setDisable(false);
    }

    private boolean validOrderFill(ObSimpleInstruction ins) {
        return StringUtils.belongto((String)ins.getType(), (String[])new String[]{"SimpleDetail", "SimpleAlgoDetail"}) && ins.getIsOrderStep();
    }

    @Override
    protected void submitOrder() {
        super.submitOrder();
        this.clearPanel();
    }

    @Override
    protected Result doAction() throws MException {
        return this.model.submit(this.instruction);
    }

    public void clearPanel() {
        this.onApprove(false);
        this.instruction = null;
        this.txtCode.requestFocus();
        this.txtCode.clear();
        this.onSecurityChange(this.txtCode, "");
        this.buyRadio.setSelected(true);
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.model.getAccDisModel().removeTree();
        this.model.getAccDisModel().setActive(true);
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new ObSimpleInstruction());
        this.onApprove(false);
        this.model.getAccDisModel().setActive(true);
        this.tabNormal.setDisable(false);
        this.tabAlgo.setDisable(false);
        this.stkPaneCommon.setDisable(true);
    }

    private void doSetCode() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            try {
                this.fillInstruction();
                this.btnOrder.setDisable(false);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }

    protected void fillInstruction() throws MException {
        this.initPanel();
        this.model.setInstruction(this.instruction);
        if (this.instruction.getOrderDetail() == null) {
            return;
        }
        String type = String.valueOf(this.instruction.getSecType()) + this.instruction.getSecMarket();
        RefItem refItem = this.refMng.getItem(type, this.instruction.getSecMarket(), this.instruction.getSecurityCode());
        this.doChange(refItem, this.instruction.getSecurityCode());
        if (this.isInstructionEvent && this.getValidRef() != null && "SimpleDetail".equals(this.instruction.getType())) {
            this.tabNormal.getTabPane().getSelectionModel().select((Object)this.tabNormal);
            this.isInstructionEvent = false;
            this.doOrderFill();
            this.tabNormal.setDisable(false);
            this.tabAlgo.setDisable(true);
        }
    }

    private void doOrderFill() {
        if (this.getValidRef() == null) {
            return;
        }
        SimpleDetail orderDetail = this.instruction.getOrderDetail();
        if (this.instruction.getJobs() != null && this.instruction.getJobs().size() > 0) {
            ExecJob job = (ExecJob)this.instruction.getJobs().get(0);
            long effectiveQuantity = (long)job.getAvailOrderQty();
            this.quantitySpn.getEditor().setText(Long.toString(effectiveQuantity));
        }
        this.cmbTif.getSelectionModel().select((Object)this.model.getTif().getNode(String.valueOf(orderDetail.getTif().getValue())));
        this.cmbTif.setDisable(true);
        this.cmbPriceTypeLimited.setDisable(true);
        this.txtCode.setDisable(true);
        this.model.getAccDisModel().setIsShow(false);
        this.model.getAccDisModel().fillAccount(this.instruction);
        this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode(orderDetail.getOrdType().getValue()));
        this.cmbPriceType.setDisable(true);
        if (!this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            this.model.setPrice(orderDetail.getPrice());
        }
        if (Side.SIDE_SELL.getValue().equals(orderDetail.getSide().getValue()) || Side.SIDE_LEND.getValue().equals(orderDetail.getSide().getValue())) {
            this.sellRadio.setSelected(true);
        } else if (Side.SIDE_BUY.getValue().equals(orderDetail.getSide().getValue())) {
            this.buyRadio.setSelected(true);
        }
        this.sellRadio.setDisable(true);
        this.buyRadio.setDisable(true);
        if (this.model.getPriceTypeLimitedStg() != null && OrdType.ORD_TYPE_LIMIT.getValue().equals(orderDetail.getOrdType().getValue())) {
            this.cmbPriceTypeLimited.getSelectionModel().select((Object)this.model.getPriceTypeLimitedStg().getNode(Integer.toString(orderDetail.getPriceRestriction())));
        }
        if (OrdType.ORD_TYPE_MARKET.getValue().equals(orderDetail.getOrdType().getValue())) {
            this.cmbPriceTypeMkt.getSelectionModel().select((Object)this.model.getPriceTypeMktStg().getNode("0"));
            this.model.setMktPrice();
        }
        if (this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            if (this.model.isSpecify()) {
                this.model.setPrice(orderDetail.getPrice());
            } else {
                this.priceSpn.getEditor().clear();
            }
        }
        if (!this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            this.model.setPrice(orderDetail.getPrice());
        }
        if ("99".equals(orderDetail.getOrdType().getValue())) {
            this.model.setPrice(orderDetail.getPrice());
        }
        this.model.setPriceProtected(orderDetail.getStopPrice());
        this.model.getAccDisModel().setShowCanBuy(false);
        if (this.model.getPriceTypeLimitedStg() != null && "3".equals(this.model.getPriceTypeLimitedStg().getRaw())) {
            this.model.setPrice(0.0);
        }
    }

    private void doAlgoOrderFill() {
        if (this.getValidRef() == null) {
            return;
        }
        SimpleDetail orderDetail = this.instruction.getOrderDetail();
        if (this.instruction.getJobs() != null && this.instruction.getJobs().size() > 0) {
            ExecJob job = (ExecJob)this.instruction.getJobs().get(0);
            job.getAvailOrderQty();
        }
        this.model.getAccDisModel().setIsShow(false);
        this.model.getAccDisModel().fillAccount(this.instruction);
        if (!Side.SIDE_SELL.getValue().equals(orderDetail.getSide().getValue())) {
            Side.SIDE_BUY.getValue().equals(orderDetail.getSide().getValue());
        }
        this.sellRadio.setDisable(true);
        this.buyRadio.setDisable(true);
        String ordType = this.instruction.getOrderDetail().getOrdType().getValue();
        String algoType = this.instruction.getAttachment().getAlgorithmName();
        String algo = String.valueOf(ordType) + "#" + algoType;
        MxNodeFactory.create((String)"hk_algo_name", (String)algo);
        if (OrdType.ORD_TYPE_LIMIT.getValue().equals(ordType)) {
            StringUtils.toStr((double)orderDetail.getPrice(), (int)this.model.getValidRef().getScale());
        }
        String startTime = this.instruction.getAttachment().getStartTime();
        int blank = startTime.indexOf(" ");
        int colon1 = startTime.indexOf(":");
        int colon2 = startTime.indexOf(":", colon1 + 1);
        startTime.substring(blank + 1, colon1);
        startTime.substring(colon1 + 1, colon2);
        String endTime = this.instruction.getAttachment().getEndTime();
        endTime.substring(blank + 1, colon1);
        endTime.substring(colon1 + 1, colon2);
    }

    private void initPanel() {
        this.onApprove(true);
        this.isInstructionEvent = true;
        this.txtCode.clear();
        this.quantitySpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new ObSimpleInstruction());
        this.model.getAccDisModel().setActive(false);
        this.buyRadio.setSelected(true);
        this.tabNormal.setDisable(false);
        this.tabAlgo.setDisable(false);
        this.stkPaneCommon.setDisable(true);
    }

    @Override
    public void setPrice(double price) {
        if (this.model.isLimitPrice() && !this.model.isSpecify() && price > 0.0) {
            this.model.setPrice(price);
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    }

    private void modifyQuantity() {
        long effectiveQuantity = this.instruction.getAvailOrderQty();
        if (this.model.getCount() > effectiveQuantity) {
            this.model.setCount(effectiveQuantity);
            this.quantitySpn.getEditor().requestFocus();
            this.quantitySpn.getEditor().selectAll();
        }
    }
}

