/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.topspeed;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.api.trade.IQueryOrderApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PInstruction;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.notice.TopSpeedInstructionReport;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.ObTopSpeedInstruction;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.current.mng.TopSpeedInstructionMng;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.query.utils.QueryByPage;
import cms.tmx.utils.ListUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import cn.hutool.core.lang.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TopSpeedInstructionModel
extends MxModel {
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdChanged;
    @Inject
    private ResourceModel resourceModel;
    @Inject
    private IInstructionApi insApi;
    @Inject
    private IRefDataMng refMng;
    private AtomicInteger count = new AtomicInteger(0);
    @Inject
    private IBaseApi baseApi;
    @Inject
    private INewOrderSingleApi orderApi;
    @Inject
    private IQueryOrderApi apiOrderQuery;
    @Inject
    private TopSpeedInstructionMng insMng;
    @Inject
    private ICancelOrderApi cancelApi;
    @Inject
    private IBaseApi apiBase;
    @Inject
    private MObjFactory of;
    private Set<String> executedIds = new HashSet<String>();
    private Set<String> canceledIds = new HashSet<String>();
    private MxList<ObTopSpeedInstruction> list = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int CHANGE_INTERVAL = 20;
    @Inject
    protected MEventService es;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    protected OrderFactory ftOrder;
    @Inject
    @Named(value="fixed.fileorder.pool")
    protected ExecutorService fixedPool;
    private MEventHandler handler = event -> this.onPush(event);

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdChanged.setInterval(20);
        this.es.subscribe("server.sub", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> this.query(), 240L, TimeUnit.SECONDS);
        });
    }

    private void onPush(MEvent event) {
        if (event.getObj() instanceof TopSpeedInstructionReport) {
            TopSpeedInstructionReport report = (TopSpeedInstructionReport)TopSpeedInstructionReport.class.cast(event.getObj());
            this.logger.info("topspeed instruction push:" + report.getReport().getInstructionList().size());
            for (PInstruction.Instruction ins : report.getReport().getInstructionList()) {
                ObTopSpeedInstruction obTopIns = new ObTopSpeedInstruction();
                this.logger.info("topspeed instruction push id:" + ins.getInstructionId() + "|" + ins.getActionStatusValue());
                obTopIns.setId(ins.getInstructionId());
                ObTopSpeedInstruction obTopSpeedInstruction = (ObTopSpeedInstruction)this.getList().get((MxObject)obTopIns);
                if (obTopSpeedInstruction == null) {
                    obTopIns.update((Object)ins);
                    this.insMng.transferField(obTopIns);
                    this.getList().add((MxObject)obTopIns);
                    continue;
                }
                obTopSpeedInstruction.update((Object)ins);
                this.insMng.transferField(obTopSpeedInstruction);
            }
            this.change();
        }
    }

    private void change() {
        this.sdChanged.schedule(event -> this.changed());
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("instruction query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        this.getList().update(this.insMng.query());
        this.changed();
    }

    public MxList<ObTopSpeedInstruction> getList() {
        return this.list;
    }

    public void batchTopSpeedExe(List<ObTopSpeedInstruction> exeList, List<ObTopSpeedInstruction> cancelList) {
        PInstructionManagement.Action.Builder ab;
        PInstructionManagement.ExecuteActionReq.Builder eb = PInstructionManagement.ExecuteActionReq.newBuilder();
        ArrayList<ObTopSpeedInstruction> ordList = new ArrayList<ObTopSpeedInstruction>();
        for (ObTopSpeedInstruction obTopSpeedInstruction : exeList) {
            if (this.executedIds.contains(obTopSpeedInstruction.getId())) continue;
            this.executedIds.add(obTopSpeedInstruction.getId());
            if (!"1".equals(obTopSpeedInstruction.getExeStatus())) continue;
            ab = PInstructionManagement.Action.newBuilder();
            ab.setInstructionId(obTopSpeedInstruction.getId());
            ab.setStatus(PInstruction.ActionStatus.kExecutedOrder);
            eb.addAction(ab);
            eb.setFlowAttrId(obTopSpeedInstruction.getFlowAttrId());
            ordList.add(obTopSpeedInstruction);
        }
        this.newOrder(ordList);
        for (ObTopSpeedInstruction obTopSpeedInstruction : cancelList) {
            if (this.canceledIds.contains(obTopSpeedInstruction.getId())) continue;
            this.canceledIds.add(obTopSpeedInstruction.getId());
            if (!"3".equals(obTopSpeedInstruction.getExeStatus())) continue;
            ab = PInstructionManagement.Action.newBuilder();
            ab.setInstructionId(obTopSpeedInstruction.getId());
            ab.setStatus(PInstruction.ActionStatus.kExecutedCancel);
            eb.addAction(ab);
            eb.setFlowAttrId(obTopSpeedInstruction.getFlowAttrId());
            this.cancelResourceAndOrder(obTopSpeedInstruction);
        }
        if (eb.getActionCount() == 0) {
            return;
        }
        this.fixedPool.execute(() -> {
            try {
                this.insApi.executeAction(eb);
            }
            catch (MException e) {
                this.logger.error("\u5feb\u6377\u952e\u6267\u884c\u5931\u8d25", (Throwable)e);
            }
        });
    }

    void newOrder(List<ObTopSpeedInstruction> ordList) {
        if (ordList.size() == 0) {
            return;
        }
        try {
            this.newOrderBatch(ordList);
        }
        catch (Exception e) {
            this.logger.error("\u6781\u901f\u6307\u4ee4\u5feb\u6377\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    private void cancelResourceAndOrder(ObTopSpeedInstruction instruction) {
        this.fixedPool.execute(() -> {
            try {
                this.resourceModel.cancelResource(instruction);
            }
            catch (MException e) {
                this.logger.error("\u6781\u901f\u6307\u4ee4\u5feb\u6377\u6267\u884c\u64a4\u9500\u8d44\u6e90\u5931\u8d25", (Throwable)e);
            }
        });
        this.fixedPool.execute(() -> {
            try {
                this.orderCancel(instruction);
            }
            catch (MException e) {
                this.logger.error("\u6781\u901f\u6307\u4ee4\u5feb\u6377\u6267\u884c\u64a4\u9500\u59d4\u6258\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public void orderCancel(ObTopSpeedInstruction instruction) throws MException {
        if (!StringUtils.isEmpty((String)instruction.getClInstructionId())) {
            PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
            String clInstructionId = instruction.getClInstructionId();
            PMessage.OrderCancelRequest.Builder builder = PMessage.OrderCancelRequest.newBuilder();
            builder.setOpUser(this.apiBase.getOpUser());
            builder.setOrigClOrdId(clInstructionId);
            builder.setClOrdId(clInstructionId);
            inst.setApplId("010");
            inst.setMarketGroup("CCS");
            inst.setMarket("XSHG");
            builder.setExtAccntId(((AccntSecInfo)instruction.getOrderAdvice().getAccSecInfoList().get(0)).getAccntId());
            builder.setInstrument(inst);
            try {
                this.cancelApi.submit(builder.build());
            }
            catch (MException mException) {
                this.logger.error("\u6839\u636e\u524d\u7aef\u6d41\u6c34\u53f7\u64a4\u6307\u4ee4\u5355\u5931\u8d25");
            }
        } else {
            Set<Order> ccsOrderList = this.queryInstrustion(instruction.getMarketGrp(), ((AccntSecInfo)instruction.getOrderAdvice().getAccSecInfoList().get(0)).getAccntId(), "", instruction.getResourceId(), instruction.getId());
            ArrayList<CcsOrder> orderList = new ArrayList<CcsOrder>();
            for (Order ccsOrder : ccsOrderList) {
                if (!(ccsOrder instanceof CcsOrder) || !ccsOrder.isCanCancel()) continue;
                orderList.add((CcsOrder)CcsOrder.class.cast(ccsOrder));
            }
            MEvent event = new MEvent();
            if (orderList.size() > 0) {
                event.setObj(orderList);
                this.es.sendEvent("ccs.cancel.order", event);
            }
        }
    }

    private void newOrderBatch(List<ObTopSpeedInstruction> instructions) {
        Map<String, List<ObTopSpeedInstruction>> insMap = instructions.stream().collect(Collectors.groupingBy(t -> ((AccntSecInfo)t.getOrderAdvice().getAccSecInfoList().get(0)).getAccntId()));
        for (Map.Entry<String, List<ObTopSpeedInstruction>> entry : insMap.entrySet()) {
            List averageAssign = ListUtils.split(entry.getValue(), (int)60);
            for (List obInsList : averageAssign) {
                this.fixedPool.execute(() -> {
                    try {
                        this.batchOrderByPage((String)entry.getKey(), obInsList);
                    }
                    catch (MException e) {
                        this.logger.error("\u6279\u91cf\u6267\u884c\u5931\u8d25", (Throwable)e);
                    }
                });
            }
        }
    }

    void batchOrderByPage(String accountId, List<ObTopSpeedInstruction> instructions) throws MException {
        PMessage.NewOrderBatchRequest.Builder nob = PMessage.NewOrderBatchRequest.newBuilder();
        PComponent.Instrument.Builder pi = PComponent.Instrument.newBuilder();
        String uuid = UUID.randomUUID().toString();
        pi.setMarketGroup("CCS");
        nob.setInstrument(pi.build());
        nob.setExtAccntId(String.valueOf(this.count.incrementAndGet()));
        nob.setOpUser(this.baseApi.getOpUser());
        for (ObTopSpeedInstruction instruction : instructions) {
            List accSecInfoList = instruction.getOrderAdvice().getAccSecInfoList();
            for (AccntSecInfo accntSecInfo : accSecInfoList) {
                String market = instruction.getOrderAdvice().getMarket();
                double price = instruction.getOrderAdvice().getPrice();
                int bstype = instruction.getOrderAdvice().getSide();
                String sec_code = instruction.getOrderAdvice().getSec();
                long count = accntSecInfo.getOrderQty();
                if (count <= 0L) continue;
                RefItem item = this.refMng.getItem(market, sec_code);
                PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
                builderI.setSecurityId(sec_code);
                builderI.setMarket(market);
                if (item != null) {
                    builderI.setSecurityType(item.getType());
                }
                if ("XSHG".equals(market) && sec_code.startsWith("688")) {
                    builderI.setApplId("700");
                } else if (item != null && item.isGem()) {
                    builderI.setApplId("GEM");
                } else {
                    builderI.setApplId("010");
                }
                builderI.setMarketGroup("CCS");
                PComponent.Instrument instrument = builderI.build();
                PMessage.NewOrderSingle.Builder builderO = PMessage.NewOrderSingle.newBuilder();
                builderO.setInstrument(instrument);
                builderO.setOrdTypeValue(50);
                builderO.setSideValue(bstype);
                builderO.setOpUser(this.apiBase.getOpUser());
                builderO.setOrderQty((double)count);
                builderO.setPrice(price);
                builderO.setClOrdId(instruction.getClInstructionId());
                builderO.setExtAccntId(accntSecInfo.getAccntId());
                builderO.setExtSecAccntId(accntSecInfo.getSecAccntId());
                builderO.setInstructionId(instruction.getId());
                builderO.setReference(instruction.getId());
                builderO.setResourceId(instruction.getResourceId());
                builderO.setBatchId(uuid);
                PMessage.NewOrderSingle order = builderO.build();
                nob.addOrders(order);
            }
        }
        this.orderApi.batchSubmit(nob.build());
    }

    private Set<Order> queryInstrustion(String marketGrp, String extAccntId, String subAccId, String resourceId, String instructionId) throws MException {
        return this.queryByPage(marketGrp, extAccntId, subAccId, resourceId, instructionId, false);
    }

    private Set<Order> queryByPage(String marketGrp, String extAccntId, String subAccId, String resourceId, String reference, boolean isUnfinishedOrder) throws MException {
        Set<Order> setOrder = Collections.synchronizedSet(new HashSet());
        QueryByPage query = (QueryByPage)this.of.create(QueryByPage.class);
        query.queryByPage(page -> {
            this.apiOrderQuery.queryOrdersInTurn(page, marketGrp, extAccntId, subAccId, resourceId, reference, isUnfinishedOrder);
            this.transferOrder(setOrder, (IPageInTurn<String, String, POrderService.SingleOrder>)page);
        });
        return setOrder;
    }

    private void transferOrder(Set<Order> setOrder, IPageInTurn<String, String, POrderService.SingleOrder> page) throws MException {
        for (POrderService.SingleOrder pOrder : page.getResList()) {
            Order order = this.ftOrder.create(pOrder);
            setOrder.add(order);
        }
    }
}

