/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.CcsTradeSettings;
import cms.tmx.instructions.viewers.regular.InstructionCcsBasePart;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.service.IUserSettingsService;
import com.google.gson.JsonArray;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UserPreCtrl {
    @Inject
    protected MEventService es;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType;
    private String menuId;
    private InstructionCcsBasePart part;
    private static final int DEF_NUM = 4;
    private static int scale = 3;
    private boolean clearAfterOrder = true;
    private boolean popBeforeOrder = true;
    private boolean popBeforeCancel = true;
    private boolean unfinishedAfterOrder = false;
    private int priceChoose;
    private String buyPriceGear = "-1";
    private Double buyPriceFloat = 0.0;
    private String buyPriceUnit = "1";
    private String sellPriceGear;
    private Double sellPriceFloat;
    private String sellPriceUnit;
    private boolean algoEnable = false;
    private String algoBeginTime = "";
    private String algoEndTime = "";
    private DoubleProperty upDownPriceFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty leftRightPriceFloat = new SimpleDoubleProperty(0.0);
    private Long buyQuantity;
    private Long sellQuantity;
    private LongProperty upDownQuantityFloat = new SimpleLongProperty(0L);
    private LongProperty leftRightQuantityFloat = new SimpleLongProperty(0L);
    private boolean autoSlice;
    private Long sliceCountMax;
    private Double buyMoney;
    private Double sellMoney;
    private DoubleProperty upDownMoneyFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty leftRightMoneyFloat = new SimpleDoubleProperty(0.0);
    private IntegerProperty[] commonQuantity = new SimpleIntegerProperty[4];
    private DoubleProperty[] commonAmount = new SimpleDoubleProperty[4];
    private DoubleProperty[] totalAssetRate = new SimpleDoubleProperty[4];
    private DoubleProperty[] canbuyRate = new SimpleDoubleProperty[4];
    private DoubleProperty[] cansellRate = new SimpleDoubleProperty[4];
    private String unit;
    private Map<String, String> secAccntMap;
    private String market;
    private String secAccnt;
    private static final Logger logger = LogManager.getLogger(UserPreCtrl.class);
    private MEventHandler reload = event -> {
        if (this.getPart() == null) {
            return;
        }
        if (this.funcPanelType == null || this.menuId == null) {
            this.initControls();
            return;
        }
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CcsTradeSettings) {
                this.getUserSetting((CcsTradeSettings)CcsTradeSettings.class.cast(settings));
                this.initControls();
            }
        }
        catch (MException mException) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25");
        }
    };

    public boolean isClearAfterOrder() {
        return this.clearAfterOrder;
    }

    public void setClearAfterOrder(boolean clearAfterOrder) {
        this.clearAfterOrder = clearAfterOrder;
    }

    @PostConstruct
    public void init() {
        this.es.subscribe("settingsRefresh", this.reload);
        this.initSet();
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", this.reload);
    }

    public void doSet() throws MException {
        if (this.funcPanelType == null || this.menuId == null) {
            this.initControls();
            return;
        }
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CcsTradeSettings) {
                this.getUserSetting((CcsTradeSettings)CcsTradeSettings.class.cast(settings));
            }
        }
        finally {
            this.initControls();
        }
    }

    public void initControls() {
        if (this.part == null) {
            return;
        }
        this.setPriceSpinner();
        SpinnerUtils.addDoubleArrowKeyHandler(this.getPart().getPriceSpn(), (ObservableNumberValue)this.upDownPriceFloatProperty(), (ObservableNumberValue)this.leftRightPriceFloatProperty());
        SpinnerUtils.addIntArrowKeyHandler(this.getPart().getQuantitySpn(), (ObservableNumberValue)this.upDownQuantityFloatProperty(), (ObservableNumberValue)this.leftRightQuantityFloatProperty());
        SpinnerUtils.addDoubleArrowKeyHandler(this.getPart().getMoneySpn(), (ObservableNumberValue)this.upDownMoneyFloatProperty(), (ObservableNumberValue)this.leftRightMoneyFloatProperty());
        Platform.runLater(() -> {
            TradeBindings.bindBigNumToInt((StringProperty)this.getPart().getLbCountOne().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[0]);
            TradeBindings.bindBigNumToInt((StringProperty)this.getPart().getLbCountTwo().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[1]);
            TradeBindings.bindBigNumToInt((StringProperty)this.getPart().getLbCountThree().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[2]);
            TradeBindings.bindBigNumToInt((StringProperty)this.getPart().getLbCountFour().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[3]);
            this.getPart().getLbCountOne().setOnMouseClicked(event -> {
                this.getPart().setCount(this.getCommonQuantity()[0].longValue());
                this.getPart().getQuantitySpn().requestFocus();
            });
            this.getPart().getLbCountTwo().setOnMouseClicked(event -> {
                this.getPart().setCount(this.getCommonQuantity()[1].longValue());
                this.getPart().getQuantitySpn().requestFocus();
            });
            this.getPart().getLbCountThree().setOnMouseClicked(event -> {
                this.getPart().setCount(this.getCommonQuantity()[2].longValue());
                this.getPart().getQuantitySpn().requestFocus();
            });
            this.getPart().getLbCountFour().setOnMouseClicked(event -> {
                this.getPart().setCount(this.getCommonQuantity()[3].longValue());
                this.getPart().getQuantitySpn().requestFocus();
            });
            Tooltip countTip1 = new Tooltip(Integer.toString(this.getCommonQuantity()[0].getValue()));
            countTip1.setFont(new Font("Arial", 14.0));
            this.getPart().getLbCountOne().setTooltip(countTip1);
            Tooltip countTip2 = new Tooltip(Integer.toString(this.getCommonQuantity()[1].getValue()));
            countTip2.setFont(new Font("Arial", 14.0));
            this.getPart().getLbCountTwo().setTooltip(countTip2);
            Tooltip countTip3 = new Tooltip(Integer.toString(this.getCommonQuantity()[2].getValue()));
            countTip3.setFont(new Font("Arial", 14.0));
            this.getPart().getLbCountThree().setTooltip(countTip3);
            Tooltip countTip4 = new Tooltip(Integer.toString(this.getCommonQuantity()[3].getValue()));
            countTip4.setFont(new Font("Arial", 14.0));
            this.getPart().getLbCountFour().setTooltip(countTip4);
            TradeBindings.bindBigNumToDouble((StringProperty)this.getPart().getLbAmountOne().textProperty(), (ObservableNumberValue)this.getCommonAmount()[0]);
            TradeBindings.bindBigNumToDouble((StringProperty)this.getPart().getLbAmountTwo().textProperty(), (ObservableNumberValue)this.getCommonAmount()[1]);
            TradeBindings.bindBigNumToDouble((StringProperty)this.getPart().getLbAmountThree().textProperty(), (ObservableNumberValue)this.getCommonAmount()[2]);
            TradeBindings.bindBigNumToDouble((StringProperty)this.getPart().getLbAmountFour().textProperty(), (ObservableNumberValue)this.getCommonAmount()[3]);
            this.getPart().getLbAmountOne().setOnMouseClicked(event -> this.getPart().setMoney(this.getCommonAmount()[0].getValue()));
            this.getPart().getLbAmountTwo().setOnMouseClicked(event -> this.getPart().setMoney(this.getCommonAmount()[1].getValue()));
            this.getPart().getLbAmountThree().setOnMouseClicked(event -> this.getPart().setMoney(this.getCommonAmount()[2].getValue()));
            this.getPart().getLbAmountFour().setOnMouseClicked(event -> this.getPart().setMoney(this.getCommonAmount()[3].getValue()));
            BigDecimal bd1 = new BigDecimal(this.getCommonAmount()[0].getValue()).setScale(2, 4);
            Tooltip amountTip1 = new Tooltip(bd1.toString());
            amountTip1.setFont(new Font("Arial", 14.0));
            this.getPart().getLbAmountOne().setTooltip(amountTip1);
            BigDecimal bd2 = new BigDecimal(this.getCommonAmount()[1].getValue()).setScale(2, 4);
            Tooltip amountTip2 = new Tooltip(bd2.toString());
            amountTip2.setFont(new Font("Arial", 14.0));
            this.getPart().getLbAmountTwo().setTooltip(amountTip2);
            BigDecimal bd3 = new BigDecimal(this.getCommonAmount()[2].getValue()).setScale(2, 4);
            Tooltip amountTip3 = new Tooltip(bd3.toString());
            amountTip3.setFont(new Font("Arial", 14.0));
            this.getPart().getLbAmountThree().setTooltip(amountTip3);
            BigDecimal bd = new BigDecimal(this.getCommonAmount()[3].getValue()).setScale(2, 4);
            Tooltip amountTip4 = new Tooltip(bd.toString());
            amountTip4.setFont(new Font("Arial", 14.0));
            this.getPart().getLbAmountFour().setTooltip(amountTip4);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbTotalOne().textProperty(), (ObservableNumberValue)this.getTotalAssetRate()[0]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbTotalTwo().textProperty(), (ObservableNumberValue)this.getTotalAssetRate()[1]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbTotalThree().textProperty(), (ObservableNumberValue)this.getTotalAssetRate()[2]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbTotalFour().textProperty(), (ObservableNumberValue)this.getTotalAssetRate()[3]);
            this.getPart().getLbTotalOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getTotalAssetRate()[0].getValue()));
            this.getPart().getLbTotalTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getTotalAssetRate()[1].getValue()));
            this.getPart().getLbTotalThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getTotalAssetRate()[2].getValue()));
            this.getPart().getLbTotalFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getTotalAssetRate()[3].getValue()));
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCanbuyOne().textProperty(), (ObservableNumberValue)this.getCanbuyRate()[0]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCanbuyTwo().textProperty(), (ObservableNumberValue)this.getCanbuyRate()[1]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCanbuyThree().textProperty(), (ObservableNumberValue)this.getCanbuyRate()[2]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCanbuyFour().textProperty(), (ObservableNumberValue)this.getCanbuyRate()[3]);
            this.getPart().getLbCanbuyOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanbuyRate()[0].getValue()));
            this.getPart().getLbCanbuyTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanbuyRate()[1].getValue()));
            this.getPart().getLbCanbuyThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanbuyRate()[2].getValue()));
            this.getPart().getLbCanbuyFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanbuyRate()[3].getValue()));
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCansellOne().textProperty(), (ObservableNumberValue)this.getCansellRate()[0]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCansellTwo().textProperty(), (ObservableNumberValue)this.getCansellRate()[1]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCansellThree().textProperty(), (ObservableNumberValue)this.getCansellRate()[2]);
            TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCansellFour().textProperty(), (ObservableNumberValue)this.getCansellRate()[3]);
            this.getPart().getLbCansellOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCansellRate()[0].getValue()));
            this.getPart().getLbCansellTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCansellRate()[1].getValue()));
            this.getPart().getLbCansellThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCansellRate()[2].getValue()));
            this.getPart().getLbCansellFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCansellRate()[3].getValue()));
        });
        this.getPart().setAutoSlice(this.isAutoSlice(), this.getSliceCountMax());
        if (this.isAlgoEnable()) {
            this.getPart().algoNode.setDefTime(this.getAlgoBeginTime(), this.getAlgoEndTime());
        }
        this.selectSecAccntMap();
    }

    public void selectSecAccntMap() {
        this.getPart().getInstructionCcsBaseModel().getAccDisModel().clearSelect();
        if (this.secAccntMap != null && this.getPart().getInstructionCcsBaseModel().isBuy()) {
            for (String secAccnt : this.secAccntMap.keySet()) {
                this.getPart().getInstructionCcsBaseModel().setPresetPstAcct(secAccnt, this.secAccntMap.get(secAccnt));
            }
        }
    }

    public void selectTwoOrAllPriceDecimal() {
        TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.part.getPriceSpn().getEditor());
    }

    public void selectTwoOrAllProtectedPriceDecimal() {
        TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.part.getProtectedPriceSpn().getEditor());
    }

    public void onBsChange(boolean buy) {
        this.selectSecAccntMap();
        this.setUserPreCount(buy);
        if (this.getPart().getActiveFlag()) {
            this.getPart().setPrice(this.getDefPrice(buy));
        }
    }

    public void onCountStgChange(boolean buy) {
        this.setUserPreCount(buy);
        this.setPriceSpinner();
    }

    private void setPriceSpinner() {
        if (this.part == null) {
            return;
        }
        RefItem refItem = this.getPart().getValidRef();
        if (refItem != null && this.getUpDownPriceFloat() < refItem.getPriceUnit()) {
            this.setUpDownPriceFloat(refItem.getPriceUnit());
        }
        if (refItem != null && this.getLeftRightPriceFloat() < refItem.getPriceUnit()) {
            this.setLeftRightPriceFloat(refItem.getPriceUnit());
        }
    }

    private void setUserPreCount(boolean buy) {
        if (this.getPart().getCountStg() == null) {
            return;
        }
        if (this.getPart().getValidRef() == null) {
            this.getPart().setCount(0L);
            return;
        }
        String stg = this.getPart().getCountStg().getRaw();
        if (stg.equals("1")) {
            if (buy) {
                this.getPart().setCount(this.getBuyQuantity());
            } else {
                this.getPart().setCount(this.getSellQuantity());
            }
        } else if (stg.equals("5")) {
            if (buy) {
                this.getPart().setMoney(this.getBuyMoney());
            } else {
                this.getPart().setMoney(this.getSellMoney());
            }
        }
    }

    public double getDefPrice(boolean buy) {
        double price = 0.0;
        int gear = 0;
        double adjust = 0.0;
        if (this.getPart().getMarketItem().getRefItem() != null) {
            scale = this.getPart().getMarketItem().getRefItem().getScale();
        }
        if (buy) {
            gear = this.getBuyPriceGear() == null ? -1 : Integer.parseInt(this.getBuyPriceGear());
            price = this.getPrice(gear);
            if (price <= 0.0) {
                return 0.0;
            }
            BigDecimal bg = new BigDecimal(String.valueOf(price));
            price = bg.setScale(scale, 4).doubleValue();
            adjust = this.getBuyPriceFloat() == null ? 0.0 : this.getBuyPriceFloat();
            bg = "2".equals(this.getBuyPriceUnit()) ? new BigDecimal(String.valueOf(price *= 1.0 + adjust / 100.0)) : bg.add(new BigDecimal(String.valueOf(adjust)));
            price = bg.setScale(scale, 1).doubleValue();
        } else {
            gear = this.getSellPriceGear() == null ? 1 : Integer.parseInt(this.getSellPriceGear());
            price = this.getPrice(gear);
            if (price <= 0.0) {
                return price;
            }
            BigDecimal bg = new BigDecimal(String.valueOf(price));
            price = bg.setScale(scale, 4).doubleValue();
            adjust = this.getSellPriceFloat() == null ? 0.0 : this.getSellPriceFloat();
            bg = "2".equals(this.getSellPriceUnit()) ? new BigDecimal(String.valueOf(price *= 1.0 + adjust / 100.0)) : bg.add(new BigDecimal(String.valueOf(adjust)));
            price = bg.setScale(scale, 0).doubleValue();
        }
        return price;
    }

    public double getPrice(int gear) {
        switch (gear) {
            case 0: {
                return this.getPart().getMarketItem().getNowPrice();
            }
            case 100: {
                return this.getPart().getMarketItem().getUpLimitPrice();
            }
            case -100: {
                return this.getPart().getMarketItem().getDownLimitPrice();
            }
        }
        if (this.getPart() != null) {
            return this.getFitablePrice(gear);
        }
        return 0.0;
    }

    private double getFitablePrice(int raw) {
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.getPart().getMarketItem().getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.getPart().getMarketItem().getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.getPart().getMarketItem().getNowPrice() == 0.0 ? this.getPart().getMarketItem().getClosePrice() : this.getPart().getMarketItem().getNowPrice();
        }
        return price;
    }

    private void initSet() {
        this.setClearAfterOrder(true);
        this.setPopBeforeOrder(true);
        this.setPopBeforeCancel(true);
        this.setPriceChoose(1);
        this.setUpDownPriceFloat(0.01);
        this.setLeftRightPriceFloat(0.05);
        this.setUpDownQuantityFloat(1000L);
        this.setLeftRightQuantityFloat(5000L);
        this.setUpDownMoneyFloat(10000.0);
        this.setLeftRightMoneyFloat(50000.0);
        this.setBuyPriceGear(Integer.toString(-1));
        this.setBuyPriceFloat(0.0);
        this.setBuyPriceUnit("2");
        this.setSellPriceGear(Integer.toString(1));
        this.setSellPriceFloat(0.0);
        this.setSellPriceUnit("2");
        this.setBuyQuantity(0L);
        this.setSellQuantity(0L);
        this.setAutoSlice(false);
        this.setSliceCountMax(1000000L);
        this.setBuyMoney(0.0);
        this.setSellMoney(0.0);
        this.setUnit("1");
        int i = 0;
        while (i < 4) {
            this.commonQuantity[i] = new SimpleIntegerProperty();
            this.commonAmount[i] = new SimpleDoubleProperty();
            this.totalAssetRate[i] = new SimpleDoubleProperty();
            this.canbuyRate[i] = new SimpleDoubleProperty();
            this.cansellRate[i] = new SimpleDoubleProperty();
            ++i;
        }
        this.commonQuantity[0].set(100000);
        this.commonQuantity[1].set(50000);
        this.commonQuantity[2].set(20000);
        this.commonQuantity[3].set(10000);
        this.commonAmount[0].set(100000.0);
        this.commonAmount[1].set(50000.0);
        this.commonAmount[2].set(20000.0);
        this.commonAmount[3].set(10000.0);
        this.totalAssetRate[0].set(100.0);
        this.totalAssetRate[1].set(50.0);
        this.totalAssetRate[2].set(33.33);
        this.totalAssetRate[3].set(25.0);
        this.canbuyRate[0].set(100.0);
        this.canbuyRate[1].set(50.0);
        this.canbuyRate[2].set(33.33);
        this.canbuyRate[3].set(25.0);
        this.cansellRate[0].set(100.0);
        this.cansellRate[1].set(50.0);
        this.cansellRate[2].set(33.33);
        this.cansellRate[3].set(25.0);
        this.setAlgoBeginTime("09:30:00");
        this.setAlgoEndTime("14:59:00");
    }

    private void getUserSetting(CcsTradeSettings settings) {
        this.setClearAfterOrder(settings.getClearAfterOrder().equals("1"));
        this.setPopBeforeOrder(settings.getPopBeforeOrder().equals("1"));
        this.setPopBeforeCancel(settings.getPopBeforeCancel().equals("1"));
        this.setUnfinishedAfterOrder(settings.getUnfinishedAfterOrder().equals("1"));
        this.setPriceChoose(settings.getPriceChoose());
        this.setUpDownPriceFloat(settings.getUpDownPriceFloat());
        this.setLeftRightPriceFloat(settings.getLeftRightPriceFloat());
        this.setUpDownQuantityFloat(settings.getUpDownQuantityFloat());
        this.setLeftRightQuantityFloat(settings.getLeftRightQuantityFloat());
        this.setUpDownMoneyFloat(settings.getUpDownMoneyFloat());
        this.setLeftRightMoneyFloat(settings.getLeftRightMoneyFloat());
        this.setBuyPriceGear(settings.getBuyPriceGear());
        this.setBuyPriceFloat(settings.getBuyPriceFloat());
        this.setBuyPriceUnit(settings.getBuyPriceUnit());
        this.setSellPriceGear(settings.getSellPriceGear());
        this.setSellPriceFloat(settings.getSellPriceFloat());
        this.setSellPriceUnit(settings.getSellPriceUnit());
        this.setBuyQuantity(settings.getBuyQuantity());
        this.setSellQuantity(settings.getSellQuantity());
        this.setAutoSlice(settings.getAutoSlice().equals("1"));
        this.setSliceCountMax(settings.getSliceCountMax());
        this.setBuyMoney(settings.getBuyMoney());
        this.setSellMoney(settings.getSellMoney());
        JsonArray json = settings.getDefaultAccounts();
        if ("200058".equals(this.menuId) && json != null) {
            this.secAccntMap = new HashMap<String, String>();
            int i = 0;
            while (i < json.size()) {
                JsonArray nodes = json.get(i).getAsJsonObject().get("subNodes").getAsJsonArray();
                int j = 0;
                while (j < nodes.size()) {
                    this.secAccnt = nodes.get(j).getAsJsonObject().get("id").getAsString();
                    this.market = nodes.get(j).getAsJsonObject().get("market").getAsString();
                    this.secAccntMap.put(this.secAccnt, this.market);
                    ++j;
                }
                ++i;
            }
        }
        if (!StringUtils.isEmpty((String)settings.getArithDefBeginTime())) {
            this.setAlgoBeginTime(settings.getArithDefBeginTime());
        }
        if (!StringUtils.isEmpty((String)settings.getArithDefEndTime())) {
            this.setAlgoEndTime(settings.getArithDefEndTime());
        }
        this.setAlgoEnable(settings.isEnabled());
        Platform.runLater(() -> {
            int i = 0;
            while (i < 4) {
                this.commonQuantity[i].set(((Integer)settings.getCommonQuantity().get(i)).intValue());
                this.commonAmount[i].set(((Double)settings.getCommonAmount().get(i)).doubleValue());
                this.totalAssetRate[i].set(((Double)settings.getTotalAssetRate().get(i)).doubleValue());
                this.canbuyRate[i].set(((Double)settings.getCanbuyRate().get(i)).doubleValue());
                this.cansellRate[i].set(((Double)settings.getCansellRate().get(i)).doubleValue());
                ++i;
            }
        });
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public void setPart(InstructionCcsBasePart instrucitonCcsBasePart) {
        this.part = instrucitonCcsBasePart;
    }

    private InstructionCcsBasePart getPart() {
        return this.part;
    }

    public boolean isAlgoEnable() {
        return this.algoEnable;
    }

    public void setAlgoEnable(boolean algoEnable) {
        this.algoEnable = algoEnable;
    }

    public final DoubleProperty upDownPriceFloatProperty() {
        return this.upDownPriceFloat;
    }

    public final double getUpDownPriceFloat() {
        return this.upDownPriceFloatProperty().get();
    }

    public final void setUpDownPriceFloat(double upDownPriceFloat) {
        this.upDownPriceFloatProperty().set(upDownPriceFloat);
    }

    public final DoubleProperty leftRightPriceFloatProperty() {
        return this.leftRightPriceFloat;
    }

    public final double getLeftRightPriceFloat() {
        return this.leftRightPriceFloatProperty().get();
    }

    public final void setLeftRightPriceFloat(double leftRightPriceFloat) {
        this.leftRightPriceFloatProperty().set(leftRightPriceFloat);
    }

    public final LongProperty upDownQuantityFloatProperty() {
        return this.upDownQuantityFloat;
    }

    public final long getUpDownQuantityFloat() {
        return this.upDownQuantityFloatProperty().get();
    }

    public final void setUpDownQuantityFloat(long upDownQuantityFloat) {
        this.upDownQuantityFloatProperty().set(upDownQuantityFloat);
    }

    public final LongProperty leftRightQuantityFloatProperty() {
        return this.leftRightQuantityFloat;
    }

    public final long getLeftRightQuantityFloat() {
        return this.leftRightQuantityFloatProperty().get();
    }

    public final void setLeftRightQuantityFloat(long leftRightQuantityFloat) {
        this.leftRightQuantityFloatProperty().set(leftRightQuantityFloat);
    }

    public final DoubleProperty upDownMoneyFloatProperty() {
        return this.upDownMoneyFloat;
    }

    public final double getUpDownMoneyFloat() {
        return this.upDownMoneyFloatProperty().get();
    }

    public final void setUpDownMoneyFloat(double upDownMoneyFloat) {
        this.upDownMoneyFloatProperty().set(upDownMoneyFloat);
    }

    public final DoubleProperty leftRightMoneyFloatProperty() {
        return this.leftRightMoneyFloat;
    }

    public final double getLeftRightMoneyFloat() {
        return this.leftRightMoneyFloatProperty().get();
    }

    public final void setLeftRightMoneyFloat(double leftRightMoneyFloat) {
        this.leftRightMoneyFloatProperty().set(leftRightMoneyFloat);
    }

    public boolean isPopBeforeOrder() {
        return this.popBeforeOrder;
    }

    public void setPopBeforeOrder(boolean popBeforeOrder) {
        this.popBeforeOrder = popBeforeOrder;
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }

    public String getBuyPriceGear() {
        return this.buyPriceGear;
    }

    public void setBuyPriceGear(String buyPriceGear) {
        this.buyPriceGear = buyPriceGear;
    }

    public Double getBuyPriceFloat() {
        return this.buyPriceFloat;
    }

    public void setBuyPriceFloat(Double buyPriceFloat) {
        this.buyPriceFloat = buyPriceFloat;
    }

    public String getBuyPriceUnit() {
        return this.buyPriceUnit;
    }

    public void setBuyPriceUnit(String buyPriceUnit) {
        this.buyPriceUnit = buyPriceUnit;
    }

    public String getSellPriceGear() {
        return this.sellPriceGear;
    }

    public void setSellPriceGear(String sellPriceGear) {
        this.sellPriceGear = sellPriceGear;
    }

    public Double getSellPriceFloat() {
        return this.sellPriceFloat;
    }

    public void setSellPriceFloat(Double sellPriceFloat) {
        this.sellPriceFloat = sellPriceFloat;
    }

    public String getSellPriceUnit() {
        return this.sellPriceUnit;
    }

    public void setSellPriceUnit(String sellPriceUnit) {
        this.sellPriceUnit = sellPriceUnit;
    }

    public Long getBuyQuantity() {
        return this.buyQuantity;
    }

    public void setBuyQuantity(Long buyQuantity) {
        this.buyQuantity = buyQuantity;
    }

    public Long getSellQuantity() {
        return this.sellQuantity;
    }

    public void setSellQuantity(Long sellQuantity) {
        this.sellQuantity = sellQuantity;
    }

    public boolean isAutoSlice() {
        return this.autoSlice;
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSlice = autoSlice;
    }

    public Long getSliceCountMax() {
        return this.sliceCountMax;
    }

    public void setSliceCountMax(Long sliceCountMax) {
        this.sliceCountMax = sliceCountMax;
    }

    public Double getBuyMoney() {
        return this.buyMoney;
    }

    public void setBuyMoney(Double buyMoney) {
        this.buyMoney = buyMoney;
    }

    public Double getSellMoney() {
        return this.sellMoney;
    }

    public void setSellMoney(Double sellMoney) {
        this.sellMoney = sellMoney;
    }

    public IntegerProperty[] getCommonQuantity() {
        return this.commonQuantity;
    }

    public void setCommonQuantity(IntegerProperty[] commonQuantity) {
        this.commonQuantity = commonQuantity;
    }

    public DoubleProperty[] getCommonAmount() {
        return this.commonAmount;
    }

    public void setCommonAmount(DoubleProperty[] commonAmount) {
        this.commonAmount = commonAmount;
    }

    public DoubleProperty[] getTotalAssetRate() {
        return this.totalAssetRate;
    }

    public void setTotalAssetRate(DoubleProperty[] totalAssetRate) {
        this.totalAssetRate = totalAssetRate;
    }

    public DoubleProperty[] getCanbuyRate() {
        return this.canbuyRate;
    }

    public void setCanbuyRate(DoubleProperty[] canbuyRate) {
        this.canbuyRate = canbuyRate;
    }

    public DoubleProperty[] getCansellRate() {
        return this.cansellRate;
    }

    public void setCansellRate(DoubleProperty[] cansellRate) {
        this.cansellRate = cansellRate;
    }

    public String getFuncPanelType() {
        return this.funcPanelType;
    }

    public void setFuncPanelType(String funcPanelType) {
        this.funcPanelType = funcPanelType;
    }

    public int getPriceChoose() {
        return this.priceChoose;
    }

    public void setPriceChoose(int priceChoose) {
        this.priceChoose = priceChoose;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getAlgoBeginTime() {
        return this.algoBeginTime;
    }

    public void setAlgoBeginTime(String algoBeginTime) {
        this.algoBeginTime = algoBeginTime;
    }

    public String getAlgoEndTime() {
        return this.algoEndTime;
    }

    public void setAlgoEndTime(String algoEndTime) {
        this.algoEndTime = algoEndTime;
    }

    public boolean isUnfinishedAfterOrder() {
        return this.unfinishedAfterOrder;
    }

    public void setUnfinishedAfterOrder(boolean unfinishedAfterOrder) {
        this.unfinishedAfterOrder = unfinishedAfterOrder;
    }
}

