/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.algorithm.models.AlgoTradeModel;
import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.define.MxDict;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionShortcutTradeModel
extends MxModel {
    @Inject
    protected CcsEntrustFactory ef;
    @Inject
    private CcsAccountMap accMap;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    private MEventService es;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private AlgoTradeModel tradeModel;

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.after.login", event -> {
            try {
                this.accMap.getAccountMap();
            }
            catch (MException e) {
                this.logger.error("get account map faild", (Throwable)e);
            }
        });
    }

    public void execute(Instruction instruction) throws MException {
        String mark = "";
        if ("2".equals(instruction.getType().getRaw()) && instruction.getSecurityType().equals("OIS")) {
            mark = instruction.getPostil();
        }
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, mark);
    }

    public void submit(Instruction inst, double price, long count) throws MException {
        MarketItem mktItem;
        CcsSingleEntrust en;
        block37: {
            OrderAdvice advice;
            block39: {
                int orderType;
                block38: {
                    block36: {
                        advice = inst.getOrderAdvice();
                        List listAcc = advice.getAccSecInfoList();
                        String acc = ((AccntSecInfo)listAcc.get(0)).getAccntId();
                        String sec = ((AccntSecInfo)listAcc.get(0)).getSecAccntId();
                        en = this.ef.createCcsSingle(acc, sec);
                        this.accMap.getAccountMap();
                        CcsFundAccount fundAcc = this.accMap.getFundAcc(((AccntSecInfo)listAcc.get(0)).getInvestorId());
                        SecAccount secAcc = this.accMap.getSecAcc(((AccntSecInfo)listAcc.get(0)).getSecAccntId().replaceAll("[_A-Z]*$", ""), advice.getMarket());
                        en.setFundAccount((FundAccount)fundAcc);
                        en.setSecAccount(secAcc);
                        en.setInvestorId(fundAcc.getInvestId());
                        en.setInvestorSecId(secAcc.getInverstorSecId());
                        int side = advice.getSide();
                        en.setSide(side);
                        en.setQuantity(count);
                        en.setSec(advice.getSec());
                        en.setSecName(advice.getSecName());
                        en.setMarket(advice.getMarket());
                        en.setSecType(advice.getSecType());
                        boolean isRepo = "REPO".equals(advice.getSecType());
                        en.setAppID(isRepo ? "110" : "010");
                        orderType = advice.getOrdType();
                        en.setOrderType(advice.getOrdType());
                        mktItem = this.getMktItem(advice);
                        if (50 != orderType) break block36;
                        en.setPrice(price);
                        break block37;
                    }
                    if (orderType != 0) break block38;
                    new Gears();
                    int ask = advice.getPriceTypeBidAsk();
                    if (ask > 0) {
                        price = mktItem.getBuyPrice(--ask);
                    } else {
                        int index = -(++ask);
                        price = mktItem.getSellPrice(index);
                    }
                    en.setPrice(price);
                    break block37;
                }
                if (99 != orderType) break block39;
                en.setPrice(price);
                break block37;
            }
            switch (advice.getMarketPriceLimit()) {
                case "SH1": {
                    en.setMaxLevels(5);
                    en.setTif(48);
                    break;
                }
                case "SH2": {
                    en.setTif(51);
                    en.setMaxLevels(5);
                    break;
                }
                case "SH3": {
                    en.setMaxLevels(1);
                    en.setTif(48);
                    break;
                }
                case "SH4": {
                    en.setMaxLevels(0);
                    en.setTif(48);
                    break;
                }
                case "SZ1": {
                    en.setTif(48);
                    en.setMaxLevels(1);
                    break;
                }
                case "SZ2": {
                    en.setTif(48);
                    en.setMaxLevels(0);
                    break;
                }
                case "SZ3": {
                    en.setTif(51);
                    en.setMaxLevels(0);
                    break;
                }
                case "SZ4": {
                    en.setTif(51);
                    en.setMaxLevels(5);
                    break;
                }
                case "SZ5": {
                    en.setTif(52);
                    en.setMaxLevels(0);
                    break;
                }
            }
            if (this.isStar(mktItem)) {
                en.setPrice(advice.getProtectedLimitPrice());
            }
        }
        en.setResourceId(inst.getResource().getId());
        en.setOrdQuantityCapacity(count);
        en.setInstructionId(inst.getId());
        if (this.isStar(mktItem)) {
            en.setAppID("700");
        }
        if (mktItem.getRefItem().isGem()) {
            en.setAppID("GEM");
        }
        en.submit();
    }

    public boolean isStar(MarketItem mktItem) {
        return mktItem.isValidRef() && mktItem.getRefItem().getCode().startsWith("688");
    }

    public MarketItem getMktItem(OrderAdvice advice) {
        LinkedList<RefItem> listRef = new LinkedList<RefItem>();
        RefItem refItem = this.refMng.getItem(advice.getSecType(), advice.getMarket(), advice.getSec());
        listRef.add(refItem);
        Gears gears = new Gears();
        gears.setBuys();
        gears.setSells();
        this.mktMng.query(listRef, gears);
        return this.mktMng.getInfo((IRefItem)refItem);
    }

    public String submit(Instruction inst, AlgoParam param) throws MException {
        ObservableList list = FxUtils.newList();
        OrderAdvice advice = inst.getOrderAdvice();
        inst.getResource();
        List listAcc = advice.getAccSecInfoList();
        if (listAcc.isEmpty()) {
            throw new MException(99, "\u8d26\u53f7\u9519\u8bef");
        }
        AccntSecInfo accnt = (AccntSecInfo)listAcc.get(0);
        param.setFundAccId(accnt.getAccntId());
        param.setSecAccId(accnt.getSecAccntId());
        param.setReference(inst.getId());
        param.setResourceId(inst.getResource().getId());
        list.add((Object)param);
        return this.tradeModel.submit(param);
    }
}

